/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.brazier;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.content.block.soul_cage.SoulCageBlock;
import dev.sterner.witchery.content.item.potion.WitcheryPotionIngredient;
import dev.sterner.witchery.content.item.potion.WitcheryPotionItem;
import dev.sterner.witchery.content.recipe.MultipleItemRecipeInput;
import dev.sterner.witchery.content.recipe.brazier.BrazierPassiveRecipe;
import dev.sterner.witchery.content.recipe.brazier.BrazierSummoningRecipe;
import dev.sterner.witchery.core.api.BrazierPassive;
import dev.sterner.witchery.core.api.block.ActiveEffect;
import dev.sterner.witchery.core.api.block.AltarPowerConsumer;
import dev.sterner.witchery.core.api.block.PotionDisperser;
import dev.sterner.witchery.core.api.block.PotionDisperserHelper;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryBrazierRegistry;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0085\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0002\u0085\u0001B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\u0016\u0010<\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020.0+H\u0016J\u0016\u0010@\u001a\u00020=2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020.0+H\u0016J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020403H\u0016J\u0016\u0010D\u001a\u00020=2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0016J\b\u0010E\u001a\u00020%H\u0016J\u0010\u0010F\u001a\u00020=2\u0006\u0010G\u001a\u00020%H\u0016J\b\u0010H\u001a\u000206H\u0016J\b\u0010I\u001a\u00020%H\u0016J \u0010J\u001a\u00020=2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010N\u001a\u00020=2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\bH\u0002J\u0018\u0010O\u001a\u00020=2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\bH\u0002J \u0010P\u001a\u00020=2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\u001bH\u0002J\u001a\u0010R\u001a\u0004\u0018\u00010\b2\u0006\u0010K\u001a\u00020L2\u0006\u0010S\u001a\u00020\bH\u0002J\b\u0010T\u001a\u00020=H\u0002J\u0018\u0010U\u001a\u00020=2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\bH\u0002J\u0018\u0010V\u001a\u00020=2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\bH\u0002J \u0010W\u001a\u00020=2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010X\u001a\u00020=2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\bH\u0002J \u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u000f2\u0006\u0010^\u001a\u00020_H\u0016J\u0010\u0010`\u001a\u00020%2\u0006\u0010]\u001a\u00020\u000fH\u0002J \u0010a\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u000f2\u0006\u0010^\u001a\u00020_H\u0002J\u0010\u0010b\u001a\u00020=2\u0006\u0010]\u001a\u00020\u000fH\u0002J\u0016\u0010c\u001a\u00020=2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020.0+H\u0002J\u0018\u0010e\u001a\u00020=2\u0006\u0010[\u001a\u00020\\2\u0006\u0010^\u001a\u00020_H\u0002J\b\u0010f\u001a\u00020=H\u0002J\b\u0010g\u001a\u00020=H\u0002J\u0018\u0010h\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u000fH\u0002J\b\u0010i\u001a\u00020=H\u0002J\u0010\u0010j\u001a\u00020Z2\u0006\u0010]\u001a\u00020\u000fH\u0002J\b\u0010k\u001a\u00020%H\u0016J\u0010\u0010l\u001a\u00020\u000f2\u0006\u0010m\u001a\u00020#H\u0016J\u0018\u0010n\u001a\u00020\u000f2\u0006\u0010m\u001a\u00020#2\u0006\u0010o\u001a\u00020#H\u0016J\u0010\u0010p\u001a\u00020\u000f2\u0006\u0010m\u001a\u00020#H\u0016J\u0018\u0010q\u001a\u00020=2\u0006\u0010m\u001a\u00020#2\u0006\u0010]\u001a\u00020\u000fH\u0016J\u0010\u0010r\u001a\u00020%2\u0006\u0010[\u001a\u00020\\H\u0016J\u0010\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020vH\u0016J\"\u0010w\u001a\u00020%2\u0006\u0010x\u001a\u00020#2\u0006\u0010]\u001a\u00020\u000f2\b\u0010y\u001a\u0004\u0018\u00010vH\u0016J \u0010z\u001a\u00020%2\u0006\u0010x\u001a\u00020#2\u0006\u0010]\u001a\u00020\u000f2\u0006\u0010y\u001a\u00020vH\u0016J\b\u0010{\u001a\u00020=H\u0016J\b\u0010|\u001a\u00020#H\u0016J\u0016\u0010}\u001a\u00020=2\f\u0010Q\u001a\b\u0012\u0002\b\u0003\u0018\u00010~H\u0016J\u000e\u0010\u007f\u001a\b\u0012\u0002\b\u0003\u0018\u00010~H\u0016J\u001c\u0010\u0080\u0001\u001a\u00020=2\u0007\u0010\u0081\u0001\u001a\u00020:2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0014J\u001c\u0010\u0084\u0001\u001a\u00020=2\u0007\u0010\u0081\u0001\u001a\u00020:2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0014R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0017\u001aB\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001b0\u001b \u001a* \u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u001c\u001aB\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001d0\u001d \u001a* \u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001d0\u001d\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020.0+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020100X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0086\u0001"}, d2={"Ldev/sterner/witchery/content/block/brazier/BrazierBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "Lnet/minecraft/world/Container;", "Ldev/sterner/witchery/core/api/block/AltarPowerConsumer;", "Lnet/minecraft/world/inventory/RecipeCraftingHolder;", "Lnet/minecraft/world/WorldlyContainer;", "Ldev/sterner/witchery/core/api/block/PotionDisperser;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "items", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "setItems", "(Lnet/minecraft/core/NonNullList;)V", "recipesUsed", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "Lnet/minecraft/resources/ResourceLocation;", "quickCheck", "Lnet/minecraft/world/item/crafting/RecipeManager$CachedCheck;", "Ldev/sterner/witchery/content/recipe/MultipleItemRecipeInput;", "kotlin.jvm.PlatformType", "Ldev/sterner/witchery/content/recipe/brazier/BrazierSummoningRecipe;", "quickCheckPassive", "Ldev/sterner/witchery/content/recipe/brazier/BrazierPassiveRecipe;", "brazierPassive", "Ldev/sterner/witchery/core/api/BrazierPassive;", "passiveTypeId", "", "summoningTicker", "", "active", "", "getActive", "()Z", "setActive", "(Z)V", "potionContents", "", "Lnet/minecraft/world/item/alchemy/PotionContents;", "specialPotions", "Ldev/sterner/witchery/content/item/potion/WitcheryPotionIngredient;", "activeEffects", "", "Ldev/sterner/witchery/core/api/block/ActiveEffect;", "owner", "Ljava/util/Optional;", "Ljava/util/UUID;", "potionEffectRadius", "", "potionEffectDuration", "cachedAltarPos", "deferredNbtData", "Lnet/minecraft/nbt/CompoundTag;", "getPotionContents", "setPotionContents", "", "contents", "getSpecialPotions", "setSpecialPotions", "potions", "getActiveEffects", "getOwner", "setOwner", "isInfiniteMode", "setInfiniteMode", "infinite", "getDispersalRadius", "shouldConsumePower", "tick", "level", "Lnet/minecraft/world/level/Level;", "pos", "tickPassive", "tickSummoning", "performSummoning", "recipe", "findSummonPosition", "centerPos", "completePassive", "completeSummoning", "tickPotionEffects", "updateLitState", "spawnClientParticles", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "stack", "hand", "Lnet/minecraft/world/InteractionHand;", "canIgnite", "handlePotionAddition", "configurePotionEffect", "configureSpecialPotionEffect", "potionList", "consumePotionItem", "playPotionSound", "spawnPotionParticles", "handleIgnition", "spawnIgnitionParticles", "handleItemAddition", "isEmpty", "getItem", "slot", "removeItem", "amount", "removeItemNoUpdate", "setItem", "stillValid", "getSlotsForFace", "", "side", "Lnet/minecraft/core/Direction;", "canPlaceItemThroughFace", "index", "direction", "canTakeItemThroughFace", "clearContent", "getContainerSize", "setRecipeUsed", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "getRecipeUsed", "saveAdditional", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nBrazierBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazierBlockEntity.kt\ndev/sterner/witchery/content/block/brazier/BrazierBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,621:1\n1869#2,2:622\n1869#2,2:624\n1740#2,3:626\n1#3:629\n*S KotlinDebug\n*F\n+ 1 BrazierBlockEntity.kt\ndev/sterner/witchery/content/block/brazier/BrazierBlockEntity\n*L\n219#1:622,2\n402#1:624,2\n500#1:626,3\n*E\n"})
public final class BrazierBlockEntity
extends WitcheryBaseBlockEntity
implements Container,
AltarPowerConsumer,
RecipeCraftingHolder,
WorldlyContainer,
PotionDisperser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NonNullList<ItemStack> items;
    @NotNull
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    private final RecipeManager.CachedCheck<MultipleItemRecipeInput, BrazierSummoningRecipe> quickCheck;
    private final RecipeManager.CachedCheck<MultipleItemRecipeInput, BrazierPassiveRecipe> quickCheckPassive;
    @Nullable
    private BrazierPassive brazierPassive;
    @Nullable
    private String passiveTypeId;
    private int summoningTicker;
    private boolean active;
    @NotNull
    private List<PotionContents> potionContents;
    @NotNull
    private List<WitcheryPotionIngredient> specialPotions;
    @NotNull
    private final List<ActiveEffect> activeEffects;
    @NotNull
    private Optional<UUID> owner;
    private double potionEffectRadius;
    private int potionEffectDuration;
    @Nullable
    private BlockPos cachedAltarPos;
    @Nullable
    private CompoundTag deferredNbtData;

    public BrazierBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getBRAZIER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
        NonNullList nonNullList = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        this.recipesUsed = new Object2IntOpenHashMap();
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)WitcheryRecipeTypes.INSTANCE.getBRAZIER_SUMMONING_RECIPE_TYPE().get()));
        this.quickCheckPassive = RecipeManager.createCheck((RecipeType)((RecipeType)WitcheryRecipeTypes.INSTANCE.getBRAZIER_PASSIVE_RECIPE_TYPE().get()));
        this.potionContents = CollectionsKt.listOf((Object)PotionContents.EMPTY);
        this.specialPotions = CollectionsKt.emptyList();
        this.activeEffects = new ArrayList();
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.owner = optional;
        this.potionEffectRadius = 8.0;
        this.potionEffectDuration = 6000;
    }

    @NotNull
    public final NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.items = nonNullList;
    }

    public final boolean getActive() {
        return this.active;
    }

    public final void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    @NotNull
    public List<PotionContents> getPotionContents() {
        return this.potionContents;
    }

    @Override
    public void setPotionContents(@NotNull List<PotionContents> contents) {
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        this.potionContents = contents;
        this.setChanged();
    }

    @Override
    @NotNull
    public List<WitcheryPotionIngredient> getSpecialPotions() {
        return this.specialPotions;
    }

    @Override
    public void setSpecialPotions(@NotNull List<WitcheryPotionIngredient> potions) {
        Intrinsics.checkNotNullParameter(potions, (String)"potions");
        this.specialPotions = potions;
        this.setChanged();
    }

    @Override
    @NotNull
    public List<ActiveEffect> getActiveEffects() {
        return this.activeEffects;
    }

    @Override
    @NotNull
    public Optional<UUID> getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@NotNull Optional<UUID> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        this.owner = owner;
        this.setChanged();
    }

    @Override
    public boolean isInfiniteMode() {
        return false;
    }

    @Override
    public void setInfiniteMode(boolean infinite) {
    }

    @Override
    public double getDispersalRadius() {
        return this.potionEffectRadius;
    }

    @Override
    public boolean shouldConsumePower() {
        return false;
    }

    @Override
    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super.tick(level, pos, blockState);
        CompoundTag compoundTag = this.deferredNbtData;
        if (compoundTag != null) {
            CompoundTag nbtData = compoundTag;
            boolean bl = false;
            PotionDisperserHelper.INSTANCE.loadPotionData(nbtData, this, level);
            if (this.activeEffects.isEmpty() && (!((Collection)this.potionContents).isEmpty() || !((Collection)this.specialPotions).isEmpty())) {
                PotionDisperserHelper.INSTANCE.refreshActiveEffects(this);
            }
            this.deferredNbtData = null;
        }
        if (this.cachedAltarPos == null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.cachedAltarPos = this.getAltarPos(serverLevel, blockPos);
            this.setChanged();
        }
        if (this.cachedAltarPos != null && this.active && !((Collection)this.items).isEmpty()) {
            this.tickSummoning(level, pos);
            this.tickPassive(level, pos);
        }
        if (level.isClientSide) {
            this.spawnClientParticles(level, pos);
            return;
        }
        if (this.active && !((Collection)this.activeEffects).isEmpty()) {
            this.tickPotionEffects(level, pos);
        }
        this.updateLitState(level, pos, blockState);
    }

    private final void tickPassive(Level level, BlockPos pos) {
        RecipeHolder brazierPassiveRecipe = this.quickCheckPassive.getRecipeFor((RecipeInput)new MultipleItemRecipeInput((List)this.items), level).orElse(null);
        if (this.brazierPassive != null) {
            BrazierPassive brazierPassive = this.brazierPassive;
            Intrinsics.checkNotNull((Object)brazierPassive);
            brazierPassive.onTickBrazier(level, pos, this);
            return;
        }
        if (brazierPassiveRecipe != null) {
            int n = this.summoningTicker;
            this.summoningTicker = n + 1;
            if (this.summoningTicker >= 100) {
                BrazierPassiveRecipe brazierPassiveRecipe2 = (BrazierPassiveRecipe)brazierPassiveRecipe.value();
                if (brazierPassiveRecipe2 == null) {
                    return;
                }
                BrazierPassiveRecipe brazierRecipe = brazierPassiveRecipe2;
                if (this.hasEnoughAltarPower(level, brazierRecipe, this.cachedAltarPos, (Function0<Unit>)((Function0)() -> BrazierBlockEntity.tickPassive$lambda$0(this)), (Function4<? super Level, ? super BlockPos, ? super Integer, ? super Boolean, Boolean>)((Function4)new Function4<Level, BlockPos, Integer, Boolean, Boolean>((Object)this){

                    public final Boolean invoke(Level p0, BlockPos p1, int p2, boolean p3) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((BrazierBlockEntity)this.receiver).tryConsumeAltarPower(p0, p1, p2, p3);
                    }
                }))) {
                    BrazierPassive brazierPassive = this.brazierPassive = brazierRecipe.getPassive();
                    boolean bl = brazierPassive != null ? brazierPassive.onStartBrazier(level, pos, this) : false;
                    if (bl) {
                        this.consumeAltarPower(level, brazierRecipe, this.cachedAltarPos, (Function0<Unit>)((Function0)() -> BrazierBlockEntity.tickPassive$lambda$1(this)), (Function4<? super Level, ? super BlockPos, ? super Integer, ? super Boolean, Boolean>)((Function4)new Function4<Level, BlockPos, Integer, Boolean, Boolean>((Object)this){

                            public final Boolean invoke(Level p0, BlockPos p1, int p2, boolean p3) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                return ((BrazierBlockEntity)this.receiver).tryConsumeAltarPower(p0, p1, p2, p3);
                            }
                        }));
                    } else {
                        this.brazierPassive = null;
                        this.active = false;
                        this.setChanged();
                    }
                }
                this.completePassive();
            }
        }
    }

    private final void tickSummoning(Level level, BlockPos pos) {
        RecipeHolder brazierSummonRecipe = this.quickCheck.getRecipeFor((RecipeInput)new MultipleItemRecipeInput((List)this.items), level).orElse(null);
        if (brazierSummonRecipe != null) {
            int n = this.summoningTicker;
            this.summoningTicker = n + 1;
            if (this.summoningTicker >= 100) {
                BrazierSummoningRecipe brazierSummoningRecipe = (BrazierSummoningRecipe)brazierSummonRecipe.value();
                if (brazierSummoningRecipe == null) {
                    return;
                }
                BrazierSummoningRecipe recipe = brazierSummoningRecipe;
                if (this.hasEnoughAltarPower(level, recipe, this.cachedAltarPos, (Function0<Unit>)((Function0)() -> BrazierBlockEntity.tickSummoning$lambda$0(this)), (Function4<? super Level, ? super BlockPos, ? super Integer, ? super Boolean, Boolean>)((Function4)new Function4<Level, BlockPos, Integer, Boolean, Boolean>((Object)this){

                    public final Boolean invoke(Level p0, BlockPos p1, int p2, boolean p3) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((BrazierBlockEntity)this.receiver).tryConsumeAltarPower(p0, p1, p2, p3);
                    }
                }))) {
                    this.performSummoning(level, pos, recipe);
                }
                this.completeSummoning(level, pos);
            }
        }
    }

    private final void performSummoning(Level level, BlockPos pos, BrazierSummoningRecipe recipe) {
        Iterable $this$forEach$iv = recipe.getOutputEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos summonPos;
            Entity entity;
            EntityType entityType = (EntityType)element$iv;
            boolean bl = false;
            if (this.findSummonPosition(level, pos) == null) continue;
            boolean bl2 = false;
            if (entityType.create(level) == null) continue;
            boolean bl3 = false;
            entity.moveTo(new Vec3((double)summonPos.getX() + 0.5, (double)summonPos.getY(), (double)summonPos.getZ() + 0.5));
            if (!level.addFreshEntity(entity)) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)this);
                continue;
            }
            this.consumeAltarPower(level, recipe, this.cachedAltarPos, (Function0<Unit>)((Function0)() -> BrazierBlockEntity.performSummoning$lambda$0$0$0$0(this)), (Function4<? super Level, ? super BlockPos, ? super Integer, ? super Boolean, Boolean>)((Function4)new Function4<Level, BlockPos, Integer, Boolean, Boolean>((Object)this){

                public final Boolean invoke(Level p0, BlockPos p1, int p2, boolean p3) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((BrazierBlockEntity)this.receiver).tryConsumeAltarPower(p0, p1, p2, p3);
                }
            }));
        }
    }

    private final BlockPos findSummonPosition(Level level, BlockPos centerPos) {
        IntRange radiusRange = new IntRange(3, 5);
        RandomSource random = level.random;
        int n = 10;
        for (int i = 0; i < n; ++i) {
            double offsetZ;
            int it = i;
            boolean bl = false;
            double offsetX = (random.nextDouble() * (double)2 - 1.0) * (double)RangesKt.random((IntRange)radiusRange, (Random)((Random)Random.Default));
            BlockPos targetPos = centerPos.offset((int)offsetX, 0, (int)(offsetZ = (random.nextDouble() * (double)2 - 1.0) * (double)RangesKt.random((IntRange)radiusRange, (Random)((Random)Random.Default))));
            if (!level.isEmptyBlock(targetPos) || !level.isEmptyBlock(targetPos.above())) continue;
            return targetPos;
        }
        return centerPos.north();
    }

    private final void completePassive() {
        this.items.clear();
        this.summoningTicker = 0;
        this.setChanged();
    }

    private final void completeSummoning(Level level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS);
        this.items.clear();
        this.summoningTicker = 0;
        this.active = false;
        this.setChanged();
    }

    private final void tickPotionEffects(Level level, BlockPos pos) {
        Iterator<ActiveEffect> iterator = this.activeEffects.iterator();
        long currentTime = level.getGameTime();
        while (iterator.hasNext()) {
            boolean shouldApply;
            ActiveEffect effect = iterator.next();
            boolean bl = effect.isSpecial() ? currentTime - effect.getLastSpecialActivation() >= 40L : (shouldApply = currentTime % (long)20 == 0L);
            if (shouldApply) {
                PotionDisperserHelper.INSTANCE.applyEffects(this, level, pos, effect);
                if (effect.isSpecial()) {
                    effect.setLastSpecialActivation(currentTime);
                }
            }
            if (effect.getRemainingTicks() <= 0) continue;
            int n = effect.getRemainingTicks();
            effect.setRemainingTicks(n + -1);
            if (effect.getRemainingTicks() > 0) continue;
            iterator.remove();
        }
        if (this.activeEffects.isEmpty() && this.items.isEmpty()) {
            this.active = false;
            this.setChanged();
        }
    }

    private final void updateLitState(Level level, BlockPos pos, BlockState blockState) {
        boolean shouldBeLit = this.active;
        Boolean currentlyLit = (Boolean)blockState.getValue((Property)BlockStateProperties.LIT);
        if (!Intrinsics.areEqual((Object)currentlyLit, (Object)shouldBeLit)) {
            level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(shouldBeLit)));
        }
    }

    private final void spawnClientParticles(Level level, BlockPos pos) {
        if (!this.active || level.getGameTime() % (long)5 != 0L) {
            return;
        }
        double centerX = (double)pos.getX() + 0.5;
        double centerY = (double)pos.getY() + 0.5;
        double centerZ = (double)pos.getZ() + 0.5;
        if (level.random.nextFloat() < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, centerX + (level.random.nextDouble() - 0.5) * 0.3, centerY, centerZ + (level.random.nextDouble() - 0.5) * 0.3, 0.0, 0.02, 0.0);
        }
        if (!((Collection)this.items).isEmpty() && level.random.nextFloat() < 0.2f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, centerX + (level.random.nextDouble() - 0.5) * 0.4, centerY + 0.1, centerZ + (level.random.nextDouble() - 0.5) * 0.4, 0.0, 0.05, 0.0);
        }
        if (!((Collection)this.activeEffects).isEmpty()) {
            PotionDisperserHelper.INSTANCE.spawnPotionParticles(level, pos, this, 0.3f);
        }
    }

    @Override
    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player player, @NotNull ItemStack stack, @NotNull InteractionHand hand) {
        ItemInteractionResult result;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (player.isShiftKeyDown() && !this.active) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            Containers.dropContents((Level)level, (BlockPos)this.getBlockPos(), this.items);
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack itemStack = (ItemStack)CollectionsKt.firstOrNull((List)((List)this.items));
        boolean bl = itemStack != null ? itemStack.is((Holder)WitcheryItems.INSTANCE.getWOOD_ASH()) : false;
        if (bl && (result = this.handlePotionAddition(player, stack, hand)) != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            return result;
        }
        if (this.canIgnite(stack)) {
            return this.handleIgnition(player, stack);
        }
        return this.handleItemAddition(stack);
    }

    private final boolean canIgnite(ItemStack stack) {
        return stack.is(Items.FLINT_AND_STEEL) || stack.is(Items.FIRE_CHARGE);
    }

    private final ItemInteractionResult handlePotionAddition(Player player, ItemStack stack, InteractionHand hand) {
        if (stack.is(Items.POTION) || stack.is(Items.SPLASH_POTION) || stack.is(Items.LINGERING_POTION)) {
            PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (potionContents == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            PotionContents contents = potionContents;
            if (Intrinsics.areEqual((Object)contents, (Object)PotionContents.EMPTY)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            this.setPotionContents(CollectionsKt.listOf((Object)contents));
            this.configurePotionEffect(stack);
            PotionDisperserHelper.INSTANCE.refreshActiveEffects(this);
            this.consumePotionItem(player, hand);
            this.playPotionSound();
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.has((DataComponentType)WitcheryDataComponents.INSTANCE.getWITCHERY_POTION_CONTENT().get())) {
            List list = (List)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getWITCHERY_POTION_CONTENT().get());
            if (list == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            List potionList = list;
            this.setSpecialPotions(potionList);
            this.configureSpecialPotionEffect(potionList);
            PotionDisperserHelper.INSTANCE.refreshActiveEffects(this);
            this.consumePotionItem(player, hand);
            this.playPotionSound();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private final void configurePotionEffect(ItemStack stack) {
        this.potionEffectRadius = stack.is(Items.LINGERING_POTION) ? 12.0 : 8.0;
        this.potionEffectDuration = stack.is(Items.LINGERING_POTION) ? 8000 : 6000;
        Iterable $this$forEach$iv = this.activeEffects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ActiveEffect effect = (ActiveEffect)element$iv;
            boolean bl = false;
            if (effect.getRemainingTicks() <= 0) continue;
            effect.setRemainingTicks(this.potionEffectDuration);
        }
    }

    private final void configureSpecialPotionEffect(List<WitcheryPotionIngredient> potionList) {
        WitcheryPotionIngredient.DispersalModifier dispersalModifier = WitcheryPotionItem.Companion.getMergedDisperseModifier(potionList);
        this.potionEffectRadius = 8.0 * (double)dispersalModifier.getRangeModifier();
        this.potionEffectDuration = 6000 * dispersalModifier.getLingeringDurationModifier();
    }

    private final void consumePotionItem(Player player, InteractionHand hand) {
        if (!player.isCreative()) {
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
    }

    private final void playPotionSound() {
        Level level = this.level;
        if (level != null) {
            level.playSound(null, this.getBlockPos(), SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.spawnPotionParticles();
    }

    private final void spawnPotionParticles() {
        if (this.level instanceof ServerLevel) {
            int color = PotionDisperserHelper.INSTANCE.calculatePotionColor(this);
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            int n = 15;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                Level level2 = this.level;
                Intrinsics.checkNotNull((Object)level2);
                double offsetX = (level2.random.nextDouble() - 0.5) * 0.6;
                Level level3 = this.level;
                Intrinsics.checkNotNull((Object)level3);
                double offsetZ = (level3.random.nextDouble() - 0.5) * 0.6;
                serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)color).toVector3f(), 0.8f), (double)this.getBlockPos().getX() + 0.5 + offsetX, (double)this.getBlockPos().getY() + 0.8, (double)this.getBlockPos().getZ() + 0.5 + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final ItemInteractionResult handleIgnition(Player player, ItemStack stack) {
        if (!(((Collection)this.items).isEmpty() == false)) ** GOTO lbl-1000
        v0 = new MultipleItemRecipeInput((List)this.items);
        v1 = this.level;
        Intrinsics.checkNotNull((Object)v1);
        if (this.quickCheck.getRecipeFor(v0, v1).isPresent()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = canSummon = false;
        }
        if (!(((Collection)this.items).isEmpty() == false)) ** GOTO lbl-1000
        v3 = new MultipleItemRecipeInput((List)this.items);
        v4 = this.level;
        Intrinsics.checkNotNull((Object)v4);
        if (this.quickCheckPassive.getRecipeFor(v3, v4).isPresent()) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        canPassive = v5;
        v6 = canActivatePotions = ((Collection)this.activeEffects).isEmpty() == false;
        if (canSummon || canActivatePotions || canPassive) {
            this.spawnIgnitionParticles();
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            v7 = this.level;
            if (v7 != null) {
                v7.playSound(null, this.getBlockPos(), SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS);
            }
            this.active = true;
            v8 = this.level;
            if (v8 != null) {
                v8.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
            }
            this.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private final void spawnIgnitionParticles() {
        int n = 3;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            Level level = this.level;
            if (level != null) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.65, (double)this.getBlockPos().getZ() + 0.5, 0.0, 0.0, 0.0);
            }
            Level level2 = this.level;
            if (level2 == null) continue;
            ParticleOptions particleOptions = (ParticleOptions)ParticleTypes.FLAME;
            double d = (double)this.getBlockPos().getX() + 0.5;
            Level level3 = this.level;
            Intrinsics.checkNotNull((Object)level3);
            double d2 = d + (level3.random.nextDouble() - 0.5) * 0.2;
            double d3 = (double)this.getBlockPos().getY() + 0.65;
            double d4 = (double)this.getBlockPos().getZ() + 0.5;
            Level level4 = this.level;
            Intrinsics.checkNotNull((Object)level4);
            level2.addParticle(particleOptions, d2, d3, d4 + (level4.random.nextDouble() - 0.5) * 0.2, 0.0, 0.0, 0.0);
        }
    }

    private final ItemInteractionResult handleItemAddition(ItemStack stack) {
        int n = ((Collection)this.items).size();
        for (int i = 0; i < n; ++i) {
            if (!((ItemStack)this.items.get(i)).isEmpty()) continue;
            this.items.set(i, (Object)stack.copyWithCount(1));
            stack.shrink(1);
            this.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)this.items;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        Object object = this.items.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem((List)((List)this.items), (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem((List)((List)this.items), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"takeItem(...)");
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.items.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize());
        this.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return CollectionsKt.toIntArray((Collection)CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((int)0, (int)this.items.size()))));
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return !this.active;
    }

    public void clearContent() {
        this.items.clear();
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        block0: {
            RecipeHolder<?> recipeHolder = recipe;
            if (recipeHolder == null) break block0;
            RecipeHolder<?> it = recipeHolder;
            boolean bl = false;
            this.recipesUsed.addTo((Object)it.id(), 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        BrazierPassive brazierPassive;
        BlockPos it;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putBoolean("Active", this.active);
        tag.putInt("SummoningTicker", this.summoningTicker);
        BlockPos blockPos = this.cachedAltarPos;
        if (blockPos != null) {
            it = blockPos;
            boolean bl = false;
            tag.put("AltarPos", NbtUtils.writeBlockPos((BlockPos)it));
        }
        Level level = this.level;
        if (level != null) {
            it = level;
            boolean bl = false;
            PotionDisperserHelper.INSTANCE.savePotionData(tag, this, (Level)it);
        }
        if ((brazierPassive = this.brazierPassive) != null && (brazierPassive = brazierPassive.getId()) != null) {
            BrazierPassive id = brazierPassive;
            boolean bl = false;
            tag.putString("PassiveId", id.toString());
        }
        tag.putDouble("PotionRadius", this.potionEffectRadius);
        tag.putInt("PotionDuration", this.potionEffectDuration);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        void it22;
        Object object;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        NonNullList nonNullList = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.active = tag.getBoolean("Active");
        this.summoningTicker = tag.getInt("SummoningTicker");
        if (tag.contains("AltarPos")) {
            this.cachedAltarPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"AltarPos").orElse(null);
        }
        Level level = this.level;
        if (level != null) {
            Level it = level;
            boolean bl = false;
            PotionDisperserHelper.INSTANCE.loadPotionData(tag, this, it);
            if (this.activeEffects.isEmpty() && (!((Collection)this.potionContents).isEmpty() || !((Collection)this.specialPotions).isEmpty())) {
                PotionDisperserHelper.INSTANCE.refreshActiveEffects(this);
            }
        } else {
            BrazierBlockEntity $this$loadAdditional_u24lambda_u241 = this;
            boolean bl = false;
            $this$loadAdditional_u24lambda_u241.deferredNbtData = tag.copy();
        }
        if (tag.contains("PassiveId")) {
            String id = tag.getString("PassiveId");
            object = id;
            String string = this.passiveTypeId = object == null || StringsKt.isBlank((CharSequence)object) || Intrinsics.areEqual((Object)id, (Object)"null") ? null : id;
            if (this.passiveTypeId != null) {
                Registry<BrazierPassive> registry = WitcheryBrazierRegistry.INSTANCE.getBRAZIER_REGISTRY();
                String string2 = this.passiveTypeId;
                Intrinsics.checkNotNull((Object)string2);
                this.brazierPassive = (BrazierPassive)registry.get(ResourceLocation.parse((String)string2));
            }
        }
        object = tag.getDouble("PotionRadius");
        double d = ((Number)object).doubleValue();
        BrazierBlockEntity brazierBlockEntity = this;
        boolean bl = false;
        boolean bl2 = it22 > 0.0;
        Object object2 = bl2 ? object : null;
        brazierBlockEntity.potionEffectRadius = object2 != null ? (Double)object2 : 8.0;
        object = tag.getInt("PotionDuration");
        int it22 = ((Number)object).intValue();
        brazierBlockEntity = this;
        boolean bl3 = false;
        bl2 = it22 > 0;
        Object object3 = bl2 ? object : null;
        brazierBlockEntity.potionEffectDuration = object3 != null ? (Integer)object3 : 6000;
    }

    private static final Unit tickPassive$lambda$0(BrazierBlockEntity this$0) {
        this$0.setChanged();
        return Unit.INSTANCE;
    }

    private static final Unit tickPassive$lambda$1(BrazierBlockEntity this$0) {
        this$0.setChanged();
        return Unit.INSTANCE;
    }

    private static final Unit tickSummoning$lambda$0(BrazierBlockEntity this$0) {
        this$0.setChanged();
        return Unit.INSTANCE;
    }

    private static final Unit performSummoning$lambda$0$0$0$0(BrazierBlockEntity this$0) {
        this$0.setChanged();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/content/block/brazier/BrazierBlockEntity$Companion;", "", "<init>", "()V", "makeSoulCage", "", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickBlock;", "player", "Lnet/minecraft/world/entity/player/Player;", "blockPos", "Lnet/minecraft/core/BlockPos;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void makeSoulCage(@NotNull PlayerInteractEvent.RightClickBlock event, @NotNull Player player, @NotNull BlockPos blockPos) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Level level = player.level();
            if (level.getBlockState(blockPos).is((Block)WitcheryBlocks.INSTANCE.getBRAZIER().get())) {
                boolean bl;
                Item item = player.getMainHandItem().getItem();
                boolean bl2 = item instanceof BlockItem ? ((BlockItem)item).getBlock() instanceof TintedGlassBlock || ((BlockItem)item).getBlock() instanceof StainedGlassBlock : (bl = false);
                if (player.getMainHandItem().is(Items.GLASS) || bl) {
                    if (!player.isCreative()) {
                        player.getMainHandItem().shrink(1);
                    }
                    level.setBlockAndUpdate(blockPos, ((SoulCageBlock)((Object)WitcheryBlocks.INSTANCE.getSOUL_CAGE().get())).defaultBlockState());
                    event.setCanceled(true);
                    return;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

