/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.cauldron;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.sterner.witchery.content.block.altar.AltarBlockEntity;
import dev.sterner.witchery.content.block.cauldron.WitcheryCauldronBlock;
import dev.sterner.witchery.content.item.potion.WitcheryPotionIngredient;
import dev.sterner.witchery.content.item.potion.WitcheryPotionItem;
import dev.sterner.witchery.content.recipe.MultipleItemRecipeInput;
import dev.sterner.witchery.content.recipe.cauldron.CauldronBrewingRecipe;
import dev.sterner.witchery.content.recipe.cauldron.CauldronCraftingRecipe;
import dev.sterner.witchery.content.recipe.cauldron.CauldronInfusionRecipe;
import dev.sterner.witchery.content.recipe.cauldron.CauldronInfusionRecipeInput;
import dev.sterner.witchery.content.recipe.cauldron.ItemStackWithColor;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.api.block.AltarPowerConsumer;
import dev.sterner.witchery.core.api.multiblock.MultiBlockCoreEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockHorizontalDirectionStructure;
import dev.sterner.witchery.core.data.PotionDataReloadListener;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryRecipeTypes;
import dev.sterner.witchery.network.CauldronEffectParticleS2CPayload;
import dev.sterner.witchery.network.CauldronPoofS2CPayload;
import dev.sterner.witchery.network.CauldronPotionBrewParticleS2CPayload;
import dev.sterner.witchery.network.SpawnSmokePoofParticlesS2CPayload;
import dev.sterner.witchery.network.SyncCauldronS2CPayload;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 m2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001mB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010+\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\bH\u0016J\u0018\u0010.\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0011H\u0002J\u0018\u00100\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0011H\u0002J\u0018\u00101\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u00102\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u00103\u001a\u00020\u0014H\u0002J\u0010\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020\u0014H\u0002J\u0018\u00106\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00107\u001a\u00020\u0014H\u0002J\u0018\u00108\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u00109\u001a\u00020'J\u0006\u0010:\u001a\u00020'J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J \u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020EH\u0016J\"\u0010F\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020EH\u0002J\u0018\u0010G\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0014H\u0002J*\u0010H\u001a\u0014\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020J0I2\u0006\u0010A\u001a\u00020B2\u0006\u0010K\u001a\u00020\u0014H\u0002J4\u0010L\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010M\u001a\u00020B2\u0006\u0010N\u001a\u00020\u00062\u0006\u0010O\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020JH\u0002J\u0018\u0010R\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010S\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010T\u001a\u00020\u0016H\u0002J\u0018\u0010U\u001a\u00020'2\u0006\u0010V\u001a\u00020<2\u0006\u0010W\u001a\u00020>H\u0014J\u0018\u0010X\u001a\u00020'2\u0006\u0010Y\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0014J\b\u0010Z\u001a\u00020'H\u0016J\b\u0010[\u001a\u00020\u0016H\u0016J\b\u0010\\\u001a\u00020%H\u0016J\u0010\u0010]\u001a\u00020\u00142\u0006\u0010^\u001a\u00020\u0016H\u0016J\u0018\u0010_\u001a\u00020\u00142\u0006\u0010^\u001a\u00020\u00162\u0006\u0010`\u001a\u00020\u0016H\u0016J\u0010\u0010a\u001a\u00020\u00142\u0006\u0010^\u001a\u00020\u0016H\u0016J\u0018\u0010b\u001a\u00020'2\u0006\u0010^\u001a\u00020\u00162\u0006\u0010c\u001a\u00020\u0014H\u0016J\u0010\u0010d\u001a\u00020%2\u0006\u0010M\u001a\u00020BH\u0016J\u0010\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hH\u0016J\"\u0010i\u001a\u00020%2\u0006\u0010j\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\u00142\b\u0010k\u001a\u0004\u0018\u00010hH\u0016J \u0010l\u001a\u00020%2\u0006\u0010j\u001a\u00020\u00162\u0006\u0010c\u001a\u00020\u00142\u0006\u0010k\u001a\u00020hH\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Ldev/sterner/witchery/content/block/cauldron/CauldronBlockEntity;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockCoreEntity;", "Lnet/minecraft/world/Container;", "Lnet/minecraft/world/WorldlyContainer;", "Ldev/sterner/witchery/core/api/block/AltarPowerConsumer;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "cauldronCraftingRecipe", "Ldev/sterner/witchery/content/recipe/cauldron/CauldronCraftingRecipe;", "cauldronBrewingRecipe", "Ldev/sterner/witchery/content/recipe/cauldron/CauldronBrewingRecipe;", "witcheryPotionItemCache", "", "Ldev/sterner/witchery/content/item/potion/WitcheryPotionIngredient;", "inputItems", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "craftingProgressTicker", "", "brewItemOutput", "cachedAltarPos", "color", "getColor", "()I", "setColor", "(I)V", "fluidTank", "Lnet/neoforged/neoforge/fluids/capability/templates/FluidTank;", "getFluidTank", "()Lnet/neoforged/neoforge/fluids/capability/templates/FluidTank;", "setFluidTank", "(Lnet/neoforged/neoforge/fluids/capability/templates/FluidTank;)V", "complete", "", "refreshCraftingAndBrewingRecipe", "", "level", "Lnet/minecraft/world/level/Level;", "refreshBrewingRecipe", "handleDripstone", "tick", "blockState", "hasEnoughAltarPower", "ingredient", "consumeAltarPower", "consumeItem", "checkInfusionRecipe", "thrownItem", "forceColor", "potionIngredientStack", "updateColor", "cacheForColorItem", "craft", "resetCauldronPartial", "fullReset", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pStack", "pHand", "Lnet/minecraft/world/InteractionHand;", "handleFluidInteraction", "handleGlassBottleInteraction", "createOutput", "Lkotlin/Triple;", "", "itemStack", "playSound", "player", "blockPos", "sound", "Lnet/minecraft/sounds/SoundEvent;", "volume", "spawnSmokeParticle", "spawnFailParticle", "getFirstEmptyIndex", "loadAdditional", "pTag", "pRegistries", "saveAdditional", "tag", "clearContent", "getContainerSize", "isEmpty", "getItem", "slot", "removeItem", "amount", "removeItemNoUpdate", "setItem", "stack", "stillValid", "getSlotsForFace", "", "side", "Lnet/minecraft/core/Direction;", "canPlaceItemThroughFace", "index", "direction", "canTakeItemThroughFace", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nCauldronBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CauldronBlockEntity.kt\ndev/sterner/witchery/content/block/cauldron/CauldronBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,759:1\n774#2:760\n865#2,2:761\n295#2,2:763\n774#2:765\n865#2,2:766\n774#2:768\n865#2,2:769\n295#2,2:771\n1869#2:773\n1740#2,3:774\n1870#2:778\n295#2,2:779\n774#2:781\n865#2,2:782\n1869#2:784\n1869#2,2:785\n1870#2:787\n1869#2:788\n1869#2,2:789\n1870#2:791\n1#3:777\n*S KotlinDebug\n*F\n+ 1 CauldronBlockEntity.kt\ndev/sterner/witchery/content/block/cauldron/CauldronBlockEntity\n*L\n89#1:760\n89#1:761,2\n92#1:763,2\n113#1:765\n113#1:766,2\n121#1:768\n121#1:769,2\n123#1:771,2\n236#1:773\n257#1:774,3\n236#1:778\n316#1:779,2\n353#1:781\n353#1:782,2\n355#1:784\n356#1:785,2\n355#1:787\n366#1:788\n367#1:789,2\n366#1:791\n*E\n"})
public final class CauldronBlockEntity
extends MultiBlockCoreEntity
implements Container,
WorldlyContainer,
AltarPowerConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CauldronCraftingRecipe cauldronCraftingRecipe;
    @Nullable
    private CauldronBrewingRecipe cauldronBrewingRecipe;
    @NotNull
    private List<WitcheryPotionIngredient> witcheryPotionItemCache;
    @NotNull
    private NonNullList<ItemStack> inputItems;
    private int craftingProgressTicker;
    @NotNull
    private ItemStack brewItemOutput;
    @Nullable
    private BlockPos cachedAltarPos;
    private int color;
    @NotNull
    private FluidTank fluidTank;
    private boolean complete;
    public static final int WATER_COLOR = 4159204;
    public static final int PROGRESS_TICKS = 60;

    public CauldronBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getCAULDRON().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        BlockEntityType blockEntityType = (BlockEntityType)object;
        MultiBlockHorizontalDirectionStructure multiBlockHorizontalDirectionStructure = WitcheryCauldronBlock.Companion.getSTRUCTURE().get();
        Intrinsics.checkNotNullExpressionValue((Object)multiBlockHorizontalDirectionStructure, (String)"get(...)");
        super(blockEntityType, multiBlockHorizontalDirectionStructure, pos, state);
        this.witcheryPotionItemCache = new ArrayList();
        NonNullList nonNullList = NonNullList.withSize((int)12, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.inputItems = nonNullList;
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.brewItemOutput = itemStack;
        this.color = 4159204;
        this.fluidTank = new FluidTank(this){
            final /* synthetic */ CauldronBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super(1000);
            }

            protected void onContentsChanged() {
                this.this$0.setChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return Intrinsics.areEqual((Object)stack.getFluid(), (Object)Fluids.WATER);
            }
        };
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    @NotNull
    public final FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public final void setFluidTank(@NotNull FluidTank fluidTank2) {
        Intrinsics.checkNotNullParameter((Object)fluidTank2, (String)"<set-?>");
        this.fluidTank = fluidTank2;
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshCraftingAndBrewingRecipe(Level level) {
        RecipeHolder possibleRecipe;
        Object v0;
        List nonEmptyItems;
        block6: {
            void $this$filterTo$iv$iv;
            List allRecipesOfType = level.getRecipeManager().getAllRecipesFor((RecipeType)WitcheryRecipeTypes.INSTANCE.getCAULDRON_RECIPE_TYPE().get());
            Iterable $this$filter$iv = (Iterable)this.inputItems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ItemStack it = (ItemStack)element$iv$iv;
                boolean bl = false;
                if (!(!it.isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            nonEmptyItems = (List)destination$iv$iv;
            Intrinsics.checkNotNull((Object)allRecipesOfType);
            Iterable $this$firstOrNull$iv = allRecipesOfType;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RecipeHolder it = (RecipeHolder)element$iv;
                boolean bl = false;
                if (!((CauldronCraftingRecipe)it.value()).matches(new MultipleItemRecipeInput(nonEmptyItems), level)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        RecipeHolder recipeHolder = possibleRecipe = (RecipeHolder)v0;
        if (recipeHolder != null) {
            RecipeHolder recipe = recipeHolder;
            boolean bl = false;
            boolean isOrderCorrect = CauldronBlockEntity.Companion.isOrderRight(nonEmptyItems, ((CauldronCraftingRecipe)recipe.value()).getInputItems());
            if (isOrderCorrect) {
                this.cauldronCraftingRecipe = (CauldronCraftingRecipe)recipe.value();
                this.complete = nonEmptyItems.size() == ((CauldronCraftingRecipe)recipe.value()).getInputItems().size();
            } else {
                this.refreshBrewingRecipe(level);
            }
        } else {
            CauldronBlockEntity $this$refreshCraftingAndBrewingRecipe_u24lambda_u243 = this;
            boolean bl = false;
            $this$refreshCraftingAndBrewingRecipe_u24lambda_u243.refreshBrewingRecipe(level);
        }
        this.setChanged();
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshBrewingRecipe(Level level) {
        RecipeHolder possibleRecipe;
        Object v1;
        List nonEmptyItems;
        block7: {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            List list = level.getRecipeManager().getAllRecipesFor((RecipeType)WitcheryRecipeTypes.INSTANCE.getCAULDRON_BREWING_RECIPE_TYPE().get());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllRecipesFor(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable<Object> destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String currentDimension;
                RecipeHolder recipe = (RecipeHolder)element$iv$iv;
                boolean bl = false;
                Set<String> dimensions = ((CauldronBrewingRecipe)recipe.value()).getDimensionKey();
                boolean noRequirement = dimensions.isEmpty() || dimensions.size() == 1 && dimensions.contains("");
                Intrinsics.checkNotNullExpressionValue((Object)level.dimension().location().toString(), (String)"toString(...)");
                if (!(noRequirement || dimensions.contains(currentDimension))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allRecipesOfType = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = (Iterable)this.inputItems;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ItemStack it = (ItemStack)element$iv$iv;
                boolean bl = false;
                if (!(!it.isEmpty())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            nonEmptyItems = (List)destination$iv$iv2;
            Iterable $this$firstOrNull$iv = allRecipesOfType;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RecipeHolder it = (RecipeHolder)element$iv;
                boolean bl = false;
                if (!((CauldronBrewingRecipe)it.value()).matches(new MultipleItemRecipeInput(nonEmptyItems), level)) continue;
                v1 = element$iv;
                break block7;
            }
            v1 = null;
        }
        RecipeHolder recipeHolder = possibleRecipe = (RecipeHolder)v1;
        if (recipeHolder != null) {
            RecipeHolder recipe = recipeHolder;
            boolean bl = false;
            boolean isOrderCorrect = CauldronBlockEntity.Companion.isOrderRight(nonEmptyItems, ((CauldronBrewingRecipe)recipe.value()).getInputItems());
            if (isOrderCorrect) {
                this.cauldronBrewingRecipe = (CauldronBrewingRecipe)recipe.value();
                this.complete = nonEmptyItems.size() == ((CauldronBrewingRecipe)recipe.value()).getInputItems().size();
            } else {
                this.cauldronBrewingRecipe = null;
                this.complete = false;
            }
        } else {
            CauldronBlockEntity $this$refreshBrewingRecipe_u24lambda_u244 = this;
            boolean bl = false;
            $this$refreshBrewingRecipe_u24lambda_u244.cauldronBrewingRecipe = null;
            $this$refreshBrewingRecipe_u24lambda_u244.complete = false;
        }
        this.setChanged();
    }

    private final void handleDripstone(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        BlockPos blockPos = PointedDripstoneBlock.findStalactiteTipAboveCauldron((Level)level, (BlockPos)pos);
        if (blockPos == null) {
            return;
        }
        BlockPos dripstone = blockPos;
        Fluid fluid = PointedDripstoneBlock.getCauldronFillFluidType((ServerLevel)((ServerLevel)level), (BlockPos)dripstone);
        if (Intrinsics.areEqual((Object)fluid, (Object)Fluids.EMPTY)) {
            return;
        }
        this.fluidTank.fill(new FluidStack(fluid, 10), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        double randZ;
        double randY;
        double randX;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        if ((double)level.random.nextFloat() < 0.005) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.handleDripstone(level, blockPos);
        }
        if (level.isClientSide || !((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            return;
        }
        if (level.getGameTime() % (long)4 == 0L && !this.complete && !this.fluidTank.isEmpty()) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.consumeItem(level, blockPos);
        }
        if (!((Collection)this.witcheryPotionItemCache).isEmpty()) {
            randX = (double)this.getBlockPos().getX() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.1, (double)0.1);
            randY = (double)this.getBlockPos().getY() + 1.0;
            randZ = (double)this.getBlockPos().getZ() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.1, (double)0.1);
            if (level instanceof ServerLevel) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new CauldronPotionBrewParticleS2CPayload(new Vector3d(randX, randY, randZ), this.color), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (!this.brewItemOutput.isEmpty()) {
            randX = (double)this.getBlockPos().getX() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
            randY = (double)this.getBlockPos().getY() + 1.0;
            randZ = (double)this.getBlockPos().getZ() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
            if (level instanceof ServerLevel) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new CauldronEffectParticleS2CPayload(new Vector3d(randX, randY, randZ), this.color), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if ((this.cauldronCraftingRecipe != null || this.cauldronBrewingRecipe != null) && this.complete) {
            if (this.craftingProgressTicker < 60) {
                int n = this.craftingProgressTicker;
                this.craftingProgressTicker = n + 1;
                this.setChanged();
            } else {
                this.craftingProgressTicker = 0;
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                this.craft(level, blockPos);
            }
        }
    }

    private final boolean hasEnoughAltarPower(Level level, WitcheryPotionIngredient ingredient) {
        int requiredAltarPower;
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            if (!(level.getBlockEntity(blockPos) instanceof AltarBlockEntity)) {
                this.cachedAltarPos = null;
                this.setChanged();
                return false;
            }
        }
        if ((requiredAltarPower = ingredient.getAltarPower()) > 0 && this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            return this.tryConsumeAltarPower(level, blockPos, requiredAltarPower, true);
        }
        return requiredAltarPower == 0;
    }

    private final boolean consumeAltarPower(Level level, WitcheryPotionIngredient ingredient) {
        int requiredAltarPower;
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            if (!(level.getBlockEntity(blockPos) instanceof AltarBlockEntity)) {
                this.cachedAltarPos = null;
                this.setChanged();
                return false;
            }
        }
        if ((requiredAltarPower = ingredient.getAltarPower()) > 0 && this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            return this.tryConsumeAltarPower(level, blockPos, requiredAltarPower, false);
        }
        return requiredAltarPower == 0;
    }

    /*
     * Unable to fully structure code
     */
    private final void consumeItem(Level level, BlockPos pos) {
        if (this.cachedAltarPos == null && level instanceof ServerLevel) {
            v0 = (ServerLevel)level;
            v1 = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getBlockPos(...)");
            this.cachedAltarPos = this.getAltarPos(v0, v1);
        }
        v2 = level.getEntities((EntityTypeTest)EntityType.ITEM, new AABB(this.getBlockPos()), (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, consumeItem$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, consumeItem$lambda$0(net.minecraft.world.entity.item.ItemEntity ), (Lnet/minecraft/world/entity/item/ItemEntity;)Ljava/lang/Boolean;)()));
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getEntities(...)");
        $this$forEach$iv = v2;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block17: {
                block15: {
                    block18: {
                        block16: {
                            entity = (ItemEntity)element$iv;
                            $i$a$-forEach-CauldronBlockEntity$consumeItem$2 = false;
                            item = entity.getItem();
                            cacheForColorItem = item.copy();
                            if (!item.is((Item)WitcheryItems.INSTANCE.getWOOD_ASH().get())) break block16;
                            this.fullReset();
                            if (level instanceof ServerLevel) {
                                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SyncCauldronS2CPayload(pos, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }
                            item.shrink(1);
                            this.setChanged();
                            break block17;
                        }
                        if (this.brewItemOutput.isEmpty()) break block18;
                        Intrinsics.checkNotNull((Object)item);
                        if (!this.checkInfusionRecipe(level, item)) break block18;
                        item.shrink(1);
                        this.setChanged();
                        break block17;
                    }
                    if (!item.is(Items.NETHER_WART) || this.cauldronCraftingRecipe != null || this.cauldronBrewingRecipe != null) ** GOTO lbl-1000
                    $this$all$iv = (Iterable)this.inputItems;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v3 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            it = (ItemStack)element$iv;
                            $i$a$-all-CauldronBlockEntity$consumeItem$2$1 = false;
                            if (it.isEmpty()) continue;
                            v3 = false;
                            break block15;
                        }
                        v3 = true;
                    }
                }
                if (v3) {
                    Intrinsics.checkNotNull((Object)item);
                    if (PotionDataReloadListener.INSTANCE.getIngredientFromItem(item) != null) {
                        $i$a$-let-CauldronBlockEntity$consumeItem$2$2 = false;
                        this.witcheryPotionItemCache.add(it);
                    }
                    this.forceColor(item);
                    level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.35f, 1.0f);
                    item.shrink(1);
                } else if (((Collection)this.witcheryPotionItemCache).isEmpty() == false) {
                    Intrinsics.checkNotNull((Object)item);
                    if (PotionDataReloadListener.INSTANCE.getIngredientFromItem(item) != null) {
                        $i$a$-let-CauldronBlockEntity$consumeItem$2$3 = false;
                        if (this.hasEnoughAltarPower(level, it) && WitcheryPotionItem.Companion.tryAddItemToPotion(this.witcheryPotionItemCache, it)) {
                            this.consumeAltarPower(level, it);
                            this.forceColor(item);
                            level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.35f, 1.0f);
                            item.shrink(1);
                        } else {
                            level.playSound(null, pos, SoundEvents.FIREWORK_ROCKET_LARGE_BLAST_FAR, SoundSource.BLOCKS, 0.25f, 1.0f);
                            level.playSound(null, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS, 0.95f, 1.0f);
                            this.spawnFailParticle(level, pos);
                            dx = CauldronBlockEntity.consumeItem$lambda$2$2$randomSmallOffset(level);
                            dz = CauldronBlockEntity.consumeItem$lambda$2$2$randomSmallOffset(level);
                            entity.setDeltaMovement(entity.getDeltaMovement().add(dx, 0.75, dz));
                        }
                    }
                } else {
                    firstEmpty = this.getFirstEmptyIndex();
                    if (firstEmpty != -1) {
                        v4 = item.split(1);
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"split(...)");
                        this.setItem(firstEmpty, v4);
                        level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.35f, 1.0f);
                        this.refreshCraftingAndBrewingRecipe(level);
                        Intrinsics.checkNotNull((Object)cacheForColorItem);
                        this.updateColor(level, cacheForColorItem);
                    }
                }
            }
            this.setChanged();
        }
    }

    private final boolean checkInfusionRecipe(Level level, ItemStack thrownItem) {
        Object v0;
        CauldronInfusionRecipeInput input;
        block4: {
            List allInfusionRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)WitcheryRecipeTypes.INSTANCE.getCAULDRON_INFUSION_RECIPE_TYPE().get());
            input = new CauldronInfusionRecipeInput(this.brewItemOutput, thrownItem);
            Intrinsics.checkNotNull((Object)allInfusionRecipes);
            Iterable $this$firstOrNull$iv = allInfusionRecipes;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RecipeHolder it = (RecipeHolder)element$iv;
                boolean bl = false;
                if (!((CauldronInfusionRecipe)it.value()).matches(input, level)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        RecipeHolder matchingRecipe = v0;
        if (matchingRecipe != null) {
            CauldronInfusionRecipe recipe = (CauldronInfusionRecipe)matchingRecipe.value();
            if (this.cachedAltarPos != null && recipe.getAltarPower() > 0) {
                BlockPos blockPos = this.cachedAltarPos;
                Intrinsics.checkNotNull((Object)blockPos);
                if (!this.tryConsumeAltarPower(level, blockPos, recipe.getAltarPower(), false)) {
                    return false;
                }
            }
            RegistryAccess registryAccess = level.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            ItemStack output = recipe.assemble(input, (HolderLookup.Provider)registryAccess);
            Containers.dropItemStack((Level)level, (double)((double)this.getBlockPos().getX() + 0.5), (double)((double)this.getBlockPos().getY() + 1.1), (double)((double)this.getBlockPos().getZ() + 0.5), (ItemStack)output);
            level.playSound(null, this.getBlockPos(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.spawnSmokeParticle(level, blockPos);
            this.fullReset();
            return true;
        }
        return false;
    }

    private final void forceColor(ItemStack potionIngredientStack) {
        WitcheryPotionIngredient witcheryPotionIngredient = PotionDataReloadListener.INSTANCE.getIngredientFromItem(potionIngredientStack);
        this.color = witcheryPotionIngredient != null ? witcheryPotionIngredient.getColor() : 5909773;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateColor(Level level, ItemStack cacheForColorItem) {
        boolean orderIsCorrect;
        ItemStackWithColor ingredientWithColor;
        Iterable $this$forEach$iv;
        void $this$filterTo$iv$iv;
        boolean colorSet = false;
        List allCraftingRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)WitcheryRecipeTypes.INSTANCE.getCAULDRON_RECIPE_TYPE().get());
        List allBrewingRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)WitcheryRecipeTypes.INSTANCE.getCAULDRON_BREWING_RECIPE_TYPE().get());
        Iterable $this$filter$iv = (Iterable)this.inputItems;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack it = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonEmptyItems = (List)destination$iv$iv;
        Intrinsics.checkNotNull((Object)allCraftingRecipes);
        Iterable $this$forEach$iv2 = allCraftingRecipes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            RecipeHolder recipe = (RecipeHolder)element$iv;
            boolean bl = false;
            $this$forEach$iv = ((CauldronCraftingRecipe)recipe.value()).getInputItems();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                ingredientWithColor = (ItemStackWithColor)element$iv2;
                boolean bl2 = false;
                orderIsCorrect = CauldronBlockEntity.Companion.isOrderRight(nonEmptyItems, ((CauldronCraftingRecipe)recipe.value()).getInputItems());
                if (!ItemStack.isSameItem((ItemStack)ingredientWithColor.getItemStack(), (ItemStack)cacheForColorItem) || !orderIsCorrect) continue;
                this.color = ingredientWithColor.getColor();
                colorSet = true;
            }
        }
        if (!colorSet) {
            Intrinsics.checkNotNull((Object)allBrewingRecipes);
            $this$forEach$iv2 = allBrewingRecipes;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                RecipeHolder recipe = (RecipeHolder)element$iv;
                boolean bl = false;
                $this$forEach$iv = ((CauldronBrewingRecipe)recipe.value()).getInputItems();
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    ingredientWithColor = (ItemStackWithColor)element$iv2;
                    boolean bl3 = false;
                    orderIsCorrect = CauldronBlockEntity.Companion.isOrderRight(nonEmptyItems, ((CauldronBrewingRecipe)recipe.value()).getInputItems());
                    if (!ItemStack.isSameItem((ItemStack)ingredientWithColor.getItemStack(), (ItemStack)cacheForColorItem) || !orderIsCorrect) continue;
                    this.color = ingredientWithColor.getColor();
                    colorSet = true;
                }
            }
        }
        if (!colorSet) {
            this.color = 5909773;
        }
    }

    private final void craft(Level level, BlockPos pos) {
        CauldronCraftingRecipe cauldronCraftingRecipe = this.cauldronCraftingRecipe;
        List itemsToCraft = cauldronCraftingRecipe != null ? cauldronCraftingRecipe.getOutputItems() : null;
        List list = itemsToCraft;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (ItemStack item : list) {
            Iterator iterator;
            NonNullList list2 = NonNullList.create();
            list2.add((Object)item.copy());
            Intrinsics.checkNotNullExpressionValue((Object)list2.iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                ItemStack drop = (ItemStack)iterator.next();
                Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 1.1), (double)((double)pos.getZ() + 0.5), (ItemStack)drop);
            }
        }
        if (level instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SyncCauldronS2CPayload(pos, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (this.cauldronCraftingRecipe != null) {
            level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.5f, 1.0f);
            this.spawnSmokeParticle(level, pos);
        }
        this.resetCauldronPartial();
    }

    public final void resetCauldronPartial() {
        if (this.cauldronCraftingRecipe != null) {
            this.fluidTank.setFluid(FluidStack.EMPTY);
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.brewItemOutput = itemStack;
        }
        if (this.cauldronBrewingRecipe != null) {
            CauldronBrewingRecipe cauldronBrewingRecipe = this.cauldronBrewingRecipe;
            Intrinsics.checkNotNull((Object)cauldronBrewingRecipe);
            this.brewItemOutput = cauldronBrewingRecipe.getOutputItem();
        } else {
            this.color = 4159204;
        }
        this.witcheryPotionItemCache = new ArrayList();
        this.clearContent();
        this.cauldronCraftingRecipe = null;
        this.cauldronBrewingRecipe = null;
        this.complete = false;
        this.setChanged();
    }

    public final void fullReset() {
        this.color = 4159204;
        this.clearContent();
        this.witcheryPotionItemCache = new ArrayList();
        this.cauldronCraftingRecipe = null;
        this.cauldronBrewingRecipe = null;
        this.complete = false;
        this.fluidTank.setFluid(FluidStack.EMPTY);
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.brewItemOutput = itemStack;
        this.setChanged();
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag tag = super.getUpdateTag(registries);
        tag.put("FluidTank", (Tag)this.fluidTank.writeToNBT(registries, new CompoundTag()));
        return tag;
    }

    @Override
    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player pPlayer, @NotNull ItemStack pStack, @NotNull InteractionHand pHand) {
        ItemInteractionResult itemInteractionResult;
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        if (pStack.is(Items.FLINT_AND_STEEL)) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            SoundEvent soundEvent = SoundEvents.FLINTANDSTEEL_USE;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"FLINTANDSTEEL_USE");
            CauldronBlockEntity.playSound$default(this, this.level, pPlayer, blockPos, soundEvent, 0.0f, 16, null);
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2);
            level2.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos());
            pStack.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
            itemInteractionResult = ItemInteractionResult.SUCCESS;
        } else if (pStack.is(Items.GLASS_BOTTLE)) {
            itemInteractionResult = this.handleGlassBottleInteraction(pPlayer, pStack);
        } else {
            itemInteractionResult = this.handleFluidInteraction(pPlayer, pStack, pHand);
            if (itemInteractionResult == null) {
                itemInteractionResult = super.onUseWithItem(pPlayer, pStack, pHand);
            }
        }
        return itemInteractionResult;
    }

    private final ItemInteractionResult handleFluidInteraction(Player pPlayer, ItemStack pStack, InteractionHand pHand) {
        boolean result;
        IFluidHandler fluidHandler;
        if (this.fluidTank.getFluidAmount() == this.fluidTank.getCapacity()) {
            return null;
        }
        Level level = this.level;
        IFluidHandler iFluidHandler = fluidHandler = level != null ? (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos(), this.getBlockState(), (BlockEntity)this, null) : null;
        if (fluidHandler != null && (result = FluidUtil.interactWithFluidHandler((Player)pPlayer, (InteractionHand)pHand, fluidHandler))) {
            this.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        if (pStack.is(Items.WATER_BUCKET)) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            SoundEvent soundEvent = SoundEvents.BUCKET_FILL;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BUCKET_FILL");
            CauldronBlockEntity.playSound$default(this, this.level, pPlayer, blockPos, soundEvent, 0.0f, 16, null);
            this.fluidTank.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
            if (!pPlayer.isCreative()) {
                pPlayer.setItemInHand(pHand, Items.BUCKET.getDefaultInstance());
            }
            this.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        if (pStack.is(Items.POTION)) {
            PotionContents potionContents;
            PotionContents potionContents2 = potionContents = (PotionContents)pStack.get(DataComponents.POTION_CONTENTS);
            boolean bl = potionContents2 != null ? potionContents2.is(Potions.WATER) : false;
            if (bl) {
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                SoundEvent soundEvent = SoundEvents.BUCKET_FILL;
                Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BUCKET_FILL");
                CauldronBlockEntity.playSound$default(this, this.level, pPlayer, blockPos, soundEvent, 0.0f, 16, null);
                if (!pPlayer.isCreative()) {
                    pPlayer.setItemInHand(pHand, Items.GLASS_BOTTLE.getDefaultInstance());
                }
                this.fluidTank.fill(new FluidStack((Fluid)Fluids.WATER, 333), IFluidHandler.FluidAction.EXECUTE);
                this.setChanged();
                return ItemInteractionResult.SUCCESS;
            }
        }
        return null;
    }

    private final ItemInteractionResult handleGlassBottleInteraction(Player pPlayer, ItemStack pStack) {
        int potionAmount = 333;
        if (!((Collection)this.witcheryPotionItemCache).isEmpty() && this.fluidTank.getFluidAmount() >= potionAmount) {
            ItemStack itemStack;
            pStack.shrink(1);
            WitcheryApi.INSTANCE.makePlayerWitchy(pPlayer);
            ItemStack $this$handleGlassBottleInteraction_u24lambda_u240 = itemStack = ((WitcheryPotionItem)((Object)WitcheryItems.INSTANCE.getWITCHERY_POTION().get())).getDefaultInstance();
            boolean bl = false;
            $this$handleGlassBottleInteraction_u24lambda_u240.set((DataComponentType)WitcheryDataComponents.INSTANCE.getWITCHERY_POTION_CONTENT().get(), this.witcheryPotionItemCache);
            ItemStack potion = itemStack;
            Intrinsics.checkNotNull((Object)potion);
            Triple<Float, ItemStack, Float> witchesPotion = this.createOutput(pPlayer, potion);
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            if (!level.isClientSide) {
                if (!pPlayer.addItem(((ItemStack)witchesPotion.getSecond()).copy())) {
                    Level level2 = this.level;
                    Intrinsics.checkNotNull((Object)level2);
                    Containers.dropItemStack((Level)level2, (double)pPlayer.getX(), (double)(pPlayer.getY() + 0.5), (double)pPlayer.getZ(), (ItemStack)((ItemStack)witchesPotion.getSecond()).copy());
                }
                Level level3 = this.level;
                Intrinsics.checkNotNull((Object)level3);
                float roll1 = level3.random.nextFloat();
                if (roll1 < ((Number)witchesPotion.getFirst()).floatValue() && !pPlayer.addItem(((ItemStack)witchesPotion.getSecond()).copy())) {
                    Level level4 = this.level;
                    Intrinsics.checkNotNull((Object)level4);
                    Containers.dropItemStack((Level)level4, (double)pPlayer.getX(), (double)(pPlayer.getY() + 0.5), (double)pPlayer.getZ(), (ItemStack)((ItemStack)witchesPotion.getSecond()).copy());
                }
                Level level5 = this.level;
                Intrinsics.checkNotNull((Object)level5);
                float roll2 = level5.random.nextFloat();
                if (roll2 < ((Number)witchesPotion.getThird()).floatValue() && !pPlayer.addItem(((ItemStack)witchesPotion.getSecond()).copy())) {
                    Level level6 = this.level;
                    Intrinsics.checkNotNull((Object)level6);
                    Containers.dropItemStack((Level)level6, (double)pPlayer.getX(), (double)(pPlayer.getY() + 0.5), (double)pPlayer.getZ(), (ItemStack)((ItemStack)witchesPotion.getSecond()).copy());
                }
            }
            this.fluidTank.drain(potionAmount, IFluidHandler.FluidAction.EXECUTE);
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            SoundEvent soundEvent = SoundEvents.ITEM_PICKUP;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"ITEM_PICKUP");
            this.playSound(this.level, pPlayer, blockPos, soundEvent, 0.5f);
            BlockPos blockPos2 = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
            SoundEvent soundEvent2 = SoundEvents.BUCKET_EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent2, (String)"BUCKET_EMPTY");
            CauldronBlockEntity.playSound$default(this, this.level, pPlayer, blockPos2, soundEvent2, 0.0f, 16, null);
            if (this.fluidTank.getFluidAmount() < potionAmount) {
                this.fullReset();
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (!this.brewItemOutput.isEmpty() && this.fluidTank.getFluidAmount() >= potionAmount) {
            WitcheryApi.INSTANCE.makePlayerWitchy(pPlayer);
            pStack.shrink(1);
            ItemStack itemStack = this.brewItemOutput.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            Triple<Float, ItemStack, Float> brewOutput = this.createOutput(pPlayer, itemStack);
            if (this.level != null) {
                Level level = this.level;
                Intrinsics.checkNotNull((Object)level);
                if (!level.isClientSide) {
                    if (!pPlayer.addItem(((ItemStack)brewOutput.getSecond()).copy())) {
                        Level level7 = this.level;
                        Intrinsics.checkNotNull((Object)level7);
                        Containers.dropItemStack((Level)level7, (double)pPlayer.getX(), (double)(pPlayer.getY() + 0.5), (double)pPlayer.getZ(), (ItemStack)((ItemStack)brewOutput.getSecond()).copy());
                    }
                    Level level8 = this.level;
                    Intrinsics.checkNotNull((Object)level8);
                    float roll1 = level8.random.nextFloat();
                    if (roll1 < ((Number)brewOutput.getFirst()).floatValue() && !pPlayer.addItem(((ItemStack)brewOutput.getSecond()).copy())) {
                        Level level9 = this.level;
                        Intrinsics.checkNotNull((Object)level9);
                        Containers.dropItemStack((Level)level9, (double)pPlayer.getX(), (double)(pPlayer.getY() + 0.5), (double)pPlayer.getZ(), (ItemStack)((ItemStack)brewOutput.getSecond()).copy());
                    }
                    Level level10 = this.level;
                    Intrinsics.checkNotNull((Object)level10);
                    float roll2 = level10.random.nextFloat();
                    if (roll2 < ((Number)brewOutput.getThird()).floatValue() && !pPlayer.addItem(((ItemStack)brewOutput.getSecond()).copy())) {
                        Level level11 = this.level;
                        Intrinsics.checkNotNull((Object)level11);
                        Containers.dropItemStack((Level)level11, (double)pPlayer.getX(), (double)(pPlayer.getY() + 0.5), (double)pPlayer.getZ(), (ItemStack)((ItemStack)brewOutput.getSecond()).copy());
                    }
                }
            }
            this.fluidTank.drain(potionAmount, IFluidHandler.FluidAction.EXECUTE);
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            SoundEvent soundEvent = SoundEvents.ITEM_PICKUP;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"ITEM_PICKUP");
            this.playSound(this.level, pPlayer, blockPos, soundEvent, 0.5f);
            BlockPos blockPos3 = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"getBlockPos(...)");
            SoundEvent soundEvent3 = SoundEvents.BUCKET_EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent3, (String)"BUCKET_EMPTY");
            CauldronBlockEntity.playSound$default(this, this.level, pPlayer, blockPos3, soundEvent3, 0.0f, 16, null);
            if (this.fluidTank.getFluidAmount() < potionAmount) {
                this.fullReset();
            }
            this.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private final Triple<Float, ItemStack, Float> createOutput(Player pPlayer, ItemStack itemStack) {
        float bonus = 0.0f;
        float thirdBonus = 0.0f;
        ItemStack headItem = pPlayer.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chestItem = pPlayer.getItemBySlot(EquipmentSlot.CHEST);
        if (headItem.is((Item)WitcheryItems.INSTANCE.getWITCHES_HAT().get())) {
            bonus += 0.35f;
        }
        if (chestItem.is((Item)WitcheryItems.INSTANCE.getWITCHES_ROBES().get())) {
            bonus += 0.35f;
        }
        if (headItem.is((Item)WitcheryItems.INSTANCE.getBABA_YAGAS_HAT().get())) {
            bonus += 0.25f;
            thirdBonus += 0.25f;
        }
        return new Triple((Object)Float.valueOf(bonus), (Object)itemStack, (Object)Float.valueOf(thirdBonus));
    }

    private final void playSound(Level level, Player player, BlockPos blockPos, SoundEvent sound, float volume) {
        Level level2 = level;
        Intrinsics.checkNotNull((Object)level2);
        level2.playSound(player, blockPos, sound, SoundSource.BLOCKS, volume, level.getRandom().nextFloat() * 0.4f + 0.8f);
    }

    static /* synthetic */ void playSound$default(CauldronBlockEntity cauldronBlockEntity, Level level, Player player, BlockPos blockPos, SoundEvent soundEvent, float f, int n, Object object) {
        if ((n & 0x10) != 0) {
            f = 1.0f;
        }
        cauldronBlockEntity.playSound(level, player, blockPos, soundEvent, f);
    }

    private final void spawnSmokeParticle(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new CauldronPoofS2CPayload(pos, this.color), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private final void spawnFailParticle(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkPos chunkPos = new ChunkPos(pos);
            Vec3 vec3 = pos.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunkPos, (CustomPacketPayload)new SpawnSmokePoofParticlesS2CPayload(vec3), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private final int getFirstEmptyIndex() {
        int n = this.getContainerSize();
        for (int i = 0; i < n; ++i) {
            if (!this.getItem(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("FluidTank")) {
            this.fluidTank.readFromNBT(pRegistries, pTag.getCompound("FluidTank"));
        }
        this.craftingProgressTicker = pTag.getInt("craftingProgressTicker");
        this.color = pTag.getInt("color");
        this.complete = pTag.getBoolean("complete");
        if (pTag.contains("Item", 10)) {
            CompoundTag compoundTag = pTag.getCompound("Item");
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
            CompoundTag compoundTag2 = compoundTag;
            ItemStack itemStack = ItemStack.parse((HolderLookup.Provider)pRegistries, (Tag)((Tag)compoundTag2)).orElse(ItemStack.EMPTY);
            Intrinsics.checkNotNull((Object)itemStack, (String)"null cannot be cast to non-null type net.minecraft.world.item.ItemStack");
            this.brewItemOutput = itemStack;
        } else {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.brewItemOutput = itemStack;
        }
        NonNullList nonNullList = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.inputItems = nonNullList;
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.inputItems, (HolderLookup.Provider)pRegistries);
        if (pTag.contains("witcheryPotionItemCache", 9)) {
            ListTag listTag = pTag.getList("witcheryPotionItemCache", 10);
            DataResult decodeResult = WitcheryPotionIngredient.Companion.getCODEC().listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)listTag);
            Optional optional = decodeResult.resultOrPartial(CauldronBlockEntity::loadAdditional$lambda$0);
            if (optional != null) {
                Optional it = optional;
                boolean bl = false;
                Object t = it.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                this.witcheryPotionItemCache = CollectionsKt.toMutableList((Collection)((Collection)t));
            }
        }
        if (pTag.contains("altarPos")) {
            this.cachedAltarPos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)pTag, (String)"altarPos").get();
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.put("FluidTank", (Tag)this.fluidTank.writeToNBT(registries, new CompoundTag()));
        tag.putInt("craftingProgressTicker", this.craftingProgressTicker);
        tag.putInt("color", this.color);
        tag.putBoolean("complete", this.complete);
        if (!this.brewItemOutput.isEmpty()) {
            tag.put("Item", this.brewItemOutput.save(registries));
        }
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inputItems, (HolderLookup.Provider)registries);
        DataResult listResult = WitcheryPotionIngredient.Companion.getCODEC().listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.witcheryPotionItemCache);
        Optional optional = listResult.resultOrPartial(CauldronBlockEntity::saveAdditional$lambda$0);
        if (optional != null) {
            Optional it = optional;
            boolean bl = false;
            tag.put("witcheryPotionItemCache", (Tag)it.get());
        }
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            tag.put("altarPos", NbtUtils.writeBlockPos((BlockPos)blockPos));
        }
    }

    public void clearContent() {
        this.inputItems.clear();
    }

    public int getContainerSize() {
        return this.inputItems.size();
    }

    public boolean isEmpty() {
        return this.inputItems.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        Object object = this.inputItems.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem((List)((List)this.inputItems), (int)slot, (int)amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeItem(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem((List)((List)this.inputItems), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"takeItem(...)");
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.inputItems.set(slot, (Object)stack);
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return CollectionsKt.toIntArray((Collection)CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((int)0, (int)this.inputItems.size()))));
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return true;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return false;
    }

    private static final boolean consumeItem$lambda$0(ItemEntity it) {
        return true;
    }

    private static final boolean consumeItem$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final double consumeItem$lambda$2$2$randomSmallOffset(Level $level) {
        void var1_1;
        double it = $level.getRandom().nextDouble() * 0.1 - 0.05;
        boolean bl = false;
        return it < 0.001 && it > -0.001 ? 0.01 : var1_1;
    }

    private static final void loadAdditional$lambda$0(String string) {
    }

    private static final void saveAdditional$lambda$0(String string) {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/content/block/cauldron/CauldronBlockEntity$Companion;", "", "<init>", "()V", "WATER_COLOR", "", "PROGRESS_TICKS", "isOrderRight", "", "inputItems", "", "Lnet/minecraft/world/item/ItemStack;", "recipeItems", "Ldev/sterner/witchery/content/recipe/cauldron/ItemStackWithColor;", "witchery"})
    @SourceDebugExtension(value={"SMAP\nCauldronBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CauldronBlockEntity.kt\ndev/sterner/witchery/content/block/cauldron/CauldronBlockEntity$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,759:1\n1#2:760\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isOrderRight(List<ItemStack> inputItems, List<ItemStackWithColor> recipeItems) {
            if (recipeItems == null) {
                return false;
            }
            if (inputItems.size() > recipeItems.size()) {
                return false;
            }
            int n = ((Collection)inputItems).size();
            for (int index = 0; index < n; ++index) {
                Object v0;
                ItemStack inputItem;
                block4: {
                    inputItem = inputItems.get(index);
                    Iterable iterable = recipeItems;
                    for (Object t : iterable) {
                        ItemStackWithColor it = (ItemStackWithColor)t;
                        boolean bl = false;
                        if (!(it.getOrder() == index)) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                ItemStackWithColor recipeItem = v0;
                if (recipeItem != null && ItemStack.isSameItem((ItemStack)recipeItem.getItemStack(), (ItemStack)inputItem)) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

