/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.critter_snare;

import dev.sterner.witchery.content.block.WitcheryBaseEntityBlock;
import dev.sterner.witchery.content.item.CritterSnareBlockItem;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u000212B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J8\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0014J0\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0015H\u0014J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020!0$2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0014J \u0010'\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010)\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010*\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-H\u0014J(\u0010.\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u000200H\u0014\u00a8\u00063"}, d2={"Ldev/sterner/witchery/content/block/critter_snare/CritterSnareBlock;", "Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "mayPlaceOn", "", "level", "Lnet/minecraft/world/level/BlockGetter;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "spawnAfterBreak", "Lnet/minecraft/server/level/ServerLevel;", "stack", "Lnet/minecraft/world/item/ItemStack;", "dropExperience", "getDrops", "", "params", "Lnet/minecraft/world/level/storage/loot/LootParams$Builder;", "getCloneItemStack", "Lnet/minecraft/world/level/LevelReader;", "canSurvive", "entityInside", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "Companion", "CapturedEntity", "witchery"})
public final class CritterSnareBlock
extends WitcheryBaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VoxelShape SHAPE;
    private static final EnumProperty<CapturedEntity> CAPTURED_STATE;

    public CritterSnareBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CAPTURED_STATE, (Comparable)((Object)CapturedEntity.NONE)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{CAPTURED_STATE};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CapturedEntity cap = context.getItemInHand().has((DataComponentType)WitcheryDataComponents.INSTANCE.getCAPTURED_ENTITY().get()) ? (CapturedEntity)((Object)context.getItemInHand().get((DataComponentType)WitcheryDataComponents.INSTANCE.getCAPTURED_ENTITY().get())) : CapturedEntity.NONE;
        BlockState blockState = this.defaultBlockState();
        Property property = (Property)CAPTURED_STATE;
        CapturedEntity capturedEntity = cap;
        Intrinsics.checkNotNull((Object)((Object)capturedEntity));
        return (BlockState)blockState.setValue(property, (Comparable)((Object)capturedEntity));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getCRITTER_SNARE().get()).create(pos, state);
    }

    private final boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.DIRT) || state.is(Blocks.GRASS_BLOCK);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        boolean cant;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        boolean bl = cant = !state.canSurvive((LevelReader)level, pos);
        if (cant) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        } else {
            BlockState blockState3 = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"updateShape(...)");
        }
        return blockState;
    }

    protected void spawnAfterBreak(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull ItemStack stack, boolean dropExperience) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getCAPTURED_ENTITY().get(), (Object)state.getValue((Property)CAPTURED_STATE));
        super.spawnAfterBreak(state, level, pos, stack, dropExperience);
        stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getCAPTURED_ENTITY().get(), (Object)state.getValue((Property)CAPTURED_STATE));
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, @NotNull LootParams.Builder params) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ItemStack stack = ((CritterSnareBlockItem)((Object)WitcheryItems.INSTANCE.getCRITTER_SNARE().get())).getDefaultInstance();
        stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getCAPTURED_ENTITY().get(), (Object)state.getValue((Property)CAPTURED_STATE));
        List list = new ArrayList();
        Intrinsics.checkNotNull((Object)stack);
        list.add(stack);
        return list;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ItemStack snare = ((CritterSnareBlockItem)((Object)WitcheryItems.INSTANCE.getCRITTER_SNARE().get())).getDefaultInstance();
        snare.set((DataComponentType)WitcheryDataComponents.INSTANCE.getCAPTURED_ENTITY().get(), (Object)state.getValue((Property)CAPTURED_STATE));
        Intrinsics.checkNotNull((Object)snare);
        return snare;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos blockPos = pos.below();
        BlockState blockState = level.getBlockState(blockPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        return this.mayPlaceOn(blockState, (BlockGetter)level, blockPos);
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (state.hasProperty((Property)CAPTURED_STATE) && state.getValue((Property)CAPTURED_STATE) == CapturedEntity.NONE) {
            if (entity instanceof Bat) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CAPTURED_STATE, (Comparable)((Object)CapturedEntity.BAT)));
                entity.discard();
            } else if (entity instanceof Slime && ((Slime)entity).isTiny()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CAPTURED_STATE, (Comparable)((Object)CapturedEntity.SLIME)));
                entity.discard();
            } else if (entity instanceof Silverfish) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CAPTURED_STATE, (Comparable)((Object)CapturedEntity.SILVERFISH)));
                entity.discard();
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return SHAPE;
    }

    static {
        VoxelShape voxelShape = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE = voxelShape;
        CAPTURED_STATE = EnumProperty.create((String)"captured", CapturedEntity.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u000b2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/content/block/critter_snare/CritterSnareBlock$CapturedEntity;", "Lnet/minecraft/util/StringRepresentable;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "SLIME", "SILVERFISH", "BAT", "getSerializedName", "", "Companion", "witchery"})
    @SourceDebugExtension(value={"SMAP\nCritterSnareBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CritterSnareBlock.kt\ndev/sterner/witchery/content/block/critter_snare/CritterSnareBlock$CapturedEntity\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,164:1\n37#2,2:165\n*S KotlinDebug\n*F\n+ 1 CritterSnareBlock.kt\ndev/sterner/witchery/content/block/critter_snare/CritterSnareBlock$CapturedEntity\n*L\n161#1:165,2\n*E\n"})
    public static final class CapturedEntity
    extends Enum<CapturedEntity>
    implements StringRepresentable {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final StringRepresentable.EnumCodec<CapturedEntity> CODEC;
        public static final /* enum */ CapturedEntity NONE;
        public static final /* enum */ CapturedEntity SLIME;
        public static final /* enum */ CapturedEntity SILVERFISH;
        public static final /* enum */ CapturedEntity BAT;
        private static final /* synthetic */ CapturedEntity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public String getSerializedName() {
            String string = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public static CapturedEntity[] values() {
            return (CapturedEntity[])$VALUES.clone();
        }

        public static CapturedEntity valueOf(String value) {
            return Enum.valueOf(CapturedEntity.class, value);
        }

        @NotNull
        public static EnumEntries<CapturedEntity> getEntries() {
            return $ENTRIES;
        }

        private static final CapturedEntity[] CODEC$lambda$0() {
            Collection $this$toTypedArray$iv = (Collection)CapturedEntity.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new CapturedEntity[0]);
        }

        static {
            NONE = new CapturedEntity();
            SLIME = new CapturedEntity();
            SILVERFISH = new CapturedEntity();
            BAT = new CapturedEntity();
            $VALUES = capturedEntityArray = new CapturedEntity[]{CapturedEntity.NONE, CapturedEntity.SLIME, CapturedEntity.SILVERFISH, CapturedEntity.BAT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            StringRepresentable.EnumCodec enumCodec = StringRepresentable.fromEnum(CapturedEntity::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
            CODEC = enumCodec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/content/block/critter_snare/CritterSnareBlock$CapturedEntity$Companion;", "", "<init>", "()V", "CODEC", "Lnet/minecraft/util/StringRepresentable$EnumCodec;", "Ldev/sterner/witchery/content/block/critter_snare/CritterSnareBlock$CapturedEntity;", "getCODEC", "()Lnet/minecraft/util/StringRepresentable$EnumCodec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final StringRepresentable.EnumCodec<CapturedEntity> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R5\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/content/block/critter_snare/CritterSnareBlock$Companion;", "", "<init>", "()V", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "CAPTURED_STATE", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Ldev/sterner/witchery/content/block/critter_snare/CritterSnareBlock$CapturedEntity;", "kotlin.jvm.PlatformType", "getCAPTURED_STATE", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VoxelShape getSHAPE() {
            return SHAPE;
        }

        public final EnumProperty<CapturedEntity> getCAPTURED_STATE() {
            return CAPTURED_STATE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

