/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.distillery;

import dev.sterner.witchery.content.block.WitcheryBaseEntityBlock;
import dev.sterner.witchery.content.block.cauldron.WitcheryCauldronBlock;
import dev.sterner.witchery.content.block.distillery.DistilleryCompanionBlock;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001c\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000b0\u0015H\u0014J(\u0010\u0017\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J0\u0010\u001b\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/content/block/distillery/DistilleryBlock;", "Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "level", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "animateTick", "Lnet/minecraft/world/level/Level;", "random", "Lnet/minecraft/util/RandomSource;", "onRemove", "newState", "movedByPiston", "", "Companion", "witchery"})
public final class DistilleryBlock
extends WitcheryBaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final VoxelShape bottomShape = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    private static final VoxelShape coreShape = Block.box((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape shape = Shapes.join((VoxelShape)bottomShape, (VoxelShape)coreShape, (BooleanOp)BooleanOp.OR);
    @NotNull
    private static final Supplier<MultiBlockStructure> STRUCTURE = DistilleryBlock::STRUCTURE$lambda$0;

    public DistilleryBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        BlockBehaviour.Properties properties2 = properties.noOcclusion().lightLevel(WitcheryCauldronBlock.Companion.litBlockEmission(8));
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"lightLevel(...)");
        super(properties2);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getDISTILLERY().get()).create(pos, state);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = shape;
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"shape");
        return voxelShape;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.LIT};
        builder.add(propertyArray);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Comparable comparable = state.getValue((Property)BlockStateProperties.LIT);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Boolean");
        if (((Boolean)comparable).booleanValue() && random.nextInt(5) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
            double baseX = (double)pos.getX() + 0.5;
            double baseY = (double)pos.getY() + 1.1;
            double baseZ = (double)pos.getZ() + 0.5;
            Pair[] pairArray = new Pair[]{new Pair((Object)Float.valueOf(0.3875f), (Object)Float.valueOf(0.0f)), new Pair((Object)Float.valueOf(-0.3875f), (Object)Float.valueOf(0.0f)), new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.3875f)), new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(-0.3875f))};
            List offsets = CollectionsKt.listOf((Object[])pairArray);
            for (Pair offset : offsets) {
                ParticleEngine manager;
                Particle effectParticle;
                float offsetX = ((Number)offset.getFirst()).floatValue();
                float offsetZ = ((Number)offset.getSecond()).floatValue();
                double particleX = baseX + (double)offsetX;
                double particleZ = baseZ + (double)offsetZ;
                Minecraft minecraft = Minecraft.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)minecraft.particleEngine, (String)"particleEngine");
                Particle particle = effectParticle = manager.createParticle((ParticleOptions)ParticleTypes.EFFECT, particleX, baseY, particleZ, 0.0, 0.0, 0.0);
                if (particle != null) {
                    particle.setColor(1.0f, 0.1f, 1.0f);
                }
            }
        }
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    private static final MultiBlockStructure STRUCTURE$lambda$0() {
        MultiBlockStructure.StructurePiece[] structurePieceArray = new MultiBlockStructure.StructurePiece[1];
        BlockState blockState = ((DistilleryCompanionBlock)((Object)WitcheryBlocks.INSTANCE.getDISTILLERY_COMPONENT().get())).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        structurePieceArray[0] = new MultiBlockStructure.StructurePiece(0, 1, 0, blockState);
        return MultiBlockStructure.Companion.of(structurePieceArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0019\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/content/block/distillery/DistilleryBlock$Companion;", "", "<init>", "()V", "bottomShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "getBottomShape", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "coreShape", "getCoreShape", "shape", "getShape", "STRUCTURE", "Ljava/util/function/Supplier;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure;", "getSTRUCTURE", "()Ljava/util/function/Supplier;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final VoxelShape getBottomShape() {
            return bottomShape;
        }

        public final VoxelShape getCoreShape() {
            return coreShape;
        }

        public final VoxelShape getShape() {
            return shape;
        }

        @NotNull
        public final Supplier<MultiBlockStructure> getSTRUCTURE() {
            return STRUCTURE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

