/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.grassper;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020 H\u0014J\b\u0010$\u001a\u00020\u001aH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010)\u001a\u00020&H\u0016J\u0018\u0010*\u001a\u00020\f2\u0006\u0010)\u001a\u00020&2\u0006\u0010+\u001a\u00020&H\u0016J\u0010\u0010,\u001a\u00020\f2\u0006\u0010)\u001a\u00020&H\u0016J\u0018\u0010\u0010\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020&2\u0006\u0010-\u001a\u00020\fH\u0016J\u0010\u0010.\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\"\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\f2\b\u00106\u001a\u0004\u0018\u000102H\u0016J \u00107\u001a\u00020(2\u0006\u00104\u001a\u00020&2\u0006\u0010-\u001a\u00020\f2\u0006\u00106\u001a\u000202H\u0016R>\u0010\n\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u00068"}, d2={"Ldev/sterner/witchery/content/block/grassper/GrassperBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "Lnet/minecraft/world/Container;", "Lnet/minecraft/world/WorldlyContainer;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "item", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "kotlin.jvm.PlatformType", "getItem", "()Lnet/minecraft/core/NonNullList;", "setItem", "(Lnet/minecraft/core/NonNullList;)V", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pStack", "pHand", "Lnet/minecraft/world/InteractionHand;", "onBreak", "", "player", "loadAdditional", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "tag", "registries", "clearContent", "getContainerSize", "", "isEmpty", "", "slot", "removeItem", "amount", "removeItemNoUpdate", "stack", "stillValid", "getSlotsForFace", "", "side", "Lnet/minecraft/core/Direction;", "canPlaceItemThroughFace", "index", "itemStack", "direction", "canTakeItemThroughFace", "witchery"})
public final class GrassperBlockEntity
extends WitcheryBaseBlockEntity
implements Container,
WorldlyContainer {
    private NonNullList<ItemStack> item;

    public GrassperBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getGRASSPER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
        this.item = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    }

    public final NonNullList<ItemStack> getItem() {
        return this.item;
    }

    public final void setItem(NonNullList<ItemStack> nonNullList) {
        this.item = nonNullList;
    }

    @Override
    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player pPlayer, @NotNull ItemStack pStack, @NotNull InteractionHand pHand) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        if (((ItemStack)this.item.get(0)).isEmpty()) {
            this.item.set(0, (Object)pStack.copy());
            ((ItemStack)this.item.get(0)).setCount(1);
            pStack.shrink(1);
            this.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.getBlockPos(), (Container)this);
        this.setChanged();
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    @Override
    public void onBreak(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Containers.dropContents((Level)this.level, (BlockPos)this.getBlockPos(), (Container)this);
        super.onBreak(player);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        this.item = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.item, (HolderLookup.Provider)pRegistries);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.item, (HolderLookup.Provider)registries);
    }

    public void clearContent() {
        this.item.clear();
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.item.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        Object object = this.item.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem((List)((List)this.item), (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem((List)((List)this.item), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"takeItem(...)");
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.item.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return CollectionsKt.toIntArray((Collection)CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((int)0, (int)this.item.size()))));
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return true;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return true;
    }
}

