/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.werewolf_altar;

import dev.sterner.witchery.content.block.bear_trap.BearTrapBlock;
import dev.sterner.witchery.content.block.werewolf_altar.WerewolfAltarBlock;
import dev.sterner.witchery.content.entity.WerewolfEntity;
import dev.sterner.witchery.content.item.curios.MoonCharmItem;
import dev.sterner.witchery.core.api.multiblock.MultiBlockCoreEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.network.SpawnItemParticlesS2CPayload;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\nH\u0002J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020&H\u0014R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/sterner/witchery/content/block/werewolf_altar/WerewolfAltarBlockEntity;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockCoreEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "items", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "setItems", "(Lnet/minecraft/core/NonNullList;)V", "conversionTicks", "", "muttonCounter", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pStack", "pHand", "Lnet/minecraft/world/InteractionHand;", "tickServer", "", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "lookForWerewolf", "level", "pos", "spawnConsumeParticles", "itemStack", "loadAdditional", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "tag", "registries", "witchery"})
@SourceDebugExtension(value={"SMAP\nWerewolfAltarBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WerewolfAltarBlockEntity.kt\ndev/sterner/witchery/content/block/werewolf_altar/WerewolfAltarBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1869#2,2:143\n*S KotlinDebug\n*F\n+ 1 WerewolfAltarBlockEntity.kt\ndev/sterner/witchery/content/block/werewolf_altar/WerewolfAltarBlockEntity\n*L\n98#1:143,2\n*E\n"})
public final class WerewolfAltarBlockEntity
extends MultiBlockCoreEntity {
    @NotNull
    private NonNullList<ItemStack> items;
    private int conversionTicks;
    private int muttonCounter;

    public WerewolfAltarBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getWEREWOLF_ALTAR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        BlockEntityType blockEntityType = (BlockEntityType)object;
        MultiBlockStructure multiBlockStructure = WerewolfAltarBlock.Companion.getSTRUCTURE().get();
        Intrinsics.checkNotNullExpressionValue((Object)multiBlockStructure, (String)"get(...)");
        super(blockEntityType, multiBlockStructure, blockPos, blockState);
        NonNullList nonNullList = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
    }

    @NotNull
    public final NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.items = nonNullList;
    }

    @Override
    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player pPlayer, @NotNull ItemStack pStack, @NotNull InteractionHand pHand) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        if (((ItemStack)this.items.get(0)).isEmpty() && pStack.is(WitcheryTags.INSTANCE.getWEREWOLF_ALTAR_ITEM())) {
            this.items.set(0, (Object)pStack);
        } else if (pPlayer.getMainHandItem().isEmpty()) {
            pPlayer.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)this.items.get(0));
            this.items.clear();
        }
        this.setChanged();
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    @Override
    public void tickServer(@NotNull ServerLevel serverLevel) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        super.tickServer(serverLevel);
        Object object = this.items.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack item = (ItemStack)object;
        if (!item.isEmpty()) {
            if (item.is(Items.GOLD_INGOT)) {
                int n = this.conversionTicks;
                this.conversionTicks = n + 1;
                this.spawnConsumeParticles(serverLevel, item);
                if (this.conversionTicks >= 40) {
                    this.conversionTicks = 0;
                    this.items.clear();
                    this.items.set(0, (Object)((MoonCharmItem)((Object)WitcheryItems.INSTANCE.getMOON_CHARM().get())).getDefaultInstance());
                    this.setChanged();
                }
            } else if (item.is(Items.MUTTON)) {
                int n = this.conversionTicks;
                this.conversionTicks = n + 1;
                this.spawnConsumeParticles(serverLevel, item);
                if (this.conversionTicks >= 40) {
                    this.conversionTicks = 0;
                    n = this.muttonCounter;
                    this.muttonCounter = n + 1;
                    this.items.clear();
                    this.setChanged();
                }
            }
        }
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        this.lookForWerewolf(serverLevel, blockPos);
    }

    private final void lookForWerewolf(ServerLevel level, BlockPos pos) {
        if (level.getGameTime() % (long)20 == 0L) {
            AABB box = new AABB(pos).inflate(4.0);
            Stream<Object> traps = BlockPos.betweenClosedStream((AABB)box).filter(arg_0 -> WerewolfAltarBlockEntity.lookForWerewolf$lambda$1(arg_0 -> WerewolfAltarBlockEntity.lookForWerewolf$lambda$0(level, arg_0), arg_0));
            traps.forEach(arg_0 -> WerewolfAltarBlockEntity.lookForWerewolf$lambda$3(arg_0 -> WerewolfAltarBlockEntity.lookForWerewolf$lambda$2(level, arg_0), arg_0));
        }
    }

    private final void spawnConsumeParticles(ServerLevel level, ItemStack itemStack) {
        if ((double)level.random.nextFloat() < 0.3) {
            Direction dir = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Vec3 offset = new Vec3(-0.35, 0.4, 0.9);
            Direction direction = dir;
            Vec3 rotatedOffset = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> offset;
                case 2 -> new Vec3(-offset.x, offset.y, -offset.z);
                case 3 -> new Vec3(offset.z, offset.y, -offset.x);
                case 4 -> new Vec3(-offset.z, offset.y, offset.x);
                default -> offset;
            };
            Vec3 spawnPos = this.getBlockPos().getCenter().add(rotatedOffset);
            ChunkPos chunkPos = new ChunkPos(this.getBlockPos());
            Intrinsics.checkNotNull((Object)spawnPos);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)new SpawnItemParticlesS2CPayload(spawnPos, itemStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        NonNullList nonNullList = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        this.conversionTicks = pTag.getInt("ConversionTicks");
        this.muttonCounter = pTag.getInt("MuttonCounter");
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putInt("ConversionTicks", this.conversionTicks);
        tag.putInt("MuttonCounter", this.muttonCounter);
    }

    private static final boolean lookForWerewolf$lambda$0(ServerLevel $level, BlockPos it) {
        return $level.getBlockState(it).getBlock() instanceof BearTrapBlock;
    }

    private static final boolean lookForWerewolf$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit lookForWerewolf$lambda$2(ServerLevel $level, BlockPos blockPos) {
        AABB trapAabb = new AABB(blockPos).inflate(0.0, 1.0, 0.0);
        List werewolves = $level.getEntities((EntityTypeTest)WitcheryEntityTypes.INSTANCE.getWEREWOLF().get(), trapAabb, arg_0 -> WerewolfAltarBlockEntity.lookForWerewolf$lambda$2$1(WerewolfAltarBlockEntity::lookForWerewolf$lambda$2$0, arg_0));
        Intrinsics.checkNotNull((Object)werewolves);
        Iterable $this$forEach$iv = werewolves;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WerewolfEntity entity = (WerewolfEntity)((Object)element$iv);
            boolean bl = false;
            entity.getEntityData().set(WerewolfEntity.Companion.getCAN_INFECT(), (Object)true);
        }
        return Unit.INSTANCE;
    }

    private static final boolean lookForWerewolf$lambda$2$0(WerewolfEntity it) {
        return it.isAlive();
    }

    private static final boolean lookForWerewolf$lambda$2$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void lookForWerewolf$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

