/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.worldgen.WitcheryWorldgenKeys;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.features.nightmare.NightmarePlayerAttachment;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0014J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/content/entity/NightmareEntity;", "Lnet/minecraft/world/entity/monster/Monster;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "intangibleCooldown", "", "ticker", "isOnFire", "", "fireImmune", "updateInWaterStateAndDoFluidPushing", "tick", "", "setIntangible", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "save", "compound", "Lnet/minecraft/nbt/CompoundTag;", "load", "isInvulnerableTo", "registerGoals", "doHurtTarget", "target", "Lnet/minecraft/world/entity/Entity;", "Companion", "NightmareTargetGoal", "witchery"})
public final class NightmareEntity
extends Monster {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int intangibleCooldown;
    private int ticker;
    @NotNull
    private static final EntityDataAccessor<Boolean> INTANGIBLE;
    @NotNull
    private static final EntityDataAccessor<Optional<UUID>> NIGHTMARE_TARGET;

    public NightmareEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getNIGHTMARE().get(), level);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.level() instanceof ServerLevel) {
            int n;
            if (this.intangibleCooldown > 0) {
                n = this.intangibleCooldown;
                this.intangibleCooldown = n + -1;
            }
            if (this.intangibleCooldown <= 0) {
                this.entityData.set(INTANGIBLE, (Object)false);
            }
            n = this.ticker;
            this.ticker = n + 1;
            if (this.ticker > 20) {
                ServerLevel nightmareWorld;
                this.ticker = 0;
                MinecraftServer minecraftServer = this.level().getServer();
                ServerLevel serverLevel = nightmareWorld = minecraftServer != null ? minecraftServer.getLevel(WitcheryWorldgenKeys.INSTANCE.getNIGHTMARE()) : null;
                if (nightmareWorld != null) {
                    boolean foundMatchingUUID = false;
                    for (ServerPlayer player : nightmareWorld.getPlayers(arg_0 -> NightmareEntity.tick$lambda$1(NightmareEntity::tick$lambda$0, arg_0))) {
                        Intrinsics.checkNotNull((Object)player);
                        NightmarePlayerAttachment.Data data2 = NightmarePlayerAttachment.getData((Player)player);
                        if (!data2.getNightmareUUID().isPresent() || !Intrinsics.areEqual((Object)data2.getNightmareUUID().get(), (Object)this.uuid)) continue;
                        foundMatchingUUID = true;
                        break;
                    }
                    if (!foundMatchingUUID) {
                        this.discard();
                    }
                }
            }
        }
    }

    private final void setIntangible() {
        this.entityData.set(INTANGIBLE, (Object)true);
        this.intangibleCooldown = 60;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (((Boolean)this.entityData.get(INTANGIBLE)).booleanValue()) {
            return false;
        }
        this.setIntangible();
        return super.hurt(source, amount);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(INTANGIBLE, (Object)false);
        builder.define(NIGHTMARE_TARGET, Optional.empty());
        super.defineSynchedData(builder);
    }

    public boolean save(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Object object = this.entityData.get(INTANGIBLE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        compound.putBoolean("Intangible", ((Boolean)object).booleanValue());
        compound.putInt("Cooldown", this.intangibleCooldown);
        return super.save(compound);
    }

    public void load(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.entityData.set(INTANGIBLE, (Object)compound.getBoolean("Intangible"));
        this.intangibleCooldown = compound.getInt("Cooldown");
        super.load(compound);
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.is(DamageTypeTags.IS_PROJECTILE) || super.isInvulnerableTo(source);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.targetSelector.addGoal(1, (Goal)new NightmareTargetGoal((Mob)this));
        super.registerGoals();
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        DamageSource damageSource = this.damageSources().magic();
        boolean bl = target.hurt(damageSource, f);
        if (bl) {
            float g = this.getKnockback(target, damageSource);
            if (g > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).knockback((double)(g * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            this.setLastHurtMob(target);
            this.playAttackSound();
        }
        return bl;
    }

    private static final boolean tick$lambda$0(ServerPlayer it) {
        return !it.isCreative() && !it.isSpectator();
    }

    private static final boolean tick$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(NightmareEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        INTANGIBLE = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(NightmareEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        NIGHTMARE_TARGET = entityDataAccessor2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/NightmareEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "INTANGIBLE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getINTANGIBLE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "NIGHTMARE_TARGET", "Ljava/util/Optional;", "Ljava/util/UUID;", "getNIGHTMARE_TARGET", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.FOLLOW_RANGE, 128.0).add(Attributes.STEP_HEIGHT, 2.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getINTANGIBLE() {
            return INTANGIBLE;
        }

        @NotNull
        public final EntityDataAccessor<Optional<UUID>> getNIGHTMARE_TARGET() {
            return NIGHTMARE_TARGET;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/content/entity/NightmareEntity$NightmareTargetGoal;", "Lnet/minecraft/world/entity/ai/goal/target/TargetGoal;", "mob", "Lnet/minecraft/world/entity/Mob;", "<init>", "(Lnet/minecraft/world/entity/Mob;)V", "target", "Lnet/minecraft/world/entity/LivingEntity;", "getTarget", "()Lnet/minecraft/world/entity/LivingEntity;", "setTarget", "(Lnet/minecraft/world/entity/LivingEntity;)V", "canUse", "", "findTarget", "", "start", "witchery"})
    public static class NightmareTargetGoal
    extends TargetGoal {
        @Nullable
        private LivingEntity target;

        public NightmareTargetGoal(@NotNull Mob mob) {
            Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
            super(mob, false, false);
            this.setFlags(EnumSet.of((Enum)Goal.Flag.TARGET));
        }

        @Nullable
        protected final LivingEntity getTarget() {
            return this.target;
        }

        protected final void setTarget(@Nullable LivingEntity livingEntity) {
            this.target = livingEntity;
        }

        public boolean canUse() {
            if (this.target == null) {
                this.findTarget();
            }
            return this.target != null;
        }

        private final void findTarget() {
            Optional opt = (Optional)this.mob.getEntityData().get(Companion.getNIGHTMARE_TARGET());
            if (opt.isPresent()) {
                this.target = (LivingEntity)this.mob.level().getPlayerByUUID((UUID)opt.get());
            }
        }

        public void start() {
            this.mob.setTarget(this.target);
            super.start();
        }
    }
}

