/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.entity.AbstractSpectralEntity;
import dev.sterner.witchery.content.entity.goal.RandomFloatAroundGoal;
import dev.sterner.witchery.content.entity.move_control.GhostMoveControl;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/content/entity/PoltergeistEntity;", "Ldev/sterner/witchery/content/entity/AbstractSpectralEntity;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "ignoredUUIDs", "", "Ljava/util/UUID;", "getIgnoredUUIDs", "()Ljava/util/Set;", "summonPos", "Lnet/minecraft/world/phys/Vec3;", "getSummonPos", "()Lnet/minecraft/world/phys/Vec3;", "setSummonPos", "(Lnet/minecraft/world/phys/Vec3;)V", "attackCount", "", "getAttackCount", "()I", "setAttackCount", "(I)V", "attackTicksRemaining", "getAttackTicksRemaining", "setAttackTicksRemaining", "registerGoals", "", "isInvulnerableTo", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "Companion", "TargetNearbyPlayersGoal", "AttackAndReturnGoal", "witchery"})
public final class PoltergeistEntity
extends AbstractSpectralEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<UUID> ignoredUUIDs;
    @NotNull
    private Vec3 summonPos;
    private int attackCount;
    private int attackTicksRemaining;

    public PoltergeistEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = WitcheryEntityTypes.INSTANCE.getPOLTERGEIST().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((EntityType<? extends FlyingMob>)((EntityType)object), level);
        this.ignoredUUIDs = new LinkedHashSet();
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.summonPos = vec3;
        this.moveControl = new GhostMoveControl(this);
    }

    @NotNull
    public final Set<UUID> getIgnoredUUIDs() {
        return this.ignoredUUIDs;
    }

    @NotNull
    public final Vec3 getSummonPos() {
        return this.summonPos;
    }

    public final void setSummonPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.summonPos = vec3;
    }

    public final int getAttackCount() {
        return this.attackCount;
    }

    public final void setAttackCount(int n) {
        this.attackCount = n;
    }

    public final int getAttackTicksRemaining() {
        return this.attackTicksRemaining;
    }

    public final void setAttackTicksRemaining(int n) {
        this.attackTicksRemaining = n;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomFloatAroundGoal(this));
        this.targetSelector.addGoal(1, (Goal)new TargetNearbyPlayersGoal(this, 32.0));
        this.goalSelector.addGoal(2, (Goal)new AttackAndReturnGoal(this));
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.is(DamageTypeTags.IS_PROJECTILE) || super.isInvulnerableTo(source);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/PoltergeistEntity$AttackAndReturnGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "spectre", "Ldev/sterner/witchery/content/entity/PoltergeistEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/PoltergeistEntity;)V", "returning", "", "maxAttacks", "", "canUse", "canContinueToUse", "tick", "", "start", "witchery"})
    public static final class AttackAndReturnGoal
    extends Goal {
        @NotNull
        private final PoltergeistEntity spectre;
        private boolean returning;
        private final int maxAttacks;

        public AttackAndReturnGoal(@NotNull PoltergeistEntity spectre) {
            Intrinsics.checkNotNullParameter((Object)((Object)spectre), (String)"spectre");
            this.spectre = spectre;
            this.maxAttacks = 5;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.spectre.getTarget() != null || this.returning;
        }

        public boolean canContinueToUse() {
            return !this.returning || this.spectre.distanceToSqr(this.spectre.getSummonPos()) > 1.0;
        }

        public void tick() {
            int n;
            PoltergeistEntity poltergeistEntity;
            LivingEntity target = this.spectre.getTarget();
            if (!this.returning && target != null && target.isAlive() && this.spectre.getAttackCount() < this.maxAttacks) {
                this.spectre.lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                this.spectre.moveControl.setWantedPosition(target.getX(), target.getY(), target.getZ(), 1.1);
                if (this.spectre.getBoundingBox().inflate(1.2).intersects(target.getBoundingBox()) && this.spectre.getAttackTicksRemaining() <= 0) {
                    this.spectre.doHurtTarget((Entity)target);
                    poltergeistEntity = this.spectre;
                    n = poltergeistEntity.getAttackCount();
                    poltergeistEntity.setAttackCount(n + 1);
                    this.spectre.setAttackTicksRemaining(20);
                }
            } else {
                this.returning = true;
                this.spectre.setTarget(null);
                this.spectre.moveControl.setWantedPosition(this.spectre.getSummonPos().x, this.spectre.getSummonPos().y, this.spectre.getSummonPos().z, 1.0);
                if (this.spectre.distanceToSqr(this.spectre.getSummonPos()) < 1.0) {
                    this.spectre.discard();
                }
            }
            if (this.spectre.getAttackTicksRemaining() > 0) {
                poltergeistEntity = this.spectre;
                n = poltergeistEntity.getAttackTicksRemaining();
                poltergeistEntity.setAttackTicksRemaining(n + -1);
            }
        }

        public void start() {
            this.returning = false;
            this.spectre.setAttackCount(0);
            this.spectre.setAttackTicksRemaining(0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/PoltergeistEntity$Companion;", "", "<init>", "()V", "summonSpectre", "Ldev/sterner/witchery/content/entity/PoltergeistEntity;", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "ignoredUUIDs", "", "Ljava/util/UUID;", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PoltergeistEntity summonSpectre(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Set<UUID> ignoredUUIDs) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter(ignoredUUIDs, (String)"ignoredUUIDs");
            PoltergeistEntity spectre = new PoltergeistEntity((Level)level);
            spectre.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            spectre.getIgnoredUUIDs().addAll((Collection<UUID>)ignoredUUIDs);
            Vec3 vec3 = spectre.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            spectre.setSummonPos(vec3);
            level.addFreshEntity((Entity)spectre);
            return spectre;
        }

        public static /* synthetic */ PoltergeistEntity summonSpectre$default(Companion companion, ServerLevel serverLevel, BlockPos blockPos, Set set, int n, Object object) {
            if ((n & 4) != 0) {
                set = SetsKt.emptySet();
            }
            return companion.summonSpectre(serverLevel, blockPos, set);
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = FlyingMob.createMobAttributes().add(Attributes.FLYING_SPEED, 0.35).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/content/entity/PoltergeistEntity$TargetNearbyPlayersGoal;", "Lnet/minecraft/world/entity/ai/goal/target/TargetGoal;", "spectre", "Ldev/sterner/witchery/content/entity/PoltergeistEntity;", "range", "", "<init>", "(Ldev/sterner/witchery/content/entity/PoltergeistEntity;D)V", "canUse", "", "witchery"})
    @SourceDebugExtension(value={"SMAP\nPoltergeistEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoltergeistEntity.kt\ndev/sterner/witchery/content/entity/PoltergeistEntity$TargetNearbyPlayersGoal\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n774#2:150\n865#2,2:151\n*S KotlinDebug\n*F\n+ 1 PoltergeistEntity.kt\ndev/sterner/witchery/content/entity/PoltergeistEntity$TargetNearbyPlayersGoal\n*L\n82#1:150\n82#1:151,2\n*E\n"})
    public static final class TargetNearbyPlayersGoal
    extends TargetGoal {
        @NotNull
        private final PoltergeistEntity spectre;
        private final double range;

        public TargetNearbyPlayersGoal(@NotNull PoltergeistEntity spectre, double range) {
            Intrinsics.checkNotNullParameter((Object)((Object)spectre), (String)"spectre");
            super((Mob)spectre, false);
            this.spectre = spectre;
            this.range = range;
        }

        /*
         * WARNING - void declaration
         */
        public boolean canUse() {
            void $this$filterTo$iv$iv;
            Level level = this.spectre.level();
            List list = level.players();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Player player = (Player)element$iv$iv;
                boolean bl = false;
                if (!(!player.isSpectator() && !this.spectre.getIgnoredUUIDs().contains(player.getUUID()) && player.distanceToSqr((Entity)this.spectre) <= this.range * this.range)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List potentialTargets = (List)destination$iv$iv;
            if (!((Collection)potentialTargets).isEmpty()) {
                this.spectre.setTarget((LivingEntity)CollectionsKt.random((Collection)potentialTargets, (Random)((Random)Random.Default)));
                return true;
            }
            return false;
        }
    }
}

