/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.goal;

import dev.sterner.witchery.content.entity.DemonEntity;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/content/entity/goal/DemonLeapAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "demon", "Ldev/sterner/witchery/content/entity/DemonEntity;", "leapCooldown", "", "<init>", "(Ldev/sterner/witchery/content/entity/DemonEntity;I)V", "cooldown", "canUse", "", "start", "", "canContinueToUse", "witchery"})
public final class DemonLeapAttackGoal
extends Goal {
    @NotNull
    private final DemonEntity demon;
    private final int leapCooldown;
    private int cooldown;

    public DemonLeapAttackGoal(@NotNull DemonEntity demon, int leapCooldown) {
        Intrinsics.checkNotNullParameter((Object)((Object)demon), (String)"demon");
        this.demon = demon;
        this.leapCooldown = leapCooldown;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.JUMP));
    }

    public /* synthetic */ DemonLeapAttackGoal(DemonEntity demonEntity, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 200;
        }
        this(demonEntity, n);
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            int n = this.cooldown;
            this.cooldown = n + -1;
            return false;
        }
        LivingEntity livingEntity = this.demon.getTarget();
        if (livingEntity == null) {
            return false;
        }
        LivingEntity target = livingEntity;
        if (!this.demon.onGround()) {
            return false;
        }
        float distance = this.demon.distanceTo((Entity)target);
        double d = distance;
        return (4.0 <= d ? d <= 12.0 : false) && this.demon.hasLineOfSight((Entity)target);
    }

    public void start() {
        LivingEntity livingEntity = this.demon.getTarget();
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        Vec3 toTarget = new Vec3(target.getX() - this.demon.getX(), 0.0, target.getZ() - this.demon.getZ()).normalize();
        double leapStrength = this.demon.isEnraged() ? 1.2 : 0.8;
        this.demon.setDeltaMovement(this.demon.getDeltaMovement().add(toTarget.x * leapStrength, 0.5, toTarget.z * leapStrength));
        this.demon.hasImpulse = true;
        this.cooldown = this.leapCooldown;
        if (this.demon.level() instanceof ServerLevel) {
            Level level = this.demon.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LAVA, this.demon.getX(), this.demon.getY(), this.demon.getZ(), 15, 0.3, 0.1, 0.3, 0.1);
        }
        this.demon.level().playSound(null, this.demon.blockPosition(), SoundEvents.BLAZE_SHOOT, SoundSource.HOSTILE, 1.0f, 1.5f);
    }

    public boolean canContinueToUse() {
        return false;
    }
}

