/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.player_shell;

import dev.sterner.witchery.core.api.TeleportRequest;
import dev.sterner.witchery.core.api.entity.PlayerShellEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.misc.AccessoryHandler;
import dev.sterner.witchery.features.misc.DeathQueueLevelAttachment;
import dev.sterner.witchery.features.misc.TeleportQueueHandler;
import dev.sterner.witchery.features.spirit_world.ManifestationPlayerAttachment;
import dev.sterner.witchery.features.spirit_world.SleepingLevelAttachment;
import dev.sterner.witchery.features.spirit_world.SleepingPlayerHandler;
import dev.sterner.witchery.network.SpawnSleepingDeathParticleS2CPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0017\u001a\u00020\rH\u0016J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0007J\b\u0010\u001c\u001a\u00020\u0007H\u0016\u00a8\u0006\u001e"}, d2={"Ldev/sterner/witchery/content/entity/player_shell/SleepingPlayerEntity;", "Ldev/sterner/witchery/core/api/entity/PlayerShellEntity;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "hurt", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "mergeSoulWithShell", "", "player", "Lnet/minecraft/world/entity/player/Player;", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "tick", "handleSleepingDamage", "isFaceplanted", "setFaceplant", "faceplant", "isPickable", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nSleepingPlayerEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SleepingPlayerEntity.kt\ndev/sterner/witchery/content/entity/player_shell/SleepingPlayerEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
public final class SleepingPlayerEntity
extends PlayerShellEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final EntityDataAccessor<Boolean> FACEPLANT = SynchedEntityData.defineId(SleepingPlayerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public SleepingPlayerEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = WitcheryEntityTypes.INSTANCE.getSLEEPING_PLAYER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((EntityType<? extends PlayerShellEntity>)((EntityType)object), level);
        this.setShellType(PlayerShellEntity.ShellType.SLEEPING);
    }

    @Override
    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.level() instanceof ServerLevel) {
            int n = this.getHurtCounter();
            this.setHurtCounter(n + 1);
            this.entityData.set(PlayerShellEntity.Companion.getHURT_TIME(), (Object)10);
            this.playSound(SoundEvents.PLAYER_HURT);
            boolean foundPlayer = false;
            if (this.getData().getResolvableProfile() != null) {
                MinecraftServer minecraftServer = this.level().getServer();
                Intrinsics.checkNotNull((Object)minecraftServer);
                for (ServerLevel serverLevel : minecraftServer.getAllLevels()) {
                    ServerPlayer player;
                    ServerPlayer serverPlayer;
                    UUID uUID = this.uuid;
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
                    Intrinsics.checkNotNull((Object)serverLevel);
                    UUID playerUuid = SleepingPlayerHandler.INSTANCE.getPlayerFromSleepingUUID(uUID, serverLevel);
                    if (playerUuid != null) {
                        UUID it;
                        boolean bl = false;
                        MinecraftServer minecraftServer2 = this.level().getServer();
                        Intrinsics.checkNotNull((Object)minecraftServer2);
                        serverPlayer = minecraftServer2.getPlayerList().getPlayer(it);
                    } else {
                        serverPlayer = null;
                    }
                    if ((player = serverPlayer) == null) continue;
                    BlockPos blockPos = this.blockPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
                    TeleportRequest teleportRequest = new TeleportRequest(playerUuid, blockPos, new ChunkPos(this.blockPosition()), this.level().getGameTime(), 0, (ResourceKey<Level>)player.level().dimension());
                    Level level = this.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    TeleportQueueHandler.INSTANCE.addRequest((ServerLevel)level, teleportRequest);
                    ManifestationPlayerAttachment.Data manifestationData = ManifestationPlayerAttachment.getData((Player)player);
                    if (manifestationData.getManifestationTimer() > 0) {
                        ManifestationPlayerAttachment.setData((Player)player, new ManifestationPlayerAttachment.Data(manifestationData.getHasRiteOfManifestation(), 0));
                    }
                    player.sendSystemMessage((Component)Component.translatable((String)"witchery.message.body_hurt"));
                    foundPlayer = true;
                    break;
                }
            }
            if (this.getHurtCounter() > 8) {
                if (!foundPlayer) {
                    ResolvableProfile resolvableProfile = this.getData().getResolvableProfile();
                    if ((resolvableProfile != null ? resolvableProfile.id() : null) != null) {
                        ResolvableProfile resolvableProfile2 = this.getData().getResolvableProfile();
                        Intrinsics.checkNotNull((Object)resolvableProfile2);
                        if (resolvableProfile2.id().isPresent()) {
                            Level level = this.level();
                            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                            ServerLevel serverLevel = (ServerLevel)level;
                            ResolvableProfile resolvableProfile3 = this.getData().getResolvableProfile();
                            Intrinsics.checkNotNull((Object)resolvableProfile3);
                            Object t = resolvableProfile3.id().get();
                            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                            DeathQueueLevelAttachment.INSTANCE.addDeathToQueue(serverLevel, (UUID)t);
                        }
                    }
                }
                this.dropInventory();
                UUID uUID = this.uuid;
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
                Level level = this.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                SleepingPlayerHandler.INSTANCE.removeBySleepingUUID(uUID, (ServerLevel)level);
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new SpawnSleepingDeathParticleS2CPayload(this.getRandomX(1.5), this.getRandomY(), this.getRandomZ(1.5)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
        return super.hurt(source, amount);
    }

    @Override
    public void mergeSoulWithShell(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(FACEPLANT, (Object)false);
    }

    @Override
    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        this.setFaceplant(compound.getBoolean("Faceplanted"));
    }

    @Override
    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Faceplanted", this.isFaceplanted());
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.level().getGameTime() % (long)10 == 0L) {
            Level level = this.level();
            ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
            if (serverLevel == null) {
                return;
            }
            ServerLevel level2 = serverLevel;
            UUID sleepingUUID = this.uuid;
            Intrinsics.checkNotNull((Object)sleepingUUID);
            UUID playerUUID = SleepingPlayerHandler.INSTANCE.getPlayerFromSleepingUUID(sleepingUUID, level2);
            if (playerUUID != null) {
                BlockPos currentPos = this.blockPosition();
                SleepingLevelAttachment.PlayerSleepingData sleepingData = SleepingPlayerHandler.INSTANCE.getPlayerFromSleeping(playerUUID, level2);
                if (sleepingData != null && !Intrinsics.areEqual((Object)sleepingData.getPos(), (Object)currentPos)) {
                    Intrinsics.checkNotNull((Object)currentPos);
                    SleepingPlayerHandler.INSTANCE.add(playerUUID, sleepingUUID, currentPos, level2);
                }
            }
        }
    }

    @Override
    public boolean handleSleepingDamage(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.getData().getResolvableProfile() != null) {
            MinecraftServer minecraftServer = this.level().getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            for (ServerLevel serverLevel : minecraftServer.getAllLevels()) {
                ServerPlayer player;
                ServerPlayer serverPlayer;
                UUID uUID = this.uuid;
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
                Intrinsics.checkNotNull((Object)serverLevel);
                UUID playerUuid = SleepingPlayerHandler.INSTANCE.getPlayerFromSleepingUUID(uUID, serverLevel);
                if (playerUuid != null) {
                    UUID it;
                    boolean bl = false;
                    MinecraftServer minecraftServer2 = this.level().getServer();
                    Intrinsics.checkNotNull((Object)minecraftServer2);
                    serverPlayer = minecraftServer2.getPlayerList().getPlayer(it);
                } else {
                    serverPlayer = null;
                }
                if ((player = serverPlayer) == null) continue;
                BlockPos blockPos = this.blockPosition();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
                TeleportRequest teleportRequest = new TeleportRequest(playerUuid, blockPos, new ChunkPos(this.blockPosition()), this.level().getGameTime(), 0, (ResourceKey<Level>)player.level().dimension());
                Level level = this.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                TeleportQueueHandler.INSTANCE.addRequest((ServerLevel)level, teleportRequest);
                ManifestationPlayerAttachment.Data manifestationData = ManifestationPlayerAttachment.getData((Player)player);
                if (manifestationData.getManifestationTimer() > 0) {
                    ManifestationPlayerAttachment.setData((Player)player, new ManifestationPlayerAttachment.Data(manifestationData.getHasRiteOfManifestation(), 0));
                }
                player.sendSystemMessage((Component)Component.translatable((String)"witchery.message.body_hurt"));
                break;
            }
        }
        return super.handleSleepingDamage(source, amount);
    }

    public final boolean isFaceplanted() {
        Object object = this.entityData.get(FACEPLANT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public final void setFaceplant(boolean faceplant) {
        this.entityData.set(FACEPLANT, (Object)faceplant);
    }

    public boolean isPickable() {
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eR5\u0010\u000f\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/content/entity/player_shell/SleepingPlayerEntity$Companion;", "", "<init>", "()V", "insertOrDrop", "", "player", "Lnet/minecraft/world/entity/player/Player;", "inventory", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "playerInv", "replaceWithPlayer", "sleepingPlayerEntity", "Ldev/sterner/witchery/content/entity/player_shell/SleepingPlayerEntity;", "FACEPLANT", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "kotlin.jvm.PlatformType", "getFACEPLANT", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        private final void insertOrDrop(Player player, NonNullList<ItemStack> inventory, NonNullList<ItemStack> playerInv) {
            int n = inventory.size();
            for (int i = 0; i < n; ++i) {
                Object object = inventory.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                ItemStack stack = (ItemStack)object;
                if (stack.isEmpty()) continue;
                Object object2 = playerInv.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                ItemStack playerStack = (ItemStack)object2;
                if (playerStack.isEmpty()) {
                    playerInv.set(i, (Object)stack.copy());
                    inventory.set(i, (Object)ItemStack.EMPTY);
                    continue;
                }
                Containers.dropItemStack((Level)player.level(), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)stack.copy());
                inventory.set(i, (Object)ItemStack.EMPTY);
            }
        }

        public final void replaceWithPlayer(@NotNull Player player, @NotNull SleepingPlayerEntity sleepingPlayerEntity) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)sleepingPlayerEntity), (String)"sleepingPlayerEntity");
            List itemsToKeep = new ArrayList();
            List armorToKeep = new ArrayList();
            LivingEntity livingEntity = (LivingEntity)player;
            Object object = WitcheryItems.INSTANCE.getDREAMWEAVER_CHARM().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ItemStack charmStack = AccessoryHandler.INSTANCE.checkNoConsume(livingEntity, (Item)object);
            if (charmStack != null) {
                for (ItemStack armor : player.getArmorSlots()) {
                    Intrinsics.checkNotNull((Object)armor);
                    armorToKeep.add(armor);
                }
            }
            int armor = player.getInventory().getContainerSize();
            for (int i = 0; i < armor; ++i) {
                ItemStack itemStack = player.getInventory().getItem(i);
                if (!itemStack.is(WitcheryTags.INSTANCE.getFROM_SPIRIT_WORLD_TRANSFERABLE())) continue;
                ItemStack itemStack2 = itemStack.copy();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"copy(...)");
                itemsToKeep.add(itemStack2);
            }
            player.getInventory().clearContent();
            for (ItemStack item : itemsToKeep) {
                player.getInventory().add(item);
            }
            for (ItemStack armor2 : armorToKeep) {
                EquipmentSlot slot = player.getEquipmentSlotForItem(armor2);
                player.setItemSlot(slot, armor2);
            }
            NonNullList<ItemStack> nonNullList = sleepingPlayerEntity.getData().getMainInventory();
            NonNullList nonNullList2 = player.getInventory().items;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList2, (String)"items");
            this.insertOrDrop(player, nonNullList, (NonNullList<ItemStack>)nonNullList2);
            NonNullList<ItemStack> nonNullList3 = sleepingPlayerEntity.getData().getArmorInventory();
            NonNullList nonNullList4 = player.getInventory().armor;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList4, (String)"armor");
            this.insertOrDrop(player, nonNullList3, (NonNullList<ItemStack>)nonNullList4);
            NonNullList<ItemStack> nonNullList5 = sleepingPlayerEntity.getData().getOffHandInventory();
            NonNullList nonNullList6 = player.getInventory().offhand;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList6, (String)"offhand");
            this.insertOrDrop(player, nonNullList5, (NonNullList<ItemStack>)nonNullList6);
            sleepingPlayerEntity.discard();
        }

        public final EntityDataAccessor<Boolean> getFACEPLANT() {
            return FACEPLANT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

