/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.player_shell;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.api.InventorySlots;
import dev.sterner.witchery.core.api.entity.PlayerShellEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.network.SpawnSleepingDeathParticleS2CPayload;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/content/entity/player_shell/SoulShellPlayerEntity;", "Ldev/sterner/witchery/core/api/entity/PlayerShellEntity;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "inventoryDropped", "", "isPickable", "tick", "", "handleShellDeath", "mergeSoulWithShell", "player", "Lnet/minecraft/world/entity/player/Player;", "remove", "reason", "Lnet/minecraft/world/entity/Entity$RemovalReason;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nSoulShellPlayerEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoulShellPlayerEntity.kt\ndev/sterner/witchery/content/entity/player_shell/SoulShellPlayerEntity\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n*L\n1#1,178:1\n69#2,15:179\n69#2,15:194\n*S KotlinDebug\n*F\n+ 1 SoulShellPlayerEntity.kt\ndev/sterner/witchery/content/entity/player_shell/SoulShellPlayerEntity\n*L\n60#1:179,15\n92#1:194,15\n*E\n"})
public final class SoulShellPlayerEntity
extends PlayerShellEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean inventoryDropped;
    private static final ResourceLocation LICH_FLIGHT_MODIFIER_ID = Witchery.Companion.id("lich_flight");

    public SoulShellPlayerEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = WitcheryEntityTypes.INSTANCE.getSOUL_SHELL_PLAYER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((EntityType<? extends PlayerShellEntity>)((EntityType)object), level);
        this.setShellType(PlayerShellEntity.ShellType.SOUL);
    }

    public boolean isPickable() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level() instanceof ServerLevel) {
            UUID uuid;
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel server = (ServerLevel)level;
            if (server.getGameTime() % (long)100 == 0L && (uuid = (UUID)this.getOriginalUUID().orElse(null)) == null) {
                this.handleShellDeath();
            }
        }
    }

    @Override
    public void handleShellDeath() {
        UUID originalUuid;
        if (!this.inventoryDropped) {
            this.dropInventory();
            this.inventoryDropped = true;
        }
        if ((originalUuid = (UUID)this.getOriginalUUID().orElse(null)) != null && this.level() instanceof ServerLevel) {
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            Player player = ((ServerLevel)level).getPlayerByUUID(originalUuid);
            if (player != null) {
                AfflictionPlayerAttachment.Data currentData$iv;
                AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
                Player player$iv = player;
                boolean sync$iv = true;
                boolean $i$f$smartUpdate = false;
                AfflictionPlayerAttachment.Data $this$handleShellDeath_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
                boolean bl = false;
                AfflictionPlayerAttachment.Data newData$iv = $this$handleShellDeath_u24lambda_u240.withSoulForm(true).withVagrant(false);
                AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
                if (player$iv.level() instanceof ServerLevel) {
                    AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
                }
                if (player instanceof ServerPlayer) {
                    Companion.enableFlight((ServerPlayer)player);
                    ((ServerPlayer)player).getAbilities().flying = true;
                    ((ServerPlayer)player).onUpdateAbilities();
                }
            }
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new SpawnSleepingDeathParticleS2CPayload(this.getRandomX(1.5), this.getRandomY(), this.getRandomZ(1.5)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.remove(Entity.RemovalReason.KILLED);
    }

    @Override
    public void mergeSoulWithShell(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player instanceof ServerPlayer) {
            AfflictionPlayerAttachment.Data currentData$iv;
            Companion.replaceWithPlayer(player, this);
            Companion.disableFlight((ServerPlayer)player);
            InventorySlots.INSTANCE.unlockAll(player);
            ((ServerPlayer)player).getAbilities().flying = false;
            ((ServerPlayer)player).onUpdateAbilities();
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$mergeSoulWithShell_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$mergeSoulWithShell_u24lambda_u240.withSoulForm(false).withVagrant(false);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            player.level().playSound(null, ((ServerPlayer)player).getX(), ((ServerPlayer)player).getY(), ((ServerPlayer)player).getZ(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, 0.7f);
            this.inventoryDropped = true;
            this.discard();
        }
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (!this.inventoryDropped && reason != Entity.RemovalReason.DISCARDED) {
            this.dropInventory();
            this.inventoryDropped = true;
        }
        super.remove(reason);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ,\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/content/entity/player_shell/SoulShellPlayerEntity$Companion;", "", "<init>", "()V", "LICH_FLIGHT_MODIFIER_ID", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "enableFlight", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "disableFlight", "replaceWithPlayer", "Lnet/minecraft/world/entity/player/Player;", "shellEntity", "Ldev/sterner/witchery/content/entity/player_shell/SoulShellPlayerEntity;", "insertOrDrop", "inventory", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "playerInv", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void enableFlight(@NotNull ServerPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            AttributeInstance attributeInstance = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
            if (attributeInstance == null) {
                return;
            }
            AttributeInstance flightAttribute = attributeInstance;
            if (flightAttribute.getModifier(LICH_FLIGHT_MODIFIER_ID) == null) {
                flightAttribute.addPermanentModifier(new AttributeModifier(LICH_FLIGHT_MODIFIER_ID, 1.0, AttributeModifier.Operation.ADD_VALUE));
            }
        }

        public final void disableFlight(@NotNull ServerPlayer player) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                AttributeInstance attributeInstance = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
                if (attributeInstance == null) {
                    return;
                }
                AttributeInstance flightAttribute = attributeInstance;
                AttributeModifier attributeModifier = flightAttribute.getModifier(LICH_FLIGHT_MODIFIER_ID);
                if (attributeModifier == null) break block1;
                AttributeModifier it = attributeModifier;
                boolean bl = false;
                flightAttribute.removeModifier(it);
            }
        }

        public final void replaceWithPlayer(@NotNull Player player, @NotNull SoulShellPlayerEntity shellEntity) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)shellEntity), (String)"shellEntity");
            player.getInventory().clearContent();
            NonNullList<ItemStack> nonNullList = shellEntity.getData().getMainInventory();
            NonNullList nonNullList2 = player.getInventory().items;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList2, (String)"items");
            this.insertOrDrop(player, nonNullList, (NonNullList<ItemStack>)nonNullList2);
            NonNullList<ItemStack> nonNullList3 = shellEntity.getData().getArmorInventory();
            NonNullList nonNullList4 = player.getInventory().armor;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList4, (String)"armor");
            this.insertOrDrop(player, nonNullList3, (NonNullList<ItemStack>)nonNullList4);
            NonNullList<ItemStack> nonNullList5 = shellEntity.getData().getOffHandInventory();
            NonNullList nonNullList6 = player.getInventory().offhand;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList6, (String)"offhand");
            this.insertOrDrop(player, nonNullList5, (NonNullList<ItemStack>)nonNullList6);
            shellEntity.getData().getMainInventory().clear();
            shellEntity.getData().getArmorInventory().clear();
            shellEntity.getData().getOffHandInventory().clear();
            shellEntity.getData().getExtraInventory().clear();
        }

        private final void insertOrDrop(Player player, NonNullList<ItemStack> inventory, NonNullList<ItemStack> playerInv) {
            int n = RangesKt.coerceAtMost((int)inventory.size(), (int)playerInv.size());
            for (int i = 0; i < n; ++i) {
                Object object = inventory.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                ItemStack stack = (ItemStack)object;
                if (stack.isEmpty()) continue;
                Object object2 = playerInv.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                ItemStack playerStack = (ItemStack)object2;
                if (playerStack.isEmpty()) {
                    playerInv.set(i, (Object)stack.copy());
                } else {
                    Containers.dropItemStack((Level)player.level(), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)stack.copy());
                }
                inventory.set(i, (Object)ItemStack.EMPTY);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

