/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.entity.player_shell.SleepingPlayerEntity;
import dev.sterner.witchery.content.item.brew.BrewOfSleepingItem;
import dev.sterner.witchery.content.worldgen.WitcheryWorldgenKeys;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/content/item/AppleOfSleepingItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "finishUsingItem", "Lnet/minecraft/world/item/ItemStack;", "stack", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "witchery"})
public final class AppleOfSleepingItem
extends Item {
    public AppleOfSleepingItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity instanceof Player) {
            LivingEntity player = livingEntity;
            if (!Intrinsics.areEqual((Object)player.level().dimension(), (Object)Level.OVERWORLD)) {
                player.sendSystemMessage((Component)Component.translatable((String)"witchery.message.cant_sleep_here"));
                ItemStack itemStack = super.finishUsingItem(stack, level, livingEntity);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
                return itemStack;
            }
            Pair<List<ItemStack>, List<ItemStack>> pair = BrewOfSleepingItem.Companion.savePlayerItems((Player)player, false);
            List itemsToKeep = (List)pair.component1();
            List armorToKeep = (List)pair.component2();
            SleepingPlayerEntity sleepingPlayer = BrewOfSleepingItem.Companion.createSleepingEntity((Player)player);
            ((Player)player).getInventory().clearContent();
            BrewOfSleepingItem.Companion.restoreKeptItems((Player)player, itemsToKeep, armorToKeep);
            player.level().addFreshEntity((Entity)sleepingPlayer);
            BrewOfSleepingItem.Companion.forceLoadPlayerChunk((Player)player);
            ResourceKey<Level> destinationKey = WitcheryWorldgenKeys.INSTANCE.getNIGHTMARE();
            BrewOfSleepingItem.Companion.teleportToDreamDimension((Player)player, destinationKey);
        }
        ItemStack itemStack = super.finishUsingItem(stack, level, livingEntity);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }
}

