/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.client.tooltip.UrnTooltipComponent;
import dev.sterner.witchery.content.item.brew.BrewItem;
import dev.sterner.witchery.content.item.brew.ThrowableBrewItem;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J8\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006!"}, d2={"Ldev/sterner/witchery/content/item/LeonardsUrnItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "overrideStackedOnOther", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "slot", "Lnet/minecraft/world/inventory/Slot;", "action", "Lnet/minecraft/world/inventory/ClickAction;", "player", "Lnet/minecraft/world/entity/player/Player;", "overrideOtherStackedOnMe", "other", "access", "Lnet/minecraft/world/entity/SlotAccess;", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getTooltipImage", "Ljava/util/Optional;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "playInsertSound", "playRemoveSound", "Companion", "witchery"})
public final class LeonardsUrnItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public LeonardsUrnItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack slotItem = slot.getItem();
        if (slotItem.isEmpty()) {
            List<ItemStack> potions = Companion.getStoredPotions(stack);
            if (!((Collection)potions).isEmpty()) {
                ItemStack removed = potions.remove(potions.size() - 1);
                Companion.setStoredPotions(stack, potions);
                slot.safeInsert(removed);
                this.playRemoveSound(player);
                return true;
            }
        } else if (slotItem.getItem() instanceof BrewItem || slotItem.getItem() instanceof ThrowableBrewItem || slotItem.getItem() instanceof PotionItem) {
            List<ItemStack> potions;
            int level = 1;
            if (stack.has((Supplier)WitcheryDataComponents.INSTANCE.getURN_LEVEL())) {
                Object object = stack.get((Supplier)WitcheryDataComponents.INSTANCE.getURN_LEVEL());
                Intrinsics.checkNotNull((Object)object);
                level += ((Number)object).intValue();
            }
            if ((potions = Companion.getStoredPotions(stack)).size() < level) {
                ItemStack toAdd = slotItem.split(1);
                Intrinsics.checkNotNull((Object)toAdd);
                potions.add(toAdd);
                Companion.setStoredPotions(stack, potions);
                this.playInsertSound(player);
                return true;
            }
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        if (action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        if (other.isEmpty()) {
            List<ItemStack> potions = Companion.getStoredPotions(stack);
            if (!((Collection)potions).isEmpty()) {
                ItemStack removed = potions.remove(potions.size() - 1);
                Companion.setStoredPotions(stack, potions);
                access.set(removed);
                this.playRemoveSound(player);
                return true;
            }
        } else if (other.getItem() instanceof BrewItem || other.getItem() instanceof ThrowableBrewItem || other.getItem() instanceof PotionItem) {
            List<ItemStack> potions;
            int level = 1;
            if (stack.has((Supplier)WitcheryDataComponents.INSTANCE.getURN_LEVEL())) {
                Object object = stack.get((Supplier)WitcheryDataComponents.INSTANCE.getURN_LEVEL());
                Intrinsics.checkNotNull((Object)object);
                level += ((Number)object).intValue();
            }
            if ((potions = Companion.getStoredPotions(stack)).size() < level) {
                ItemStack toAdd = other.split(1);
                Intrinsics.checkNotNull((Object)toAdd);
                potions.add(toAdd);
                Companion.setStoredPotions(stack, potions);
                this.playInsertSound(player);
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        List<ItemStack> potions = Companion.getStoredPotions(stack);
        int level = 1;
        if (stack.has((Supplier)WitcheryDataComponents.INSTANCE.getURN_LEVEL())) {
            Object object = stack.get((Supplier)WitcheryDataComponents.INSTANCE.getURN_LEVEL());
            Intrinsics.checkNotNull((Object)object);
            level += ((Number)object).intValue();
        }
        Object[] objectArray = new Object[]{potions.size(), level};
        MutableComponent mutableComponent = Component.translatable((String)"item.witchery.leonards_urn.potions", (Object[])objectArray).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        tooltipComponents.add((Component)mutableComponent);
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        Optional<TooltipComponent> optional;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        List<ItemStack> potions = Companion.getStoredPotions(stack);
        if (potions.isEmpty()) {
            Optional<TooltipComponent> optional2 = Optional.empty();
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else {
            Optional<UrnTooltipComponent> optional3 = Optional.of(new UrnTooltipComponent(potions));
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        }
        return optional;
    }

    private final void playInsertSound(Player player) {
        player.playSound(SoundEvents.BOTTLE_FILL, 1.0f, 1.0f + player.level().random.nextFloat() * 0.4f);
    }

    private final void playRemoveSound(Player player) {
        player.playSound(SoundEvents.BOTTLE_EMPTY, 1.0f, 0.8f + player.level().random.nextFloat() * 0.4f);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/content/item/LeonardsUrnItem$Companion;", "", "<init>", "()V", "getStoredPotions", "", "Lnet/minecraft/world/item/ItemStack;", "stack", "setStoredPotions", "", "potions", "", "hasUrn", "", "player", "Lnet/minecraft/world/entity/player/Player;", "findUrn", "witchery"})
    @SourceDebugExtension(value={"SMAP\nLeonardsUrnItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeonardsUrnItem.kt\ndev/sterner/witchery/content/item/LeonardsUrnItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1761#2,3:170\n295#2,2:173\n*S KotlinDebug\n*F\n+ 1 LeonardsUrnItem.kt\ndev/sterner/witchery/content/item/LeonardsUrnItem$Companion\n*L\n162#1:170,3\n166#1:173,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<ItemStack> getStoredPotions(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            List list = (List)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getURN_POTIONS().get());
            if (list == null) {
                return new ArrayList();
            }
            List list2 = list;
            return CollectionsKt.toMutableList((Collection)list2);
        }

        public final void setStoredPotions(@NotNull ItemStack stack, @NotNull List<ItemStack> potions) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter(potions, (String)"potions");
            List list = potions.isEmpty() ? (List)stack.remove((DataComponentType)WitcheryDataComponents.INSTANCE.getURN_POTIONS().get()) : (List)stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getURN_POTIONS().get(), potions);
        }

        public final boolean hasUrn(@NotNull Player player) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                NonNullList nonNullList = player.getInventory().items;
                Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
                Iterable $this$any$iv = (Iterable)nonNullList;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ItemStack it = (ItemStack)element$iv;
                        boolean bl2 = false;
                        if (!(it.getItem() instanceof LeonardsUrnItem)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Nullable
        public final ItemStack findUrn(@NotNull Player player) {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                NonNullList nonNullList = player.getInventory().items;
                Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
                Iterable $this$firstOrNull$iv = (Iterable)nonNullList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl = false;
                    if (!(it.getItem() instanceof LeonardsUrnItem)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

