/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item.brew;

import com.google.common.base.Predicate;
import dev.sterner.witchery.content.entity.projectile.ThrownBrewEntity;
import dev.sterner.witchery.content.item.brew.BrewItem;
import dev.sterner.witchery.core.api.WitcheryApi;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/content/item/brew/ThrowableBrewItem;", "Ldev/sterner/witchery/content/item/brew/BrewItem;", "Lnet/minecraft/world/item/ProjectileItem;", "color", "", "properties", "Lnet/minecraft/world/item/Item$Properties;", "predicate", "Lcom/google/common/base/Predicate;", "Lnet/minecraft/core/Direction;", "<init>", "(ILnet/minecraft/world/item/Item$Properties;Lcom/google/common/base/Predicate;)V", "getColor", "()I", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "asProjectile", "Lnet/minecraft/world/entity/projectile/Projectile;", "pos", "Lnet/minecraft/core/Position;", "stack", "direction", "createDispenseConfig", "Lnet/minecraft/world/item/ProjectileItem$DispenseConfig;", "witchery"})
public class ThrowableBrewItem
extends BrewItem
implements ProjectileItem {
    private final int color;

    public ThrowableBrewItem(int color, @NotNull Item.Properties properties, @NotNull Predicate<Direction> predicate) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        super(color, properties, predicate);
        this.color = color;
    }

    public /* synthetic */ ThrowableBrewItem(int n, Item.Properties properties, Predicate predicate, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            predicate = ThrowableBrewItem::_init_$lambda$0;
        }
        this(n, properties, (Predicate<Direction>)predicate);
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (!level.isClientSide) {
            WitcheryApi.INSTANCE.makePlayerWitchy(player);
            ThrownBrewEntity thrownPotion = new ThrownBrewEntity(level, (LivingEntity)player);
            thrownPotion.setItem(itemStack);
            thrownPotion.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            level.addFreshEntity((Entity)thrownPotion);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        itemStack.consume(1, (LivingEntity)player);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
        return interactionResultHolder;
    }

    @NotNull
    public Projectile asProjectile(@NotNull Level level, @NotNull Position pos, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        ThrownBrewEntity thrownPotion = new ThrownBrewEntity(level, pos.x(), pos.y(), pos.z());
        thrownPotion.setItem(stack);
        return (Projectile)thrownPotion;
    }

    @NotNull
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        ProjectileItem.DispenseConfig dispenseConfig = ProjectileItem.DispenseConfig.builder().uncertainty(ProjectileItem.DispenseConfig.DEFAULT.uncertainty() * 0.5f).power(ProjectileItem.DispenseConfig.DEFAULT.power() * 1.25f).build();
        Intrinsics.checkNotNullExpressionValue((Object)dispenseConfig, (String)"build(...)");
        return dispenseConfig;
    }

    private static final boolean _init_$lambda$0(Direction it) {
        return true;
    }
}

