/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item.curios;

import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryTags;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/content/item/curios/HagsRingItem;", "Lnet/minecraft/world/item/Item;", "Ltop/theillusivec4/curios/api/type/capability/ICurioItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "makesPiglinsNeutral", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "wearer", "Lnet/minecraft/world/entity/LivingEntity;", "canEquipFromUse", "slotContext", "Ltop/theillusivec4/curios/api/SlotContext;", "Companion", "witchery"})
public final class HagsRingItem
extends Item
implements ICurioItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_VEIN_SIZE = 64;

    public HagsRingItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public boolean makesPiglinsNeutral(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)wearer, (String)"wearer");
        return true;
    }

    public boolean canEquipFromUse(@NotNull SlotContext slotContext, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)slotContext, (String)"slotContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ2\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/content/item/curios/HagsRingItem$Companion;", "", "<init>", "()V", "MAX_VEIN_SIZE", "", "getFortuneLevel", "player", "Lnet/minecraft/world/entity/player/Player;", "gatherConnectedOfSameTag", "", "Lnet/minecraft/core/BlockPos;", "level", "Lnet/minecraft/server/level/ServerLevel;", "startPos", "targetBlock", "Lnet/minecraft/world/level/block/Block;", "tag", "Lnet/minecraft/tags/TagKey;", "gatherConnectedOres", "gatherConnectedLogs", "witchery"})
    @SourceDebugExtension(value={"SMAP\nHagsRingItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HagsRingItem.kt\ndev/sterner/witchery/content/item/curios/HagsRingItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1068#2:102\n*S KotlinDebug\n*F\n+ 1 HagsRingItem.kt\ndev/sterner/witchery/content/item/curios/HagsRingItem$Companion\n*L\n78#1:102\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getFortuneLevel(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            ICuriosItemHandler iCuriosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)((LivingEntity)player)).orElse(null);
            if (iCuriosItemHandler == null) {
                return 0;
            }
            ICuriosItemHandler curiosInventory = iCuriosItemHandler;
            ItemStack ringStack = curiosInventory.findFirstCurio((Item)WitcheryItems.INSTANCE.getHAGS_RING().get()).map(arg_0 -> Companion.getFortuneLevel$lambda$1(Companion::getFortuneLevel$lambda$0, arg_0)).orElse(ItemStack.EMPTY);
            if (ringStack.isEmpty()) {
                return 0;
            }
            Object object = ringStack.getOrDefault((DataComponentType)WitcheryDataComponents.INSTANCE.getFORTUNE_LEVEL().get(), (Object)0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
            return ((Number)object).intValue();
        }

        @NotNull
        public final List<BlockPos> gatherConnectedOfSameTag(@NotNull ServerLevel level, @NotNull BlockPos startPos, @NotNull Block targetBlock, @NotNull TagKey<Block> tag) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
            Intrinsics.checkNotNullParameter((Object)targetBlock, (String)"targetBlock");
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            Set visited = new LinkedHashSet();
            List orePositions = new ArrayList();
            dev.sterner.witchery.content.item.curios.HagsRingItem$Companion.gatherConnectedOfSameTag$dfs(visited, orePositions, level, tag, targetBlock, startPos);
            Iterable $this$sortedByDescending$iv = orePositions;
            boolean $i$f$sortedByDescending = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(startPos){
                final /* synthetic */ BlockPos $startPos$inlined;
                {
                    this.$startPos$inlined = blockPos;
                }

                public final int compare(T a, T b) {
                    BlockPos it = (BlockPos)b;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.distSqr((Vec3i)this.$startPos$inlined));
                    it = (BlockPos)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.distSqr((Vec3i)this.$startPos$inlined)));
                }
            });
        }

        @NotNull
        public final List<BlockPos> gatherConnectedOres(@NotNull ServerLevel level, @NotNull BlockPos startPos, @NotNull Block targetBlock) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
            Intrinsics.checkNotNullParameter((Object)targetBlock, (String)"targetBlock");
            return this.gatherConnectedOfSameTag(level, startPos, targetBlock, WitcheryTags.INSTANCE.getVEIN_MINEABLE());
        }

        @NotNull
        public final List<BlockPos> gatherConnectedLogs(@NotNull ServerLevel level, @NotNull BlockPos startPos, @NotNull Block targetBlock) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
            Intrinsics.checkNotNullParameter((Object)targetBlock, (String)"targetBlock");
            TagKey tagKey = BlockTags.LOGS;
            Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"LOGS");
            return this.gatherConnectedOfSameTag(level, startPos, targetBlock, (TagKey<Block>)tagKey);
        }

        private static final ItemStack getFortuneLevel$lambda$0(SlotResult it) {
            return it.stack();
        }

        private static final ItemStack getFortuneLevel$lambda$1(Function1 $tmp0, Object p0) {
            return (ItemStack)$tmp0.invoke(p0);
        }

        private static final void gatherConnectedOfSameTag$dfs(Set<BlockPos> visited, List<BlockPos> orePositions, ServerLevel $level, TagKey<Block> $tag, Block $targetBlock, BlockPos pos) {
            if (visited.contains(pos) || orePositions.size() >= 64) {
                return;
            }
            visited.add(pos);
            BlockState state = $level.getBlockState(pos);
            if (state.is($tag) && Intrinsics.areEqual((Object)state.getBlock(), (Object)$targetBlock)) {
                orePositions.add(pos);
                for (int dx = -1; dx < 2; ++dx) {
                    for (int dy = -1; dy < 2; ++dy) {
                        for (int dz = -1; dz < 2; ++dz) {
                            if (dx == 0 && dy == 0 && dz == 0) continue;
                            BlockPos blockPos = pos.offset(dx, dy, dz);
                            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                            dev.sterner.witchery.content.item.curios.HagsRingItem$Companion.gatherConnectedOfSameTag$dfs(visited, orePositions, $level, $tag, $targetBlock, blockPos);
                        }
                    }
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

