/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.recipe.cauldron;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.content.recipe.cauldron.CauldronInfusionRecipeInput;
import dev.sterner.witchery.core.registry.WitcheryRecipeSerializers;
import dev.sterner.witchery.core.registry.WitcheryRecipeTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002!\"B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J\f\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/content/recipe/cauldron/CauldronInfusionRecipe;", "Lnet/minecraft/world/item/crafting/Recipe;", "Ldev/sterner/witchery/content/recipe/cauldron/CauldronInfusionRecipeInput;", "brewInput", "Lnet/minecraft/world/item/ItemStack;", "infusionItem", "outputItem", "altarPower", "", "<init>", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;I)V", "getBrewInput", "()Lnet/minecraft/world/item/ItemStack;", "getInfusionItem", "getOutputItem", "getAltarPower", "()I", "matches", "", "input", "level", "Lnet/minecraft/world/level/Level;", "assemble", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "width", "height", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "Serializer", "Companion", "witchery"})
public final class CauldronInfusionRecipe
implements Recipe<CauldronInfusionRecipeInput> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStack brewInput;
    @NotNull
    private final ItemStack infusionItem;
    @NotNull
    private final ItemStack outputItem;
    private final int altarPower;
    @NotNull
    public static final String NAME = "cauldron_infusion";

    public CauldronInfusionRecipe(@NotNull ItemStack brewInput, @NotNull ItemStack infusionItem, @NotNull ItemStack outputItem, int altarPower) {
        Intrinsics.checkNotNullParameter((Object)brewInput, (String)"brewInput");
        Intrinsics.checkNotNullParameter((Object)infusionItem, (String)"infusionItem");
        Intrinsics.checkNotNullParameter((Object)outputItem, (String)"outputItem");
        this.brewInput = brewInput;
        this.infusionItem = infusionItem;
        this.outputItem = outputItem;
        this.altarPower = altarPower;
    }

    @NotNull
    public final ItemStack getBrewInput() {
        return this.brewInput;
    }

    @NotNull
    public final ItemStack getInfusionItem() {
        return this.infusionItem;
    }

    @NotNull
    public final ItemStack getOutputItem() {
        return this.outputItem;
    }

    public final int getAltarPower() {
        return this.altarPower;
    }

    public boolean matches(@NotNull CauldronInfusionRecipeInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!ItemStack.isSameItem((ItemStack)this.brewInput, (ItemStack)input.getBrewStack())) {
            return false;
        }
        return ItemStack.isSameItem((ItemStack)this.infusionItem, (ItemStack)input.getThrownItem());
    }

    @NotNull
    public ItemStack assemble(@NotNull CauldronInfusionRecipeInput input, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ItemStack itemStack = this.outputItem.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        return this.outputItem;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = WitcheryRecipeSerializers.INSTANCE.getCAULDRON_INFUSION_RECIPE_SERIALIZER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    @NotNull
    public RecipeType<?> getType() {
        Object object = WitcheryRecipeTypes.INSTANCE.getCAULDRON_INFUSION_RECIPE_TYPE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeType)object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/sterner/witchery/content/recipe/cauldron/CauldronInfusionRecipe$Companion;", "", "<init>", "()V", "NAME", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/recipe/cauldron/CauldronInfusionRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Ldev/sterner/witchery/content/recipe/cauldron/CauldronInfusionRecipe;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Companion", "witchery"})
    public static final class Serializer
    implements RecipeSerializer<CauldronInfusionRecipe> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MapCodec<CauldronInfusionRecipe> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, CauldronInfusionRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<CauldronInfusionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CauldronInfusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.group((App)ItemStack.CODEC.fieldOf("brewInput").forGetter(Serializer::CODEC$lambda$0$0), (App)ItemStack.CODEC.fieldOf("infusionItem").forGetter(Serializer::CODEC$lambda$0$1), (App)ItemStack.CODEC.fieldOf("outputItem").forGetter(Serializer::CODEC$lambda$0$2), (App)Codec.INT.fieldOf("altarPower").forGetter(Serializer::CODEC$lambda$0$3)).apply((Applicative)obj, CauldronInfusionRecipe::new);
        }

        private static final ItemStack CODEC$lambda$0$0(CauldronInfusionRecipe it) {
            return it.getBrewInput();
        }

        private static final ItemStack CODEC$lambda$0$1(CauldronInfusionRecipe it) {
            return it.getInfusionItem();
        }

        private static final ItemStack CODEC$lambda$0$2(CauldronInfusionRecipe it) {
            return it.getOutputItem();
        }

        private static final Integer CODEC$lambda$0$3(CauldronInfusionRecipe it) {
            return it.getAltarPower();
        }

        static {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(Serializer::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            CODEC = mapCodec;
            StreamCodec streamCodec = ByteBufCodecs.fromCodecWithRegistries((Codec)CODEC.codec());
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"fromCodecWithRegistries(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/content/recipe/cauldron/CauldronInfusionRecipe$Serializer$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/sterner/witchery/content/recipe/cauldron/CauldronInfusionRecipe;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<CauldronInfusionRecipe> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, CauldronInfusionRecipe> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

