/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.worldgen.patch;

import com.mojang.serialization.Codec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/worldgen/patch/MushroomCircleFeature;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "Lnet/minecraft/world/level/levelgen/feature/configurations/RandomPatchConfiguration;", "codec", "Lcom/mojang/serialization/Codec;", "<init>", "(Lcom/mojang/serialization/Codec;)V", "place", "", "context", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "witchery"})
public final class MushroomCircleFeature
extends Feature<RandomPatchConfiguration> {
    public MushroomCircleFeature(@NotNull Codec<RandomPatchConfiguration> codec) {
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        super(codec);
    }

    public boolean place(@NotNull FeaturePlaceContext<RandomPatchConfiguration> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        RandomPatchConfiguration config = (RandomPatchConfiguration)context.config();
        RandomSource randomSource = context.random();
        BlockPos origin = context.origin();
        WorldGenLevel worldGenLevel = context.level();
        int radius = config.xzSpread();
        int successfulPlacements = 0;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)360)), (int)10);
        int angle = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && angle <= n || n2 < 0 && n <= angle) {
            while (true) {
                int targetZ;
                int targetY;
                double radians = Math.toRadians(angle);
                int xOffset = (int)((double)radius * Math.cos(radians));
                int zOffset = (int)((double)radius * Math.sin(radians));
                int targetX = origin.getX() + xOffset;
                BlockPos targetPos = new BlockPos(targetX, targetY = worldGenLevel.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, targetX, targetZ = origin.getZ() + zOffset), targetZ);
                if (worldGenLevel.getBlockState(targetPos.below()).isSolid() && worldGenLevel.isEmptyBlock(targetPos) && ((PlacedFeature)config.feature().value()).place(worldGenLevel, context.chunkGenerator(), randomSource, targetPos)) {
                    ++successfulPlacements;
                }
                if (angle == n) break;
                angle += n2;
            }
        }
        return successfulPlacements > 0;
    }
}

