/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.sterner.witchery.content.item.potion.WitcheryPotionIngredient;
import dev.sterner.witchery.core.api.SpecialPotion;
import dev.sterner.witchery.core.api.block.ActiveEffect;
import dev.sterner.witchery.core.api.block.PotionDisperser;
import dev.sterner.witchery.core.data.InfiniteCenserReloadListener;
import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import dev.sterner.witchery.core.registry.WitcherySpecialPotionEffects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/core/api/block/PotionDisperserHelper;", "", "<init>", "()V", "processRegularPotion", "", "disperser", "Ldev/sterner/witchery/core/api/block/PotionDisperser;", "potion", "Lnet/minecraft/world/item/alchemy/PotionContents;", "processSpecialPotions", "isEmptyEffect", "", "rl", "Lnet/minecraft/resources/ResourceLocation;", "applyEffects", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "effect", "Ldev/sterner/witchery/core/api/block/ActiveEffect;", "calculatePotionColor", "", "spawnPotionParticles", "density", "", "savePotionData", "tag", "Lnet/minecraft/nbt/CompoundTag;", "loadPotionData", "refreshActiveEffects", "witchery"})
@SourceDebugExtension(value={"SMAP\nPotionDisperserHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PotionDisperserHelper.kt\ndev/sterner/witchery/core/api/block/PotionDisperserHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n1#2:320\n1869#3,2:321\n1869#3,2:323\n1869#3,2:325\n*S KotlinDebug\n*F\n+ 1 PotionDisperserHelper.kt\ndev/sterner/witchery/core/api/block/PotionDisperserHelper\n*L\n115#1:321,2\n167#1:323,2\n47#1:325,2\n*E\n"})
public final class PotionDisperserHelper {
    @NotNull
    public static final PotionDisperserHelper INSTANCE = new PotionDisperserHelper();

    private PotionDisperserHelper() {
    }

    private final void processRegularPotion(PotionDisperser disperser, PotionContents potion) {
        for (MobEffectInstance effect : potion.customEffects()) {
            ResourceLocation rl;
            if (BuiltInRegistries.MOB_EFFECT.getKey(effect.getEffect().value()) == null || this.isEmptyEffect(rl)) continue;
            boolean isInfinite = disperser.isInfiniteMode() && InfiniteCenserReloadListener.INSTANCE.getINFINITE_POTIONS().contains(effect.getEffect());
            int remainingTicks = isInfinite ? -1 : effect.getDuration();
            ((Collection)disperser.getActiveEffects()).add(new ActiveEffect(rl, false, effect.getAmplifier(), remainingTicks, effect.getDuration(), new WitcheryPotionIngredient.DispersalModifier(0, 0, 3, null), 0L));
        }
        potion.potion().ifPresent(arg_0 -> PotionDisperserHelper.processRegularPotion$lambda$1(arg_0 -> PotionDisperserHelper.processRegularPotion$lambda$0(disperser, arg_0), arg_0));
    }

    private final void processSpecialPotions(PotionDisperser disperser) {
        Object object;
        Object object2;
        Object it;
        Object object3;
        List<WitcheryPotionIngredient> specialPotions = disperser.getSpecialPotions();
        if (specialPotions.isEmpty()) {
            return;
        }
        Iterator<Object> iterator = ((Iterable)specialPotions).iterator();
        if (!iterator.hasNext()) {
            object3 = null;
        } else {
            it = (WitcheryPotionIngredient)iterator.next();
            boolean bl = false;
            it = ((WitcheryPotionIngredient)it).getEffectModifier().getPowerAddition();
            while (iterator.hasNext()) {
                Object it2 = (WitcheryPotionIngredient)iterator.next();
                $i$a$-maxOfOrNull-PotionDisperserHelper$processSpecialPotions$compoundPower$1 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(((WitcheryPotionIngredient)it2).getEffectModifier().getPowerAddition())) >= 0) continue;
                it = it2;
            }
            object3 = it;
        }
        Integer n = (Integer)object3;
        int compoundPower = n != null ? n : 0;
        it = ((Iterable)specialPotions).iterator();
        if (!it.hasNext()) {
            object2 = null;
        } else {
            Object it3 = (WitcheryPotionIngredient)it.next();
            boolean bl = false;
            it3 = ((WitcheryPotionIngredient)it3).getEffectModifier().getDurationAddition();
            while (it.hasNext()) {
                Object it4 = (WitcheryPotionIngredient)it.next();
                $i$a$-maxOfOrNull-PotionDisperserHelper$processSpecialPotions$compoundDurationAdd$1 = false;
                if (it3.compareTo(it4 = (Comparable)Integer.valueOf(((WitcheryPotionIngredient)it4).getEffectModifier().getDurationAddition())) >= 0) continue;
                it3 = it4;
            }
            object2 = it3;
        }
        Integer n2 = (Integer)object2;
        int compoundDurationAdd = n2 != null ? n2 : 0;
        Iterator it3 = ((Iterable)specialPotions).iterator();
        if (!it3.hasNext()) {
            object = null;
        } else {
            Object it5 = (WitcheryPotionIngredient)it3.next();
            boolean bl = false;
            it5 = ((WitcheryPotionIngredient)it5).getEffectModifier().getDurationMultiplier();
            while (it3.hasNext()) {
                Object it6 = (WitcheryPotionIngredient)it3.next();
                $i$a$-maxOfOrNull-PotionDisperserHelper$processSpecialPotions$compoundDurationMult$1 = false;
                if (it5.compareTo(it6 = (Comparable)Integer.valueOf(((WitcheryPotionIngredient)it6).getEffectModifier().getDurationMultiplier())) >= 0) continue;
                it5 = it6;
            }
            object = it5;
        }
        Integer n3 = (Integer)object;
        int compoundDurationMult = n3 != null ? n3 : 1;
        for (WitcheryPotionIngredient special : specialPotions) {
            ResourceLocation rl;
            special.getSpecialEffect().ifPresent(arg_0 -> PotionDisperserHelper.processSpecialPotions$lambda$4(arg_0 -> PotionDisperserHelper.processSpecialPotions$lambda$3(special, compoundDurationAdd, compoundDurationMult, disperser, compoundPower, arg_0), arg_0));
            if (Intrinsics.areEqual(special.getEffect(), WitcheryMobEffects.INSTANCE.getEMPTY()) || BuiltInRegistries.MOB_EFFECT.getKey(special.getEffect().value()) == null || this.isEmptyEffect(rl)) continue;
            int baseDuration = (special.getBaseDuration() + compoundDurationAdd) * compoundDurationMult;
            boolean isInfinite = disperser.isInfiniteMode() && InfiniteCenserReloadListener.INSTANCE.getINFINITE_POTIONS().contains(special.getEffect());
            int remainingTicks = isInfinite ? -1 : baseDuration;
            ((Collection)disperser.getActiveEffects()).add(new ActiveEffect(rl, false, compoundPower, remainingTicks, baseDuration, special.getDispersalModifier(), 0L, 64, null));
        }
    }

    private final boolean isEmptyEffect(ResourceLocation rl) {
        return Intrinsics.areEqual((Object)rl.getPath(), (Object)"empty") && Intrinsics.areEqual((Object)rl.getNamespace(), (Object)"witchery");
    }

    public final void applyEffects(@NotNull PotionDisperser disperser, @NotNull Level level, @NotNull BlockPos pos, @NotNull ActiveEffect effect) {
        SpecialPotion specialEffect;
        Intrinsics.checkNotNullParameter((Object)disperser, (String)"disperser");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        double radius = disperser.getDispersalRadius();
        AABB aabb = AABB.ofSize((Vec3)pos.getCenter(), (double)(radius * (double)2), (double)(radius * (double)2), (double)(radius * (double)2));
        Holder.Reference mobEffect = BuiltInRegistries.MOB_EFFECT.getHolder(effect.getId()).orElse(null);
        if (mobEffect != null) {
            List list = level.getEntitiesOfClass(LivingEntity.class, aabb);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LivingEntity entity = (LivingEntity)element$iv;
                boolean bl = false;
                int effectDuration = effect.getRemainingTicks() == -1 ? effect.getOriginalDuration() : effect.getRemainingTicks();
                entity.addEffect(new MobEffectInstance((Holder)mobEffect, effectDuration, effect.getAmplifier(), true, true));
            }
        }
        if (effect.isSpecial() && (specialEffect = (SpecialPotion)WitcherySpecialPotionEffects.INSTANCE.getSPECIAL_REGISTRY().get(effect.getId())) != null) {
            List entities = level.getEntitiesOfClass(Entity.class, aabb);
            Player owner = disperser.getOwner().flatMap(arg_0 -> PotionDisperserHelper.applyEffects$lambda$2(arg_0 -> PotionDisperserHelper.applyEffects$lambda$1(level, arg_0), arg_0)).orElse(null);
            int duration = effect.getRemainingTicks() == -1 ? effect.getOriginalDuration() : effect.getRemainingTicks();
            BlockHitResult hitResult = new BlockHitResult(pos.getCenter(), Direction.UP, pos, false);
            Entity entity = (Entity)owner;
            HitResult hitResult2 = (HitResult)hitResult;
            Intrinsics.checkNotNull((Object)entities);
            specialEffect.onActivated(level, entity, hitResult2, entities, effect.getDispersal(), duration, effect.getAmplifier());
        }
    }

    public final int calculatePotionColor(@NotNull PotionDisperser disperser) {
        int n;
        Intrinsics.checkNotNullParameter((Object)disperser, (String)"disperser");
        List<PotionContents> potionContents = disperser.getPotionContents();
        if (!((Collection)potionContents).isEmpty() && !Intrinsics.areEqual((Object)potionContents.get(0), (Object)PotionContents.EMPTY)) {
            return potionContents.get(0).getColor();
        }
        List<WitcheryPotionIngredient> specialPotions = disperser.getSpecialPotions();
        if (!((Collection)specialPotions).isEmpty()) {
            int r = 0;
            int g = 0;
            int b = 0;
            int count = 0;
            Iterable $this$forEach$iv = specialPotions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WitcheryPotionIngredient potion = (WitcheryPotionIngredient)element$iv;
                boolean bl = false;
                if (potion.getColor() == 0) continue;
                r += potion.getColor() >> 16 & 0xFF;
                g += potion.getColor() >> 8 & 0xFF;
                b += potion.getColor() & 0xFF;
                ++count;
            }
            return count > 0 ? r / count << 16 | g / count << 8 | b / count : 8073150;
        }
        ActiveEffect activeEffect = (ActiveEffect)CollectionsKt.firstOrNull(disperser.getActiveEffects());
        if (activeEffect != null) {
            MobEffect mobEffect;
            ActiveEffect effect = activeEffect;
            boolean bl = false;
            MobEffect mobEffect2 = mobEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(effect.getId());
            n = mobEffect2 != null ? mobEffect2.getColor() : 8073150;
        } else {
            n = 8073150;
        }
        return n;
    }

    public final void spawnPotionParticles(@NotNull Level level, @NotNull BlockPos pos, @NotNull PotionDisperser disperser, float density) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)disperser, (String)"disperser");
        if (disperser.getActiveEffects().isEmpty()) {
            return;
        }
        if (level.random.nextFloat() >= density) {
            return;
        }
        int color = this.calculatePotionColor(disperser);
        double centerX = (double)pos.getX() + 0.5;
        double centerY = (double)pos.getY() + 0.5;
        double centerZ = (double)pos.getZ() + 0.5;
        double angle = level.random.nextDouble() * Math.PI * (double)2;
        double radius = 0.3 + level.random.nextDouble() * 0.2;
        double particleX = centerX + Math.cos(angle) * radius;
        double particleZ = centerZ + Math.sin(angle) * radius;
        level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)color).toVector3f(), 0.8f), particleX, centerY + level.random.nextDouble() * 0.3, particleZ, 0.0, 0.01, 0.0);
    }

    public static /* synthetic */ void spawnPotionParticles$default(PotionDisperserHelper potionDisperserHelper, Level level, BlockPos blockPos, PotionDisperser potionDisperser, float f, int n, Object object) {
        if ((n & 8) != 0) {
            f = 0.2f;
        }
        potionDisperserHelper.spawnPotionParticles(level, blockPos, potionDisperser, f);
    }

    public final void savePotionData(@NotNull CompoundTag tag, @NotNull PotionDisperser disperser, @NotNull Level level) {
        List<WitcheryPotionIngredient> specialPotions;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)disperser, (String)"disperser");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ListTag potionList = new ListTag();
        for (PotionContents potion : disperser.getPotionContents()) {
            if (Intrinsics.areEqual((Object)potion, (Object)PotionContents.EMPTY)) continue;
            RegistryOps registryOps = level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            PotionContents.CODEC.encodeStart((DynamicOps)registryOps, (Object)potion).resultOrPartial(PotionDisperserHelper::savePotionData$lambda$0).ifPresent(arg_0 -> PotionDisperserHelper.savePotionData$lambda$2(arg_0 -> PotionDisperserHelper.savePotionData$lambda$1(potionList, arg_0), arg_0));
        }
        if (!potionList.isEmpty()) {
            tag.put("PotionContents", (Tag)potionList);
        }
        if (!((Collection)(specialPotions = disperser.getSpecialPotions())).isEmpty()) {
            DataResult encodeResult = WitcheryPotionIngredient.Companion.getCODEC().listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, specialPotions);
            encodeResult.resultOrPartial(PotionDisperserHelper::savePotionData$lambda$3).ifPresent(arg_0 -> PotionDisperserHelper.savePotionData$lambda$5(arg_0 -> PotionDisperserHelper.savePotionData$lambda$4(tag, arg_0), arg_0));
        }
        ListTag effectsList = new ListTag();
        for (ActiveEffect effect : disperser.getActiveEffects()) {
            CompoundTag effectTag = new CompoundTag();
            effectTag.putString("Id", effect.getId().toString());
            effectTag.putBoolean("IsSpecial", effect.isSpecial());
            effectTag.putInt("Remaining", effect.getRemainingTicks());
            effectTag.putInt("Original", effect.getOriginalDuration());
            effectTag.putInt("Amplifier", effect.getAmplifier());
            effectTag.putLong("LastActivation", effect.getLastSpecialActivation());
            effectsList.add((Object)effectTag);
        }
        tag.put("ActiveEffects", (Tag)effectsList);
        disperser.getOwner().ifPresent(arg_0 -> PotionDisperserHelper.savePotionData$lambda$7(arg_0 -> PotionDisperserHelper.savePotionData$lambda$6(tag, arg_0), arg_0));
        tag.putBoolean("InfiniteMode", disperser.isInfiniteMode());
    }

    public final void loadPotionData(@NotNull CompoundTag tag, @NotNull PotionDisperser disperser, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)disperser, (String)"disperser");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        List potionContents = new ArrayList();
        if (tag.contains("PotionContents")) {
            ListTag potionList = tag.getList("PotionContents", 10);
            RegistryOps registryOps = level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            int n = potionList.size();
            for (int i = 0; i < n; ++i) {
                PotionContents.CODEC.parse((DynamicOps)registryOps, (Object)potionList.get(i)).resultOrPartial(PotionDisperserHelper::loadPotionData$lambda$0).ifPresent(arg_0 -> PotionDisperserHelper.loadPotionData$lambda$2(arg_0 -> PotionDisperserHelper.loadPotionData$lambda$1(potionContents, arg_0), arg_0));
            }
        }
        disperser.setPotionContents(potionContents);
        if (tag.contains("SpecialPotions")) {
            Codec codec = WitcheryPotionIngredient.Companion.getCODEC().listOf();
            DynamicOps dynamicOps = (DynamicOps)NbtOps.INSTANCE;
            Tag tag2 = tag.get("SpecialPotions");
            Intrinsics.checkNotNull((Object)tag2);
            DataResult decodeResult = codec.parse(dynamicOps, (Object)tag2);
            decodeResult.resultOrPartial(PotionDisperserHelper::loadPotionData$lambda$3).ifPresent(arg_0 -> PotionDisperserHelper.loadPotionData$lambda$5(arg_0 -> PotionDisperserHelper.loadPotionData$lambda$4(disperser, arg_0), arg_0));
        }
        disperser.getActiveEffects().clear();
        if (tag.contains("ActiveEffects")) {
            ListTag effectsList = tag.getList("ActiveEffects", 10);
            int n = effectsList.size();
            for (int i = 0; i < n; ++i) {
                CompoundTag effectTag = effectsList.getCompound(i);
                ResourceLocation rl = ResourceLocation.parse((String)effectTag.getString("Id"));
                boolean isSpecial = effectTag.getBoolean("IsSpecial");
                int remaining = effectTag.getInt("Remaining");
                int original = effectTag.getInt("Original");
                int amplifier = effectTag.getInt("Amplifier");
                long lastActivation = effectTag.getLong("LastActivation");
                Collection collection = disperser.getActiveEffects();
                Intrinsics.checkNotNull((Object)rl);
                collection.add(new ActiveEffect(rl, isSpecial, amplifier, remaining, original, new WitcheryPotionIngredient.DispersalModifier(0, 0, 3, null), lastActivation));
            }
        }
        if (tag.contains("Owner")) {
            Optional<UUID> optional = Optional.of(tag.getUUID("Owner"));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            disperser.setOwner(optional);
        }
        disperser.setInfiniteMode(tag.getBoolean("InfiniteMode"));
    }

    public final void refreshActiveEffects(@NotNull PotionDisperser disperser) {
        Intrinsics.checkNotNullParameter((Object)disperser, (String)"disperser");
        disperser.getActiveEffects().clear();
        for (PotionContents potion : disperser.getPotionContents()) {
            this.processRegularPotion(disperser, potion);
        }
        this.processSpecialPotions(disperser);
    }

    private static final Unit processRegularPotion$lambda$0(PotionDisperser $disperser, Holder potionHolder) {
        Intrinsics.checkNotNullParameter((Object)potionHolder, (String)"potionHolder");
        List list = ((Potion)potionHolder.value()).getEffects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEffects(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceLocation rl;
            MobEffectInstance effect = (MobEffectInstance)element$iv;
            boolean bl = false;
            if (BuiltInRegistries.MOB_EFFECT.getKey(effect.getEffect().value()) == null || INSTANCE.isEmptyEffect(rl)) continue;
            boolean isInfinite = $disperser.isInfiniteMode() && InfiniteCenserReloadListener.INSTANCE.getINFINITE_POTIONS().contains(effect.getEffect());
            int remainingTicks = isInfinite ? -1 : effect.getDuration();
            ((Collection)$disperser.getActiveEffects()).add(new ActiveEffect(rl, false, effect.getAmplifier(), remainingTicks, effect.getDuration(), null, 0L, 96, null));
        }
        return Unit.INSTANCE;
    }

    private static final void processRegularPotion$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit processSpecialPotions$lambda$3(WitcheryPotionIngredient $special, int $compoundDurationAdd, int $compoundDurationMult, PotionDisperser $disperser, int $compoundPower, ResourceLocation rl) {
        Intrinsics.checkNotNullParameter((Object)rl, (String)"rl");
        if (INSTANCE.isEmptyEffect(rl)) {
            return Unit.INSTANCE;
        }
        int baseDuration = ($special.getBaseDuration() + $compoundDurationAdd) * $compoundDurationMult;
        boolean isInfinite = $disperser.isInfiniteMode() && InfiniteCenserReloadListener.INSTANCE.getINFINITE_SPECIAL_POTIONS().contains(rl);
        int remainingTicks = isInfinite ? -1 : baseDuration;
        ((Collection)$disperser.getActiveEffects()).add(new ActiveEffect(rl, true, $compoundPower, remainingTicks, baseDuration, $special.getDispersalModifier(), 0L));
        return Unit.INSTANCE;
    }

    private static final void processSpecialPotions$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Optional applyEffects$lambda$1(Level $level, UUID it) {
        return Optional.ofNullable($level.getPlayerByUUID(it));
    }

    private static final Optional applyEffects$lambda$2(Function1 $tmp0, Object p0) {
        return (Optional)$tmp0.invoke(p0);
    }

    private static final void savePotionData$lambda$0(String it) {
    }

    private static final Unit savePotionData$lambda$1(ListTag $potionList, Tag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $potionList.add((Object)it);
        return Unit.INSTANCE;
    }

    private static final void savePotionData$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void savePotionData$lambda$3(String error) {
    }

    private static final Unit savePotionData$lambda$4(CompoundTag $tag, Tag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $tag.put("SpecialPotions", it);
        return Unit.INSTANCE;
    }

    private static final void savePotionData$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit savePotionData$lambda$6(CompoundTag $tag, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $tag.putUUID("Owner", it);
        return Unit.INSTANCE;
    }

    private static final void savePotionData$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void loadPotionData$lambda$0(String it) {
    }

    private static final Unit loadPotionData$lambda$1(List $potionContents, PotionContents it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $potionContents.add(it);
        return Unit.INSTANCE;
    }

    private static final void loadPotionData$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void loadPotionData$lambda$3(String error) {
    }

    private static final Unit loadPotionData$lambda$4(PotionDisperser $disperser, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $disperser.setSpecialPotions(it);
        return Unit.INSTANCE;
    }

    private static final void loadPotionData$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

