/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.api.BrazierPassive;
import dev.sterner.witchery.features.brazier.AnguishOfTheDeadBrazierPassive;
import dev.sterner.witchery.features.brazier.DeathlyVeilBrazierPassive;
import dev.sterner.witchery.features.brazier.DrainGrowthBrazierPassive;
import dev.sterner.witchery.features.brazier.EmptyBrazierPassive;
import dev.sterner.witchery.features.brazier.FortificationOfTheCorpseBrazierPassive;
import dev.sterner.witchery.features.brazier.GraveyardMistBrazierPassive;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010(\u001a\u0004\u0018\u00010\f2\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001a0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001d0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u001d\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020 0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u001d\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020#0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0018R\u001d\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020&0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u00062"}, d2={"Ldev/sterner/witchery/core/registry/WitcheryBrazierRegistry;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "BRAZIER_REGISTRY_KEY", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "Ldev/sterner/witchery/core/api/BrazierPassive;", "getBRAZIER_REGISTRY_KEY", "()Lnet/minecraft/resources/ResourceKey;", "BRAZIER_REGISTRY", "getBRAZIER_REGISTRY", "()Lnet/minecraft/core/Registry;", "BRAZIERS", "Lnet/neoforged/neoforge/registries/DeferredRegister;", "EMPTY", "Lnet/neoforged/neoforge/registries/DeferredHolder;", "Ldev/sterner/witchery/features/brazier/EmptyBrazierPassive;", "getEMPTY", "()Lnet/neoforged/neoforge/registries/DeferredHolder;", "GRAVEYARD_MIST", "Ldev/sterner/witchery/features/brazier/GraveyardMistBrazierPassive;", "getGRAVEYARD_MIST", "ANGUISH_OF_THE_DEAD", "Ldev/sterner/witchery/features/brazier/AnguishOfTheDeadBrazierPassive;", "getANGUISH_OF_THE_DEAD", "DEATHLY_VEIL", "Ldev/sterner/witchery/features/brazier/DeathlyVeilBrazierPassive;", "getDEATHLY_VEIL", "DRAIN_GROWTH", "Ldev/sterner/witchery/features/brazier/DrainGrowthBrazierPassive;", "getDRAIN_GROWTH", "FORTIFICATION_OF_THE_CORPSE", "Ldev/sterner/witchery/features/brazier/FortificationOfTheCorpseBrazierPassive;", "getFORTIFICATION_OF_THE_CORPSE", "getById", "id", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "register", "", "modEventBus", "Lnet/neoforged/bus/api/IEventBus;", "witchery"})
@SourceDebugExtension(value={"SMAP\nWitcheryBrazierRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitcheryBrazierRegistry.kt\ndev/sterner/witchery/core/registry/WitcheryBrazierRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n295#2,2:65\n*S KotlinDebug\n*F\n+ 1 WitcheryBrazierRegistry.kt\ndev/sterner/witchery/core/registry/WitcheryBrazierRegistry\n*L\n48#1:65,2\n*E\n"})
public final class WitcheryBrazierRegistry {
    @NotNull
    public static final WitcheryBrazierRegistry INSTANCE = new WitcheryBrazierRegistry();
    private static final ResourceLocation ID = Witchery.Companion.id("brazier_passive");
    @NotNull
    private static final ResourceKey<Registry<BrazierPassive>> BRAZIER_REGISTRY_KEY;
    @NotNull
    private static final Registry<BrazierPassive> BRAZIER_REGISTRY;
    @NotNull
    private static final DeferredRegister<BrazierPassive> BRAZIERS;
    @NotNull
    private static final DeferredHolder<BrazierPassive, EmptyBrazierPassive> EMPTY;
    @NotNull
    private static final DeferredHolder<BrazierPassive, GraveyardMistBrazierPassive> GRAVEYARD_MIST;
    @NotNull
    private static final DeferredHolder<BrazierPassive, AnguishOfTheDeadBrazierPassive> ANGUISH_OF_THE_DEAD;
    @NotNull
    private static final DeferredHolder<BrazierPassive, DeathlyVeilBrazierPassive> DEATHLY_VEIL;
    @NotNull
    private static final DeferredHolder<BrazierPassive, DrainGrowthBrazierPassive> DRAIN_GROWTH;
    @NotNull
    private static final DeferredHolder<BrazierPassive, FortificationOfTheCorpseBrazierPassive> FORTIFICATION_OF_THE_CORPSE;
    @NotNull
    private static final Codec<BrazierPassive> CODEC;

    private WitcheryBrazierRegistry() {
    }

    public final ResourceLocation getID() {
        return ID;
    }

    @NotNull
    public final ResourceKey<Registry<BrazierPassive>> getBRAZIER_REGISTRY_KEY() {
        return BRAZIER_REGISTRY_KEY;
    }

    @NotNull
    public final Registry<BrazierPassive> getBRAZIER_REGISTRY() {
        return BRAZIER_REGISTRY;
    }

    @NotNull
    public final DeferredHolder<BrazierPassive, EmptyBrazierPassive> getEMPTY() {
        return EMPTY;
    }

    @NotNull
    public final DeferredHolder<BrazierPassive, GraveyardMistBrazierPassive> getGRAVEYARD_MIST() {
        return GRAVEYARD_MIST;
    }

    @NotNull
    public final DeferredHolder<BrazierPassive, AnguishOfTheDeadBrazierPassive> getANGUISH_OF_THE_DEAD() {
        return ANGUISH_OF_THE_DEAD;
    }

    @NotNull
    public final DeferredHolder<BrazierPassive, DeathlyVeilBrazierPassive> getDEATHLY_VEIL() {
        return DEATHLY_VEIL;
    }

    @NotNull
    public final DeferredHolder<BrazierPassive, DrainGrowthBrazierPassive> getDRAIN_GROWTH() {
        return DRAIN_GROWTH;
    }

    @NotNull
    public final DeferredHolder<BrazierPassive, FortificationOfTheCorpseBrazierPassive> getFORTIFICATION_OF_THE_CORPSE() {
        return FORTIFICATION_OF_THE_CORPSE;
    }

    @Nullable
    public final BrazierPassive getById(@NotNull ResourceLocation id) {
        DeferredHolder holder;
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Collection collection = BRAZIERS.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEntries(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DeferredHolder it = (DeferredHolder)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        DeferredHolder deferredHolder = holder = (DeferredHolder)v1;
        return deferredHolder != null ? (BrazierPassive)deferredHolder.get() : null;
    }

    @NotNull
    public final Codec<BrazierPassive> getCODEC() {
        return CODEC;
    }

    public final void register(@NotNull IEventBus modEventBus) {
        Intrinsics.checkNotNullParameter((Object)modEventBus, (String)"modEventBus");
        BRAZIERS.register(modEventBus);
    }

    private static final EmptyBrazierPassive EMPTY$lambda$0() {
        return new EmptyBrazierPassive();
    }

    private static final GraveyardMistBrazierPassive GRAVEYARD_MIST$lambda$0() {
        return new GraveyardMistBrazierPassive();
    }

    private static final AnguishOfTheDeadBrazierPassive ANGUISH_OF_THE_DEAD$lambda$0() {
        return new AnguishOfTheDeadBrazierPassive();
    }

    private static final DeathlyVeilBrazierPassive DEATHLY_VEIL$lambda$0() {
        return new DeathlyVeilBrazierPassive();
    }

    private static final DrainGrowthBrazierPassive DRAIN_GROWTH$lambda$0() {
        return new DrainGrowthBrazierPassive();
    }

    private static final FortificationOfTheCorpseBrazierPassive FORTIFICATION_OF_THE_CORPSE$lambda$0() {
        return new FortificationOfTheCorpseBrazierPassive();
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(WitcheryBrazierRegistry::CODEC$lambda$0$0)).apply((Applicative)instance, WitcheryBrazierRegistry::CODEC$lambda$0$1);
    }

    private static final ResourceLocation CODEC$lambda$0$0(BrazierPassive it) {
        return it.getId();
    }

    private static final BrazierPassive CODEC$lambda$0$1(ResourceLocation resourceLocation) {
        Intrinsics.checkNotNull((Object)resourceLocation);
        BrazierPassive brazierPassive = INSTANCE.getById(resourceLocation);
        if (brazierPassive == null) {
            brazierPassive = new EmptyBrazierPassive();
        }
        return brazierPassive;
    }

    static {
        ResourceKey resourceKey = ResourceKey.createRegistryKey((ResourceLocation)ID);
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"createRegistryKey(...)");
        BRAZIER_REGISTRY_KEY = resourceKey;
        Registry registry = new RegistryBuilder(BRAZIER_REGISTRY_KEY).sync(true).defaultKey(ID).maxId(256).create();
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"create(...)");
        BRAZIER_REGISTRY = registry;
        DeferredRegister deferredRegister = DeferredRegister.create(BRAZIER_REGISTRY, (String)"witchery");
        Intrinsics.checkNotNullExpressionValue((Object)deferredRegister, (String)"create(...)");
        BRAZIERS = deferredRegister;
        DeferredHolder deferredHolder = BRAZIERS.register("empty", WitcheryBrazierRegistry::EMPTY$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)deferredHolder, (String)"register(...)");
        EMPTY = deferredHolder;
        DeferredHolder deferredHolder2 = BRAZIERS.register("graveyard_mist", WitcheryBrazierRegistry::GRAVEYARD_MIST$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)deferredHolder2, (String)"register(...)");
        GRAVEYARD_MIST = deferredHolder2;
        DeferredHolder deferredHolder3 = BRAZIERS.register("anguish_of_the_dead", WitcheryBrazierRegistry::ANGUISH_OF_THE_DEAD$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)deferredHolder3, (String)"register(...)");
        ANGUISH_OF_THE_DEAD = deferredHolder3;
        DeferredHolder deferredHolder4 = BRAZIERS.register("deathly_veil", WitcheryBrazierRegistry::DEATHLY_VEIL$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)deferredHolder4, (String)"register(...)");
        DEATHLY_VEIL = deferredHolder4;
        DeferredHolder deferredHolder5 = BRAZIERS.register("drain_growth", WitcheryBrazierRegistry::DRAIN_GROWTH$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)deferredHolder5, (String)"register(...)");
        DRAIN_GROWTH = deferredHolder5;
        DeferredHolder deferredHolder6 = BRAZIERS.register("fortification_of_the_corpse", WitcheryBrazierRegistry::FORTIFICATION_OF_THE_CORPSE$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)deferredHolder6, (String)"register(...)");
        FORTIFICATION_OF_THE_CORPSE = deferredHolder6;
        Codec codec = RecordCodecBuilder.create(WitcheryBrazierRegistry::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }
}

