/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.util;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.mixin.ArgumentTypeInfosInvoker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0016J\u001e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010\"\u001a\u00020\u001bH\u0007J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0007J \u0010(\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030*\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030+0)H\u0007J\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0007\u00a8\u00061"}, d2={"Ldev/sterner/witchery/core/util/WitcheryUtil;", "", "<init>", "()V", "hasAdvancement", "", "serverPlayer", "Lnet/minecraft/server/level/ServerPlayer;", "advancementResourceLocation", "Lnet/minecraft/resources/ResourceLocation;", "grantAdvancementCriterion", "", "criterion", "", "rotateShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "from", "Lnet/minecraft/core/Direction;", "to", "shape", "formatDuration", "ticks", "", "toRoman", "number", "addItemToInventoryAndConsume", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "itemToAdd", "Lnet/minecraft/world/item/ItemStack;", "allEquippedAccessories", "", "livingEntity", "tryEnableBatFlight", "tryDisableBatFlight", "registerWoodType", "Lnet/minecraft/world/level/block/state/properties/WoodType;", "woodType", "getByClass", "", "Ljava/lang/Class;", "Lnet/minecraft/commands/synchronization/ArgumentTypeInfo;", "createProxiedDamage", "Lnet/minecraft/world/damagesource/DamageSource;", "source", "newAttacker", "Lnet/minecraft/world/entity/Entity;", "witchery"})
public final class WitcheryUtil {
    @NotNull
    public static final WitcheryUtil INSTANCE = new WitcheryUtil();

    private WitcheryUtil() {
    }

    public final boolean hasAdvancement(@NotNull ServerPlayer serverPlayer, @NotNull ResourceLocation advancementResourceLocation) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter((Object)advancementResourceLocation, (String)"advancementResourceLocation");
        if (serverPlayer.getServer() == null) {
            return false;
        }
        ServerAdvancementManager manager = serverPlayer.server.getAdvancements();
        PlayerAdvancements playerAdvancements = serverPlayer.getAdvancements();
        Intrinsics.checkNotNullExpressionValue((Object)playerAdvancements, (String)"getAdvancements(...)");
        PlayerAdvancements tracker = playerAdvancements;
        AdvancementHolder advancement = manager.get(advancementResourceLocation);
        if (advancement != null) {
            return tracker.getOrStartProgress(advancement).isDone();
        }
        return false;
    }

    public final void grantAdvancementCriterion(@NotNull ServerPlayer serverPlayer, @NotNull ResourceLocation advancementResourceLocation, @NotNull String criterion) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter((Object)advancementResourceLocation, (String)"advancementResourceLocation");
        Intrinsics.checkNotNullParameter((Object)criterion, (String)"criterion");
        if (serverPlayer.getServer() == null) {
            return;
        }
        ServerAdvancementManager manager = serverPlayer.server.getAdvancements();
        PlayerAdvancements playerAdvancements = serverPlayer.getAdvancements();
        Intrinsics.checkNotNullExpressionValue((Object)playerAdvancements, (String)"getAdvancements(...)");
        PlayerAdvancements tracker = playerAdvancements;
        AdvancementHolder advancement = manager.get(advancementResourceLocation);
        if (advancement != null && !tracker.getOrStartProgress(advancement).isDone()) {
            tracker.award(advancement, criterion);
        }
    }

    @NotNull
    public final VoxelShape rotateShape(@NotNull Direction from, @NotNull Direction to, @NotNull VoxelShape shape) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        VoxelShape[] voxelShapeArray = new VoxelShape[2];
        voxelShapeArray[0] = shape;
        Intrinsics.checkNotNullExpressionValue((Object)Shapes.empty(), (String)"empty(...)");
        VoxelShape[] buffer = voxelShapeArray;
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> WitcheryUtil.rotateShape$lambda$0(buffer, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
            buffer[0] = buffer[1];
            Intrinsics.checkNotNullExpressionValue((Object)Shapes.empty(), (String)"empty(...)");
        }
        return buffer[0];
    }

    @NotNull
    public final String formatDuration(int ticks) {
        int totalSeconds = ticks / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        String string = "%02d:%02d";
        Object[] objectArray = new Object[]{minutes, seconds};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final String toRoman(int number) {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)10, (Object)"X"), TuplesKt.to((Object)9, (Object)"IX"), TuplesKt.to((Object)5, (Object)"V"), TuplesKt.to((Object)4, (Object)"IV"), TuplesKt.to((Object)1, (Object)"I")};
        List numerals = CollectionsKt.listOf((Object[])objectArray);
        int n = number;
        StringBuilder result = new StringBuilder();
        for (Pair pair : numerals) {
            int value = ((Number)pair.component1()).intValue();
            String numeral = (String)pair.component2();
            while (n >= value) {
                result.append(numeral);
                n -= value;
            }
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void addItemToInventoryAndConsume(@NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack itemToAdd) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)itemToAdd, (String)"itemToAdd");
        ItemStack itemStack = player.getItemInHand(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        ItemStack currentItemStack = itemStack;
        if (currentItemStack.isEmpty()) {
            player.setItemInHand(hand, itemToAdd);
        } else if (currentItemStack.getCount() == 1) {
            player.setItemInHand(hand, itemToAdd);
        } else {
            currentItemStack.shrink(1);
            if (!player.getInventory().add(itemToAdd)) {
                player.drop(itemToAdd, false, true);
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final List<ItemStack> allEquippedAccessories(@NotNull Player livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        ICuriosItemHandler iCuriosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)((LivingEntity)livingEntity)).orElse(null);
        if (iCuriosItemHandler == null) {
            return CollectionsKt.emptyList();
        }
        ICuriosItemHandler curioInventory = iCuriosItemHandler;
        IItemHandlerModifiable equippedCurios = curioInventory.getEquippedCurios();
        List equippedItems = new ArrayList();
        int n = equippedCurios.getSlots();
        for (int slotIndex = 0; slotIndex < n; ++slotIndex) {
            ItemStack itemStack = equippedCurios.getStackInSlot(slotIndex);
            if (itemStack.isEmpty()) continue;
            Intrinsics.checkNotNull((Object)itemStack);
            equippedItems.add(itemStack);
        }
        return equippedItems;
    }

    @JvmStatic
    public static final void tryEnableBatFlight(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!player.isCreative() && !player.isSpectator()) {
            AttributeInstance flightAttribute = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
            if (flightAttribute != null && flightAttribute.getValue() <= 0.0) {
                flightAttribute.addPermanentModifier(new AttributeModifier(Witchery.Companion.id("bat_flight"), 1.0, AttributeModifier.Operation.ADD_VALUE));
            }
            if (!player.onGround()) {
                player.getAbilities().flying = true;
                player.onUpdateAbilities();
            }
        }
    }

    @JvmStatic
    public static final void tryDisableBatFlight(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!player.isCreative() && !player.isSpectator()) {
            AttributeInstance flightAttribute;
            AttributeInstance attributeInstance = flightAttribute = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
            if (attributeInstance != null) {
                attributeInstance.removeModifier(Witchery.Companion.id("bat_flight"));
            }
            player.getAbilities().flying = false;
            player.onUpdateAbilities();
        }
    }

    @JvmStatic
    @NotNull
    public static final WoodType registerWoodType(@NotNull WoodType woodType) {
        Intrinsics.checkNotNullParameter((Object)woodType, (String)"woodType");
        WoodType woodType2 = WoodType.register((WoodType)woodType);
        Intrinsics.checkNotNullExpressionValue((Object)woodType2, (String)"register(...)");
        return woodType2;
    }

    @JvmStatic
    @NotNull
    public static final Map<Class<?>, ArgumentTypeInfo<?, ?>> getByClass() {
        Map<Class<?>, ArgumentTypeInfo<?, ?>> map = ArgumentTypeInfosInvoker.getByClass();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getByClass(...)");
        return map;
    }

    @JvmStatic
    @Nullable
    public static final DamageSource createProxiedDamage(@NotNull DamageSource source, @NotNull Entity newAttacker) {
        Holder damageType;
        ResourceKey key;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)newAttacker, (String)"newAttacker");
        if (source.getEntity() != null && (key = (damageType = source.typeHolder()).getKey()) != null) {
            return newAttacker.damageSources().source(key, source.getDirectEntity(), source.getEntity());
        }
        return null;
    }

    private static final void rotateShape$lambda$0(VoxelShape[] $buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Intrinsics.checkNotNullExpressionValue((Object)Shapes.join((VoxelShape)$buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.OR), (String)"join(...)");
    }
}

