/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.lich;

import dev.sterner.witchery.content.entity.player_shell.SoulShellPlayerEntity;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.ability.AbilityCooldownManager;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbility;
import dev.sterner.witchery.features.affliction.lich.LichdomSoulPoolHandler;
import dev.sterner.witchery.features.affliction.lich.LichdomSpecificEventHandler;
import dev.sterner.witchery.features.misc.MiscPlayerAttachment;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import dev.sterner.witchery.features.necromancy.NecroHandler;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B#\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/features/affliction/lich/LichdomAbility;", "Ldev/sterner/witchery/features/affliction/ability/AfflictionAbility;", "", "requiredLevel", "", "cooldown", "affliction", "Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "<init>", "(Ljava/lang/String;IIILdev/sterner/witchery/features/affliction/AfflictionTypes;)V", "getRequiredLevel", "()I", "getCooldown", "getAffliction", "()Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "SUMMON_UNDEAD", "SOUL_FORM", "CORPSE_EXPLOSION", "LIFE_DRAIN", "DEATH_TELEPORT", "witchery"})
public abstract class LichdomAbility
extends Enum<LichdomAbility>
implements AfflictionAbility {
    private final int requiredLevel;
    private final int cooldown;
    @NotNull
    private final AfflictionTypes affliction;
    public static final /* enum */ LichdomAbility SUMMON_UNDEAD = new SUMMON_UNDEAD("SUMMON_UNDEAD", 0);
    public static final /* enum */ LichdomAbility SOUL_FORM = new SOUL_FORM("SOUL_FORM", 1);
    public static final /* enum */ LichdomAbility CORPSE_EXPLOSION = new CORPSE_EXPLOSION("CORPSE_EXPLOSION", 2);
    public static final /* enum */ LichdomAbility LIFE_DRAIN = new LIFE_DRAIN("LIFE_DRAIN", 3);
    public static final /* enum */ LichdomAbility DEATH_TELEPORT = new DEATH_TELEPORT("DEATH_TELEPORT", 4);
    private static final /* synthetic */ LichdomAbility[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private LichdomAbility(int requiredLevel, int cooldown, AfflictionTypes affliction) {
        this.requiredLevel = requiredLevel;
        this.cooldown = cooldown;
        this.affliction = affliction;
    }

    /* synthetic */ LichdomAbility(String string, int n, int n2, int n3, AfflictionTypes afflictionTypes, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            afflictionTypes = AfflictionTypes.LICHDOM;
        }
        this(n2, n3, afflictionTypes);
    }

    @Override
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    @NotNull
    public AfflictionTypes getAffliction() {
        return this.affliction;
    }

    public static LichdomAbility[] values() {
        return (LichdomAbility[])$VALUES.clone();
    }

    public static LichdomAbility valueOf(String value) {
        return Enum.valueOf(LichdomAbility.class, value);
    }

    @NotNull
    public static EnumEntries<LichdomAbility> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = lichdomAbilityArray = new LichdomAbility[]{LichdomAbility.SUMMON_UNDEAD, LichdomAbility.SOUL_FORM, LichdomAbility.CORPSE_EXPLOSION, LichdomAbility.LIFE_DRAIN, LichdomAbility.DEATH_TELEPORT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"dev/sterner/witchery/features/affliction/lich/LichdomAbility.CORPSE_EXPLOSION", "Ldev/sterner/witchery/features/affliction/lich/LichdomAbility;", "id", "", "getId", "()Ljava/lang/String;", "requiresTarget", "", "getRequiresTarget", "()Z", "use", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class CORPSE_EXPLOSION
    extends LichdomAbility {
        @NotNull
        private final String id;
        private final boolean requiresTarget;

        /*
         * WARNING - void declaration
         */
        CORPSE_EXPLOSION() {
            void var1_1;
            this.id = "corpse_explosion";
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean getRequiresTarget() {
            return this.requiresTarget;
        }

        @Override
        public boolean use(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            int lichLevel = AfflictionPlayerAttachment.getData(player).getLichLevel();
            float explosionPower = 2.0f + (float)lichLevel * 0.5f;
            double range = 20.0 + (double)lichLevel * 2.0;
            List summonedUndead = player.level().getEntitiesOfClass(LivingEntity.class, ((ServerPlayer)player).getBoundingBox().inflate(range), arg_0 -> CORPSE_EXPLOSION.use$lambda$1(arg_0 -> CORPSE_EXPLOSION.use$lambda$0(player, arg_0), arg_0));
            if (summonedUndead.isEmpty()) {
                return false;
            }
            for (LivingEntity undead : summonedUndead) {
                undead.level().explode((Entity)player, undead.getX(), undead.getY() + 0.5, undead.getZ(), explosionPower, Level.ExplosionInteraction.MOB);
                undead.hurt(undead.damageSources().magic(), Float.MAX_VALUE);
            }
            player.level().playSound(null, ((ServerPlayer)player).getX(), ((ServerPlayer)player).getY(), ((ServerPlayer)player).getZ(), SoundEvents.CREEPER_PRIMED, SoundSource.PLAYERS, 1.0f, 0.5f);
            AbilityCooldownManager.INSTANCE.startCooldown(player, this);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean use$lambda$0(Player $player, LivingEntity entity) {
            if (!entity.getType().is(WitcheryTags.INSTANCE.getNECROMANCER_SUMMONABLE())) return false;
            Intrinsics.checkNotNull((Object)entity);
            if (!Intrinsics.areEqual((Object)EtherealEntityAttachment.getData(entity).getOwnerUUID(), (Object)((ServerPlayer)$player).getUUID())) return false;
            return true;
        }

        private static final boolean use$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"dev/sterner/witchery/features/affliction/lich/LichdomAbility.DEATH_TELEPORT", "Ldev/sterner/witchery/features/affliction/lich/LichdomAbility;", "id", "", "getId", "()Ljava/lang/String;", "use", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class DEATH_TELEPORT
    extends LichdomAbility {
        @NotNull
        private final String id;

        /*
         * WARNING - void declaration
         */
        DEATH_TELEPORT() {
            void var1_1;
            this.id = "death_teleport";
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean use(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            MiscPlayerAttachment.Data miscData = MiscPlayerAttachment.getData(player);
            if (miscData.getHasDeathTeleport()) {
                ((ServerPlayer)player).displayClientMessage((Component)Component.translatable((String)"witchery.ability.death_teleport.already_used").withStyle(ChatFormatting.RED), true);
                return false;
            }
            GlobalPos globalPos = ((ServerPlayer)player).getLastDeathLocation().orElse(null);
            if (globalPos == null) {
                return false;
            }
            GlobalPos lastDeathPos = globalPos;
            if (Intrinsics.areEqual((Object)lastDeathPos.dimension(), (Object)player.level().dimension())) {
                ((ServerPlayer)player).teleportTo((double)lastDeathPos.pos().getX() + 0.5, (double)lastDeathPos.pos().getY(), (double)lastDeathPos.pos().getZ() + 0.5);
                player.level().playSound(null, ((ServerPlayer)player).getX(), ((ServerPlayer)player).getY(), ((ServerPlayer)player).getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 0.5f);
                MiscPlayerAttachment.Data updatedData = MiscPlayerAttachment.Data.copy$default(miscData, false, true, 1, null);
                MiscPlayerAttachment.setData(player, updatedData);
                AbilityCooldownManager.INSTANCE.startCooldown(player, this);
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"dev/sterner/witchery/features/affliction/lich/LichdomAbility.LIFE_DRAIN", "Ldev/sterner/witchery/features/affliction/lich/LichdomAbility;", "id", "", "getId", "()Ljava/lang/String;", "requiresTarget", "", "getRequiresTarget", "()Z", "use", "player", "Lnet/minecraft/world/entity/player/Player;", "target", "Lnet/minecraft/world/entity/Entity;", "witchery"})
    static final class LIFE_DRAIN
    extends LichdomAbility {
        @NotNull
        private final String id;
        private final boolean requiresTarget;

        /*
         * WARNING - void declaration
         */
        LIFE_DRAIN() {
            void var1_1;
            this.id = "life_drain";
            this.requiresTarget = true;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean getRequiresTarget() {
            return this.requiresTarget;
        }

        @Override
        public boolean use(@NotNull Player player, @NotNull Entity target) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (!(player instanceof ServerPlayer) || !(target instanceof LivingEntity)) {
                return false;
            }
            int lichLevel = AfflictionPlayerAttachment.getData(player).getLichLevel();
            float drainAmount = 2.0f + (float)lichLevel * 0.5f;
            ((LivingEntity)target).hurt(player.damageSources().magic(), drainAmount);
            player.heal(drainAmount * 0.5f);
            if (!((LivingEntity)target).isAlive()) {
                LivingEntity livingEntity = (LivingEntity)target;
                int soulValue = livingEntity instanceof Villager ? 10 : (livingEntity instanceof Player ? 25 : (livingEntity instanceof Animal ? 1 : 2));
                LichdomSoulPoolHandler.increaseSouls$default(LichdomSoulPoolHandler.INSTANCE, (ServerPlayer)player, soulValue, null, 4, null);
            }
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, ((LivingEntity)target).getX(), ((LivingEntity)target).getY() + (double)(((LivingEntity)target).getBbHeight() / (float)2), ((LivingEntity)target).getZ(), 10, 0.3, 0.3, 0.3, 0.1);
            AbilityCooldownManager.INSTANCE.startCooldown(player, this);
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000/\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"dev/sterner/witchery/features/affliction/lich/LichdomAbility.SOUL_FORM", "Ldev/sterner/witchery/features/affliction/lich/LichdomAbility;", "id", "", "getId", "()Ljava/lang/String;", "requiresTarget", "", "getRequiresTarget", "()Z", "isAvailable", "player", "Lnet/minecraft/world/entity/player/Player;", "level", "", "use", "target", "Lnet/minecraft/world/entity/Entity;", "witchery"})
    static final class SOUL_FORM
    extends LichdomAbility {
        @NotNull
        private final String id;
        private final boolean requiresTarget;

        /*
         * WARNING - void declaration
         */
        SOUL_FORM() {
            void var1_1;
            this.id = "soul_form";
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean getRequiresTarget() {
            return this.requiresTarget;
        }

        @Override
        public boolean isAvailable(@NotNull Player player, int level) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            AfflictionPlayerAttachment.Data afflictionData = AfflictionPlayerAttachment.getData(player);
            if (afflictionData.isSoulForm() || afflictionData.isVagrant()) {
                return true;
            }
            return super.isAvailable(player, level);
        }

        @Override
        public boolean use(@NotNull Player player) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            AfflictionPlayerAttachment.Data afflictionData = AfflictionPlayerAttachment.getData(player);
            PossessionComponentAttachment.PossessionComponent possessionComponent = PossessionComponentAttachment.INSTANCE.get(player);
            PossessionComponentAttachment.PossessionData possessionData = PossessionComponentAttachment.INSTANCE.getPossessionData(player);
            boolean isPossessing = possessionData.isPossessing();
            Mob host = possessionComponent.getHost();
            if (isPossessing && host != null) {
                LichdomSpecificEventHandler.INSTANCE.exitPossessionToSoulForm((ServerPlayer)player);
                bl = true;
            } else if (afflictionData.isSoulForm() || afflictionData.isVagrant()) {
                bl = false;
            } else {
                LichdomSpecificEventHandler.INSTANCE.activateSoulForm((ServerPlayer)player);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean use(@NotNull Player player, @NotNull Entity target) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            AfflictionPlayerAttachment.Data afflictionData = AfflictionPlayerAttachment.getData(player);
            PossessionComponentAttachment.PossessionData possessionData = PossessionComponentAttachment.INSTANCE.getPossessionData(player);
            if (possessionData.isPossessing()) {
                return false;
            }
            if (!afflictionData.isSoulForm()) {
                return false;
            }
            Entity entity = target;
            if (entity instanceof SoulShellPlayerEntity) {
                if (afflictionData.isVagrant()) {
                    return false;
                }
                if (Intrinsics.areEqual(((SoulShellPlayerEntity)target).getOriginalUUID().orElse(null), (Object)((ServerPlayer)player).getUUID())) {
                    LichdomSpecificEventHandler.INSTANCE.returnToShell((ServerPlayer)player, (SoulShellPlayerEntity)target);
                    AbilityCooldownManager.INSTANCE.startCooldown(player, this);
                    bl = true;
                } else {
                    bl = false;
                }
            } else if (entity instanceof Mob) {
                boolean result = LichdomSpecificEventHandler.INSTANCE.attemptPossession((ServerPlayer)player, (Mob)target);
                if (result) {
                    AbilityCooldownManager.INSTANCE.startCooldown(player, this);
                }
                bl = result;
            } else {
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"dev/sterner/witchery/features/affliction/lich/LichdomAbility.SUMMON_UNDEAD", "Ldev/sterner/witchery/features/affliction/lich/LichdomAbility;", "id", "", "getId", "()Ljava/lang/String;", "use", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class SUMMON_UNDEAD
    extends LichdomAbility {
        @NotNull
        private final String id;

        /*
         * WARNING - void declaration
         */
        SUMMON_UNDEAD() {
            void var1_1;
            this.id = "summon_undead";
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean use(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            int lichLevel = AfflictionPlayerAttachment.getData(player).getLichLevel();
            int radius = 5 + lichLevel;
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = player.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            NecroHandler.INSTANCE.summonNecroAroundPos(serverLevel, player, blockPos, radius);
            AbilityCooldownManager.INSTANCE.startCooldown(player, this);
            return true;
        }
    }
}

