/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.bark_belt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncBarkS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/bark_belt/BarkBeltPlayerAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/bark_belt/BarkBeltPlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "sync", "Data", "witchery"})
public final class BarkBeltPlayerAttachment {
    @NotNull
    public static final BarkBeltPlayerAttachment INSTANCE = new BarkBeltPlayerAttachment();

    private BarkBeltPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getBARK_PLAYER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getBARK_PLAYER_DATA_ATTACHMENT(), (Object)data2);
        INSTANCE.sync(player, data2);
    }

    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncBarkS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/features/bark_belt/BarkBeltPlayerAttachment$Data;", "", "currentBark", "", "maxBark", "rechargeRate", "tickCounter", "<init>", "(IIII)V", "getCurrentBark", "()I", "getMaxBark", "getRechargeRate", "getTickCounter", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int currentBark;
        private final int maxBark;
        private final int rechargeRate;
        private final int tickCounter;
        @NotNull
        private static final ResourceLocation ID;
        @NotNull
        private static final Codec<Data> CODEC;

        public Data(int currentBark, int maxBark, int rechargeRate, int tickCounter) {
            this.currentBark = currentBark;
            this.maxBark = maxBark;
            this.rechargeRate = rechargeRate;
            this.tickCounter = tickCounter;
        }

        public /* synthetic */ Data(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 1;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            this(n, n2, n3, n4);
        }

        public final int getCurrentBark() {
            return this.currentBark;
        }

        public final int getMaxBark() {
            return this.maxBark;
        }

        public final int getRechargeRate() {
            return this.rechargeRate;
        }

        public final int getTickCounter() {
            return this.tickCounter;
        }

        public final int component1() {
            return this.currentBark;
        }

        public final int component2() {
            return this.maxBark;
        }

        public final int component3() {
            return this.rechargeRate;
        }

        public final int component4() {
            return this.tickCounter;
        }

        @NotNull
        public final Data copy(int currentBark, int maxBark, int rechargeRate, int tickCounter) {
            return new Data(currentBark, maxBark, rechargeRate, tickCounter);
        }

        public static /* synthetic */ Data copy$default(Data data2, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = data2.currentBark;
            }
            if ((n5 & 2) != 0) {
                n2 = data2.maxBark;
            }
            if ((n5 & 4) != 0) {
                n3 = data2.rechargeRate;
            }
            if ((n5 & 8) != 0) {
                n4 = data2.tickCounter;
            }
            return data2.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Data(currentBark=" + this.currentBark + ", maxBark=" + this.maxBark + ", rechargeRate=" + this.rechargeRate + ", tickCounter=" + this.tickCounter + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.currentBark);
            result = result * 31 + Integer.hashCode(this.maxBark);
            result = result * 31 + Integer.hashCode(this.rechargeRate);
            result = result * 31 + Integer.hashCode(this.tickCounter);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (this.currentBark != data2.currentBark) {
                return false;
            }
            if (this.maxBark != data2.maxBark) {
                return false;
            }
            if (this.rechargeRate != data2.rechargeRate) {
                return false;
            }
            return this.tickCounter == data2.tickCounter;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.fieldOf("currentBark").forGetter(Data::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("maxBark").forGetter(Data::CODEC$lambda$0$1), (App)Codec.INT.fieldOf("rechargeRate").forGetter(Data::CODEC$lambda$0$2), (App)Codec.INT.fieldOf("tickCounter").forGetter(Data::CODEC$lambda$0$3)).apply((Applicative)instance, Data::new);
        }

        private static final Integer CODEC$lambda$0$0(Data it) {
            return it.currentBark;
        }

        private static final Integer CODEC$lambda$0$1(Data it) {
            return it.maxBark;
        }

        private static final Integer CODEC$lambda$0$2(Data it) {
            return it.rechargeRate;
        }

        private static final Integer CODEC$lambda$0$3(Data it) {
            return it.tickCounter;
        }

        public Data() {
            this(0, 0, 0, 0, 15, null);
        }

        static {
            ResourceLocation resourceLocation = Witchery.Companion.id("player_bark_belt");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/bark_belt/BarkBeltPlayerAttachment$Data$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/bark_belt/BarkBeltPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

