/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.blood;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncBloodS2CPayload;
import dev.sterner.witchery.network.SyncOtherBloodS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/blood/BloodPoolLivingEntityAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/blood/BloodPoolLivingEntityAttachment$Data;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "setData", "", "data", "sync", "Data", "witchery"})
public final class BloodPoolLivingEntityAttachment {
    @NotNull
    public static final BloodPoolLivingEntityAttachment INSTANCE = new BloodPoolLivingEntityAttachment();

    private BloodPoolLivingEntityAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Object object = livingEntity.getData(WitcheryDataAttachments.getBLOOD_LIVING_ENTITY_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull LivingEntity livingEntity, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        livingEntity.setData(WitcheryDataAttachments.getBLOOD_LIVING_ENTITY_DATA_ATTACHMENT(), (Object)data2);
        INSTANCE.sync(livingEntity, data2);
    }

    public final void sync(@NotNull LivingEntity livingEntity, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (livingEntity.level() instanceof ServerLevel) {
            if (livingEntity instanceof Player) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)livingEntity), (CustomPacketPayload)new SyncBloodS2CPayload((Player)livingEntity, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)livingEntity), (CustomPacketPayload)new SyncOtherBloodS2CPayload(livingEntity, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/features/blood/BloodPoolLivingEntityAttachment$Data;", "", "maxBlood", "", "bloodPool", "<init>", "(II)V", "getMaxBlood", "()I", "getBloodPool", "copy", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int maxBlood;
        private final int bloodPool;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(int maxBlood, int bloodPool) {
            this.maxBlood = maxBlood;
            this.bloodPool = bloodPool;
        }

        public /* synthetic */ Data(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public final int getMaxBlood() {
            return this.maxBlood;
        }

        public final int getBloodPool() {
            return this.bloodPool;
        }

        @NotNull
        public final Data copy(int maxBlood, int bloodPool) {
            return new Data(maxBlood, bloodPool);
        }

        public static /* synthetic */ Data copy$default(Data data2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = data2.maxBlood;
            }
            if ((n3 & 2) != 0) {
                n2 = data2.bloodPool;
            }
            return data2.copy(n, n2);
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.fieldOf("maxBlood").forGetter(Data::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("bloodPool").forGetter(Data::CODEC$lambda$0$1)).apply((Applicative)instance, Data::new);
        }

        private static final Integer CODEC$lambda$0$0(Data it) {
            return it.maxBlood;
        }

        private static final Integer CODEC$lambda$0$1(Data it) {
            return it.bloodPool;
        }

        public Data() {
            this(0, 0, 3, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("blood_pool_entity_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/blood/BloodPoolLivingEntityAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/blood/BloodPoolLivingEntityAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

