/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.chain;

import dev.sterner.witchery.content.entity.ChainEntity;
import dev.sterner.witchery.core.api.interfaces.EntityChainInterface;
import dev.sterner.witchery.core.api.schedule.ServerTickTask;
import dev.sterner.witchery.core.api.schedule.TickTaskScheduler;
import dev.sterner.witchery.features.chain.ChainType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J:\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013JV\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0019\u001a\u00020\u00112\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u00112\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013JV\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0019\u001a\u00020\u00112\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u00112\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J2\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0019\u001a\u00020\u00112\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010 \u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002JD\u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013JL\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010&\u001a\u00020\u00112\b\b\u0002\u0010'\u001a\u00020\u00112\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000bJ\u0016\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u000bJ\u000e\u0010-\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000b\u00a8\u0006."}, d2={"Ldev/sterner/witchery/features/chain/ChainManager;", "", "<init>", "()V", "createChain", "Ldev/sterner/witchery/content/entity/ChainEntity;", "level", "Lnet/minecraft/world/level/Level;", "position", "Lnet/minecraft/world/phys/Vec3;", "targetEntity", "Lnet/minecraft/world/entity/Entity;", "extensionSpeed", "", "retractionSpeed", "pullStrength", "lifetime", "", "chainType", "Ldev/sterner/witchery/features/chain/ChainType;", "createRandomizedChain", "noPull", "", "createMultipleChains", "", "numChains", "radius", "", "sequentialDelay", "createAerialChains", "height", "findChainPositions", "hasLineOfSight", "pos", "createHookAndPullChain", "sourcePos", "pullDelay", "createChainCage", "numChainsHorizontal", "numChainsVertical", "releaseEntity", "", "target", "tryReleaseEntity", "chainEntity", "retractAllChains", "witchery"})
@SourceDebugExtension(value={"SMAP\nChainManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChainManager.kt\ndev/sterner/witchery/features/chain/ChainManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,377:1\n1563#2:378\n1634#2,3:379\n1869#2,2:382\n1869#2,2:384\n1869#2,2:386\n1869#2,2:388\n*S KotlinDebug\n*F\n+ 1 ChainManager.kt\ndev/sterner/witchery/features/chain/ChainManager\n*L\n114#1:378\n114#1:379,3\n120#1:382,2\n346#1:384,2\n356#1:386,2\n372#1:388,2\n*E\n"})
public final class ChainManager {
    @NotNull
    public static final ChainManager INSTANCE = new ChainManager();

    private ChainManager() {
    }

    @NotNull
    public final ChainEntity createChain(@NotNull Level level, @NotNull Vec3 position, @NotNull Entity targetEntity, float extensionSpeed, float retractionSpeed, float pullStrength, int lifetime, @NotNull ChainType chainType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        Intrinsics.checkNotNullParameter((Object)((Object)chainType), (String)"chainType");
        ChainEntity chain = new ChainEntity(level);
        chain.getEntityData().set(ChainEntity.Companion.getTYPE(), (Object)chainType.getIndex());
        chain.setPos(position.x, position.y, position.z);
        chain.setTargetEntity(targetEntity);
        chain.setExtensionSpeed(extensionSpeed);
        chain.setRetractionSpeed(retractionSpeed);
        chain.setPullStrength(pullStrength);
        if (lifetime > 0) {
            chain.setLife(lifetime);
        }
        level.addFreshEntity((Entity)chain);
        return chain;
    }

    public static /* synthetic */ ChainEntity createChain$default(ChainManager chainManager, Level level, Vec3 vec3, Entity entity, float f, float f2, float f3, int n, ChainType chainType, int n2, Object object) {
        if ((n2 & 8) != 0) {
            f = 0.15f;
        }
        if ((n2 & 0x10) != 0) {
            f2 = 0.05f;
        }
        if ((n2 & 0x20) != 0) {
            f3 = 0.15f;
        }
        if ((n2 & 0x40) != 0) {
            n = -1;
        }
        return chainManager.createChain(level, vec3, entity, f, f2, f3, n, chainType);
    }

    @NotNull
    public final ChainEntity createRandomizedChain(@NotNull Level level, @NotNull Vec3 position, @NotNull Entity targetEntity, int lifetime, boolean noPull, @NotNull ChainType chainType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        Intrinsics.checkNotNullParameter((Object)((Object)chainType), (String)"chainType");
        RandomSource random = level.random;
        float extensionSpeed = 0.04f + random.nextFloat() * 0.03f;
        float retractionSpeed = 0.02f + random.nextFloat() * 0.02f;
        float pullStrength = noPull ? 0.0f : 0.12f + random.nextFloat() * 0.08f;
        return this.createChain(level, position, targetEntity, extensionSpeed, retractionSpeed, pullStrength, lifetime, chainType);
    }

    public static /* synthetic */ ChainEntity createRandomizedChain$default(ChainManager chainManager, Level level, Vec3 vec3, Entity entity, int n, boolean bl, ChainType chainType, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        return chainManager.createRandomizedChain(level, vec3, entity, n, bl, chainType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ChainEntity> createMultipleChains(@NotNull Level level, @NotNull Entity targetEntity, int numChains, double radius, int sequentialDelay, int lifetime, boolean noPull, @NotNull ChainType chainType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        Intrinsics.checkNotNullParameter((Object)((Object)chainType), (String)"chainType");
        List<Vec3> chainPositions = this.findChainPositions(level, targetEntity, numChains, radius);
        List chains = new ArrayList();
        if (sequentialDelay <= 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = chainPositions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void pos;
                Vec3 vec3 = (Vec3)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ChainManager.createRandomizedChain$default(INSTANCE, level, (Vec3)pos, targetEntity, lifetime, false, chainType, 16, null));
            }
            return (List)destination$iv$iv;
        }
        int delay = 0;
        Iterable $this$forEach$iv = chainPositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vec3 pos = (Vec3)element$iv;
            boolean bl = false;
            if (level instanceof ServerLevel) {
                TickTaskScheduler.INSTANCE.addTask(new ServerTickTask(delay, () -> ChainManager.createMultipleChains$lambda$1$0(level, pos, targetEntity, lifetime, noPull, chainType, chains)));
            }
            delay += sequentialDelay;
        }
        return chains;
    }

    public static /* synthetic */ List createMultipleChains$default(ChainManager chainManager, Level level, Entity entity, int n, double d, int n2, int n3, boolean bl, ChainType chainType, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n = 5;
        }
        if ((n4 & 8) != 0) {
            d = 8.0;
        }
        if ((n4 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x20) != 0) {
            n3 = -1;
        }
        if ((n4 & 0x40) != 0) {
            bl = false;
        }
        return chainManager.createMultipleChains(level, entity, n, d, n2, n3, bl, chainType);
    }

    @NotNull
    public final List<ChainEntity> createAerialChains(@NotNull Level level, @NotNull Entity targetEntity, int numChains, double radius, double height, int sequentialDelay, int lifetime, @NotNull ChainType chainType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        Intrinsics.checkNotNullParameter((Object)((Object)chainType), (String)"chainType");
        Vec3 targetPos = targetEntity.position();
        List chains = new ArrayList();
        for (int i = 0; i < numChains; ++i) {
            double angle = level.random.nextDouble() * Math.PI * (double)2;
            double distance = level.random.nextDouble() * radius;
            double x = targetPos.x + Math.sin(angle) * distance;
            double y = targetPos.y + height;
            double z = targetPos.z + Math.cos(angle) * distance;
            Vec3 chainPos = new Vec3(x, y, z);
            if (!(level instanceof ServerLevel)) continue;
            TickTaskScheduler.INSTANCE.addTask(new ServerTickTask(i * sequentialDelay, () -> ChainManager.createAerialChains$lambda$0(level, chainPos, targetEntity, lifetime, chainType, chains)));
        }
        return chains;
    }

    public static /* synthetic */ List createAerialChains$default(ChainManager chainManager, Level level, Entity entity, int n, double d, double d2, int n2, int n3, ChainType chainType, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n = 3;
        }
        if ((n4 & 8) != 0) {
            d = 3.0;
        }
        if ((n4 & 0x10) != 0) {
            d2 = 10.0;
        }
        if ((n4 & 0x20) != 0) {
            n2 = 5;
        }
        if ((n4 & 0x40) != 0) {
            n3 = -1;
        }
        return chainManager.createAerialChains(level, entity, n, d, d2, n2, n3, chainType);
    }

    private final List<Vec3> findChainPositions(Level level, Entity targetEntity, int numChains, double radius) {
        Vec3 targetPos = targetEntity.position();
        List result = new ArrayList();
        int maxAttempts = numChains * 6;
        for (int attempts = 0; result.size() < numChains && attempts < maxAttempts; ++attempts) {
            double angle = level.random.nextDouble() * Math.PI * (double)2;
            double distance = radius * 0.5 + level.random.nextDouble() * radius * 0.5;
            double x = targetPos.x + Math.sin(angle) * distance;
            double y = targetPos.y + (level.random.nextDouble() * (double)8 - (double)4);
            double z = targetPos.z + Math.cos(angle) * distance;
            Vec3 pos = new Vec3(x, y, z);
            BlockPos blockPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z);
            if (!level.getBlockState(blockPos).isAir() || !this.hasLineOfSight(level, pos, targetEntity)) continue;
            result.add(pos);
        }
        return result;
    }

    static /* synthetic */ List findChainPositions$default(ChainManager chainManager, Level level, Entity entity, int n, double d, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 5;
        }
        if ((n2 & 8) != 0) {
            d = 8.0;
        }
        return chainManager.findChainPositions(level, entity, n, d);
    }

    private final boolean hasLineOfSight(Level level, Vec3 pos, Entity targetEntity) {
        Vec3 targetPos = targetEntity.position().add(0.0, (double)targetEntity.getBbHeight() / 2.0, 0.0);
        ClipContext context = new ClipContext(pos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        BlockHitResult result = level.clip(context);
        Vec3 hitPos = result.getLocation();
        return hitPos.distanceTo(targetPos) < 0.5;
    }

    @NotNull
    public final ChainEntity createHookAndPullChain(@NotNull Level level, @NotNull Vec3 sourcePos, @NotNull Entity targetEntity, float pullStrength, float extensionSpeed, int pullDelay, @NotNull ChainType chainType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)sourcePos, (String)"sourcePos");
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        Intrinsics.checkNotNullParameter((Object)((Object)chainType), (String)"chainType");
        ChainEntity chain = ChainManager.createChain$default(this, level, sourcePos, targetEntity, extensionSpeed, 0.02f, pullStrength, 0, chainType, 64, null);
        if (level instanceof ServerLevel) {
            TickTaskScheduler.INSTANCE.addTask(new ServerTickTask(pullDelay, () -> ChainManager.createHookAndPullChain$lambda$0(chain)));
        }
        return chain;
    }

    public static /* synthetic */ ChainEntity createHookAndPullChain$default(ChainManager chainManager, Level level, Vec3 vec3, Entity entity, float f, float f2, int n, ChainType chainType, int n2, Object object) {
        if ((n2 & 8) != 0) {
            f = 0.2f;
        }
        if ((n2 & 0x10) != 0) {
            f2 = 0.1f;
        }
        if ((n2 & 0x20) != 0) {
            n = 10;
        }
        return chainManager.createHookAndPullChain(level, vec3, entity, f, f2, n, chainType);
    }

    @NotNull
    public final List<ChainEntity> createChainCage(@NotNull Level level, @NotNull Entity targetEntity, int numChainsHorizontal, int numChainsVertical, double radius, int lifetime, @NotNull ChainType chainType) {
        Vec3 pos;
        double z;
        double y;
        double x;
        double angle;
        int i;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        Intrinsics.checkNotNullParameter((Object)((Object)chainType), (String)"chainType");
        List chains = new ArrayList();
        Vec3 targetPos = targetEntity.position();
        for (i = 0; i < numChainsHorizontal; ++i) {
            angle = (double)i / (double)numChainsHorizontal * Math.PI * (double)2;
            x = targetPos.x + Math.sin(angle) * radius;
            y = targetPos.y + 0.5;
            z = targetPos.z + Math.cos(angle) * radius;
            pos = new Vec3(x, y, z);
            chains.add(this.createChain(level, pos, targetEntity, 0.15f, 0.01f, 0.0f, lifetime, chainType));
        }
        for (i = 0; i < numChainsVertical; ++i) {
            angle = (double)i / (double)numChainsVertical * Math.PI;
            x = targetPos.x + Math.sin(angle) * radius;
            y = targetPos.y + Math.cos(angle) * radius;
            z = targetPos.z;
            pos = new Vec3(x, y, z);
            chains.add(this.createChain(level, pos, targetEntity, 0.15f, 0.01f, 0.0f, lifetime, chainType));
            double x2 = targetPos.x;
            double y2 = targetPos.y + Math.cos(angle) * radius;
            double z2 = targetPos.z + Math.sin(angle) * radius;
            Vec3 pos2 = new Vec3(x2, y2, z2);
            chains.add(this.createChain(level, pos2, targetEntity, 0.15f, 0.01f, 0.0f, lifetime, chainType));
        }
        return chains;
    }

    public static /* synthetic */ List createChainCage$default(ChainManager chainManager, Level level, Entity entity, int n, int n2, double d, int n3, ChainType chainType, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n = 8;
        }
        if ((n4 & 8) != 0) {
            n2 = 6;
        }
        if ((n4 & 0x10) != 0) {
            d = 3.0;
        }
        if ((n4 & 0x20) != 0) {
            n3 = -1;
        }
        return chainManager.createChainCage(level, entity, n, n2, d, n3, chainType);
    }

    public final void releaseEntity(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof EntityChainInterface) {
            List<ChainEntity> chains = ((EntityChainInterface)target).witchery$getRestrainingChains();
            Iterable $this$forEach$iv = chains;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChainEntity it = (ChainEntity)((Object)element$iv);
                boolean bl = false;
                it.discard();
            }
        }
    }

    public final void tryReleaseEntity(@NotNull ChainEntity chainEntity, @NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)((Object)chainEntity), (String)"chainEntity");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof EntityChainInterface) {
            List<ChainEntity> chains = ((EntityChainInterface)target).witchery$getRestrainingChains();
            Iterable $this$forEach$iv = chains;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChainEntity it = (ChainEntity)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Object)it), (Object)((Object)chainEntity))) continue;
                it.discard();
            }
        }
    }

    public final void retractAllChains(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof EntityChainInterface) {
            List<ChainEntity> chains = ((EntityChainInterface)target).witchery$getRestrainingChains();
            Iterable $this$forEach$iv = chains;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChainEntity it = (ChainEntity)((Object)element$iv);
                boolean bl = false;
                it.startRetracting();
            }
        }
    }

    private static final void createMultipleChains$lambda$1$0(Level $level, Vec3 $pos, Entity $targetEntity, int $lifetime, boolean $noPull, ChainType $chainType, List $chains) {
        ChainEntity chain = INSTANCE.createRandomizedChain($level, $pos, $targetEntity, $lifetime, $noPull, $chainType);
        $chains.add(chain);
    }

    private static final void createAerialChains$lambda$0(Level $level, Vec3 $chainPos, Entity $targetEntity, int $lifetime, ChainType $chainType, List $chains) {
        ChainEntity chain = ChainManager.createRandomizedChain$default(INSTANCE, $level, $chainPos, $targetEntity, $lifetime, false, $chainType, 16, null);
        chain.setExtensionSpeed(0.08f + $level.random.nextFloat() * 0.04f);
        $chains.add(chain);
    }

    private static final void createHookAndPullChain$lambda$0(ChainEntity $chain) {
        $chain.startRetracting();
    }
}

