/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.death;

import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.death.DeathPlayerAttachment;
import dev.sterner.witchery.features.death.DeathTransformationHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/death/DeathEquipmentEventHandler;", "", "<init>", "()V", "onEquipmentChange", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingEquipmentChangeEvent;", "onPlayerTick", "Lnet/neoforged/neoforge/event/tick/PlayerTickEvent$Post;", "checkAndUpdateDeathStatus", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
public final class DeathEquipmentEventHandler {
    @NotNull
    public static final DeathEquipmentEventHandler INSTANCE = new DeathEquipmentEventHandler();

    private DeathEquipmentEventHandler() {
    }

    public final void onEquipmentChange(@NotNull LivingEquipmentChangeEvent event) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            LivingEntity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            if (((Player)entity).level().isClientSide) {
                return;
            }
            EquipmentSlot slot = event.getSlot();
            if (!slot.isArmor() && !Intrinsics.areEqual((Object)slot.name(), (Object)"mainhand")) break block3;
            MinecraftServer minecraftServer = ((Player)entity).level().getServer();
            if (minecraftServer != null) {
                minecraftServer.execute(() -> DeathEquipmentEventHandler.onEquipmentChange$lambda$0(entity));
            }
        }
    }

    public final void onPlayerTick(@NotNull PlayerTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (player.tickCount % 20 != 0) {
            return;
        }
    }

    private final void checkAndUpdateDeathStatus(Player player) {
        boolean isCurrentlyDeath = DeathTransformationHelper.INSTANCE.isPlayerFullyDeath(player);
        boolean wasDeath = DeathTransformationHelper.INSTANCE.isDeath(player);
        DeathTransformationHelper.INSTANCE.updateDeathStatus(player);
        if (isCurrentlyDeath && !wasDeath) {
            Integer n = AfflictionAbilityHandler.INSTANCE.getAbilityIndex();
            int n2 = -1;
            if (n == null || n != n2) {
                AfflictionAbilityHandler.INSTANCE.setAbilityIndex(player, -1);
                player.getInventory().selected = 0;
            }
        } else if (!isCurrentlyDeath && wasDeath) {
            DeathPlayerAttachment.Data data2 = DeathPlayerAttachment.getData(player);
            DeathPlayerAttachment.setData(player, DeathPlayerAttachment.Data.copy$default(data2, false, false, false, 1, null));
        }
    }

    private static final void onEquipmentChange$lambda$0(LivingEntity $entity) {
        INSTANCE.checkAndUpdateDeathStatus((Player)$entity);
    }
}

