/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.death;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.features.death.DeathPlayerAttachment;
import dev.sterner.witchery.network.SyncDeathS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/death/DeathPlayerAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/death/DeathPlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "sync", "Data", "witchery"})
public final class DeathPlayerAttachment {
    @NotNull
    public static final DeathPlayerAttachment INSTANCE = new DeathPlayerAttachment();

    private DeathPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getDEATH_PLAYER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getDEATH_PLAYER_DATA_ATTACHMENT(), (Object)data2);
        INSTANCE.sync(player, data2);
    }

    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncDeathS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/features/death/DeathPlayerAttachment$Data;", "", "isDeath", "", "hasDeathNightVision", "hasDeathFluidWalking", "<init>", "(ZZZ)V", "()Z", "setDeath", "(Z)V", "getHasDeathNightVision", "setHasDeathNightVision", "getHasDeathFluidWalking", "setHasDeathFluidWalking", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean isDeath;
        private boolean hasDeathNightVision;
        private boolean hasDeathFluidWalking;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(boolean isDeath, boolean hasDeathNightVision, boolean hasDeathFluidWalking) {
            this.isDeath = isDeath;
            this.hasDeathNightVision = hasDeathNightVision;
            this.hasDeathFluidWalking = hasDeathFluidWalking;
        }

        public /* synthetic */ Data(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            this(bl, bl2, bl3);
        }

        public final boolean isDeath() {
            return this.isDeath;
        }

        public final void setDeath(boolean bl) {
            this.isDeath = bl;
        }

        public final boolean getHasDeathNightVision() {
            return this.hasDeathNightVision;
        }

        public final void setHasDeathNightVision(boolean bl) {
            this.hasDeathNightVision = bl;
        }

        public final boolean getHasDeathFluidWalking() {
            return this.hasDeathFluidWalking;
        }

        public final void setHasDeathFluidWalking(boolean bl) {
            this.hasDeathFluidWalking = bl;
        }

        public final boolean component1() {
            return this.isDeath;
        }

        public final boolean component2() {
            return this.hasDeathNightVision;
        }

        public final boolean component3() {
            return this.hasDeathFluidWalking;
        }

        @NotNull
        public final Data copy(boolean isDeath, boolean hasDeathNightVision, boolean hasDeathFluidWalking) {
            return new Data(isDeath, hasDeathNightVision, hasDeathFluidWalking);
        }

        public static /* synthetic */ Data copy$default(Data data2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = data2.isDeath;
            }
            if ((n & 2) != 0) {
                bl2 = data2.hasDeathNightVision;
            }
            if ((n & 4) != 0) {
                bl3 = data2.hasDeathFluidWalking;
            }
            return data2.copy(bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "Data(isDeath=" + this.isDeath + ", hasDeathNightVision=" + this.hasDeathNightVision + ", hasDeathFluidWalking=" + this.hasDeathFluidWalking + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isDeath);
            result = result * 31 + Boolean.hashCode(this.hasDeathNightVision);
            result = result * 31 + Boolean.hashCode(this.hasDeathFluidWalking);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (this.isDeath != data2.isDeath) {
                return false;
            }
            if (this.hasDeathNightVision != data2.hasDeathNightVision) {
                return false;
            }
            return this.hasDeathFluidWalking == data2.hasDeathFluidWalking;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.BOOL.fieldOf("isDeath").forGetter(Data::CODEC$lambda$0$0), (App)Codec.BOOL.fieldOf("hasDeathNightVision").forGetter(Data::CODEC$lambda$0$1), (App)Codec.BOOL.fieldOf("hasDeathFluidWalking").forGetter(Data::CODEC$lambda$0$2)).apply((Applicative)instance, Data::new);
        }

        private static final Boolean CODEC$lambda$0$0(Data it) {
            return it.isDeath;
        }

        private static final Boolean CODEC$lambda$0$1(Data it) {
            return it.hasDeathNightVision;
        }

        private static final Boolean CODEC$lambda$0$2(Data it) {
            return it.hasDeathFluidWalking;
        }

        private static final void STREAM_CODEC$lambda$0(RegistryFriendlyByteBuf buf, Boolean value) {
            Intrinsics.checkNotNull((Object)value);
            buf.writeBoolean(value.booleanValue());
        }

        private static final Boolean STREAM_CODEC$lambda$1(RegistryFriendlyByteBuf it) {
            return it.readBoolean();
        }

        private static final Boolean STREAM_CODEC$lambda$2(KMutableProperty1 $tmp0, Data p0) {
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final void STREAM_CODEC$lambda$3(RegistryFriendlyByteBuf buf, Boolean value) {
            Intrinsics.checkNotNull((Object)value);
            buf.writeBoolean(value.booleanValue());
        }

        private static final Boolean STREAM_CODEC$lambda$4(RegistryFriendlyByteBuf it) {
            return it.readBoolean();
        }

        private static final Boolean STREAM_CODEC$lambda$5(KMutableProperty1 $tmp0, Data p0) {
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final void STREAM_CODEC$lambda$6(RegistryFriendlyByteBuf buf, Boolean value) {
            Intrinsics.checkNotNull((Object)value);
            buf.writeBoolean(value.booleanValue());
        }

        private static final Boolean STREAM_CODEC$lambda$7(RegistryFriendlyByteBuf it) {
            return it.readBoolean();
        }

        private static final Boolean STREAM_CODEC$lambda$8(KMutableProperty1 $tmp0, Data p0) {
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        public Data() {
            this(false, false, false, 7, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)StreamCodec.of(Data::STREAM_CODEC$lambda$0, Data::STREAM_CODEC$lambda$1), arg_0 -> Data.STREAM_CODEC$lambda$2((KMutableProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), (StreamCodec)StreamCodec.of(Data::STREAM_CODEC$lambda$3, Data::STREAM_CODEC$lambda$4), arg_0 -> Data.STREAM_CODEC$lambda$5((KMutableProperty1)Companion.STREAM_CODEC.6.INSTANCE, arg_0), (StreamCodec)StreamCodec.of(Data::STREAM_CODEC$lambda$6, Data::STREAM_CODEC$lambda$7), arg_0 -> Data.STREAM_CODEC$lambda$8((KMutableProperty1)Companion.STREAM_CODEC.9.INSTANCE, arg_0), Data::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            STREAM_CODEC = streamCodec;
            ResourceLocation resourceLocation = Witchery.Companion.id("death_player_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/features/death/DeathPlayerAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/death/DeathPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, Data> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

