/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.death;

import dev.sterner.witchery.content.entity.DeathEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.death.DeathPlayerAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/features/death/DeathTransformationHelper;", "", "<init>", "()V", "death", "Ldev/sterner/witchery/content/entity/DeathEntity;", "getDeathEntity", "player", "Lnet/minecraft/world/entity/player/Player;", "isPlayerFullyDeath", "", "isDeath", "updateDeathStatus", "", "findDeathPlayer", "level", "Lnet/minecraft/world/level/Level;", "hasDeathHood", "hasDeathRobe", "hasDeathBoots", "witchery"})
public final class DeathTransformationHelper {
    @NotNull
    public static final DeathTransformationHelper INSTANCE = new DeathTransformationHelper();
    @Nullable
    private static DeathEntity death;

    private DeathTransformationHelper() {
    }

    @Nullable
    public final DeathEntity getDeathEntity(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (death == null) {
            death = (DeathEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getDEATH().get()).create(player.level());
        }
        return death;
    }

    public final boolean isPlayerFullyDeath(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chestplate = player.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack boots = player.getItemBySlot(EquipmentSlot.FEET);
        boolean hasHelmet = helmet.is((Item)WitcheryItems.INSTANCE.getDEATH_HOOD().get());
        boolean hasChestplate = chestplate.is((Item)WitcheryItems.INSTANCE.getDEATH_ROBE().get());
        boolean hasBoots = boots.is((Item)WitcheryItems.INSTANCE.getDEATH_BOOTS().get());
        return hasHelmet && hasChestplate && hasBoots;
    }

    public final boolean isDeath(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return DeathPlayerAttachment.getData(player).isDeath();
    }

    public final void updateDeathStatus(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean shouldBeDeath = this.isPlayerFullyDeath(player);
        DeathPlayerAttachment.Data currentData = DeathPlayerAttachment.getData(player);
        if (currentData.isDeath() != shouldBeDeath) {
            DeathPlayerAttachment.setData(player, DeathPlayerAttachment.Data.copy$default(currentData, shouldBeDeath, false, false, 6, null));
        }
        if (!shouldBeDeath) {
            Integer n = AfflictionAbilityHandler.INSTANCE.getAbilityIndex();
            int n2 = -1;
            if (n == null || n != n2) {
                AfflictionAbilityHandler.INSTANCE.setAbilityIndex(player, -1);
                player.getInventory().selected = 0;
            }
        }
    }

    @Nullable
    public final Player findDeathPlayer(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        for (Player player : level.players()) {
            Intrinsics.checkNotNull((Object)player);
            DeathPlayerAttachment.Data data2 = DeathPlayerAttachment.getData(player);
            if (!data2.isDeath() || !this.isPlayerFullyDeath(player)) continue;
            return player;
        }
        return null;
    }

    public final boolean hasDeathHood(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.getItemBySlot(EquipmentSlot.HEAD).is((Item)WitcheryItems.INSTANCE.getDEATH_HOOD().get());
    }

    public final boolean hasDeathRobe(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.getItemBySlot(EquipmentSlot.CHEST).is((Item)WitcheryItems.INSTANCE.getDEATH_ROBE().get());
    }

    public final boolean hasDeathBoots(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.getItemBySlot(EquipmentSlot.FEET).is((Item)WitcheryItems.INSTANCE.getDEATH_BOOTS().get());
    }
}

