/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.lifeblood;

import dev.sterner.witchery.features.lifeblood.LifebloodPlayerAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/features/lifeblood/LifebloodHandler;", "", "<init>", "()V", "tick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "handleDamage", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "damage", "addLifeblood", "points", "", "witchery"})
public final class LifebloodHandler {
    @NotNull
    public static final LifebloodHandler INSTANCE = new LifebloodHandler();

    private LifebloodHandler() {
    }

    public final void tick(@NotNull Player player) {
        long currentTick;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.level().isClientSide) {
            return;
        }
        LifebloodPlayerAttachment.Data data2 = LifebloodPlayerAttachment.getData(player);
        if (data2.canRegenerate() && (currentTick = player.level().getGameTime()) - data2.getLastRegenTick() >= 100L) {
            LifebloodPlayerAttachment.Data newData = data2.copy(RangesKt.coerceAtMost((int)(data2.getLifebloodPoints() + 1), (int)data2.getMaxRegenPoints()), currentTick);
            LifebloodPlayerAttachment.setData(player, newData);
        }
    }

    public final float handleDamage(@NotNull Player player, @NotNull DamageSource source, float damage) {
        float f;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        LifebloodPlayerAttachment.Data data2 = LifebloodPlayerAttachment.getData(player);
        if (data2.getLifebloodPoints() <= 0) {
            return damage;
        }
        int damageInPoints = RangesKt.coerceAtLeast((int)((int)damage), (int)1);
        if (damageInPoints >= data2.getLifebloodPoints()) {
            float remainingDamage = damage - (float)data2.getLifebloodPoints();
            LifebloodPlayerAttachment.Data newData = data2.copy(0, 0L);
            LifebloodPlayerAttachment.setData(player, newData);
            f = remainingDamage;
        } else {
            LifebloodPlayerAttachment.Data newData = data2.copy(data2.getLifebloodPoints() - damageInPoints, player.level().getGameTime());
            LifebloodPlayerAttachment.setData(player, newData);
            f = 0.0f;
        }
        return f;
    }

    public final void addLifeblood(@NotNull Player player, int points) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LifebloodPlayerAttachment.Data data2 = LifebloodPlayerAttachment.getData(player);
        LifebloodPlayerAttachment.Data newData = LifebloodPlayerAttachment.Data.copy$default(data2.addPoints(points), 0, player.level().getGameTime(), 1, null);
        LifebloodPlayerAttachment.setData(player, newData);
    }
}

