/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.petrification;

import com.mojang.blaze3d.platform.NativeImage;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.mixin.client.HttpTextureAccessor;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0006\u0010\u0019\u001a\u00020\u000fJ\u0010\u0010\u001a\u001a\u00020\u000f2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0015H\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0005J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/sterner/witchery/features/petrification/PetrificationTextureManager;", "", "<init>", "()V", "STONE_TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "textureCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "dynamicTextures", "Lnet/minecraft/client/renderer/texture/DynamicTexture;", "currentEntity", "Lnet/minecraft/world/entity/LivingEntity;", "setCurrentEntity", "", "entity", "clearCurrentEntity", "getPetrifiedTexture", "originalTexture", "loadNativeImage", "Lcom/mojang/blaze3d/platform/NativeImage;", "resourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "location", "clearCache", "clearOldTextures", "maxAge", "", "loadPlayerSkinAsNativeImage", "skin", "Lnet/minecraft/client/renderer/texture/HttpTexture;", "copyNativeImage", "image", "extractNativeImageFromTextureManager", "textureManager", "Lnet/minecraft/client/renderer/texture/TextureManager;", "resLoc", "getTextureSize", "Ldev/sterner/witchery/features/petrification/PetrificationTextureManager$Size;", "generatePetrifiedTexture", "Size", "witchery"})
@SourceDebugExtension(value={"SMAP\nPetrificationTextureManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PetrificationTextureManager.kt\ndev/sterner/witchery/features/petrification/PetrificationTextureManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,212:1\n1#2:213\n1869#3,2:214\n1869#3,2:218\n216#4,2:216\n*S KotlinDebug\n*F\n+ 1 PetrificationTextureManager.kt\ndev/sterner/witchery/features/petrification/PetrificationTextureManager\n*L\n57#1:214,2\n76#1:218,2\n66#1:216,2\n*E\n"})
public final class PetrificationTextureManager {
    @NotNull
    public static final PetrificationTextureManager INSTANCE = new PetrificationTextureManager();
    private static final ResourceLocation STONE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/block/stone.png");
    @NotNull
    private static final ConcurrentHashMap<String, ResourceLocation> textureCache = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<ResourceLocation, DynamicTexture> dynamicTextures = new ConcurrentHashMap();
    @Nullable
    private static volatile LivingEntity currentEntity;

    private PetrificationTextureManager() {
    }

    public final void setCurrentEntity(@Nullable LivingEntity entity) {
        currentEntity = entity;
    }

    public final void clearCurrentEntity() {
        currentEntity = null;
    }

    @NotNull
    public final ResourceLocation getPetrifiedTexture(@NotNull ResourceLocation originalTexture) {
        Intrinsics.checkNotNullParameter((Object)originalTexture, (String)"originalTexture");
        int progressKey = 1;
        String cacheKey = originalTexture.getNamespace() + ":" + originalTexture.getPath() + "_petrified_" + progressKey;
        ResourceLocation resourceLocation = textureCache.get(cacheKey);
        if (resourceLocation != null) {
            ResourceLocation it = resourceLocation;
            boolean bl = false;
            return it;
        }
        ResourceLocation petrifiedTexture = this.generatePetrifiedTexture(originalTexture);
        ((Map)textureCache).put(cacheKey, petrifiedTexture);
        return petrifiedTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NativeImage loadNativeImage(ResourceManager resourceManager, ResourceLocation location) {
        NativeImage nativeImage;
        Resource resource = resourceManager.getResource(location).orElse(null);
        if (resource == null) {
            return null;
        }
        Resource resource2 = resource;
        Closeable closeable = resource2.open();
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            nativeImage = NativeImage.read((InputStream)inputStream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return nativeImage;
    }

    public final void clearCache() {
        Collection<DynamicTexture> collection = dynamicTextures.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DynamicTexture it = (DynamicTexture)element$iv;
            boolean bl = false;
            it.close();
        }
        dynamicTextures.clear();
        textureCache.clear();
    }

    public final void clearOldTextures(long maxAge) {
        Map.Entry element$iv;
        long currentTime = System.currentTimeMillis();
        List toRemove = new ArrayList();
        Object $this$forEach$iv = dynamicTextures;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation location = (ResourceLocation)entry.getKey();
            String string = location.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Long l = StringsKt.toLongOrNull((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)string, (String)"dynamic/petrified/", null, (int)2, null), (String)"_", null, (int)2, null));
            long timestamp = l != null ? l : 0L;
            if (currentTime - timestamp <= maxAge) continue;
            toRemove.add(location);
        }
        $this$forEach$iv = toRemove;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            ResourceLocation location = (ResourceLocation)element$iv;
            boolean bl = false;
            DynamicTexture dynamicTexture = dynamicTextures.remove(location);
            if (dynamicTexture != null) {
                dynamicTexture.close();
            }
            textureCache.entrySet().removeIf(arg_0 -> PetrificationTextureManager.clearOldTextures$lambda$1$1(arg_0 -> PetrificationTextureManager.clearOldTextures$lambda$1$0(location, arg_0), arg_0));
        }
    }

    public static /* synthetic */ void clearOldTextures$default(PetrificationTextureManager petrificationTextureManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 300000L;
        }
        petrificationTextureManager.clearOldTextures(l);
    }

    @Nullable
    public final NativeImage loadPlayerSkinAsNativeImage(@NotNull HttpTexture skin) {
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        try {
            File cacheFile = ((HttpTextureAccessor)skin).getFile();
            NativeImage nativeImage = cacheFile != null && cacheFile.isFile() ? NativeImage.read((InputStream)new FileInputStream(cacheFile)) : null;
            return nativeImage;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final NativeImage copyNativeImage(NativeImage image) {
        NativeImage copy = new NativeImage(image.format(), image.getWidth(), image.getHeight(), false);
        copy.copyFrom(image);
        return copy;
    }

    private final NativeImage extractNativeImageFromTextureManager(TextureManager textureManager, ResourceLocation resLoc) {
        NativeImage nativeImage;
        AbstractTexture tex = textureManager.getTexture(resLoc);
        AbstractTexture abstractTexture = tex;
        if (abstractTexture instanceof DynamicTexture) {
            NativeImage nativeImage2 = ((DynamicTexture)tex).getPixels();
            if (nativeImage2 != null) {
                NativeImage it = nativeImage2;
                boolean bl = false;
                nativeImage = INSTANCE.copyNativeImage(it);
            } else {
                nativeImage = null;
            }
        } else {
            nativeImage = abstractTexture instanceof HttpTexture ? this.loadPlayerSkinAsNativeImage((HttpTexture)tex) : null;
        }
        return nativeImage;
    }

    @NotNull
    public final Size getTextureSize(@NotNull ResourceLocation originalTexture) {
        NativeImage originalImage;
        Intrinsics.checkNotNullParameter((Object)originalTexture, (String)"originalTexture");
        Minecraft minecraft = Minecraft.getInstance();
        ResourceManager resourceManager = minecraft.getResourceManager();
        Intrinsics.checkNotNull((Object)resourceManager);
        NativeImage nativeImage = originalImage = this.loadNativeImage(resourceManager, originalTexture);
        Intrinsics.checkNotNull((Object)nativeImage);
        return new Size(nativeImage.getWidth(), originalImage.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResourceLocation generatePetrifiedTexture(ResourceLocation originalTexture) {
        Minecraft minecraft = Minecraft.getInstance();
        TextureManager textureManager = minecraft.getTextureManager();
        ResourceManager resourceManager = minecraft.getResourceManager();
        NativeImage originalImage = null;
        Intrinsics.checkNotNull((Object)resourceManager);
        originalImage = this.loadNativeImage(resourceManager, originalTexture);
        if (originalImage == null) {
            Intrinsics.checkNotNull((Object)textureManager);
            originalImage = this.extractNativeImageFromTextureManager(textureManager, originalTexture);
        }
        if (originalImage == null) {
            return originalTexture;
        }
        ResourceLocation resourceLocation = STONE_TEXTURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"STONE_TEXTURE");
        NativeImage nativeImage = this.loadNativeImage(resourceManager, resourceLocation);
        if (nativeImage == null) {
            PetrificationTextureManager $this$generatePetrifiedTexture_u24lambda_u240 = this;
            boolean bl = false;
            originalImage.close();
            return originalTexture;
        }
        NativeImage stoneImage = nativeImage;
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        NativeImage resultImage = new NativeImage(width, height, true);
        try {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int originalPixel = originalImage.getPixelRGBA(x, y);
                    int alpha = originalPixel >> 24 & 0xFF;
                    if (alpha == 0) {
                        resultImage.setPixelRGBA(x, y, 0);
                        continue;
                    }
                    int red = originalPixel >> 16 & 0xFF;
                    int green = originalPixel >> 8 & 0xFF;
                    int blue = originalPixel & 0xFF;
                    int gray = (int)(0.299f * (float)red + 0.587f * (float)green + 0.114f * (float)blue);
                    int stoneX = x % stoneImage.getWidth();
                    int stoneY = y % stoneImage.getHeight();
                    int stonePixel = stoneImage.getPixelRGBA(stoneX, stoneY);
                    int stoneRed = stonePixel >> 16 & 0xFF;
                    int stoneGreen = stonePixel >> 8 & 0xFF;
                    int stoneBlue = stonePixel & 0xFF;
                    float blendFactor = 0.5f;
                    float grayProgress = 1.0f - blendFactor;
                    float stoneProgress = blendFactor;
                    int finalRed = RangesKt.coerceIn((int)((int)(((float)gray * grayProgress + (float)stoneRed * stoneProgress) / (grayProgress + stoneProgress))), (int)0, (int)255);
                    int finalGreen = RangesKt.coerceIn((int)((int)(((float)gray * grayProgress + (float)stoneGreen * stoneProgress) / (grayProgress + stoneProgress))), (int)0, (int)255);
                    int finalBlue = RangesKt.coerceIn((int)((int)(((float)gray * grayProgress + (float)stoneBlue * stoneProgress) / (grayProgress + stoneProgress))), (int)0, (int)255);
                    float darkenFactor = 0.85f;
                    int finalR = RangesKt.coerceIn((int)((int)((float)finalRed * darkenFactor)), (int)0, (int)255);
                    int finalG = RangesKt.coerceIn((int)((int)((float)finalGreen * darkenFactor)), (int)0, (int)255);
                    int finalB = RangesKt.coerceIn((int)((int)((float)finalBlue * darkenFactor)), (int)0, (int)255);
                    int finalPixel = alpha << 24 | finalR << 16 | finalG << 8 | finalB;
                    resultImage.setPixelRGBA(x, y, finalPixel);
                }
            }
            DynamicTexture dynamicTexture = new DynamicTexture(resultImage);
            ResourceLocation textureLocation = Witchery.Companion.id("dynamic/petrified/" + System.currentTimeMillis() + "_" + originalTexture.getPath().hashCode());
            textureManager.register(textureLocation, (AbstractTexture)dynamicTexture);
            ((Map)dynamicTextures).put(textureLocation, dynamicTexture);
            Intrinsics.checkNotNull((Object)textureLocation);
            ResourceLocation resourceLocation2 = textureLocation;
            return resourceLocation2;
        }
        finally {
            originalImage.close();
            stoneImage.close();
        }
    }

    private static final boolean clearOldTextures$lambda$1$0(ResourceLocation $location, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual(it.getValue(), (Object)$location);
    }

    private static final boolean clearOldTextures$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/features/petrification/PetrificationTextureManager$Size;", "", "width", "", "height", "<init>", "(II)V", "getWidth", "()I", "setWidth", "(I)V", "getHeight", "setHeight", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "witchery"})
    public static final class Size {
        private int width;
        private int height;

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final Size copy(int width, int height) {
            return new Size(width, height);
        }

        public static /* synthetic */ Size copy$default(Size size, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = size.width;
            }
            if ((n3 & 2) != 0) {
                n2 = size.height;
            }
            return size.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Size(width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Size)) {
                return false;
            }
            Size size = (Size)other;
            if (this.width != size.width) {
                return false;
            }
            return this.height == size.height;
        }
    }
}

