/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.poppet;

import dev.sterner.witchery.content.item.PoppetItem;
import dev.sterner.witchery.core.api.PoppetUsage;
import dev.sterner.witchery.core.api.interfaces.PoppetType;
import dev.sterner.witchery.core.registry.WitcheryItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/features/poppet/ArmorProtectionPoppet;", "Ldev/sterner/witchery/core/api/interfaces/PoppetType;", "<init>", "()V", "item", "Lnet/minecraft/world/item/Item;", "getItem", "()Lnet/minecraft/world/item/Item;", "isValidFor", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "getDurabilityDamage", "", "usage", "Ldev/sterner/witchery/core/api/PoppetUsage;", "onActivate", "owner", "onCorruptedActivate", "witchery"})
public final class ArmorProtectionPoppet
implements PoppetType {
    @NotNull
    private final Item item;

    public ArmorProtectionPoppet() {
        Object object = WitcheryItems.INSTANCE.getARMOR_PROTECTION_POPPET().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.item = (Item)object;
    }

    @Override
    @NotNull
    public Item getItem() {
        return this.item;
    }

    @Override
    public boolean isValidFor(@NotNull LivingEntity entity, @Nullable DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return true;
    }

    @Override
    public int getDurabilityDamage(@NotNull PoppetUsage usage) {
        Intrinsics.checkNotNullParameter((Object)((Object)usage), (String)"usage");
        return 1;
    }

    @Override
    public boolean onActivate(@NotNull LivingEntity owner, @Nullable DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        owner.level().playSound(null, owner.getX(), owner.getY(), owner.getZ(), SoundEvents.ARMOR_STAND_HIT, SoundSource.PLAYERS, 0.7f, 1.2f);
        return true;
    }

    @Override
    public boolean onCorruptedActivate(@NotNull LivingEntity owner, @Nullable DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!(owner instanceof Player)) {
            return this.onActivate(owner, source);
        }
        List equipment = new ArrayList();
        for (EquipmentSlot slot : EntriesMappings.entries$0) {
            ItemStack item = ((Player)owner).getItemBySlot(slot);
            if (item.isEmpty() || item.getMaxDamage() <= 0 || item.getItem() instanceof PoppetItem) continue;
            Intrinsics.checkNotNull((Object)item);
            equipment.add(item);
        }
        if (equipment.isEmpty()) {
            return this.onActivate(owner, source);
        }
        ItemStack itemToDamage = (ItemStack)CollectionsKt.random((Collection)equipment, (Random)((Random)Random.Default));
        itemToDamage.hurtAndBreak(owner.level().random.nextInt(3) + 1, owner, null);
        owner.level().playSound(null, ((Player)owner).getX(), ((Player)owner).getY(), ((Player)owner).getZ(), SoundEvents.ARMOR_EQUIP_IRON, SoundSource.PLAYERS, 0.7f, 0.8f);
        Object[] objectArray = new Object[]{Component.translatable((String)itemToDamage.getDescriptionId())};
        ((Player)owner).displayClientMessage((Component)Component.translatable((String)"curse.witchery.corrupt_poppet.armor_effect", (Object[])objectArray).withStyle(ChatFormatting.DARK_PURPLE), true);
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }
}

