/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.poppet;

import dev.sterner.witchery.content.item.PoppetItem;
import dev.sterner.witchery.core.api.PoppetUsage;
import dev.sterner.witchery.core.api.interfaces.PoppetType;
import dev.sterner.witchery.core.registry.WitcheryItems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u001c\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/features/poppet/DeathProtectionPoppet;", "Ldev/sterner/witchery/core/api/interfaces/PoppetType;", "<init>", "()V", "item", "Ldev/sterner/witchery/content/item/PoppetItem;", "kotlin.jvm.PlatformType", "getItem", "()Ldev/sterner/witchery/content/item/PoppetItem;", "isValidFor", "", "owner", "Lnet/minecraft/world/entity/LivingEntity;", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "getDurabilityDamage", "", "usage", "Ldev/sterner/witchery/core/api/PoppetUsage;", "onActivate", "onCorruptedActivate", "witchery"})
public final class DeathProtectionPoppet
implements PoppetType {
    private final PoppetItem item = (PoppetItem)((Object)WitcheryItems.INSTANCE.getDEATH_PROTECTION_POPPET().get());

    @Override
    public PoppetItem getItem() {
        return this.item;
    }

    @Override
    public boolean isValidFor(@NotNull LivingEntity owner, @Nullable DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return source == null || !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY);
    }

    @Override
    public int getDurabilityDamage(@NotNull PoppetUsage usage) {
        Intrinsics.checkNotNullParameter((Object)((Object)usage), (String)"usage");
        return WhenMappings.$EnumSwitchMapping$0[usage.ordinal()] == 1 ? 1 : 0;
    }

    @Override
    public boolean onActivate(@NotNull LivingEntity owner, @Nullable DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (owner instanceof Player) {
            ((Player)owner).setHealth(4.0f);
            owner.removeAllEffects();
            owner.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            owner.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            owner.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            owner.playSound(SoundEvents.TOTEM_USE);
            return true;
        }
        return false;
    }

    @Override
    public boolean onCorruptedActivate(@NotNull LivingEntity owner, @Nullable DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (owner instanceof Player) {
            ((Player)owner).setHealth(1.0f);
            owner.removeAllEffects();
            owner.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 1200, 1));
            owner.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 1000, 1));
            owner.addEffect(new MobEffectInstance(MobEffects.UNLUCK, 2400, 0));
            owner.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0));
            ((Player)owner).playSound(SoundEvents.TOTEM_USE, 0.8f, 0.5f);
            ((Player)owner).displayClientMessage((Component)Component.translatable((String)"curse.witchery.corrupt_poppet.death_effect").withStyle(ChatFormatting.DARK_PURPLE), true);
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PoppetUsage.values().length];
            try {
                nArray[PoppetUsage.PROTECTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

