/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.ritual;

import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.core.api.Ritual;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.features.misc.BindingRitualAttachment;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/ritual/BindingRitual;", "Ldev/sterner/witchery/core/api/Ritual;", "<init>", "()V", "onStartRitual", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "goldenChalkBlockEntity", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "Companion", "witchery"})
public final class BindingRitual
extends Ritual {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int BINDING_DURATION = 2400;
    public static final int WEAK_BINDING_DURATION = 1200;
    private static final double BINDING_RADIUS = 20.0;

    public BindingRitual() {
        super("binding");
    }

    @Override
    public boolean onStartRitual(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        LivingEntity target;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        if (level.isClientSide) {
            return true;
        }
        if (goldenChalkBlockEntity.getTargetPlayer() != null) {
            ServerPlayer serverPlayer;
            MinecraftServer minecraftServer = level.getServer();
            if (minecraftServer != null && (minecraftServer = minecraftServer.getPlayerList()) != null) {
                UUID uUID = goldenChalkBlockEntity.getTargetPlayer();
                Intrinsics.checkNotNull((Object)uUID);
                serverPlayer = minecraftServer.getPlayer(uUID);
            } else {
                serverPlayer = null;
            }
            v3 = (LivingEntity)serverPlayer;
        } else if (goldenChalkBlockEntity.getTargetEntity() != null) {
            Integer n = goldenChalkBlockEntity.getTargetEntity();
            Intrinsics.checkNotNull((Object)n);
            Entity entity = level.getEntity(n.intValue());
            v3 = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        } else {
            v3 = target = null;
        }
        if (target == null) {
            return false;
        }
        GlobalPos globalPos = goldenChalkBlockEntity.getTargetPos();
        if (globalPos == null) {
            return false;
        }
        GlobalPos waystonePos = globalPos;
        int dur = 2400;
        if (target instanceof Player && !WitcheryApi.INSTANCE.isWitchy((Player)target)) {
            dur = 1200;
        }
        BlockPos blockPos2 = waystonePos.pos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"pos(...)");
        BindingRitualAttachment.Data bindingData = new BindingRitualAttachment.Data(blockPos2, 20.0, dur, true);
        BindingRitualAttachment.INSTANCE.setData(target, bindingData);
        if (level instanceof ServerLevel) {
            ((ServerLevel)level).playSound(null, waystonePos.pos(), SoundEvents.CHAIN_PLACE, SoundSource.BLOCKS, 1.0f, 0.5f);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, (double)waystonePos.pos().getX() + 0.5, (double)waystonePos.pos().getY() + 1.0, (double)waystonePos.pos().getZ() + 0.5, 50, 2.0, 1.0, 2.0, 0.1);
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/features/ritual/BindingRitual$Companion;", "", "<init>", "()V", "BINDING_DURATION", "", "WEAK_BINDING_DURATION", "BINDING_RADIUS", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

