/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.ritual;

import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.content.recipe.ritual.RitualRecipe;
import dev.sterner.witchery.core.api.Ritual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/features/ritual/BlocksBelowRitual;", "Ldev/sterner/witchery/core/api/Ritual;", "targetOre", "Lnet/minecraft/world/level/block/Block;", "targetDeepslateOre", "<init>", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/level/block/Block;)V", "()V", "columnsToProcess", "", "Lkotlin/Pair;", "", "collectedItems", "Lnet/minecraft/world/item/ItemStack;", "tickCounter", "onStartRitual", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "goldenChalkBlockEntity", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "onTickRitual", "", "pos", "onEndRitual", "saveState", "tag", "Lnet/minecraft/nbt/CompoundTag;", "loadState", "witchery"})
@SourceDebugExtension(value={"SMAP\nBlocksBelowRitual.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlocksBelowRitual.kt\ndev/sterner/witchery/features/ritual/BlocksBelowRitual\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1869#2,2:175\n1869#2,2:177\n*S KotlinDebug\n*F\n+ 1 BlocksBelowRitual.kt\ndev/sterner/witchery/features/ritual/BlocksBelowRitual\n*L\n125#1:175,2\n134#1:177,2\n*E\n"})
public final class BlocksBelowRitual
extends Ritual {
    @NotNull
    private Block targetOre;
    @NotNull
    private Block targetDeepslateOre;
    @NotNull
    private final List<Pair<Integer, Integer>> columnsToProcess;
    @NotNull
    private final List<ItemStack> collectedItems;
    private int tickCounter;

    public BlocksBelowRitual(@NotNull Block targetOre, @NotNull Block targetDeepslateOre) {
        Intrinsics.checkNotNullParameter((Object)targetOre, (String)"targetOre");
        Intrinsics.checkNotNullParameter((Object)targetDeepslateOre, (String)"targetDeepslateOre");
        super("blocks_below");
        this.targetOre = targetOre;
        this.targetDeepslateOre = targetDeepslateOre;
        this.columnsToProcess = new ArrayList();
        this.collectedItems = new ArrayList();
    }

    public /* synthetic */ BlocksBelowRitual(Block block, Block block2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Block block3 = Blocks.IRON_ORE;
            Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"IRON_ORE");
            block = block3;
        }
        if ((n & 2) != 0) {
            Block block4 = Blocks.DEEPSLATE_IRON_ORE;
            Intrinsics.checkNotNullExpressionValue((Object)block4, (String)"DEEPSLATE_IRON_ORE");
            block2 = block4;
        }
        this(block, block2);
    }

    public BlocksBelowRitual() {
        Block block = Blocks.IRON_ORE;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"IRON_ORE");
        Block block2 = Blocks.DEEPSLATE_IRON_ORE;
        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"DEEPSLATE_IRON_ORE");
        this(block, block2);
    }

    @Override
    public boolean onStartRitual(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        super.onStartRitual(level, blockPos, goldenChalkBlockEntity);
        RitualRecipe ritualRecipe = goldenChalkBlockEntity.getRitualRecipe();
        if (ritualRecipe != null) {
            RitualRecipe recipe = ritualRecipe;
            boolean bl = false;
            CompoundTag ritualData = recipe.getRitualData();
            if (ritualData.contains("targetOre")) {
                Object object = BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)ritualData.getString("targetOre")));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                this.targetOre = (Block)object;
            }
            if (ritualData.contains("targetDeepslateOre")) {
                Object object = BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)ritualData.getString("targetDeepslateOre")));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                this.targetDeepslateOre = (Block)object;
            }
        }
        int radius = 9;
        int dx = -radius;
        if (dx <= radius) {
            while (true) {
                int dz;
                if ((dz = -radius) <= radius) {
                    while (true) {
                        if (dx * dx + dz * dz <= radius * radius) {
                            this.columnsToProcess.add((Pair<Integer, Integer>)TuplesKt.to((Object)(blockPos.getX() + dx), (Object)(blockPos.getZ() + dz)));
                        }
                        if (dz == radius) break;
                        ++dz;
                    }
                }
                if (dx == radius) break;
                ++dx;
            }
        }
        return true;
    }

    @Override
    public void onTickRitual(@NotNull Level level, @NotNull BlockPos pos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        super.onTickRitual(level, pos, goldenChalkBlockEntity);
        if (this.columnsToProcess.isEmpty() && this.collectedItems.isEmpty()) {
            return;
        }
        List columnsThisTick = CollectionsKt.take((Iterable)this.columnsToProcess, (int)3);
        block0: for (Object object : columnsThisTick) {
            int x = ((Number)object.component1()).intValue();
            int z = ((Number)object.component2()).intValue();
            this.columnsToProcess.remove(new Pair((Object)x, (Object)z));
            IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)level.getMinBuildHeight(), (int)pos.getY())));
            int y = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if ((n2 <= 0 || y > n) && (n2 >= 0 || n > y)) continue;
            while (true) {
                BlockPos blockPos;
                Block block;
                Block block2;
                if (Intrinsics.areEqual((Object)(block2 = (block = level.getBlockState(blockPos = new BlockPos(x, y, z)).getBlock())), (Object)this.targetOre)) {
                    ItemStack itemStack = this.targetOre.asItem().getDefaultInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
                    this.collectedItems.add(itemStack);
                    level.setBlockAndUpdate(blockPos, Blocks.STONE.defaultBlockState());
                } else if (Intrinsics.areEqual((Object)block2, (Object)this.targetDeepslateOre)) {
                    ItemStack itemStack = this.targetDeepslateOre.asItem().getDefaultInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
                    this.collectedItems.add(itemStack);
                    level.setBlockAndUpdate(blockPos, Blocks.DEEPSLATE.defaultBlockState());
                }
                if (y == n) continue block0;
                y += n2;
            }
        }
        int n = this.tickCounter;
        this.tickCounter = n + 1;
        if (this.tickCounter >= 5) {
            this.tickCounter = 0;
            if (!((Collection)this.collectedItems).isEmpty()) {
                List toSpawn = CollectionsKt.take((Iterable)this.collectedItems, (int)20);
                this.collectedItems.removeAll(CollectionsKt.toSet((Iterable)toSpawn));
                for (ItemStack stack : toSpawn) {
                    ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, stack);
                    level.addFreshEntity((Entity)entity);
                }
            }
        }
    }

    @Override
    public void onEndRitual(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        if (!((Collection)this.collectedItems).isEmpty()) {
            for (ItemStack stack : this.collectedItems) {
                ItemEntity entity = new ItemEntity(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 0.5, stack);
                level.addFreshEntity((Entity)entity);
            }
            this.collectedItems.clear();
        }
        super.onEndRitual(level, blockPos, goldenChalkBlockEntity);
    }

    @Override
    public void saveState(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity, @NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        ListTag columnsTag = new ListTag();
        Iterable $this$forEach$iv = this.columnsToProcess;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int x = ((Number)pair.component1()).intValue();
            int z = ((Number)pair.component2()).intValue();
            CompoundTag columnTag = new CompoundTag();
            columnTag.putInt("x", x);
            columnTag.putInt("z", z);
            columnsTag.add((Object)columnTag);
        }
        tag.put("columnsToProcess", (Tag)columnsTag);
        ListTag itemsTag = new ListTag();
        Iterable $this$forEach$iv2 = this.collectedItems;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            ItemStack stack = (ItemStack)element$iv;
            boolean bl = false;
            itemsTag.add((Object)stack.save((HolderLookup.Provider)level.registryAccess(), (Tag)new CompoundTag()));
        }
        tag.put("collectedItems", (Tag)itemsTag);
        tag.putInt("tickCounter", this.tickCounter);
        tag.putString("targetOre", BuiltInRegistries.BLOCK.getKey((Object)this.targetOre).toString());
        tag.putString("targetDeepslateOre", BuiltInRegistries.BLOCK.getKey((Object)this.targetDeepslateOre).toString());
    }

    @Override
    public void loadState(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity, @NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.columnsToProcess.clear();
        ListTag columnsTag = tag.getList("columnsToProcess", 10);
        int n = columnsTag.size();
        for (int i = 0; i < n; ++i) {
            CompoundTag columnTag = columnsTag.getCompound(i);
            this.columnsToProcess.add((Pair<Integer, Integer>)TuplesKt.to((Object)columnTag.getInt("x"), (Object)columnTag.getInt("z")));
        }
        this.collectedItems.clear();
        ListTag itemsTag = tag.getList("collectedItems", 10);
        int n2 = itemsTag.size();
        for (int i = 0; i < n2; ++i) {
            CompoundTag itemTag = itemsTag.getCompound(i);
            ItemStack.parse((HolderLookup.Provider)((HolderLookup.Provider)level.registryAccess()), (Tag)((Tag)itemTag)).ifPresent(arg_0 -> BlocksBelowRitual.loadState$lambda$1(arg_0 -> BlocksBelowRitual.loadState$lambda$0(this, arg_0), arg_0));
        }
        this.tickCounter = tag.getInt("tickCounter");
        if (tag.contains("targetOre")) {
            Object object = BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("targetOre")));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.targetOre = (Block)object;
        }
        if (tag.contains("targetDeepslateOre")) {
            Object object = BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("targetDeepslateOre")));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.targetDeepslateOre = (Block)object;
        }
    }

    private static final Unit loadState$lambda$0(BlocksBelowRitual this$0, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.collectedItems.add(it);
        return Unit.INSTANCE;
    }

    private static final void loadState$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

