/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.sterner.witchery.MobAccessor;
import dev.sterner.witchery.content.entity.goal.DisorientationGoal;
import dev.sterner.witchery.core.data.BloodPoolReloadListener;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import java.util.Map;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity
implements MobAccessor {
    @Shadow
    @Final
    protected GoalSelector goalSelector;
    @Unique
    private int disorientCooldown = 0;
    @Unique
    private int disorientTime = 0;

    protected MobMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")})
    private void witchery$finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        EntityType entityType;
        BloodPoolReloadListener.BloodData bloodValue;
        Mob mob = (Mob)Mob.class.cast(this);
        BloodPoolLivingEntityAttachment.Data data2 = BloodPoolLivingEntityAttachment.getData((LivingEntity)mob);
        Map<EntityType<?>, BloodPoolReloadListener.BloodData> bloodJson = BloodPoolReloadListener.INSTANCE.getBLOOD_PAIR();
        if (data2.getMaxBlood() == 0 && data2.getBloodPool() == 0 && (bloodValue = bloodJson.get(entityType = mob.getType())) != null) {
            int maxBlood = bloodValue.getBloodDrops() * 300;
            BloodPoolLivingEntityAttachment.setData((LivingEntity)mob, new BloodPoolLivingEntityAttachment.Data(maxBlood, maxBlood));
        }
    }

    @ModifyReturnValue(method={"createMobAttributes"}, at={@At(value="RETURN")})
    private static AttributeSupplier.Builder witchery$addAttack(AttributeSupplier.Builder original) {
        return original.add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    @ModifyReturnValue(method={"isSunBurnTick"}, at={@At(value="RETURN")})
    private boolean witchery$modifySunBurnTick(boolean original) {
        Mob self = (Mob)this;
        if (EtherealEntityAttachment.getData((LivingEntity)self).isEthereal()) {
            return false;
        }
        return original;
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    public void witchery$registerDisorientationGoal(CallbackInfo ci) {
        this.goalSelector.addGoal(0, (Goal)new DisorientationGoal((Mob)this));
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void witchery$defineEntityDataAccessor(CallbackInfo ci) {
        MobAccessor.Data.DISORIENTED = SynchedEntityData.defineId(Mob.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    public void witchery$defineDisData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(MobAccessor.Data.DISORIENTED, (Object)false);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void witchery$tickDisorientation(CallbackInfo ci) {
        if (((Boolean)this.entityData.get(MobAccessor.Data.DISORIENTED)).booleanValue()) {
            ++this.disorientTime;
            if (this.disorientTime >= 400) {
                this.entityData.set(MobAccessor.Data.DISORIENTED, (Object)false);
                this.disorientCooldown = 400;
                this.disorientTime = 0;
            }
        } else if (this.disorientCooldown > 0) {
            --this.disorientCooldown;
        }
    }

    @Override
    public boolean witchery$canBeDisoriented() {
        return this.disorientCooldown <= 0 && (Boolean)this.entityData.get(MobAccessor.Data.DISORIENTED) == false;
    }

    @Override
    public void witchery$setDisorientedActive(boolean active) {
        if (this.witchery$canBeDisoriented()) {
            this.entityData.set(MobAccessor.Data.DISORIENTED, (Object)active);
            this.disorientTime = 0;
        }
    }
}

