/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.sterner.witchery.core.api.event.SleepingEvent;
import dev.sterner.witchery.features.death.DeathPlayerAttachment;
import dev.sterner.witchery.features.death.DeathTransformationHelper;
import dev.sterner.witchery.features.misc.InventoryLockPlayerAttachment;
import dev.sterner.witchery.mixin_logic.PlayerMixinLogic;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Shadow
    private int sleepCounter;

    @Inject(method={"stopSleepInBed"}, at={@At(value="TAIL")})
    private void witchery$stopSleepInBed(boolean wakeImmediately, boolean updateLevelForSleepingPlayers, CallbackInfo ci) {
        Player player = (Player)Player.class.cast(this);
        NeoForge.EVENT_BUS.post((Event)new SleepingEvent.Stop(player, this.sleepCounter, wakeImmediately));
    }

    @ModifyReturnValue(method={"wantsToStopRiding"}, at={@At(value="RETURN")})
    private boolean witchery$neoStopDismount(boolean original) {
        Player player = (Player)Player.class.cast(this);
        return PlayerMixinLogic.INSTANCE.wantsStopRiding(original, player);
    }

    @Inject(method={"canUseGameMasterBlocks"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventBlockPlacementFromLockedSlot(CallbackInfoReturnable<Boolean> cir) {
        Player self = (Player)this;
        if (InventoryLockPlayerAttachment.INSTANCE.isSlotLocked(self, self.getInventory().selected)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void witchery$deathNightVision(CallbackInfo ci) {
        DeathPlayerAttachment.Data data2;
        Player player = (Player)this;
        if (!player.level().isClientSide && DeathTransformationHelper.INSTANCE.hasDeathHood(player) && (data2 = DeathPlayerAttachment.getData(player)).getHasDeathNightVision()) {
            boolean isDark;
            boolean bl = isDark = player.level().dimensionType().ambientLight() == 0.0f || player.level().getBrightness(LightLayer.BLOCK, player.blockPosition()) < 8;
            if (!(!isDark && player.level().isDay() || player.hasEffect(MobEffects.NIGHT_VISION))) {
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, false, false, false));
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void witchery$deathHoodConfusion(CallbackInfo ci) {
        Level level;
        Player player = (Player)this;
        if (!player.level().isClientSide && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (DeathTransformationHelper.INSTANCE.hasDeathHood(player) && player.tickCount % 20 == 0) {
                List nearbyPlayers = player.level().getEntitiesOfClass(Player.class, player.getBoundingBox().inflate(8.0), p -> p != player && p.hasLineOfSight((Entity)player));
                for (Player target : nearbyPlayers) {
                    target.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0, false, false, true));
                    target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 0, false, false, true));
                }
            }
        }
    }
}

