/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.client;

import dev.sterner.witchery.core.api.Curse;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.registry.WitcheryCurseRegistry;
import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.features.curse.CurseHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={LocalPlayer.class})
public class LocalPlayerMixin {
    @Shadow
    public Input input;
    @Unique
    private long witchery$lastInputDisruptTime = 0L;
    @Unique
    private static final long witchery$INPUT_DISRUPT_COOLDOWN = 40L;

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void witchery$disableMovementInput(CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        if (player.hasEffect(WitcheryMobEffects.INSTANCE.getBEAR_TRAP_INCAPACITATED())) {
            player.input.up = false;
            player.input.down = false;
            player.input.left = false;
            player.input.right = false;
            player.input.jumping = false;
            player.input.shiftKeyDown = false;
            player.input.leftImpulse = 0.0f;
            player.input.forwardImpulse = 0.0f;
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void witchery$onAiStep(CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        Level level = player.level();
        if (!CurseHandler.INSTANCE.hasCurse((Player)player, (Curse)WitcheryCurseRegistry.INSTANCE.getBEFUDDLEMENT().get())) {
            return;
        }
        long currentTime = level.getGameTime();
        if (currentTime - this.witchery$lastInputDisruptTime < 40L) {
            return;
        }
        float effectivenessMultiplier = WitcheryApi.INSTANCE.isWitchy((Player)player) ? 1.0f : 0.3f;
        float disruptChance = 0.05f * effectivenessMultiplier;
        if (level.random.nextFloat() < disruptChance) {
            this.witchery$disruptInput(player);
            this.witchery$lastInputDisruptTime = currentTime;
        }
    }

    @Unique
    private void witchery$disruptInput(LocalPlayer player) {
        int randomInput = player.level().random.nextInt(5);
        switch (randomInput) {
            case 0: {
                this.input.forwardImpulse = 1.0f;
                break;
            }
            case 1: {
                this.input.forwardImpulse = -1.0f;
                break;
            }
            case 2: {
                this.input.leftImpulse = 1.0f;
                break;
            }
            case 3: {
                this.input.leftImpulse = -1.0f;
                break;
            }
            case 4: {
                this.input.jumping = true;
            }
        }
        this.witchery$playDisruptSound(player);
        Minecraft.getInstance().tell(() -> {
            if (CurseHandler.INSTANCE.hasCurse((Player)player, (Curse)WitcheryCurseRegistry.INSTANCE.getBEFUDDLEMENT().get())) {
                this.input.forwardImpulse = 0.0f;
                this.input.leftImpulse = 0.0f;
                this.input.jumping = false;
            }
        });
    }

    @Unique
    private void witchery$playDisruptSound(LocalPlayer player) {
        player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), SoundSource.PLAYERS, 0.3f, 0.5f + player.level().random.nextFloat() * 0.5f, false);
    }

    @ModifyArgs(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"))
    private void witchery$preventGroundBatMovement(Args args) {
        LocalPlayer player = (LocalPlayer)LocalPlayer.class.cast(this);
        if (TransformationHandler.isBat((Player)player) && player.onGround()) {
            Vec3 old = (Vec3)args.get(1);
            args.set(1, (Object)new Vec3(0.0, old.y, 0.0));
        }
    }
}

