/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.possession.possessor;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import dev.sterner.witchery.core.api.interfaces.Possessable;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import dev.sterner.witchery.mixin.possession.possessor.EntityAccessor;
import dev.sterner.witchery.mixin.possession.possessor.PossessorLivingEntityMixin;
import java.util.EnumSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PossessorPlayerMixin
extends PossessorLivingEntityMixin {
    @Shadow
    public abstract FoodData getFoodData();

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$travel(Vec3 travelVector, CallbackInfo info) {
        Mob possessed = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessed != null && ((Possessable)possessed).isRegularEater()) {
            if (!(this.witchery$getWorld().isClientSide || this.witchery$getX() == possessed.getX() && this.witchery$getY() == possessed.getY() && this.witchery$getZ() == possessed.getZ())) {
                ServerGamePacketListenerImpl networkHandler = ((ServerPlayer)this).connection;
                networkHandler.teleport(possessed.getX(), possessed.getY(), possessed.getZ(), this.witchery$getYaw(), this.witchery$getPitch(), EnumSet.allOf(RelativeMovement.class));
                networkHandler.resetPosition();
            }
            info.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void witchery$tick(CallbackInfo ci) {
        Player self = (Player)this;
        Mob possessed = PossessionComponentAttachment.INSTANCE.get(self).getHost();
        if (possessed != null) {
            EntityDimensions possessedDims = possessed.getDimensions(self.getPose());
            EntityDimensions currentDims = self.getDimensions(self.getPose());
            if (Math.abs(possessedDims.height() - currentDims.height()) > 0.01f || Math.abs(possessedDims.width() - currentDims.width()) > 0.01f) {
                self.refreshDimensions();
            }
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;jumpFromGround()V")})
    private void witchery$jumpFromGround(CallbackInfo ci) {
        Mob possessed = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessed != null) {
            possessed.jumpFromGround();
        }
    }

    @Inject(method={"getDefaultDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$getDefaultDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessedEntity != null) {
            cir.setReturnValue((Object)possessedEntity.getDimensions(pose));
        }
    }

    @Inject(method={"canEat"}, at={@At(value="RETURN")}, cancellable=true)
    private void witchery$canEat(boolean ignoreHunger, CallbackInfoReturnable<Boolean> cir) {
        Possessable possessed = (Possessable)PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessed != null) {
            cir.setReturnValue((Object)(ignoreHunger || possessed.isRegularEater() && this.getFoodData().needsFood() ? 1 : 0));
        }
    }

    @Inject(method={"isHurt"}, at={@At(value="RETURN")}, cancellable=true)
    private void witchery$isHurt(CallbackInfoReturnable<Boolean> cir) {
        Mob possessed = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessed != null) {
            cir.setReturnValue((Object)(((Possessable)possessed).isRegularEater() && possessed.getHealth() > 0.0f && possessed.getHealth() < possessed.getMaxHealth() ? 1 : 0));
        }
    }

    @WrapWithCondition(method={"causeFoodExhaustion"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;addExhaustion(F)V")})
    private boolean witchery$causeFoodExhaustion(FoodData instance, float exhaustion) {
        Possessable possessed = (Possessable)PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessed != null && possessed.isRegularEater() && !this.witchery$getWorld().isClientSide) {
            this.getFoodData().addExhaustion(exhaustion);
            return false;
        }
        return true;
    }

    @Override
    protected void witchery$delegateBreath(CallbackInfoReturnable<Integer> cir) {
        Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessedEntity != null) {
            cir.setReturnValue((Object)possessedEntity.getAirSupply());
        }
    }

    @Override
    protected void witchery$delegateMaxBreath(CallbackInfoReturnable<Integer> cir) {
        Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessedEntity != null) {
            cir.setReturnValue((Object)possessedEntity.getMaxAirSupply());
        }
    }

    @Override
    protected void witchery$canFly(CallbackInfoReturnable<Boolean> cir) {
        Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessedEntity != null) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    protected void witchery$setSprinting(boolean sprinting, CallbackInfo ci) {
        Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessedEntity != null) {
            possessedEntity.setSprinting(sprinting);
        }
    }

    @Override
    protected void witchery$canClimb(CallbackInfoReturnable<Boolean> cir) {
    }

    @Override
    protected void witchery$soulsAvoidTraps(CallbackInfoReturnable<Boolean> cir) {
        Player self = (Player)this;
        if (!cir.getReturnValueZ()) {
            if (AfflictionPlayerAttachment.getData(self).isSoulForm()) {
                cir.setReturnValue((Object)true);
            } else {
                Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get(self).getHost();
                if (possessedEntity != null && possessedEntity.isIgnoringBlockTriggers()) {
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }

    @Override
    protected void witchery$isOnFire(CallbackInfoReturnable<Boolean> cir) {
        Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessedEntity != null) {
            cir.setReturnValue((Object)possessedEntity.isOnFire());
        } else if (AfflictionPlayerAttachment.getData((Player)this).isSoulForm()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    protected void witchery$canWalkOnFluid(FluidState fluid, CallbackInfoReturnable<Boolean> cir) {
        Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessedEntity != null) {
            cir.setReturnValue((Object)possessedEntity.canStandOnFluid(fluid));
        }
    }

    @Inject(method={"makeStuckInBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$makeStuckInBlock(BlockState state, Vec3 motionMultiplier, CallbackInfo ci) {
        Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get((Player)this).getHost();
        if (possessedEntity != null) {
            possessedEntity.fallDistance = this.witchery$getFallDistance();
            possessedEntity.makeStuckInBlock(state, motionMultiplier);
            this.witchery$setFallDistance(possessedEntity.fallDistance);
            this.witchery$setMovementMultiplier(((EntityAccessor)possessedEntity).witchery$getMovementMultiplier());
            ci.cancel();
        }
    }
}

