/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.network;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0010\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ldev/sterner/witchery/network/GrantWitcheryAdvancementsC2SPayload;", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "<init>", "(Lnet/minecraft/nbt/CompoundTag;)V", "buf", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "()V", "getNbt", "()Lnet/minecraft/nbt/CompoundTag;", "type", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "write", "", "handleOnServer", "ctx", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "grantAllWitcheryAdvancements", "player", "Lnet/minecraft/server/level/ServerPlayer;", "Companion", "witchery"})
public final class GrantWitcheryAdvancementsC2SPayload
implements CustomPacketPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompoundTag nbt;
    @NotNull
    private static final CustomPacketPayload.Type<GrantWitcheryAdvancementsC2SPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"witchery", (String)"grant_witchery_advancements"));
    @NotNull
    private static final StreamCodec<? super RegistryFriendlyByteBuf, GrantWitcheryAdvancementsC2SPayload> STREAM_CODEC;

    public GrantWitcheryAdvancementsC2SPayload(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.nbt = nbt;
    }

    @NotNull
    public final CompoundTag getNbt() {
        return this.nbt;
    }

    public GrantWitcheryAdvancementsC2SPayload(@NotNull RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        CompoundTag compoundTag = buf.readNbt();
        Intrinsics.checkNotNull((Object)compoundTag);
        this(compoundTag);
    }

    /*
     * WARNING - void declaration
     */
    public GrantWitcheryAdvancementsC2SPayload() {
        void $this$_init__u24lambda_u240;
        CompoundTag compoundTag;
        CompoundTag compoundTag2 = compoundTag = new CompoundTag();
        GrantWitcheryAdvancementsC2SPayload grantWitcheryAdvancementsC2SPayload = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.putBoolean("grantAdvancements", true);
        grantWitcheryAdvancementsC2SPayload(compoundTag);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    private final void write(RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.nbt);
    }

    public final void handleOnServer(@NotNull IPayloadContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Player player = ctx.player();
        boolean shouldGrant = this.nbt.getBoolean("grantAdvancements");
        if (player instanceof ServerPlayer && shouldGrant) {
            this.grantAllWitcheryAdvancements((ServerPlayer)player);
        }
    }

    private final void grantAllWitcheryAdvancements(ServerPlayer player) {
        MinecraftServer minecraftServer = player.server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        ServerAdvancementManager advancementManager = server.getAdvancements();
        int grantedCount = 0;
        for (AdvancementHolder holder : advancementManager.getAllAdvancements()) {
            ResourceLocation id = holder.id();
            if (!Intrinsics.areEqual((Object)id.getNamespace(), (Object)"witchery")) continue;
            Advancement advancement = holder.value();
            AdvancementProgress progress = player.getAdvancements().getOrStartProgress(holder);
            if (progress.isDone()) continue;
            boolean wasCompleted = false;
            for (String criterion : advancement.criteria().keySet()) {
                CriterionProgress criterionProgress = progress.getCriterion(criterion);
                Intrinsics.checkNotNull((Object)criterionProgress);
                if (criterionProgress.isDone()) continue;
                player.getAdvancements().award(holder, criterion);
                wasCompleted = true;
            }
            if (!wasCompleted) continue;
            ++grantedCount;
        }
        player.sendSystemMessage((Component)Component.literal((String)("Granted " + grantedCount + " Witchery advancements!")));
    }

    private static final void STREAM_CODEC$lambda$0(GrantWitcheryAdvancementsC2SPayload payload, RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNull((Object)buf);
        payload.write(buf);
    }

    private static final GrantWitcheryAdvancementsC2SPayload STREAM_CODEC$lambda$1(RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNull((Object)buf);
        return new GrantWitcheryAdvancementsC2SPayload(buf);
    }

    static {
        StreamCodec streamCodec = CustomPacketPayload.codec(GrantWitcheryAdvancementsC2SPayload::STREAM_CODEC$lambda$0, GrantWitcheryAdvancementsC2SPayload::STREAM_CODEC$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"codec(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\u0006\b\u0000\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/network/GrantWitcheryAdvancementsC2SPayload$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Ldev/sterner/witchery/network/GrantWitcheryAdvancementsC2SPayload;", "getID", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomPacketPayload.Type<GrantWitcheryAdvancementsC2SPayload> getID() {
            return ID;
        }

        @NotNull
        public final StreamCodec<? super RegistryFriendlyByteBuf, GrantWitcheryAdvancementsC2SPayload> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

