/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client;

import com.mojang.authlib.GameProfile;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/client/SleepingClientPlayerEntity;", "Lnet/minecraft/client/player/RemotePlayer;", "clientLevel", "Lnet/minecraft/client/multiplayer/ClientLevel;", "gameProfile", "Lcom/mojang/authlib/GameProfile;", "equipmentList", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "model", "", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;Lcom/mojang/authlib/GameProfile;Lnet/minecraft/core/NonNullList;B)V", "getModel", "()B", "isSpectator", "", "isModelPartShown", "part", "Lnet/minecraft/world/entity/player/PlayerModelPart;", "witchery"})
public final class SleepingClientPlayerEntity
extends RemotePlayer {
    private final byte model;

    public SleepingClientPlayerEntity(@NotNull ClientLevel clientLevel, @NotNull GameProfile gameProfile, @NotNull NonNullList<ItemStack> equipmentList, byte model) {
        Intrinsics.checkNotNullParameter((Object)clientLevel, (String)"clientLevel");
        Intrinsics.checkNotNullParameter((Object)gameProfile, (String)"gameProfile");
        Intrinsics.checkNotNullParameter(equipmentList, (String)"equipmentList");
        super(clientLevel, gameProfile);
        this.model = model;
        for (EquipmentSlot type : EntriesMappings.entries$0) {
            this.setItemSlot(type, (ItemStack)equipmentList.get(type.ordinal()));
        }
    }

    public final byte getModel() {
        return this.model;
    }

    public boolean isSpectator() {
        return false;
    }

    public boolean isModelPartShown(@NotNull PlayerModelPart part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        return (byte)(this.model & (byte)part.getMask()) == (byte)part.getMask();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }
}

