/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.HornedHuntsmanEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001%B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J0\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0016J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ldev/sterner/witchery/client/model/HornedHuntsmanModel;", "Lnet/minecraft/client/model/HumanoidModel;", "Ldev/sterner/witchery/content/entity/HornedHuntsmanEntity;", "Lnet/minecraft/client/model/ArmedModel;", "root", "Lnet/minecraft/client/model/geom/ModelPart;", "<init>", "(Lnet/minecraft/client/model/geom/ModelPart;)V", "getRoot", "()Lnet/minecraft/client/model/geom/ModelPart;", "body", "head", "leftLeg", "rightLeg", "leftArm", "rightArm", "setupAnim", "", "entity", "limbSwing", "", "limbSwingAmount", "ageInTicks", "netHeadYaw", "headPitch", "renderToBuffer", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "vertexConsumer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "packedLight", "", "packedOverlay", "color", "translateToHand", "side", "Lnet/minecraft/world/entity/HumanoidArm;", "Companion", "witchery"})
public final class HornedHuntsmanModel
extends HumanoidModel<HornedHuntsmanEntity>
implements ArmedModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelPart root;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart leftLeg;
    @NotNull
    private final ModelPart rightLeg;
    @NotNull
    private final ModelPart leftArm;
    @NotNull
    private final ModelPart rightArm;
    @NotNull
    private static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Witchery.Companion.id("horned_huntsman"), "main");

    public HornedHuntsmanModel(@NotNull ModelPart root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(root);
        this.root = root;
        ModelPart modelPart = this.root.getChild("body");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"getChild(...)");
        this.body = modelPart;
        ModelPart modelPart2 = this.root.getChild("head");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"getChild(...)");
        this.head = modelPart2;
        ModelPart modelPart3 = this.root.getChild("left_leg");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"getChild(...)");
        this.leftLeg = modelPart3;
        ModelPart modelPart4 = this.root.getChild("right_leg");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart4, (String)"getChild(...)");
        this.rightLeg = modelPart4;
        ModelPart modelPart5 = this.root.getChild("left_arm");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart5, (String)"getChild(...)");
        this.leftArm = modelPart5;
        ModelPart modelPart6 = this.root.getChild("right_arm");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart6, (String)"getChild(...)");
        this.rightArm = modelPart6;
    }

    @NotNull
    public final ModelPart getRoot() {
        return this.root;
    }

    public void setupAnim(@NotNull HornedHuntsmanEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.body.y = 6.0f;
        this.rightLeg.y = 8.0f;
        this.leftLeg.y = 8.0f;
        this.leftArm.y = 3.0f;
        this.rightArm.y = 3.0f;
        ModelPart modelPart = this.rightLeg;
        modelPart.zRot += 0.08726646f;
        modelPart = this.leftLeg;
        modelPart.zRot -= 0.08726646f;
        modelPart = this.rightArm;
        modelPart.zRot += 0.04363323f;
        modelPart = this.leftArm;
        modelPart.zRot -= 0.04363323f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6f)) * 0.6f * limbSwingAmount / 1.0f - 0.17453292f;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6f + (float)Math.PI)) * 0.6f * limbSwingAmount / 1.0f - 0.17453292f;
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void translateToHand(@NotNull HumanoidArm side, @NotNull PoseStack poseStack) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        ModelPart modelPart = side == HumanoidArm.RIGHT ? this.rightArm : this.leftArm;
        poseStack.translate(0.0, 0.15, 0.0);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0, -0.15, 0.0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/client/model/HornedHuntsmanModel$Companion;", "", "<init>", "()V", "LAYER_LOCATION", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getLAYER_LOCATION", "()Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createBodyLayer", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelLayerLocation getLAYER_LOCATION() {
            return LAYER_LOCATION;
        }

        @NotNull
        public final LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(21, 0).addBox(-3.0f, 1.0f, -2.0f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)1.0f));
            body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, -7.0f, -1.0f, 8.0f, 7.0f, 5.0f, new CubeDeformation(0.2f)).texOffs(21, 21).addBox(-4.0f, -7.0f, -1.0f, 8.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-1.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
            PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(26, 8).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(25, 45).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.1f)).texOffs(40, 54).addBox(-3.0f, 1.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.1f)).texOffs(0, 0).addBox(-3.5f, -3.5f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-4.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
            head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 44).addBox(-6.0f, -10.5f, 0.0f, 12.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)1.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 33).addBox(-6.0f, -10.5f, 0.0f, 12.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
            PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 26).addBox(-2.0f, -2.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(41, 0).addBox(-2.0f, 1.0f, -0.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)1.0f, (float)-1.0f, (float)-0.0436f, (float)0.0f, (float)-0.0873f));
            leftArm.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(12, 26).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)6.0f, (float)0.5f, (float)-0.5672f, (float)0.0f, (float)0.0f));
            PartDefinition leftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(36, 33).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)1.5f, (float)7.0f, (float)0.5f, (float)-0.2182f, (float)0.0f, (float)-0.0436f));
            leftLeg.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(24, 33).addBox(-1.5f, 0.0f, 0.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-1.5f, (float)0.2182f, (float)0.0f, (float)0.0f));
            PartDefinition rightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(36, 33).mirror().addBox(-1.5f, 0.0f, -1.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)7.0f, (float)0.5f, (float)-0.2182f, (float)0.0f, (float)0.0436f));
            rightLeg.addOrReplaceChild("bone2", CubeListBuilder.create().texOffs(24, 33).mirror().addBox(-1.5f, 0.0f, 0.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-1.5f, (float)0.2182f, (float)0.0f, (float)0.0f));
            PartDefinition rightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 26).mirror().addBox(-1.0f, -2.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(41, 0).mirror().addBox(0.0f, 1.0f, -0.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)1.0f, (float)-1.0f, (float)-0.0436f, (float)0.0f, (float)0.0873f));
            rightArm.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(12, 26).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)6.0f, (float)0.5f, (float)-0.5672f, (float)0.0f, (float)0.0f));
            LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
            Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"create(...)");
            return layerDefinition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

