/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.MandrakeEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J0\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/client/model/MandrakeEntityModel;", "Lnet/minecraft/client/model/EntityModel;", "Ldev/sterner/witchery/content/entity/MandrakeEntity;", "root", "Lnet/minecraft/client/model/geom/ModelPart;", "<init>", "(Lnet/minecraft/client/model/geom/ModelPart;)V", "head", "arms", "legs", "rightLeg", "leftLeg", "bb_main", "setupAnim", "", "entity", "limbSwing", "", "limbSwingAmount", "ageInTicks", "netHeadYaw", "headPitch", "renderToBuffer", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "packedLight", "", "packedOverlay", "color", "Companion", "witchery"})
public final class MandrakeEntityModel
extends EntityModel<MandrakeEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart arms;
    @NotNull
    private final ModelPart legs;
    @NotNull
    private final ModelPart rightLeg;
    @NotNull
    private final ModelPart leftLeg;
    @NotNull
    private final ModelPart bb_main;
    @NotNull
    private static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Witchery.Companion.id("mandrake"), "main");

    public MandrakeEntityModel(@NotNull ModelPart root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModelPart modelPart = root.getChild("head");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"getChild(...)");
        this.head = modelPart;
        ModelPart modelPart2 = root.getChild("arms");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"getChild(...)");
        this.arms = modelPart2;
        ModelPart modelPart3 = root.getChild("legs");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"getChild(...)");
        this.legs = modelPart3;
        ModelPart modelPart4 = this.legs.getChild("rightLeg");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart4, (String)"getChild(...)");
        this.rightLeg = modelPart4;
        ModelPart modelPart5 = this.legs.getChild("leftLeg");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart5, (String)"getChild(...)");
        this.leftLeg = modelPart5;
        ModelPart modelPart6 = root.getChild("bb_main");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart6, (String)"getChild(...)");
        this.bb_main = modelPart6;
    }

    public void setupAnim(@NotNull MandrakeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.zRot = netHeadYaw * ((float)Math.PI / 180) + Mth.sin((float)(ageInTicks * 0.1f)) * 0.1f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.arms.zRot = Mth.sin((float)(ageInTicks * 0.1f)) * 0.05f;
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.arms.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.legs.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.bb_main.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/client/model/MandrakeEntityModel$Companion;", "", "<init>", "()V", "LAYER_LOCATION", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getLAYER_LOCATION", "()Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createBodyLayer", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelLayerLocation getLAYER_LOCATION() {
            return LAYER_LOCATION;
        }

        @NotNull
        public final LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(16, 22).addBox(-5.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 20).addBox(3.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
            PartDefinition legs = partdefinition.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
            legs.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(16, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-2.0f, (float)0.0f));
            legs.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(0, 20).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-2.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -8.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(-4.0f, -18.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
            LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
            Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"create(...)");
            return layerDefinition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

