/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.SpiritPortalBlockEntityModel;
import dev.sterner.witchery.client.model.SpiritPortalPortalModel;
import dev.sterner.witchery.content.block.spirit_portal.SpiritPortalBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryRenderTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/client/renderer/block/SpiritPortalBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/spirit_portal/SpiritPortalBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "model", "Ldev/sterner/witchery/client/model/SpiritPortalBlockEntityModel;", "modelShaderModel", "Ldev/sterner/witchery/client/model/SpiritPortalPortalModel;", "getRenderBoundingBox", "Lnet/minecraft/world/phys/AABB;", "blockEntity", "render", "", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "witchery"})
public final class SpiritPortalBlockEntityRenderer
implements BlockEntityRenderer<SpiritPortalBlockEntity> {
    @NotNull
    private final SpiritPortalBlockEntityModel model;
    @NotNull
    private final SpiritPortalPortalModel modelShaderModel;

    public SpiritPortalBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ModelPart modelPart = ctx.bakeLayer(SpiritPortalBlockEntityModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.model = new SpiritPortalBlockEntityModel(modelPart);
        ModelPart modelPart2 = ctx.bakeLayer(SpiritPortalPortalModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        this.modelShaderModel = new SpiritPortalPortalModel(modelPart2);
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull SpiritPortalBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 1.0, (double)pos.getY() - 0.0, (double)pos.getZ() - 1.0, (double)pos.getX() + 1.0, (double)pos.getY() + 2.0, (double)pos.getZ() + 1.0);
    }

    public void render(@NotNull SpiritPortalBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.pushPose();
        poseStack.translate(1.0, 1.5, 0.0);
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        float yDir = dir.toYRot();
        poseStack.mulPose(Axis.YP.rotationDegrees((float)180 - yDir));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(0.0, 0.0, -0.05);
        if (dir == Direction.WEST) {
            poseStack.translate(0.0, 0.0, 1.0);
        }
        if (dir == Direction.EAST) {
            poseStack.translate(1.0, 0.0, 0.0);
        }
        if (dir == Direction.NORTH) {
            poseStack.translate(0.0, 0.0, 0.0);
        }
        if (dir == Direction.SOUTH) {
            poseStack.translate(1.0, 0.0, 1.0);
        }
        this.modelShaderModel.renderToBuffer(poseStack, bufferSource.getBuffer((RenderType)WitcheryRenderTypes.INSTANCE.getSPIRIT_PORTAL().apply(Witchery.Companion.id("textures/block/spirit_door_portal.png"))), packedLight, packedOverlay);
        poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
        float progress = blockEntity.getRenderProgress(partialTick);
        float doorAngle = progress * 90.0f * (float)-1;
        poseStack.pushPose();
        this.model.getFrame().render(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)Witchery.Companion.id("textures/block/spirit_door_square.png"))), packedLight, packedOverlay);
        poseStack.translate(-1.0, 0.0, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(doorAngle));
        poseStack.translate(1.0, 0.0, 0.0);
        this.model.getLDoor().render(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)Witchery.Companion.id("textures/block/spirit_door_square.png"))), packedLight, packedOverlay);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(1.0, 0.0, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(-doorAngle));
        poseStack.translate(-1.0, 0.0, 0.0);
        this.model.getRDoor().render(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)Witchery.Companion.id("textures/block/spirit_door_square.png"))), packedLight, packedOverlay);
        poseStack.popPose();
        poseStack.popPose();
    }
}

