/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.content.block.SuspiciousGraveyardDirtBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012H\u0014J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J0\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0016J8\u0010%\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010 \u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u0016H\u0016J(\u0010+\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020,2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0016J \u0010/\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00100\u001a\u000201H\u0016J(\u00102\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u00064"}, d2={"Ldev/sterner/witchery/content/block/SuspiciousGraveyardDirtBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/Fallable;", "turnsInto", "Lnet/minecraft/world/level/block/Block;", "brushSound", "Lnet/minecraft/sounds/SoundEvent;", "brushCompletedSound", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getTurnsInto", "()Lnet/minecraft/world/level/block/Block;", "getBrushSound", "()Lnet/minecraft/sounds/SoundEvent;", "getBrushCompletedSound", "codec", "Lcom/mojang/serialization/MapCodec;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "onPlace", "level", "Lnet/minecraft/world/level/Level;", "oldState", "movedByPiston", "", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "tick", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "onBrokenAfterFall", "fallingBlock", "Lnet/minecraft/world/entity/item/FallingBlockEntity;", "animateTick", "Companion", "witchery"})
public final class SuspiciousGraveyardDirtBlock
extends BaseEntityBlock
implements Fallable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Block turnsInto;
    @NotNull
    private final SoundEvent brushSound;
    @NotNull
    private final SoundEvent brushCompletedSound;
    @NotNull
    private static final MapCodec<SuspiciousGraveyardDirtBlock> CODEC;
    @NotNull
    private static final IntegerProperty DUSTED;
    public static final int TICK_DELAY = 2;

    public SuspiciousGraveyardDirtBlock(@NotNull Block turnsInto, @NotNull SoundEvent brushSound, @NotNull SoundEvent brushCompletedSound, @NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)turnsInto, (String)"turnsInto");
        Intrinsics.checkNotNullParameter((Object)brushSound, (String)"brushSound");
        Intrinsics.checkNotNullParameter((Object)brushCompletedSound, (String)"brushCompletedSound");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.turnsInto = turnsInto;
        this.brushSound = brushSound;
        this.brushCompletedSound = brushCompletedSound;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DUSTED, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public final Block getTurnsInto() {
        return this.turnsInto;
    }

    @NotNull
    public final SoundEvent getBrushSound() {
        return this.brushSound;
    }

    @NotNull
    public final SoundEvent getBrushCompletedSound() {
        return this.brushCompletedSound;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getBRUSHABLE_BLOCK().get()).create(pos, state);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{DUSTED};
        builder.add(propertyArray);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        level.scheduleTick(pos, (Block)this, 2);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        level.scheduleTick(pos, (Block)this, 2);
        BlockState blockState = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (level.getBlockEntity(pos) instanceof SuspiciousGraveyardDirtBlockEntity) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.SuspiciousGraveyardDirtBlockEntity");
            SuspiciousGraveyardDirtBlockEntity brushableBlockEntity = (SuspiciousGraveyardDirtBlockEntity)blockEntity;
            brushableBlockEntity.resetBrushingState();
        }
        if (FallingBlock.isFree((BlockState)level.getBlockState(pos.below())) && pos.getY() >= level.getMinBuildHeight()) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)((Level)level), (BlockPos)pos, (BlockState)state);
            fallingBlockEntity.disableDrop();
        }
    }

    public void onBrokenAfterFall(@NotNull Level level, @NotNull BlockPos pos, @NotNull FallingBlockEntity fallingBlock) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)fallingBlock, (String)"fallingBlock");
        Vec3 vec3 = fallingBlock.getBoundingBox().getCenter();
        level.levelEvent(2001, BlockPos.containing((Position)((Position)vec3)), BaseEntityBlock.getId((BlockState)fallingBlock.getBlockState()));
        level.gameEvent((Entity)fallingBlock, (Holder)GameEvent.BLOCK_DESTROY, vec3);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockPos blockPos;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (random.nextInt(16) == 0 && FallingBlock.isFree((BlockState)level.getBlockState(blockPos = pos.below()))) {
            double d = (double)pos.getX() + random.nextDouble();
            double e = (double)pos.getY() - 0.05;
            double f = (double)pos.getZ() + random.nextDouble();
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state), d, e, f, 0.0, 0.0, 0.0);
        }
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("turns_into").forGetter(SuspiciousGraveyardDirtBlock::CODEC$lambda$0$0), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("brush_sound").forGetter(SuspiciousGraveyardDirtBlock::CODEC$lambda$0$1), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("brush_completed_sound").forGetter(SuspiciousGraveyardDirtBlock::CODEC$lambda$0$2), (App)BaseEntityBlock.propertiesCodec()).apply((Applicative)instance, SuspiciousGraveyardDirtBlock::CODEC$lambda$0$3);
    }

    private static final Block CODEC$lambda$0$0(SuspiciousGraveyardDirtBlock obj) {
        Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
        return obj.turnsInto;
    }

    private static final SoundEvent CODEC$lambda$0$1(SuspiciousGraveyardDirtBlock obj) {
        Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
        return obj.brushSound;
    }

    private static final SoundEvent CODEC$lambda$0$2(SuspiciousGraveyardDirtBlock obj) {
        Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
        return obj.brushCompletedSound;
    }

    private static final SuspiciousGraveyardDirtBlock CODEC$lambda$0$3(Block turnsInto, SoundEvent brushSound, SoundEvent brushCompletedSound, BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)turnsInto, (String)"turnsInto");
        Intrinsics.checkNotNullParameter((Object)brushSound, (String)"brushSound");
        Intrinsics.checkNotNullParameter((Object)brushCompletedSound, (String)"brushCompletedSound");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new SuspiciousGraveyardDirtBlock(turnsInto, brushSound, brushCompletedSound, properties);
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(SuspiciousGraveyardDirtBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        IntegerProperty integerProperty = BlockStateProperties.DUSTED;
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"DUSTED");
        DUSTED = integerProperty;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/content/block/SuspiciousGraveyardDirtBlock$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/sterner/witchery/content/block/SuspiciousGraveyardDirtBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "DUSTED", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "TICK_DELAY", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<SuspiciousGraveyardDirtBlock> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

