/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.bear_trap;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0005H\u0016J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u0010'\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013\u00a8\u0006("}, d2={"Ldev/sterner/witchery/content/block/bear_trap/BearTrapBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "isOpen", "", "()Z", "setOpen", "(Z)V", "isTriggered", "angle", "", "getAngle", "()I", "setAngle", "(I)V", "prevAngle", "getPrevAngle", "setPrevAngle", "onUseWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "triggerBearTrap", "", "tick", "level", "Lnet/minecraft/world/level/Level;", "pos", "state", "loadAdditional", "compoundTag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "witchery"})
public final class BearTrapBlockEntity
extends WitcheryBaseBlockEntity {
    private boolean isOpen;
    private boolean isTriggered;
    private int angle;
    private int prevAngle;

    public BearTrapBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getBEAR_TRAP().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
    }

    public final boolean isOpen() {
        return this.isOpen;
    }

    public final void setOpen(boolean bl) {
        this.isOpen = bl;
    }

    public final int getAngle() {
        return this.angle;
    }

    public final void setAngle(int n) {
        this.angle = n;
    }

    public final int getPrevAngle() {
        return this.prevAngle;
    }

    public final void setPrevAngle(int n) {
        this.prevAngle = n;
    }

    @Override
    @NotNull
    public InteractionResult onUseWithoutItem(@NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        if (!this.isOpen && !this.isTriggered) {
            this.isOpen = true;
            this.setChanged();
        }
        return super.onUseWithoutItem(pPlayer);
    }

    public final void triggerBearTrap() {
        if (this.isOpen && !this.isTriggered) {
            this.isTriggered = true;
            this.setChanged();
        }
    }

    @Override
    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.tick(level, pos, state);
        this.prevAngle = this.angle;
        if (this.isOpen && !this.isTriggered && this.angle < 110) {
            this.angle = Math.min(this.angle + 2, 110);
            this.setChanged();
        } else if (this.isTriggered && this.angle > 0) {
            this.angle = Math.max(this.angle - 30, 0);
            this.setChanged();
        } else if (this.isTriggered && this.angle <= 0) {
            this.isOpen = false;
            this.isTriggered = false;
            this.setChanged();
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.loadAdditional(compoundTag, provider);
        this.angle = compoundTag.getInt("angle");
        this.isOpen = compoundTag.getBoolean("isOpen");
        this.isTriggered = compoundTag.getBoolean("isTriggered");
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt("angle", this.angle);
        compoundTag.putBoolean("isOpen", this.isOpen);
        compoundTag.putBoolean("isTriggered", this.isTriggered);
    }
}

