/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.brazier;

import dev.sterner.witchery.content.block.WitcheryBaseEntityBlock;
import dev.sterner.witchery.content.block.brazier.BrazierBlockEntity;
import dev.sterner.witchery.content.block.cauldron.WitcheryCauldronBlock;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0014J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J0\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J(\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/content/block/brazier/BrazierBlock;", "Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "level", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "onRemove", "Lnet/minecraft/world/level/Level;", "newState", "movedByPiston", "", "animateTick", "random", "Lnet/minecraft/util/RandomSource;", "witchery"})
public final class BrazierBlock
extends WitcheryBaseEntityBlock {
    public BrazierBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        BlockBehaviour.Properties properties2 = properties.lightLevel(WitcheryCauldronBlock.Companion.litBlockEmission(14));
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"lightLevel(...)");
        super(properties2);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.LIT};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getBRAZIER().get()).create(pos, state);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.75, (double)0.8125);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        return voxelShape;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (level.getBlockEntity(pos) instanceof BrazierBlockEntity) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.brazier.BrazierBlockEntity");
            BrazierBlockEntity be = (BrazierBlockEntity)blockEntity;
            if (!be.getActive()) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)be);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            double baseX = (double)pos.getX() + 0.5;
            double baseY = (double)pos.getY() + 0.8;
            double baseZ = (double)pos.getZ() + 0.5;
            double offsetX = (random.nextDouble() - 0.5) * 0.4;
            double offsetY = (random.nextDouble() - 0.5) * 0.4;
            double offsetZ = (random.nextDouble() - 0.5) * 0.4;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, baseX + offsetX, baseY + offsetY, baseZ + offsetZ, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, baseX + offsetX, baseY + offsetY, baseZ + offsetZ, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, baseX + offsetX, baseY + offsetY, baseZ + offsetZ, 0.0, 0.0, 0.0);
        }
    }
}

