/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.ritual;

import com.mojang.serialization.DynamicOps;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.WitcheryConfig;
import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.content.block.altar.AltarBlockEntity;
import dev.sterner.witchery.content.block.grassper.GrassperBlockEntity;
import dev.sterner.witchery.content.block.ritual.RitualHelper;
import dev.sterner.witchery.content.block.ritual.RitualPatternUtil;
import dev.sterner.witchery.content.entity.CovenWitchEntity;
import dev.sterner.witchery.content.item.SeerStoneItem;
import dev.sterner.witchery.content.item.TaglockItem;
import dev.sterner.witchery.content.item.WaystoneItem;
import dev.sterner.witchery.content.recipe.ritual.RitualRecipe;
import dev.sterner.witchery.core.api.Ritual;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.api.block.AltarPowerConsumer;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryRecipeTypes;
import dev.sterner.witchery.core.registry.WitcheryRitualRegistry;
import dev.sterner.witchery.features.coven.CovenHandler;
import dev.sterner.witchery.features.familiar.FamiliarHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 \u0098\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0004\u0098\u0001\u0099\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010C\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010D\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010E\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010F\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010G\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010H\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010@\u001a\u00020AH\u0002J*\u0010L\u001a\u0004\u0018\u00010K2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020K0J2\u0010\u0010N\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003010JH\u0002J\u0010\u0010O\u001a\u00020?2\u0006\u0010P\u001a\u00020KH\u0002J\u0010\u0010Q\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020S0J2\u0006\u0010@\u001a\u00020AH\u0002J\"\u0010T\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020V0U0J2\u0006\u0010@\u001a\u00020AH\u0002J,\u0010W\u001a\u00020\r2\u0006\u0010X\u001a\u00020S2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020*0J2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020*00H\u0002J,\u0010[\u001a\u00020\r2\u0006\u0010\\\u001a\u00020V2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020*0J2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020*00H\u0002J\u0010\u0010]\u001a\u00020?2\u0006\u0010^\u001a\u00020*H\u0002J\b\u0010_\u001a\u00020?H\u0002J$\u0010`\u001a\u00020\r2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020*0JH\u0002J\u001e\u0010a\u001a\u00020?2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010^\u001a\u00020*H\u0002J\u0010\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0016J\u0010\u0010f\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010g\u001a\u00020?2\u0006\u0010h\u001a\u00020eH\u0002J\u0018\u0010i\u001a\u00020?2\u0006\u0010h\u001a\u00020e2\u0006\u0010j\u001a\u000204H\u0002J\u0010\u0010k\u001a\u00020?2\u0006\u0010h\u001a\u00020eH\u0002J\u0010\u0010l\u001a\u00020?2\u0006\u0010h\u001a\u00020eH\u0002J\u0016\u0010m\u001a\b\u0012\u0004\u0012\u00020*0J2\u0006\u0010@\u001a\u00020AH\u0002J\u0016\u0010n\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010@\u001a\u00020AH\u0002JB\u0010o\u001a\n\u0012\u0004\u0012\u000204\u0018\u00010p2\u0014\u0010q\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002040p\u0018\u0001002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0J2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020K0JH\u0002J \u0010r\u001a\u00020\r2\u0006\u0010h\u001a\u00020e2\u0006\u0010@\u001a\u00020A2\u0006\u0010j\u001a\u000204H\u0002J\u0018\u0010s\u001a\u00020\r2\u0006\u0010h\u001a\u00020e2\u0006\u0010j\u001a\u000204H\u0002J\u0018\u0010t\u001a\u00020\r2\u0006\u0010@\u001a\u00020A2\u0006\u0010j\u001a\u000204H\u0002J\u0018\u0010u\u001a\u00020\r2\u0006\u0010@\u001a\u00020A2\u0006\u0010j\u001a\u000204H\u0002J\u0018\u0010v\u001a\u00020\r2\u0006\u0010h\u001a\u00020e2\u0006\u0010j\u001a\u000204H\u0002J\u0018\u0010w\u001a\u00020\r2\u0006\u0010@\u001a\u00020A2\u0006\u0010j\u001a\u000204H\u0002J\u0018\u0010x\u001a\u00020\r2\u0006\u0010@\u001a\u00020A2\u0006\u0010j\u001a\u000204H\u0002J\u0018\u0010y\u001a\u00020\r2\u0006\u0010@\u001a\u00020A2\u0006\u0010j\u001a\u000204H\u0002J\u0010\u0010z\u001a\u00020\u00162\u0006\u0010@\u001a\u00020AH\u0002J\u0016\u0010{\u001a\b\u0012\u0004\u0012\u00020S0J2\u0006\u0010@\u001a\u00020AH\u0002J\u0019\u0010|\u001a\u00020?2\u0006\u0010}\u001a\u00020~2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0014J\u0014\u0010\u0081\u0001\u001a\u0004\u0018\u0001042\u0007\u0010\u0082\u0001\u001a\u00020\u000bH\u0002J\u0012\u0010\u0083\u0001\u001a\u00020?2\u0007\u0010\u0084\u0001\u001a\u00020~H\u0002J \u0010\u0085\u0001\u001a\u0010\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020A0\u0087\u00010\u0086\u00012\u0007\u0010\u0084\u0001\u001a\u00020~H\u0002J\u001c\u0010\u0089\u0001\u001a\u00020?2\u0007\u0010\u0084\u0001\u001a\u00020~2\b\u0010\u008a\u0001\u001a\u00030\u0080\u0001H\u0014J\u0012\u0010\u008b\u0001\u001a\u00020?2\u0007\u0010\u0084\u0001\u001a\u00020~H\u0002J\"\u0010\u008c\u0001\u001a\u00020?2\u000e\u0010\u008d\u0001\u001a\t\u0012\u0004\u0012\u00020A0\u0087\u00012\u0007\u0010\u0084\u0001\u001a\u00020~H\u0002J\t\u0010\u008e\u0001\u001a\u00020?H\u0016J\t\u0010\u008f\u0001\u001a\u00020\u0016H\u0016J\t\u0010\u0090\u0001\u001a\u00020\rH\u0016J\u0012\u0010\u0091\u0001\u001a\u00020*2\u0007\u0010\u0092\u0001\u001a\u00020\u0016H\u0016J\u001b\u0010\u0093\u0001\u001a\u00020*2\u0007\u0010\u0092\u0001\u001a\u00020\u00162\u0007\u0010\u0094\u0001\u001a\u00020\u0016H\u0016J\u0012\u0010\u0095\u0001\u001a\u00020*2\u0007\u0010\u0092\u0001\u001a\u00020\u0016H\u0016J\u001a\u0010\u0096\u0001\u001a\u00020?2\u0007\u0010\u0092\u0001\u001a\u00020\u00162\u0006\u0010^\u001a\u00020*H\u0016J\u0011\u0010\u0097\u0001\u001a\u00020\r2\u0006\u0010h\u001a\u00020eH\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R \u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0018\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00103\u001a\u0004\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u000e\u00109\u001a\u00020:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0088\u0001\u001a\u00020#X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009a\u0001"}, d2={"Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "Lnet/minecraft/world/Container;", "Ldev/sterner/witchery/core/api/block/AltarPowerConsumer;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "pendingRitualTypeId", "Lnet/minecraft/resources/ResourceLocation;", "needsRitualLoad", "", "cachedAltarPos", "targetPlayer", "Ljava/util/UUID;", "getTargetPlayer", "()Ljava/util/UUID;", "setTargetPlayer", "(Ljava/util/UUID;)V", "targetEntity", "", "getTargetEntity", "()Ljava/lang/Integer;", "setTargetEntity", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "targetPos", "Lnet/minecraft/core/GlobalPos;", "getTargetPos", "()Lnet/minecraft/core/GlobalPos;", "setTargetPos", "(Lnet/minecraft/core/GlobalPos;)V", "ownerName", "", "getOwnerName", "()Ljava/lang/String;", "setOwnerName", "(Ljava/lang/String;)V", "items", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "setItems", "(Lnet/minecraft/core/NonNullList;)V", "consumedSacrifices", "", "Lnet/minecraft/world/entity/EntityType;", "hasRitualStarted", "ritualRecipe", "Ldev/sterner/witchery/content/recipe/ritual/RitualRecipe;", "getRitualRecipe", "()Ldev/sterner/witchery/content/recipe/ritual/RitualRecipe;", "setRitualRecipe", "(Ldev/sterner/witchery/content/recipe/ritual/RitualRecipe;)V", "currentState", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity$RitualState;", "isRitualActive", "tickCounter", "ritualTickCounter", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "processActiveRitual", "onStartRitual", "cancelRitualAndDropItems", "onTickRitual", "onEndRitual", "processSacrificeConsumption", "getSacrificeEntities", "", "Lnet/minecraft/world/entity/LivingEntity;", "findNextRequiredSacrifice", "entities", "requiredTypes", "consumeSacrifice", "entity", "processItemConsumption", "getItemEntities", "Lnet/minecraft/world/entity/item/ItemEntity;", "findNearbyGrasspers", "Lkotlin/Pair;", "Ldev/sterner/witchery/content/block/grassper/GrassperBlockEntity;", "tryConsumeFromItemEntity", "itemEntity", "recipeItems", "consumedItems", "tryConsumeFromGrassper", "grassper", "addWaystoneOrTaglockToContext", "stack", "resetRitual", "itemsMatchRecipe", "addItemToInventory", "onUseWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "updateAltarCache", "tryStartRitual", "player", "startRitual", "recipe", "playRitualStartSound", "playRitualFailureSound", "collectNearbyItems", "collectNearbyEntities", "findBestMatchingRecipe", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "recipes", "validateRitualRequirements", "requiresCat", "hasWeatherCondition", "hasCelestialCondition", "hasCovenCondition", "hasEnoughAltarPower", "validateRitualCircle", "consumeAltarPower", "getAttunedStoneBonus", "findAttunedStone", "loadAdditional", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "findRitualRecipeByType", "ritualTypeId", "loadGlobalPosition", "tag", "getLodestoneDimension", "Ljava/util/Optional;", "Lnet/minecraft/resources/ResourceKey;", "TAG_RITUAL_STATE", "saveAdditional", "registries", "saveGlobalPosition", "addGlobalPosTag", "lodestoneDimension", "clearContent", "getContainerSize", "isEmpty", "getItem", "slot", "removeItem", "amount", "removeItemNoUpdate", "setItem", "stillValid", "Companion", "RitualState", "witchery"})
@SourceDebugExtension(value={"SMAP\nGoldenChalkBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoldenChalkBlockEntity.kt\ndev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1081:1\n1761#2,3:1082\n1869#2,2:1085\n1740#2,2:1088\n1761#2,3:1090\n1742#2:1093\n1563#2:1094\n1634#2,3:1095\n774#2:1098\n865#2:1099\n1740#2,2:1100\n1761#2,3:1102\n1742#2:1105\n866#2:1106\n774#2:1107\n865#2:1108\n1740#2,2:1109\n1761#2,3:1111\n1742#2:1114\n866#2:1115\n1999#2,14:1116\n1761#2,3:1130\n1869#2,2:1133\n1617#2,9:1135\n1869#2:1144\n1870#2:1146\n1626#2:1147\n295#2,2:1148\n1563#2:1150\n1634#2,3:1151\n1803#2,3:1154\n1740#2,3:1157\n1#3:1087\n1#3:1145\n*S KotlinDebug\n*F\n+ 1 GoldenChalkBlockEntity.kt\ndev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity\n*L\n309#1:1082,3\n351#1:1085,2\n485#1:1088,2\n486#1:1090,3\n485#1:1093\n627#1:1094\n627#1:1095,3\n663#1:1098\n663#1:1099\n665#1:1100,2\n666#1:1102,3\n665#1:1105\n663#1:1106\n672#1:1107\n672#1:1108\n674#1:1109,2\n675#1:1111,3\n674#1:1114\n672#1:1115\n681#1:1116,14\n751#1:1130,3\n780#1:1133,2\n937#1:1135,9\n937#1:1144\n937#1:1146\n937#1:1147\n946#1:1148,2\n1013#1:1150\n1013#1:1151,3\n1014#1:1154,3\n1052#1:1157,3\n937#1:1145\n*E\n"})
public final class GoldenChalkBlockEntity
extends WitcheryBaseBlockEntity
implements Container,
AltarPowerConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ResourceLocation pendingRitualTypeId;
    private boolean needsRitualLoad;
    @Nullable
    private BlockPos cachedAltarPos;
    @Nullable
    private UUID targetPlayer;
    @Nullable
    private Integer targetEntity;
    @Nullable
    private GlobalPos targetPos;
    @Nullable
    private String ownerName;
    @NotNull
    private NonNullList<ItemStack> items;
    @NotNull
    private List<EntityType<?>> consumedSacrifices;
    private boolean hasRitualStarted;
    @Nullable
    private RitualRecipe ritualRecipe;
    @NotNull
    private RitualState currentState;
    private boolean isRitualActive;
    private int tickCounter;
    private int ritualTickCounter;
    @NotNull
    private final String TAG_RITUAL_STATE;
    private static final int INVENTORY_SIZE = 16;
    private static final double RITUAL_AREA_RADIUS = 4.0;
    private static final double VERTICAL_RITUAL_AREA = 1.0;
    private static final double COVEN_SEARCH_RADIUS = 16.0;
    private static final double COVEN_SEARCH_HEIGHT = 8.0;
    private static final double ITEM_SEARCH_RADIUS = 3.0;
    private static final int TICK_INTERVAL = 20;
    private static final int ATTUNED_STONE_POWER_BONUS = 2000;
    @NotNull
    private static final String TAG_SHOULD_RUN = "shouldRun";
    @NotNull
    private static final String TAG_SHOULD_CONSUME_SACRIFICES = "shouldStartConsuming";
    @NotNull
    private static final String TAG_SHOULD_CONSUME_ITEMS = "shouldStartConsumingItems";
    @NotNull
    private static final String TAG_IS_RITUAL_ACTIVE = "isRitualActive";
    @NotNull
    private static final String TAG_TICK_COUNTER = "tickCounter";
    @NotNull
    private static final String TAG_RITUAL_TICK_COUNTER = "ritualTickCounter";
    @NotNull
    private static final String TAG_HAS_RITUAL_STARTED = "hasRitualStarted";
    @NotNull
    private static final String TAG_ALTAR_POS = "altarPos";
    @NotNull
    private static final String TAG_RITUAL_ID = "ritualId";
    @NotNull
    private static final String TAG_OWNER_NAME = "ownerName";
    @NotNull
    private static final String TAG_TARGET_PLAYER = "targetPlayer";
    @NotNull
    private static final String TAG_TARGET_ENTITY = "targetEntity";
    @NotNull
    private static final String TAG_GLOBAL_POS = "globalPos";
    @NotNull
    private static final String TAG_TARGET_POS = "targetPos";
    @NotNull
    private static final String TAG_CONSUMED_SACRIFICES = "ConsumedSacrifices";
    @NotNull
    private static final String TAG_DIMENSION = "Dimension";

    public GoldenChalkBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getGOLDEN_CHALK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
        NonNullList nonNullList = NonNullList.withSize((int)16, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        this.consumedSacrifices = new ArrayList();
        this.currentState = RitualState.IDLE;
        this.TAG_RITUAL_STATE = "ritualState";
    }

    @Nullable
    public final UUID getTargetPlayer() {
        return this.targetPlayer;
    }

    public final void setTargetPlayer(@Nullable UUID uUID) {
        this.targetPlayer = uUID;
    }

    @Nullable
    public final Integer getTargetEntity() {
        return this.targetEntity;
    }

    public final void setTargetEntity(@Nullable Integer n) {
        this.targetEntity = n;
    }

    @Nullable
    public final GlobalPos getTargetPos() {
        return this.targetPos;
    }

    public final void setTargetPos(@Nullable GlobalPos globalPos) {
        this.targetPos = globalPos;
    }

    @Nullable
    public final String getOwnerName() {
        return this.ownerName;
    }

    public final void setOwnerName(@Nullable String string) {
        this.ownerName = string;
    }

    @NotNull
    public final NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.items = nonNullList;
    }

    @Nullable
    public final RitualRecipe getRitualRecipe() {
        return this.ritualRecipe;
    }

    public final void setRitualRecipe(@Nullable RitualRecipe ritualRecipe) {
        this.ritualRecipe = ritualRecipe;
    }

    @Override
    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super.tick(level, pos, blockState);
        if (this.pendingRitualTypeId != null && !level.isClientSide) {
            ResourceLocation resourceLocation = this.pendingRitualTypeId;
            Intrinsics.checkNotNull((Object)resourceLocation);
            this.ritualRecipe = this.findRitualRecipeByType(resourceLocation);
            if (this.ritualRecipe != null) {
                this.pendingRitualTypeId = null;
                if (this.hasRitualStarted) {
                    this.needsRitualLoad = true;
                }
            }
        }
        if (this.needsRitualLoad && !level.isClientSide) {
            ResourceLocation ritualType;
            this.needsRitualLoad = false;
            Object object = this.ritualRecipe;
            ResourceLocation resourceLocation = object != null && (object = ((RitualRecipe)object).getRitualType()) != null ? ((Ritual)object).getId() : (ritualType = null);
            if (ritualType != null) {
                Ritual ritual = (Ritual)WitcheryRitualRegistry.INSTANCE.getRITUAL_REGISTRY().get(ritualType);
                if (ritual != null) {
                    ritual.onLoadRitual(level, pos, this);
                }
            } else {
                this.resetRitual();
            }
        }
        if (level.isClientSide || this.currentState == RitualState.IDLE) {
            return;
        }
        int n = this.tickCounter;
        this.tickCounter = n + 1;
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentState.ordinal()]) {
            case 1: {
                this.processItemConsumption(level);
                break;
            }
            case 2: {
                this.processSacrificeConsumption(level);
                break;
            }
            case 3: {
                this.processActiveRitual(level);
            }
        }
    }

    private final void processActiveRitual(Level level) {
        int n = this.ritualTickCounter;
        this.ritualTickCounter = n + 1;
        if (this.ritualRecipe != null) {
            RitualRecipe ritualRecipe = this.ritualRecipe;
            Intrinsics.checkNotNull((Object)ritualRecipe);
            if (ritualRecipe.getAltarPowerPerSecond() > 0 && this.ritualTickCounter % 20 == 0) {
                RitualRecipe ritualRecipe2 = this.ritualRecipe;
                Intrinsics.checkNotNull((Object)ritualRecipe2);
                if (!this.consumeAltarPower(level, ritualRecipe2)) {
                    Witchery.Companion.logDebugRitual("Insufficient altar power per second, ritual ending");
                    this.resetRitual();
                    return;
                }
            }
        }
        this.onTickRitual(level);
        if (this.ritualRecipe != null) {
            RitualRecipe ritualRecipe = this.ritualRecipe;
            Intrinsics.checkNotNull((Object)ritualRecipe);
            if (this.tickCounter >= ritualRecipe.getTicks()) {
                RitualRecipe ritualRecipe3 = this.ritualRecipe;
                Intrinsics.checkNotNull((Object)ritualRecipe3);
                if (!ritualRecipe3.isInfinite()) {
                    this.onEndRitual(level);
                    this.resetRitual();
                }
            }
        }
        this.setChanged();
    }

    private final void onStartRitual(Level level) {
        if (!this.hasRitualStarted) {
            boolean ritualSuccess;
            Object object;
            level.playSound(null, this.getBlockPos(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (this.ritualRecipe != null) {
                RitualRecipe ritualRecipe = this.ritualRecipe;
                Intrinsics.checkNotNull((Object)ritualRecipe);
                if (ritualRecipe.getAltarPower() > 0) {
                    int attunedStoneBonus = this.getAttunedStoneBonus(level);
                    List<ItemEntity> maybeAttunedItem = this.findAttunedStone(level);
                    RitualRecipe ritualRecipe2 = this.ritualRecipe;
                    Intrinsics.checkNotNull((Object)ritualRecipe2);
                    int requiredAltarPower = Mth.clamp((int)(ritualRecipe2.getAltarPower() - attunedStoneBonus), (int)0, (int)Integer.MAX_VALUE);
                    if (requiredAltarPower > 0 && this.cachedAltarPos != null) {
                        BlockPos blockPos = this.cachedAltarPos;
                        Intrinsics.checkNotNull((Object)blockPos);
                        boolean success = this.tryConsumeAltarPower(level, blockPos, requiredAltarPower, false);
                        if (!success) {
                            Witchery.Companion.logDebugRitual("Failed to consume initial altar power, ritual aborted");
                            this.resetRitual();
                            return;
                        }
                        if (success && !((Collection)maybeAttunedItem).isEmpty()) {
                            maybeAttunedItem.get(0).getItem().remove((DataComponentType)WitcheryDataComponents.INSTANCE.getATTUNED().get());
                        }
                    }
                }
            }
            if ((object = this.ritualRecipe) == null || (object = ((RitualRecipe)object).getRitualType()) == null || (object = ((Ritual)object).getId()) == null) {
                return;
            }
            Object ritualType = object;
            Ritual ritual = (Ritual)WitcheryRitualRegistry.INSTANCE.getRITUAL_REGISTRY().get((ResourceLocation)ritualType);
            if (ritual != null) {
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                v6 = ritual.onStartRitual(level, blockPos, this);
            } else {
                v6 = ritualSuccess = true;
            }
            if (!ritualSuccess) {
                Witchery.Companion.logDebugRitual("Ritual onStartRitual returned false, canceling ritual and dropping items");
                this.cancelRitualAndDropItems(level);
                return;
            }
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            RitualHelper.INSTANCE.runCommand(level, blockPos, this, "start");
            this.isRitualActive = true;
            this.currentState = RitualState.ACTIVE;
            this.hasRitualStarted = true;
            this.setChanged();
        }
    }

    private final void cancelRitualAndDropItems(Level level) {
        Containers.dropContents((Level)level, (BlockPos)this.getBlockPos(), (Container)this);
        level.playSound(null, this.getBlockPos(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.resetRitual();
    }

    private final void onTickRitual(Level level) {
        Object object = this.ritualRecipe;
        if (object == null || (object = ((RitualRecipe)object).getRitualType()) == null || (object = ((Ritual)object).getId()) == null) {
            return;
        }
        Object ritualType = object;
        Ritual ritual = (Ritual)WitcheryRitualRegistry.INSTANCE.getRITUAL_REGISTRY().get((ResourceLocation)ritualType);
        if (ritual != null) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            ritual.onTickRitual(level, blockPos, this);
        }
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        RitualHelper.INSTANCE.runCommand(level, blockPos, this, "tick");
    }

    private final void onEndRitual(Level level) {
        Object object = this.ritualRecipe;
        if (object == null || (object = ((RitualRecipe)object).getRitualType()) == null || (object = ((Ritual)object).getId()) == null) {
            return;
        }
        Object ritualType = object;
        Ritual ritual = (Ritual)WitcheryRitualRegistry.INSTANCE.getRITUAL_REGISTRY().get((ResourceLocation)ritualType);
        if (ritual != null) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            ritual.onEndRitual(level, blockPos, this);
        }
        level.playSound(null, this.getBlockPos(), SoundEvents.END_PORTAL_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        RitualHelper.INSTANCE.runCommand(level, blockPos, this, "end");
        BlockPos blockPos2 = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        RitualHelper.INSTANCE.summonItems(level, blockPos2, this);
        BlockPos blockPos3 = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"getBlockPos(...)");
        RitualHelper.INSTANCE.summonSummons(level, blockPos3, this);
        this.items.clear();
        this.setChanged();
    }

    private final void processSacrificeConsumption(Level level) {
        Object recipeEntities;
        Object object = this.ritualRecipe;
        if (object == null || (object = ((RitualRecipe)object).getInputEntities()) == null) {
            object = CollectionsKt.emptyList();
        }
        if ((recipeEntities = object).isEmpty()) {
            this.onStartRitual(level);
            return;
        }
        if (this.consumedSacrifices.size() == recipeEntities.size()) {
            return;
        }
        if (this.tickCounter % 20 == 0) {
            List<LivingEntity> entities = this.getSacrificeEntities(level);
            LivingEntity matchingEntity = this.findNextRequiredSacrifice((List<? extends LivingEntity>)entities, (List<? extends EntityType<?>>)recipeEntities);
            if (matchingEntity != null) {
                this.consumeSacrifice(matchingEntity);
                if (this.consumedSacrifices.containsAll((Collection)recipeEntities)) {
                    this.onStartRitual(level);
                }
            } else {
                this.resetRitual();
            }
        }
    }

    private final List<LivingEntity> getSacrificeEntities(Level level) {
        List list = level.getEntitiesOfClass(LivingEntity.class, new AABB(this.getBlockPos()).inflate(4.0, 1.0, 4.0), arg_0 -> GoldenChalkBlockEntity.getSacrificeEntities$lambda$1(GoldenChalkBlockEntity::getSacrificeEntities$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        return list;
    }

    private final LivingEntity findNextRequiredSacrifice(List<? extends LivingEntity> entities, List<? extends EntityType<?>> requiredTypes) {
        Object v1;
        block5: {
            Iterable iterable = entities;
            for (Object t : iterable) {
                boolean bl;
                block4: {
                    LivingEntity entity = (LivingEntity)t;
                    boolean bl2 = false;
                    Iterable $this$any$iv = requiredTypes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            EntityType requiredType = (EntityType)element$iv;
                            boolean bl3 = false;
                            if (!(Intrinsics.areEqual((Object)entity.getType(), (Object)requiredType) && !this.consumedSacrifices.contains(entity.getType()))) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    private final void consumeSacrifice(LivingEntity entity) {
        entity.kill();
        EntityType entityType = entity.getType();
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
        this.consumedSacrifices.add(entityType);
        this.setChanged();
    }

    private final void processItemConsumption(Level level) {
        Object object = this.ritualRecipe;
        if (object == null || (object = ((RitualRecipe)object).getInputItems()) == null) {
            return;
        }
        Object recipeItems = object;
        if (this.tickCounter % 20 == 0) {
            List consumedItems = new ArrayList();
            boolean consumedFromEntity = false;
            List<ItemEntity> itemEntities = this.getItemEntities(level);
            for (ItemEntity itemEntity : itemEntities) {
                if (!this.tryConsumeFromItemEntity(itemEntity, (List<ItemStack>)recipeItems, consumedItems)) continue;
                consumedFromEntity = true;
                break;
            }
            if (!consumedFromEntity) {
                GrassperBlockEntity grassper;
                List<Pair<BlockPos, GrassperBlockEntity>> grasspers = this.findNearbyGrasspers(level);
                Iterator<Pair<BlockPos, GrassperBlockEntity>> iterator = grasspers.iterator();
                while (iterator.hasNext() && !this.tryConsumeFromGrassper(grassper = (GrassperBlockEntity)((Object)iterator.next().component2()), (List<ItemStack>)recipeItems, consumedItems)) {
                }
            }
            Iterable $this$forEach$iv = consumedItems;
            boolean bl = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl2 = false;
                this.addItemToInventory(this.items, it);
            }
            if (this.itemsMatchRecipe(this.items, (List<ItemStack>)recipeItems)) {
                this.currentState = RitualState.CONSUMING_SACRIFICES;
                this.setChanged();
            } else if (itemEntities.isEmpty() && this.findNearbyGrasspers(level).isEmpty()) {
                this.resetRitual();
            }
        }
    }

    private final List<ItemEntity> getItemEntities(Level level) {
        List list = level.getEntities((EntityTypeTest)EntityType.ITEM, new AABB(this.getBlockPos()).inflate(3.0, 0.0, 3.0), arg_0 -> GoldenChalkBlockEntity.getItemEntities$lambda$1(GoldenChalkBlockEntity::getItemEntities$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
        return list;
    }

    private final List<Pair<BlockPos, GrassperBlockEntity>> findNearbyGrasspers(Level level) {
        List<Object> list = BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)this.getBlockPos().getCenter(), (double)4.0, (double)4.0, (double)4.0)).filter(arg_0 -> GoldenChalkBlockEntity.findNearbyGrasspers$lambda$1(arg_0 -> GoldenChalkBlockEntity.findNearbyGrasspers$lambda$0(level, arg_0), arg_0)).map(arg_0 -> GoldenChalkBlockEntity.findNearbyGrasspers$lambda$3(arg_0 -> GoldenChalkBlockEntity.findNearbyGrasspers$lambda$2(level, arg_0), arg_0)).filter(arg_0 -> GoldenChalkBlockEntity.findNearbyGrasspers$lambda$5(GoldenChalkBlockEntity::findNearbyGrasspers$lambda$4, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    private final boolean tryConsumeFromItemEntity(ItemEntity itemEntity, List<ItemStack> recipeItems, List<ItemStack> consumedItems) {
        block4: {
            Object v0;
            ItemStack stack;
            block3: {
                stack = itemEntity.getItem();
                Iterable iterable = recipeItems;
                for (Object t : iterable) {
                    ItemStack recipeItem = (ItemStack)t;
                    boolean bl = false;
                    if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)recipeItem)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((ItemStack)v0 == null) {
                return false;
            }
            ItemStack itemStack = stack.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            consumedItems.add(itemStack);
            Intrinsics.checkNotNull((Object)stack);
            this.addWaystoneOrTaglockToContext(stack);
            stack.shrink(1);
            if (stack.isEmpty()) {
                itemEntity.remove(Entity.RemovalReason.DISCARDED);
            }
            Level level = this.level;
            if (level == null) break block4;
            level.playSound(null, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
        }
        return true;
    }

    private final boolean tryConsumeFromGrassper(GrassperBlockEntity grassper, List<ItemStack> recipeItems, List<ItemStack> consumedItems) {
        block3: {
            Object v0;
            ItemStack grassperItem;
            block2: {
                grassperItem = ((ItemStack)grassper.getItem().get(0)).copy();
                Iterable iterable = recipeItems;
                for (Object t : iterable) {
                    ItemStack recipeItem = (ItemStack)t;
                    boolean bl = false;
                    if (!ItemStack.isSameItem((ItemStack)grassperItem, (ItemStack)recipeItem)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((ItemStack)v0 == null) {
                return false;
            }
            Intrinsics.checkNotNull((Object)grassperItem);
            consumedItems.add(grassperItem);
            ((ItemStack)grassper.getItem().get(0)).shrink(1);
            grassper.setChanged();
            this.addWaystoneOrTaglockToContext(grassperItem);
            Level level = this.level;
            if (level == null) break block3;
            level.playSound(null, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
        }
        return true;
    }

    private final void addWaystoneOrTaglockToContext(ItemStack stack) {
        block2: {
            if (stack.is((Item)WitcheryItems.INSTANCE.getWAYSTONE().get())) {
                this.targetPos = WaystoneItem.Companion.getGlobalPos(stack);
            }
            if (!stack.is((Item)WitcheryItems.INSTANCE.getTAGLOCK().get())) break block2;
            Level level = this.level;
            if (level != null) {
                Level safeLevel = level;
                boolean bl = false;
                Player player = TaglockItem.Companion.getPlayer(safeLevel, stack);
                this.targetPlayer = player != null ? player.getUUID() : null;
                LivingEntity livingEntity = TaglockItem.Companion.getLivingEntity(safeLevel, stack);
                this.targetEntity = livingEntity != null ? Integer.valueOf(livingEntity.getId()) : null;
            }
        }
    }

    private final void resetRitual() {
        if (!this.hasRitualStarted) {
            Level level = this.level;
            if (level != null) {
                Level it = level;
                boolean bl = false;
                Containers.dropContents((Level)it, (BlockPos)this.getBlockPos(), (Container)this);
            }
        }
        NonNullList nonNullList = NonNullList.withSize((int)16, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        this.consumedSacrifices = new ArrayList();
        this.ritualRecipe = null;
        this.currentState = RitualState.IDLE;
        this.isRitualActive = false;
        this.hasRitualStarted = false;
        this.tickCounter = 0;
        this.ritualTickCounter = 0;
        this.targetPlayer = null;
        this.targetEntity = null;
        this.targetPos = null;
        this.ownerName = null;
        this.setChanged();
    }

    private final boolean itemsMatchRecipe(NonNullList<ItemStack> items, List<ItemStack> recipeItems) {
        boolean bl;
        block7: {
            Iterable $this$all$iv = recipeItems;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    block6: {
                        ItemStack recipeItem = (ItemStack)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv = (Iterable)items;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                ItemStack inventoryItem = (ItemStack)element$iv2;
                                boolean bl4 = false;
                                if (!(ItemStack.isSameItem((ItemStack)inventoryItem, (ItemStack)recipeItem) && inventoryItem.getCount() >= recipeItem.getCount())) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void addItemToInventory(NonNullList<ItemStack> items, ItemStack stack) {
        int i;
        int n = ((Collection)items).size();
        for (i = 0; i < n; ++i) {
            if (!ItemStack.isSameItem((ItemStack)((ItemStack)items.get(i)), (ItemStack)stack)) continue;
            ((ItemStack)items.get(i)).grow(1);
            stack.shrink(1);
            if (!stack.isEmpty()) continue;
            return;
        }
        n = ((Collection)items).size();
        for (i = 0; i < n; ++i) {
            if (!((ItemStack)items.get(i)).isEmpty()) continue;
            items.set(i, (Object)stack.copy());
            return;
        }
    }

    @Override
    @NotNull
    public InteractionResult onUseWithoutItem(@NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        if (WitcheryApi.INSTANCE.isInSpiritWorld(pPlayer)) {
            return InteractionResult.PASS;
        }
        if (this.ritualRecipe != null && pPlayer.isShiftKeyDown()) {
            this.items.clear();
            this.resetRitual();
            Witchery.Companion.logDebugRitual("Ritual reset by player " + pPlayer.getName().getString() + ".");
            return InteractionResult.SUCCESS;
        }
        Level level = pPlayer.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this.updateAltarCache(level);
        if (this.ritualRecipe == null && this.level instanceof ServerLevel) {
            this.tryStartRitual(pPlayer);
        }
        return super.onUseWithoutItem(pPlayer);
    }

    private final void updateAltarCache(Level level) {
        if (this.cachedAltarPos == null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.cachedAltarPos = this.getAltarPos(serverLevel, blockPos);
            this.setChanged();
            Witchery.Companion.logDebugRitual("Cached altar position updated: " + this.cachedAltarPos + ".");
        }
    }

    private final void tryStartRitual(Player player) {
        Witchery.Companion.logDebugRitual("No current ritual recipe found. Searching for valid recipes.");
        Level level = player.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        List<ItemStack> items = this.collectNearbyItems(level);
        Level level2 = player.level();
        Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
        List<LivingEntity> entities = this.collectNearbyEntities(level2);
        Witchery.Companion.logDebugRitual("Found " + items.size() + " items and " + entities.size() + " entities near block position " + this.getBlockPos() + ".");
        Level level3 = this.level;
        List recipes = level3 != null && (level3 = level3.getRecipeManager()) != null ? level3.getAllRecipesFor((RecipeType)WitcheryRecipeTypes.INSTANCE.getRITUAL_RECIPE_TYPE().get()) : null;
        RecipeHolder<RitualRecipe> selectedRecipe = this.findBestMatchingRecipe(recipes, items, entities);
        if (selectedRecipe != null) {
            Witchery.Companion.logDebugRitual("Selected recipe: " + selectedRecipe.value() + " with inputs: " + ((RitualRecipe)selectedRecipe.value()).getInputItems().size() + " items and " + ((RitualRecipe)selectedRecipe.value()).getInputEntities().size() + " entities.");
            if (!((Boolean)WitcheryConfig.ENABLE_CURSES.get()).booleanValue()) {
                Recipe recipe = selectedRecipe.value();
                Intrinsics.checkNotNullExpressionValue((Object)recipe, (String)"value(...)");
                if (RitualHelper.INSTANCE.usesCurseCommands((RitualRecipe)recipe)) {
                    Witchery.Companion.logDebugRitual("Ritual failed: Curses are disabled in config");
                    player.displayClientMessage((Component)Component.translatable((String)"witchery.ritual.curses_disabled").withStyle(ChatFormatting.RED), true);
                    this.playRitualFailureSound(player);
                    return;
                }
            }
            Level level4 = this.level;
            Intrinsics.checkNotNull((Object)level4);
            Recipe recipe = selectedRecipe.value();
            Intrinsics.checkNotNullExpressionValue((Object)recipe, (String)"value(...)");
            if (this.validateRitualRequirements(player, level4, (RitualRecipe)recipe)) {
                Recipe recipe2 = selectedRecipe.value();
                Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"value(...)");
                this.startRitual(player, (RitualRecipe)recipe2);
            } else {
                Witchery.Companion.logDebugRitual("Ritual failed due to unmet conditions.");
                this.playRitualFailureSound(player);
            }
        } else {
            Witchery.Companion.logDebugRitual("No valid rituals found. Extinguishing ritual.");
            this.playRitualFailureSound(player);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void startRitual(Player player, RitualRecipe recipe) {
        String string;
        GoldenChalkBlockEntity goldenChalkBlockEntity = this;
        String string2 = player.getGameProfile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string2;
        if (((CharSequence)string3).length() > 0) {
            void p0;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            GoldenChalkBlockEntity goldenChalkBlockEntity2 = goldenChalkBlockEntity;
            boolean bl = false;
            String string4 = String.valueOf((char)p0);
            Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
            String string5 = string4.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            String string6 = string5;
            goldenChalkBlockEntity = goldenChalkBlockEntity2;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string6);
            String string7 = string3;
            int n = 1;
            String string8 = string7.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
            string = stringBuilder2.append(string8).toString();
        } else {
            string = string3;
        }
        goldenChalkBlockEntity.ownerName = string;
        this.ritualRecipe = recipe;
        this.currentState = RitualState.CONSUMING_ITEMS;
        this.setChanged();
        Witchery.Companion.logDebugRitual("Ritual started by " + player.getName().getString() + " with recipe " + this.ritualRecipe + ".");
        this.playRitualStartSound(player);
    }

    private final void playRitualStartSound(Player player) {
        block1: {
            Level level = this.level;
            if (level != null) {
                level.playSound(player, this.getBlockPos(), (SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), SoundSource.BLOCKS);
            }
            Level level2 = this.level;
            if (level2 == null) break block1;
            level2.playSound(null, this.getBlockPos(), (SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), SoundSource.BLOCKS);
        }
    }

    private final void playRitualFailureSound(Player player) {
        block1: {
            Level level = this.level;
            if (level != null) {
                level.playSound(player, this.getBlockPos(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS);
            }
            Level level2 = this.level;
            if (level2 == null) break block1;
            level2.playSound(null, this.getBlockPos(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ItemStack> collectNearbyItems(Level level) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List result = new ArrayList();
        Iterable iterable = level.getEntities((EntityTypeTest)EntityType.ITEM, new AABB(this.getBlockPos()).inflate(3.0, 0.0, 3.0), arg_0 -> GoldenChalkBlockEntity.collectNearbyItems$lambda$1(GoldenChalkBlockEntity::collectNearbyItems$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getEntities(...)");
        iterable = iterable;
        List list = result;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemEntity itemEntity = (ItemEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getItem());
        }
        list.addAll((List)destination$iv$iv);
        BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)this.getBlockPos().getCenter(), (double)4.0, (double)4.0, (double)4.0)).filter(arg_0 -> GoldenChalkBlockEntity.collectNearbyItems$lambda$4(arg_0 -> GoldenChalkBlockEntity.collectNearbyItems$lambda$3(level, arg_0), arg_0)).map(arg_0 -> GoldenChalkBlockEntity.collectNearbyItems$lambda$6(arg_0 -> GoldenChalkBlockEntity.collectNearbyItems$lambda$5(level, arg_0), arg_0)).filter(arg_0 -> GoldenChalkBlockEntity.collectNearbyItems$lambda$8(GoldenChalkBlockEntity::collectNearbyItems$lambda$7, arg_0)).forEach(arg_0 -> GoldenChalkBlockEntity.collectNearbyItems$lambda$10(arg_0 -> GoldenChalkBlockEntity.collectNearbyItems$lambda$9(result, arg_0), arg_0));
        return result;
    }

    private final List<LivingEntity> collectNearbyEntities(Level level) {
        List list = level.getEntitiesOfClass(LivingEntity.class, new AABB(this.getBlockPos()).inflate(4.0, 1.0, 4.0), arg_0 -> GoldenChalkBlockEntity.collectNearbyEntities$lambda$1(GoldenChalkBlockEntity::collectNearbyEntities$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        return list;
    }

    /*
     * Unable to fully structure code
     */
    private final RecipeHolder<RitualRecipe> findBestMatchingRecipe(List<RecipeHolder<RitualRecipe>> recipes, List<ItemStack> items, List<? extends LivingEntity> entities) {
        v0 = recipes;
        if (v0 != null) {
            $this$filter$iv = v0;
            $i$f$filter = false;
            var8_6 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block24: {
                    recipe = (RecipeHolder)element$iv$iv;
                    $i$a$-filter-GoldenChalkBlockEntity$findBestMatchingRecipe$validItemRecipes$1 = false;
                    recipeItems = ((RitualRecipe)recipe.value()).getInputItems();
                    $this$all$iv = recipeItems;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v1 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            block23: {
                                recipeItem = (ItemStack)element$iv;
                                $i$a$-all-GoldenChalkBlockEntity$findBestMatchingRecipe$validItemRecipes$1$1 = false;
                                $this$any$iv = items;
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    v2 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        itemStack = (ItemStack)element$iv;
                                        $i$a$-any-GoldenChalkBlockEntity$findBestMatchingRecipe$validItemRecipes$1$1$1 = false;
                                        if (!ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)recipeItem)) continue;
                                        v2 = true;
                                        break block23;
                                    }
                                    v2 = false;
                                }
                            }
                            if (v2) continue;
                            v1 = false;
                            break block24;
                        }
                        v1 = true;
                    }
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return null;
        }
        validItemRecipes = (List)destination$iv$iv;
        Witchery.Companion.logDebugRitual("Filtered valid item recipes: " + validItemRecipes.size() + " found.");
        $this$filter$iv = validItemRecipes;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block26: {
                recipe = (RecipeHolder)element$iv$iv;
                $i$a$-filter-GoldenChalkBlockEntity$findBestMatchingRecipe$validSacrificesAndItemsRecipe$1 = false;
                requiredSacrifices = ((RitualRecipe)recipe.value()).getInputEntities();
                if (requiredSacrifices.isEmpty()) ** GOTO lbl-1000
                $this$all$iv = requiredSacrifices;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v3 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        block25: {
                            requiredEntity = (EntityType)element$iv;
                            $i$a$-all-GoldenChalkBlockEntity$findBestMatchingRecipe$validSacrificesAndItemsRecipe$1$1 = false;
                            $this$any$iv = entities;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v4 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    entity = (LivingEntity)element$iv;
                                    $i$a$-any-GoldenChalkBlockEntity$findBestMatchingRecipe$validSacrificesAndItemsRecipe$1$1$1 = false;
                                    if (!Intrinsics.areEqual((Object)entity.getType(), (Object)requiredEntity)) continue;
                                    v4 = true;
                                    break block25;
                                }
                                v4 = false;
                            }
                        }
                        if (v4) continue;
                        v3 = false;
                        break block26;
                    }
                    v3 = true;
                }
            }
            if (v3) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        validSacrificesAndItemsRecipe = (List)destination$iv$iv;
        Witchery.Companion.logDebugRitual("Filtered valid item and entity recipes: " + validSacrificesAndItemsRecipe.size() + " found.");
        $this$maxByOrNull$iv = validSacrificesAndItemsRecipe;
        $i$f$maxByOrNull = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v6 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v6 = maxElem$iv;
            } else {
                recipe = (RecipeHolder)maxElem$iv;
                $i$a$-maxByOrNull-GoldenChalkBlockEntity$findBestMatchingRecipe$1 = false;
                maxValue$iv = ((RitualRecipe)recipe.value()).getInputItems().size() + ((RitualRecipe)recipe.value()).getInputEntities().size();
                do {
                    e$iv = iterator$iv.next();
                    recipe = (RecipeHolder)e$iv;
                    $i$a$-maxByOrNull-GoldenChalkBlockEntity$findBestMatchingRecipe$1 = false;
                    v$iv = ((RitualRecipe)recipe.value()).getInputItems().size() + ((RitualRecipe)recipe.value()).getInputEntities().size();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v6 = maxElem$iv;
            }
        }
        return v6;
    }

    private final boolean validateRitualRequirements(Player player, Level level, RitualRecipe recipe) {
        boolean hasValidCircle = this.validateRitualCircle(level, recipe);
        boolean hasEnoughPower = this.hasEnoughAltarPower(level, recipe);
        boolean meetsCelestialCondition = this.hasCelestialCondition(level, recipe);
        boolean meetsWeatherRequirement = this.hasWeatherCondition(level, recipe);
        boolean requiresCat = this.requiresCat(player, recipe);
        boolean hasCovenCount = this.hasCovenCondition(player, recipe);
        Witchery.Companion.logDebugRitual("Ritual conditions - Valid Circle: " + hasValidCircle + ", Enough Power: " + hasEnoughPower + " : " + recipe.getAltarPower() + ", Celestial Condition: " + meetsCelestialCondition + ", Coven Condition: " + hasCovenCount + ", Cat: " + requiresCat + ", Weather Condition: " + meetsWeatherRequirement);
        return hasValidCircle && hasEnoughPower && meetsCelestialCondition && hasCovenCount && meetsWeatherRequirement && requiresCat;
    }

    private final boolean requiresCat(Player player, RitualRecipe recipe) {
        if (!recipe.getRequireCat()) {
            return true;
        }
        if (player.level() instanceof ServerLevel) {
            UUID uUID = player.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            return Intrinsics.areEqual(FamiliarHandler.INSTANCE.getFamiliarEntityType(uUID, (ServerLevel)level), (Object)EntityType.CAT);
        }
        return false;
    }

    private final boolean hasWeatherCondition(Level level, RitualRecipe recipe) {
        if (recipe.getWeather().isEmpty()) {
            return true;
        }
        boolean rain = level.isRaining();
        boolean thunder = level.isThundering();
        boolean clear = !rain && !thunder;
        return recipe.getWeather().contains((Object)RitualRecipe.Weather.CLEAR) ? clear : (recipe.getWeather().contains((Object)RitualRecipe.Weather.STORM) ? thunder : (recipe.getWeather().contains((Object)RitualRecipe.Weather.RAIN) ? rain || thunder : false));
    }

    private final boolean hasCelestialCondition(Level level, RitualRecipe recipe) {
        boolean bl;
        block12: {
            if (recipe.getCelestialConditions().isEmpty()) {
                return true;
            }
            Iterable $this$any$iv = recipe.getCelestialConditions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RitualRecipe.Celestial condition = (RitualRecipe.Celestial)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(switch (WhenMappings.$EnumSwitchMapping$1[condition.ordinal()]) {
                        case 1 -> RitualHelper.INSTANCE.isDaytime(level);
                        case 2 -> RitualHelper.INSTANCE.isFullMoon(level);
                        case 3 -> RitualHelper.INSTANCE.isNewMoon(level);
                        case 4 -> RitualHelper.INSTANCE.isNighttime(level);
                        case 5 -> RitualHelper.INSTANCE.isWaxing(level);
                        case 6 -> RitualHelper.INSTANCE.isWaning(level);
                        default -> throw new NoWhenBranchMatchedException();
                    })) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasCovenCondition(Player player, RitualRecipe recipe) {
        if (recipe.getCovenCount() == 0) {
            return true;
        }
        List witches = player.level().getEntities((EntityTypeTest)WitcheryEntityTypes.INSTANCE.getCOVEN_WITCH().get(), new AABB(this.getBlockPos()).inflate(16.0, 8.0, 16.0), arg_0 -> GoldenChalkBlockEntity.hasCovenCondition$lambda$1(GoldenChalkBlockEntity::hasCovenCondition$lambda$0, arg_0));
        Intrinsics.checkNotNull((Object)witches);
        Iterable $this$forEach$iv = witches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CovenWitchEntity it = (CovenWitchEntity)((Object)element$iv);
            boolean bl = false;
            if (it == null) continue;
            Optional<BlockPos> optional = Optional.of(this.getBlockPos());
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            it.setLastRitualPos(optional);
        }
        if (witches.size() >= recipe.getCovenCount()) {
            return true;
        }
        if (player.getInventory().contains(GoldenChalkBlockEntity::hasCovenCondition$lambda$3)) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            int activeWitches = CovenHandler.INSTANCE.getActiveCovenSize(player, blockPos);
            if (activeWitches >= recipe.getCovenCount()) {
                Level level = this.level;
                if (level != null) {
                    Level safeLevel = level;
                    boolean bl = false;
                    SeerStoneItem.Companion.summonWitchesAroundCircle(player, safeLevel, activeWitches);
                }
                return true;
            }
        }
        player.displayClientMessage((Component)Component.translatable((String)"witchery.too_few_in_coven"), true);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasEnoughAltarPower(Level level, RitualRecipe recipe) {
        int requiredAltarPower;
        int attunedStoneBonus = this.getAttunedStoneBonus(level);
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            if (!(level.getBlockEntity(blockPos) instanceof AltarBlockEntity)) {
                this.cachedAltarPos = null;
                this.setChanged();
                return false;
            }
        }
        if ((requiredAltarPower = Mth.clamp((int)(recipe.getAltarPower() - attunedStoneBonus), (int)0, (int)Integer.MAX_VALUE)) <= 0) {
            return true;
        }
        if (this.cachedAltarPos == null) return false;
        BlockPos blockPos = this.cachedAltarPos;
        Intrinsics.checkNotNull((Object)blockPos);
        if (!this.tryConsumeAltarPower(level, blockPos, requiredAltarPower, true)) return false;
        return true;
    }

    private final boolean validateRitualCircle(Level level, RitualRecipe recipe) {
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return RitualPatternUtil.INSTANCE.matchesPattern(level, blockPos, recipe);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean consumeAltarPower(Level level, RitualRecipe recipe) {
        if (recipe.getAltarPowerPerSecond() <= 0) {
            return true;
        }
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            if (!(level.getBlockEntity(blockPos) instanceof AltarBlockEntity)) {
                this.cachedAltarPos = null;
                this.setChanged();
                return false;
            }
        }
        if (this.cachedAltarPos == null) return false;
        BlockPos blockPos = this.cachedAltarPos;
        Intrinsics.checkNotNull((Object)blockPos);
        if (!this.tryConsumeAltarPower(level, blockPos, recipe.getAltarPowerPerSecond(), false)) return false;
        return true;
    }

    private final int getAttunedStoneBonus(Level level) {
        List<ItemEntity> maybeAttunedItem = this.findAttunedStone(level);
        return !((Collection)maybeAttunedItem).isEmpty() ? 2000 : 0;
    }

    private final List<ItemEntity> findAttunedStone(Level level) {
        List list = level.getEntities((EntityTypeTest)EntityType.ITEM, new AABB(this.getBlockPos()).inflate(3.0, 0.0, 3.0), arg_0 -> GoldenChalkBlockEntity.findAttunedStone$lambda$1(GoldenChalkBlockEntity::findAttunedStone$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object ritualTypeId;
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        this.currentState = pTag.getBoolean(TAG_SHOULD_RUN) ? (pTag.getBoolean(TAG_IS_RITUAL_ACTIVE) ? RitualState.ACTIVE : (pTag.getBoolean(TAG_SHOULD_CONSUME_SACRIFICES) ? RitualState.CONSUMING_SACRIFICES : (pTag.getBoolean(TAG_SHOULD_CONSUME_ITEMS) ? RitualState.CONSUMING_ITEMS : RitualState.IDLE))) : RitualState.IDLE;
        this.isRitualActive = pTag.getBoolean(TAG_IS_RITUAL_ACTIVE);
        this.tickCounter = pTag.getInt(TAG_TICK_COUNTER);
        this.ritualTickCounter = pTag.getInt(TAG_RITUAL_TICK_COUNTER);
        this.hasRitualStarted = pTag.getBoolean(TAG_HAS_RITUAL_STARTED);
        if (pTag.contains(TAG_ALTAR_POS)) {
            Optional optional = NbtUtils.readBlockPos((CompoundTag)pTag, (String)TAG_ALTAR_POS);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"readBlockPos(...)");
            this.cachedAltarPos = (BlockPos)OptionalsKt.getOrNull((Optional)optional);
        }
        if (pTag.contains(TAG_RITUAL_ID)) {
            this.pendingRitualTypeId = ritualTypeId = ResourceLocation.parse((String)pTag.getString(TAG_RITUAL_ID));
            Intrinsics.checkNotNull((Object)ritualTypeId);
            this.ritualRecipe = this.findRitualRecipeByType((ResourceLocation)ritualTypeId);
            if (this.ritualRecipe != null) {
                this.pendingRitualTypeId = null;
                if (pTag.contains(this.TAG_RITUAL_STATE) && this.level != null) {
                    CompoundTag ritualStateTag = pTag.getCompound(this.TAG_RITUAL_STATE);
                    Ritual ritual = (Ritual)WitcheryRitualRegistry.INSTANCE.getRITUAL_REGISTRY().get(ritualTypeId);
                    if (ritual != null) {
                        Level level = this.level;
                        Intrinsics.checkNotNull((Object)level);
                        BlockPos blockPos = this.getBlockPos();
                        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                        Intrinsics.checkNotNull((Object)ritualStateTag);
                        ritual.loadState(level, blockPos, this, ritualStateTag);
                    }
                }
                if (this.hasRitualStarted) {
                    this.needsRitualLoad = true;
                }
            }
        }
        if (pTag.contains(TAG_OWNER_NAME)) {
            this.ownerName = pTag.getString(TAG_OWNER_NAME);
        }
        if (pTag.contains(TAG_TARGET_PLAYER)) {
            this.targetPlayer = pTag.getUUID(TAG_TARGET_PLAYER);
        }
        if (pTag.contains(TAG_TARGET_ENTITY)) {
            this.targetEntity = pTag.getInt(TAG_TARGET_ENTITY);
        }
        if (pTag.contains(TAG_GLOBAL_POS)) {
            this.loadGlobalPosition(pTag);
        }
        ListTag listTag = pTag.getList(TAG_CONSUMED_SACRIFICES, 8);
        Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"getList(...)");
        ritualTypeId = (Iterable)listTag;
        GoldenChalkBlockEntity goldenChalkBlockEntity = this;
        boolean $i$f$mapNotNull = false;
        void var5_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EntityType it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Tag it = (Tag)element$iv$iv;
            boolean bl2 = false;
            Optional optional = EntityType.byString((String)it.getAsString());
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"byString(...)");
            if ((EntityType)OptionalsKt.getOrNull((Optional)optional) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        goldenChalkBlockEntity.consumedSacrifices = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final RitualRecipe findRitualRecipeByType(ResourceLocation ritualTypeId) {
        Object v7;
        List list;
        block1: {
            List allRecipes;
            Level level = this.level;
            Level level2 = level;
            if (level == null) return null;
            RecipeManager recipeManager = level2.getRecipeManager();
            level2 = recipeManager;
            if (recipeManager == null) return null;
            List list2 = level2.getAllRecipesFor((RecipeType)WitcheryRecipeTypes.INSTANCE.getRITUAL_RECIPE_TYPE().get());
            List list3 = allRecipes = list2;
            list = list3;
            if (list3 == null) return null;
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RecipeHolder it = (RecipeHolder)element$iv;
                boolean bl = false;
                Ritual ritual = ((RitualRecipe)it.value()).getRitualType();
                if (!Intrinsics.areEqual((Object)(ritual != null ? ritual.getId() : null), (Object)ritualTypeId)) continue;
                v7 = element$iv;
                break block1;
            }
            v7 = null;
        }
        RecipeHolder recipeHolder = v7;
        list = recipeHolder;
        if (recipeHolder == null) return null;
        RitualRecipe ritualRecipe = (RitualRecipe)list.value();
        return ritualRecipe;
    }

    private final void loadGlobalPosition(CompoundTag tag) {
        Optional<ResourceKey<Level>> optionalDimension = this.getLodestoneDimension(tag);
        if (optionalDimension.isPresent()) {
            Optional blockPosOpt = NbtUtils.readBlockPos((CompoundTag)tag, (String)TAG_TARGET_POS);
            blockPosOpt.ifPresent(arg_0 -> GoldenChalkBlockEntity.loadGlobalPosition$lambda$1(arg_0 -> GoldenChalkBlockEntity.loadGlobalPosition$lambda$0(this, optionalDimension, arg_0), arg_0));
        }
    }

    private final Optional<ResourceKey<Level>> getLodestoneDimension(CompoundTag tag) {
        Tag tag2 = tag.get(TAG_DIMENSION);
        if (tag2 == null) {
            Optional<ResourceKey<Level>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Tag dimensionTag = tag2;
        Optional optional = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)dimensionTag).result();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"result(...)");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        void $this$fold$iv;
        void initial$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Object it;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putBoolean(TAG_SHOULD_RUN, this.currentState != RitualState.IDLE);
        tag.putBoolean(TAG_SHOULD_CONSUME_SACRIFICES, this.currentState == RitualState.CONSUMING_SACRIFICES);
        tag.putBoolean(TAG_SHOULD_CONSUME_ITEMS, this.currentState == RitualState.CONSUMING_ITEMS);
        tag.putBoolean(TAG_IS_RITUAL_ACTIVE, this.isRitualActive);
        tag.putBoolean(TAG_HAS_RITUAL_STARTED, this.hasRitualStarted);
        tag.putInt(TAG_TICK_COUNTER, this.tickCounter);
        tag.putInt(TAG_RITUAL_TICK_COUNTER, this.ritualTickCounter);
        if (this.cachedAltarPos != null) {
            BlockPos blockPos = this.cachedAltarPos;
            Intrinsics.checkNotNull((Object)blockPos);
            tag.put(TAG_ALTAR_POS, NbtUtils.writeBlockPos((BlockPos)blockPos));
        }
        if (this.ritualRecipe != null) {
            ResourceLocation ritualType;
            RitualRecipe ritualRecipe = this.ritualRecipe;
            Intrinsics.checkNotNull((Object)ritualRecipe);
            Ritual ritual = ritualRecipe.getRitualType();
            String ritualTypeId = String.valueOf(ritual != null ? ritual.getId() : null);
            tag.putString(TAG_RITUAL_ID, ritualTypeId);
            RitualRecipe ritualRecipe2 = this.ritualRecipe;
            Intrinsics.checkNotNull((Object)ritualRecipe2);
            Ritual ritual2 = ritualRecipe2.getRitualType();
            Object object = ritualType = ritual2 != null ? ritual2.getId() : null;
            if (ritualType != null && this.level != null) {
                CompoundTag ritualStateTag = new CompoundTag();
                Ritual ritual3 = (Ritual)WitcheryRitualRegistry.INSTANCE.getRITUAL_REGISTRY().get(ritualType);
                if (ritual3 != null) {
                    Level level = this.level;
                    Intrinsics.checkNotNull((Object)level);
                    BlockPos blockPos = this.getBlockPos();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                    ritual3.saveState(level, blockPos, this, ritualStateTag);
                }
                if (!ritualStateTag.isEmpty()) {
                    tag.put(this.TAG_RITUAL_STATE, (Tag)ritualStateTag);
                }
            }
        }
        String string = this.ownerName;
        if (string != null) {
            it = string;
            boolean bl = false;
            tag.putString(TAG_OWNER_NAME, (String)it);
        }
        UUID uUID = this.targetPlayer;
        if (uUID != null) {
            it = uUID;
            boolean bl = false;
            tag.putUUID(TAG_TARGET_PLAYER, (UUID)it);
        }
        Integer n = this.targetEntity;
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            tag.putInt(TAG_TARGET_ENTITY, it2);
        }
        if (this.targetPos != null) {
            this.saveGlobalPosition(tag);
        }
        Iterable $this$map$iv = this.consumedSacrifices;
        boolean $i$f$map22 = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            EntityType entityType = (EntityType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(EntityType.getKey((EntityType)it3).toString());
        }
        List sacrificesList = (List)destination$iv$iv;
        $this$map$iv = sacrificesList;
        ListTag $i$f$map22 = new ListTag();
        String string2 = TAG_CONSUMED_SACRIFICES;
        collection = tag;
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entity;
            Object item$iv$iv;
            item$iv$iv = (String)element$iv;
            void list = accumulator$iv;
            boolean bl3 = false;
            list.add((Object)StringTag.valueOf((String)entity));
            accumulator$iv = list;
        }
        void var15_21 = accumulator$iv;
        collection.put(string2, (Tag)var15_21);
    }

    private final void saveGlobalPosition(CompoundTag tag) {
        block0: {
            GlobalPos globalPos = this.targetPos;
            if (globalPos == null) break block0;
            GlobalPos pos = globalPos;
            boolean bl = false;
            CompoundTag posTag = new CompoundTag();
            posTag.put(TAG_TARGET_POS, NbtUtils.writeBlockPos((BlockPos)pos.pos()));
            ResourceKey resourceKey = pos.dimension();
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
            this.addGlobalPosTag((ResourceKey<Level>)resourceKey, posTag);
            tag.put(TAG_GLOBAL_POS, (Tag)posTag);
        }
    }

    private final void addGlobalPosTag(ResourceKey<Level> lodestoneDimension, CompoundTag tag) {
        Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, lodestoneDimension).resultOrPartial(GoldenChalkBlockEntity::addGlobalPosTag$lambda$0).ifPresent(arg_0 -> GoldenChalkBlockEntity.addGlobalPosTag$lambda$2(arg_0 -> GoldenChalkBlockEntity.addGlobalPosTag$lambda$1(tag, arg_0), arg_0));
    }

    public void clearContent() {
        this.items.clear();
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)this.items;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        ItemStack itemStack;
        boolean bl = 0 <= slot ? slot < ((Collection)this.items).size() : false;
        if (bl) {
            Object object = this.items.get(slot);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            itemStack = (ItemStack)object;
        } else {
            ItemStack itemStack2 = ItemStack.EMPTY;
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        }
        return itemStack;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem((List)((List)this.items), (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem((List)((List)this.items), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"takeItem(...)");
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        boolean bl = 0 <= slot ? slot < ((Collection)this.items).size() : false;
        if (bl) {
            this.items.set(slot, (Object)stack);
            this.setChanged();
        }
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    private static final boolean getSacrificeEntities$lambda$0(LivingEntity it) {
        return true;
    }

    private static final boolean getSacrificeEntities$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getItemEntities$lambda$0(ItemEntity it) {
        return true;
    }

    private static final boolean getItemEntities$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findNearbyGrasspers$lambda$0(Level $level, BlockPos it) {
        return $level.getBlockEntity(it) instanceof GrassperBlockEntity;
    }

    private static final boolean findNearbyGrasspers$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Pair findNearbyGrasspers$lambda$2(Level $level, BlockPos it) {
        BlockEntity blockEntity = $level.getBlockEntity(it);
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.grassper.GrassperBlockEntity");
        return TuplesKt.to((Object)it, (Object)((Object)((GrassperBlockEntity)blockEntity)));
    }

    private static final Pair findNearbyGrasspers$lambda$3(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    private static final boolean findNearbyGrasspers$lambda$4(Pair pair) {
        GrassperBlockEntity grassper = (GrassperBlockEntity)((Object)pair.component2());
        return !grassper.isEmpty();
    }

    private static final boolean findNearbyGrasspers$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean collectNearbyItems$lambda$0(ItemEntity it) {
        return true;
    }

    private static final boolean collectNearbyItems$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean collectNearbyItems$lambda$3(Level $level, BlockPos it) {
        return $level.getBlockEntity(it) instanceof GrassperBlockEntity;
    }

    private static final boolean collectNearbyItems$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final GrassperBlockEntity collectNearbyItems$lambda$5(Level $level, BlockPos it) {
        BlockEntity blockEntity = $level.getBlockEntity(it);
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.grassper.GrassperBlockEntity");
        return (GrassperBlockEntity)blockEntity;
    }

    private static final GrassperBlockEntity collectNearbyItems$lambda$6(Function1 $tmp0, Object p0) {
        return (GrassperBlockEntity)((Object)$tmp0.invoke(p0));
    }

    private static final boolean collectNearbyItems$lambda$7(GrassperBlockEntity it) {
        return !it.isEmpty();
    }

    private static final boolean collectNearbyItems$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit collectNearbyItems$lambda$9(List $result, GrassperBlockEntity it) {
        Object object = it.getItem().get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $result.add(object);
        return Unit.INSTANCE;
    }

    private static final void collectNearbyItems$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean collectNearbyEntities$lambda$0(LivingEntity it) {
        return true;
    }

    private static final boolean collectNearbyEntities$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean hasCovenCondition$lambda$0(CovenWitchEntity it) {
        return it.isAlive() && it != null && it.getIsCoven();
    }

    private static final boolean hasCovenCondition$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean hasCovenCondition$lambda$3(ItemStack it) {
        return it.is((Item)WitcheryItems.INSTANCE.getSEER_STONE().get());
    }

    private static final boolean findAttunedStone$lambda$0(ItemEntity it) {
        return it.getItem().is((Item)WitcheryItems.INSTANCE.getATTUNED_STONE().get()) && Intrinsics.areEqual((Object)it.getItem().get((DataComponentType)WitcheryDataComponents.INSTANCE.getATTUNED().get()), (Object)true);
    }

    private static final boolean findAttunedStone$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit loadGlobalPosition$lambda$0(GoldenChalkBlockEntity this$0, Optional $optionalDimension, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this$0.targetPos = GlobalPos.of((ResourceKey)((ResourceKey)$optionalDimension.get()), (BlockPos)pos);
        return Unit.INSTANCE;
    }

    private static final void loadGlobalPosition$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void addGlobalPosTag$lambda$0(String error) {
        Witchery.Companion.logDebugRitual("Failed to encode dimension: " + error);
    }

    private static final Unit addGlobalPosTag$lambda$1(CompoundTag $tag, Tag dimensionTag) {
        Intrinsics.checkNotNullParameter((Object)dimensionTag, (String)"dimensionTag");
        $tag.put(TAG_DIMENSION, dimensionTag);
        return Unit.INSTANCE;
    }

    private static final void addGlobalPosTag$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity$Companion;", "", "<init>", "()V", "INVENTORY_SIZE", "", "RITUAL_AREA_RADIUS", "", "VERTICAL_RITUAL_AREA", "COVEN_SEARCH_RADIUS", "COVEN_SEARCH_HEIGHT", "ITEM_SEARCH_RADIUS", "TICK_INTERVAL", "ATTUNED_STONE_POWER_BONUS", "TAG_SHOULD_RUN", "", "TAG_SHOULD_CONSUME_SACRIFICES", "TAG_SHOULD_CONSUME_ITEMS", "TAG_IS_RITUAL_ACTIVE", "TAG_TICK_COUNTER", "TAG_RITUAL_TICK_COUNTER", "TAG_HAS_RITUAL_STARTED", "TAG_ALTAR_POS", "TAG_RITUAL_ID", "TAG_OWNER_NAME", "TAG_TARGET_PLAYER", "TAG_TARGET_ENTITY", "TAG_GLOBAL_POS", "TAG_TARGET_POS", "TAG_CONSUMED_SACRIFICES", "TAG_DIMENSION", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity$RitualState;", "", "<init>", "(Ljava/lang/String;I)V", "IDLE", "CONSUMING_ITEMS", "CONSUMING_SACRIFICES", "ACTIVE", "witchery"})
    private static final class RitualState
    extends Enum<RitualState> {
        public static final /* enum */ RitualState IDLE = new RitualState();
        public static final /* enum */ RitualState CONSUMING_ITEMS = new RitualState();
        public static final /* enum */ RitualState CONSUMING_SACRIFICES = new RitualState();
        public static final /* enum */ RitualState ACTIVE = new RitualState();
        private static final /* synthetic */ RitualState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RitualState[] values() {
            return (RitualState[])$VALUES.clone();
        }

        public static RitualState valueOf(String value) {
            return Enum.valueOf(RitualState.class, value);
        }

        @NotNull
        public static EnumEntries<RitualState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = ritualStateArray = new RitualState[]{RitualState.IDLE, RitualState.CONSUMING_ITEMS, RitualState.CONSUMING_SACRIFICES, RitualState.ACTIVE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RitualState.values().length];
            try {
                nArray[RitualState.CONSUMING_ITEMS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RitualState.CONSUMING_SACRIFICES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RitualState.ACTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RitualRecipe.Celestial.values().length];
            try {
                nArray[RitualRecipe.Celestial.DAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RitualRecipe.Celestial.FULL_MOON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RitualRecipe.Celestial.NEW_MOON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RitualRecipe.Celestial.NIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RitualRecipe.Celestial.WAXING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RitualRecipe.Celestial.WANING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

