/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.soul_cage;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.content.entity.AbstractSpectralEntity;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.chain.ChainManager;
import dev.sterner.witchery.features.chain.ChainType;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.IntIterator;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 b2\u00020\u0001:\u0001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010%\u001a\u00020\u000fJ \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00032\b\b\u0002\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\tJ \u0010.\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010/\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0003H\u0002J$\u00100\u001a\u0004\u0018\u0001012\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00032\b\b\u0002\u00102\u001a\u00020,H\u0002J\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018042\u0006\u00105\u001a\u00020\u0018J\"\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u00182\b\b\u0002\u00109\u001a\u00020\u0018H\u0002J\u0018\u0010:\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0018H\u0002J\u0018\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0014J\u0018\u0010@\u001a\u00020'2\u0006\u0010A\u001a\u00020=2\u0006\u0010B\u001a\u00020?H\u0014J \u0010C\u001a\u00020D2\u0006\u0010E\u001a\u0002012\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020'H\u0002J\u0006\u0010K\u001a\u00020\tJ\u0016\u0010L\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0003J \u0010M\u001a\u00020'2\u0006\u0010N\u001a\u00020O2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0002JH\u0010P\u001a\u00020'2\u0006\u0010(\u001a\u00020Q2\u0006\u0010R\u001a\u00020,2\u0006\u0010S\u001a\u00020,2\u0006\u0010T\u001a\u00020,2\u0006\u0010U\u001a\u00020,2\u0006\u0010V\u001a\u00020,2\u0006\u0010W\u001a\u00020,2\u0006\u0010X\u001a\u00020YH\u0002J@\u0010Z\u001a\u00020'2\u0006\u0010(\u001a\u00020Q2\u0006\u0010R\u001a\u00020,2\u0006\u0010S\u001a\u00020,2\u0006\u0010T\u001a\u00020,2\u0006\u0010[\u001a\u00020,2\u0006\u0010\\\u001a\u00020,2\u0006\u0010]\u001a\u00020,H\u0002J \u0010^\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010_\u001a\u00020Y2\u0006\u0010*\u001a\u00020\u0003H\u0002J\u000e\u0010`\u001a\u00020'2\u0006\u0010A\u001a\u00020=J\u000e\u0010a\u001a\u00020'2\u0006\u0010A\u001a\u00020=R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Ldev/sterner/witchery/content/block/soul_cage/SoulCageBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "hasSoul", "", "getHasSoul", "()Z", "setHasSoul", "(Z)V", "chainChargeUp", "", "getChainChargeUp", "()I", "setChainChargeUp", "(I)V", "maxChargeUp", "getMaxChargeUp", "setMaxChargeUp", "currentYaw", "", "currentPitch", "targetYaw", "targetPitch", "prevYaw", "prevPitch", "isTrackingPlayer", "previousTrackingState", "saltCount", "fuelTime", "maxFuelTime", "animationTime", "wasProcessing", "getAnimationTime", "lookAndConsumeSoul", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "radius", "", "extractSoul", "tick", "makeAmbientParticles", "findClosestPlayerInRange", "Lnet/minecraft/world/entity/player/Player;", "range", "getInterpolatedRotation", "Lkotlin/Pair;", "partialTick", "lerpAngle", "current", "target", "factor", "normalizeYawDifference", "loadAdditional", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "tag", "registries", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "pPlayer", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pHand", "Lnet/minecraft/world/InteractionHand;", "startProcessing", "isProcessing", "tickSoulBox", "containSpectralEntity", "entity", "Ldev/sterner/witchery/content/entity/AbstractSpectralEntity;", "createBarrierParticlesForBoundingBox", "Lnet/minecraft/server/level/ServerLevel;", "particleX", "particleY", "particleZ", "centerX", "centerY", "centerZ", "entityBounds", "Lnet/minecraft/world/phys/AABB;", "createRippleEffect", "normalizedX", "normalizedY", "normalizedZ", "containSpectralEntities", "box", "loadSoulBarrier", "saveSoulBarrier", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nSoulCageBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoulCageBlockEntity.kt\ndev/sterner/witchery/content/block/soul_cage/SoulCageBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,717:1\n774#2:718\n865#2,2:719\n774#2:721\n865#2,2:722\n2423#2,14:724\n1869#2,2:738\n*S KotlinDebug\n*F\n+ 1 SoulCageBlockEntity.kt\ndev/sterner/witchery/content/block/soul_cage/SoulCageBlockEntity\n*L\n70#1:718\n70#1:719,2\n75#1:721\n75#1:722,2\n87#1:724,14\n100#1:738,2\n*E\n"})
public final class SoulCageBlockEntity
extends WitcheryBaseBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasSoul;
    private int chainChargeUp;
    private int maxChargeUp;
    private float currentYaw;
    private float currentPitch;
    private float targetYaw;
    private float targetPitch;
    private float prevYaw;
    private float prevPitch;
    private boolean isTrackingPlayer;
    private boolean previousTrackingState;
    private int saltCount;
    private int fuelTime;
    private int maxFuelTime;
    private int animationTime;
    private boolean wasProcessing;
    public static final float TOTAL_DURATION = 20.0f;
    public static final int SALT_TIME = 1200;
    private static final double CONTAINMENT_RADIUS = 5.0;
    private static final double PARTICLE_OFFSET = 0.1;
    @NotNull
    private static final HashMap<UUID, BlockPos> entityToSoulCageMap = new HashMap();

    public SoulCageBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getSOUL_CAGE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
        this.maxChargeUp = 2;
    }

    public final boolean getHasSoul() {
        return this.hasSoul;
    }

    public final void setHasSoul(boolean bl) {
        this.hasSoul = bl;
    }

    public final int getChainChargeUp() {
        return this.chainChargeUp;
    }

    public final void setChainChargeUp(int n) {
        this.chainChargeUp = n;
    }

    public final int getMaxChargeUp() {
        return this.maxChargeUp;
    }

    public final void setMaxChargeUp(int n) {
        this.maxChargeUp = n;
    }

    public final int getAnimationTime() {
        return this.animationTime;
    }

    /*
     * WARNING - void declaration
     */
    public final void lookAndConsumeSoul(@NotNull Level level, @NotNull BlockPos pos, double radius) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.hasSoul) {
            return;
        }
        if (level instanceof ServerLevel) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ZombieVillager it;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            AABB area = AABB.ofSize((Vec3)pos.getCenter(), (double)(radius * (double)2), (double)(radius * (double)2), (double)(radius * (double)2));
            List list = level.getEntitiesOfClass(ZombieVillager.class, area);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
            Iterable iterable = list;
            boolean $i$f$filter22 = false;
            void var9_8 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (ZombieVillager)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!EtherealEntityAttachment.getData((LivingEntity)it).isEthereal()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List zvillagers = (List)destination$iv$iv;
            List list2 = level.getEntitiesOfClass(Villager.class, area);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntitiesOfClass(...)");
            Iterable $i$f$filter22 = list2;
            int $i$f$filter = 0;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Villager it2 = (Villager)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                if (!EtherealEntityAttachment.getData((LivingEntity)it2).isEthereal()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List villagers = (List)destination$iv$iv2;
            ArrayList mixedList = new ArrayList(zvillagers.size() + villagers.size());
            mixedList.addAll(zvillagers);
            mixedList.addAll(villagers);
            if (!((Collection)mixedList).isEmpty()) {
                $i$f$filter = this.chainChargeUp;
                this.chainChargeUp = $i$f$filter + 1;
                if (this.chainChargeUp > this.maxChargeUp) {
                    Object minElem$iv;
                    Object v2;
                    this.chainChargeUp = 0;
                    Iterable $this$minByOrNull$iv = mixedList;
                    boolean $i$f$minByOrNull = false;
                    Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v2 = null;
                    } else {
                        minElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v2 = minElem$iv;
                        } else {
                            it = (Entity)minElem$iv;
                            boolean bl = false;
                            double minValue$iv = it.distanceToSqr(pos.getCenter());
                            do {
                                Object e$iv = iterator$iv.next();
                                Entity it3 = (Entity)e$iv;
                                $i$a$-minByOrNull-SoulCageBlockEntity$lookAndConsumeSoul$mixedList2$1 = false;
                                double v$iv = it3.distanceToSqr(pos.getCenter());
                                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                                minElem$iv = e$iv;
                                minValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v2 = minElem$iv;
                        }
                    }
                    Entity mixedList2 = v2;
                    if (mixedList2 != null) {
                        Entity villager = mixedList2;
                        boolean bl = false;
                        ((Map)entityToSoulCageMap).put(villager.getUUID(), pos);
                        minElem$iv = ChainManager.INSTANCE;
                        ServerLevel minValue$iv = (ServerLevel)level;
                        Vec3 vec3 = pos.getCenter().add(0.0, 0.25, 0.0);
                        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
                        Vec3 vec32 = vec3;
                        ChainType v$iv = ChainType.SOUL;
                        ChainManager.createHookAndPullChain$default(minElem$iv, (Level)minValue$iv, vec32, villager, 0.0f, 0.4f, 20, v$iv, 8, null);
                        List list3 = level.getEntitiesOfClass(ServerPlayer.class, area);
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getEntitiesOfClass(...)");
                        Iterable $this$forEach$iv = list3;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ServerPlayer it4 = (ServerPlayer)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)it4);
                            ResourceLocation resourceLocation = Witchery.Companion.id("soul");
                            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
                            WitcheryUtil.INSTANCE.grantAdvancementCriterion(it4, resourceLocation, "has_seen_soul");
                        }
                        ((ServerLevel)level).playSound(null, pos, SoundEvents.CHAIN_PLACE, SoundSource.BLOCKS, 1.0f, 0.5f);
                        return;
                    }
                }
                this.setChanged();
            }
        }
    }

    public static /* synthetic */ void lookAndConsumeSoul$default(SoulCageBlockEntity soulCageBlockEntity, Level level, BlockPos blockPos, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 8.0;
        }
        soulCageBlockEntity.lookAndConsumeSoul(level, blockPos, d);
    }

    public final boolean extractSoul() {
        if (this.hasSoul) {
            this.hasSoul = false;
            this.setChanged();
            Level level = this.level;
            if (level != null) {
                level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
            }
            return true;
        }
        return false;
    }

    @Override
    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super.tick(level, pos, blockState);
        this.tickSoulBox(level, pos);
        if (!this.hasSoul && !this.isProcessing()) {
            level.setBlockAndUpdate(this.getBlockPos(), (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
        }
        if (!this.hasSoul && level.getGameTime() % (long)20 == 0L) {
            SoulCageBlockEntity.lookAndConsumeSoul$default(this, level, pos, 0.0, 4, null);
        }
        this.makeAmbientParticles(level, pos);
        if (level instanceof ServerLevel) {
            return;
        }
        this.prevYaw = this.currentYaw;
        this.prevPitch = this.currentPitch;
        Player closestPlayer = SoulCageBlockEntity.findClosestPlayerInRange$default(this, level, pos, 0.0, 4, null);
        this.previousTrackingState = this.isTrackingPlayer;
        boolean bl = this.isTrackingPlayer = closestPlayer != null;
        if (this.isTrackingPlayer && closestPlayer != null) {
            double dx = closestPlayer.getX() - ((double)pos.getX() + 0.5);
            double dy = closestPlayer.getY() + (double)closestPlayer.getEyeHeight() - ((double)pos.getY() + 0.5);
            double dz = closestPlayer.getZ() - ((double)pos.getZ() + 0.5);
            float newTargetYaw = ((float)Math.toDegrees(Math.atan2(-dx, dz)) + (float)180) % (float)360;
            double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
            float newTargetPitch = -((float)Math.toDegrees(Math.atan2(dy, horizontalDistance)));
            this.targetYaw = this.normalizeYawDifference(this.currentYaw, newTargetYaw);
            this.targetPitch = RangesKt.coerceIn((float)newTargetPitch, (float)-45.0f, (float)45.0f);
        } else {
            long gameTime = level.getGameTime();
            this.targetYaw = (float)gameTime * 0.5f % (float)360;
            this.targetPitch = (float)(Math.sin((double)gameTime * 0.05) * (double)10);
        }
        this.currentYaw = SoulCageBlockEntity.lerpAngle$default(this, this.currentYaw, this.targetYaw, 0.0f, 4, null);
        this.currentPitch = SoulCageBlockEntity.lerpAngle$default(this, this.currentPitch, this.targetPitch, 0.0f, 4, null);
    }

    private final void makeAmbientParticles(Level level, BlockPos pos) {
        if (this.hasSoul && level.getGameTime() % (long)20 == 0L && level instanceof ServerLevel) {
            double blockWidthX = 0.75;
            double blockWidthZ = 0.75;
            double marginX = (1.0 - blockWidthX) / 2.0 + 0.75;
            double marginZ = (1.0 - blockWidthZ) / 2.0 + 0.75;
            SimpleParticleType particleType = ParticleTypes.SOUL;
            switch (level.random.nextInt(4)) {
                case 0: {
                    ((ServerLevel)level).sendParticles((ParticleOptions)particleType, (double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5) * 0.4, (double)pos.getY() + 1.0 + level.random.nextDouble() * 0.2, (double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5) * 0.4, 1, 0.0, 0.02, 0.0, 0.01);
                    break;
                }
                case 1: {
                    double cornerX = level.random.nextBoolean() ? (double)pos.getX() + marginX : (double)(pos.getX() + 1) - marginX;
                    double cornerZ = level.random.nextBoolean() ? (double)pos.getZ() + marginZ : (double)(pos.getZ() + 1) - marginZ;
                    ((ServerLevel)level).sendParticles((ParticleOptions)particleType, cornerX, (double)pos.getY() + 0.8 + level.random.nextDouble() * 0.3, cornerZ, 1, 0.0, 0.03, 0.0, 0.01);
                    break;
                }
                case 2: 
                case 3: {
                    int side = level.random.nextInt(4);
                    Pair pair = switch (side) {
                        case 0 -> new Pair((Object)((double)pos.getX() + marginX + level.random.nextDouble() * 0.1), (Object)((double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5) * 0.4));
                        case 1 -> new Pair((Object)((double)(pos.getX() + 1) - marginX - level.random.nextDouble() * 0.1), (Object)((double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5) * 0.4));
                        case 2 -> new Pair((Object)((double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5) * 0.4), (Object)((double)pos.getZ() + marginZ + level.random.nextDouble() * 0.1));
                        default -> new Pair((Object)((double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5) * 0.4), (Object)((double)(pos.getZ() + 1) - marginZ - level.random.nextDouble() * 0.1));
                    };
                    double particleX = ((Number)pair.component1()).doubleValue();
                    double particleZ = ((Number)pair.component2()).doubleValue();
                    ((ServerLevel)level).sendParticles((ParticleOptions)particleType, particleX, (double)pos.getY() + 0.4 + level.random.nextDouble() * 0.5, particleZ, 1, 0.0, 0.02, 0.0, 0.01);
                }
            }
        }
    }

    private final Player findClosestPlayerInRange(Level level, BlockPos pos, double range) {
        return level.players().stream().filter(arg_0 -> SoulCageBlockEntity.findClosestPlayerInRange$lambda$1(arg_0 -> SoulCageBlockEntity.findClosestPlayerInRange$lambda$0(pos, range, arg_0), arg_0)).min(Comparator.comparingDouble(arg_0 -> SoulCageBlockEntity.findClosestPlayerInRange$lambda$3(arg_0 -> SoulCageBlockEntity.findClosestPlayerInRange$lambda$2(pos, arg_0), arg_0))).orElse(null);
    }

    static /* synthetic */ Player findClosestPlayerInRange$default(SoulCageBlockEntity soulCageBlockEntity, Level level, BlockPos blockPos, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 4.0;
        }
        return soulCageBlockEntity.findClosestPlayerInRange(level, blockPos, d);
    }

    @NotNull
    public final Pair<Float, Float> getInterpolatedRotation(float partialTick) {
        float interpYaw = Mth.lerp((float)partialTick, (float)this.prevYaw, (float)this.currentYaw);
        float interpPitch = Mth.lerp((float)partialTick, (float)this.prevPitch, (float)this.currentPitch);
        return new Pair((Object)Float.valueOf(interpYaw), (Object)Float.valueOf(interpPitch));
    }

    private final float lerpAngle(float current, float target, float factor) {
        return current + factor * Mth.wrapDegrees((float)(target - current));
    }

    static /* synthetic */ float lerpAngle$default(SoulCageBlockEntity soulCageBlockEntity, float f, float f2, float f3, int n, Object object) {
        if ((n & 4) != 0) {
            f3 = 0.15f;
        }
        return soulCageBlockEntity.lerpAngle(f, f2, f3);
    }

    private final float normalizeYawDifference(float current, float target) {
        float diff = Mth.wrapDegrees((float)(target - current));
        return current + diff;
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("HasSoul")) {
            this.hasSoul = pTag.getBoolean("HasSoul");
        }
        this.loadSoulBarrier(pTag);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putBoolean("HasSoul", this.hasSoul);
        this.saveSoulBarrier(tag);
    }

    @Override
    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player pPlayer, @NotNull ItemStack pStack, @NotNull InteractionHand pHand) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        if (pStack.is((Item)WitcheryItems.INSTANCE.getSPECTRAL_DUST().get())) {
            if (this.saltCount < 1) {
                pStack.shrink(1);
                this.animationTime = 0;
                this.saltCount = 1;
                if (!this.isProcessing()) {
                    this.startProcessing();
                }
                this.setChanged();
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    private final void startProcessing() {
        if (this.saltCount > 0) {
            this.fuelTime = 1200;
            this.maxFuelTime = 1200;
            int n = this.saltCount;
            this.saltCount = n + -1;
            Level level = this.level;
            if (level != null) {
                level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
            }
            this.setChanged();
        }
    }

    public final boolean isProcessing() {
        return this.fuelTime > 0;
    }

    public final void tickSoulBox(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!level.isClientSide) {
            int n;
            boolean isProcessingNow = this.isProcessing();
            if (isProcessingNow && !this.wasProcessing) {
                this.animationTime = 0;
            }
            if (isProcessingNow && (float)this.animationTime < 20.0f) {
                n = this.animationTime;
                this.animationTime = n + 1;
            }
            this.wasProcessing = isProcessingNow;
            if (this.fuelTime > 0) {
                n = this.fuelTime;
                this.fuelTime = n + -1;
                if (this.fuelTime == 0 && this.saltCount > 0) {
                    this.startProcessing();
                }
                AABB box = new AABB((double)pos.getX() - 5.0, (double)pos.getY() - 5.0, (double)pos.getZ() - 5.0, (double)pos.getX() + 5.0 + 1.0, (double)pos.getY() + 5.0 + 1.0, (double)pos.getZ() + 5.0 + 1.0);
                this.containSpectralEntities(level, box, pos);
                this.setChanged();
            }
        } else if (this.isProcessing() && level.random.nextFloat() < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.END_ROD, (double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5), (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5), 0.0, 0.02, 0.0);
        }
    }

    private final void containSpectralEntity(AbstractSpectralEntity entity, BlockPos pos, Level level) {
        double centerX = (double)pos.getX() + 0.5;
        double centerY = (double)pos.getY() + 0.5;
        double centerZ = (double)pos.getZ() + 0.5;
        AABB entityBounds = entity.getBoundingBox();
        double entityCenterX = (entityBounds.minX + entityBounds.maxX) / 2.0;
        double entityCenterY = (entityBounds.minY + entityBounds.maxY) / 2.0;
        double entityCenterZ = (entityBounds.minZ + entityBounds.maxZ) / 2.0;
        double minX = centerX - 5.0;
        double maxX = centerX + 5.0;
        double minY = centerY - 5.0;
        double maxY = centerY + 5.0;
        double minZ = centerZ - 5.0;
        double maxZ = centerZ + 5.0;
        boolean hitBoundary = false;
        double particleX = entityCenterX;
        double particleY = entityCenterY;
        double particleZ = entityCenterZ;
        if (entityBounds.maxX > maxX) {
            hitBoundary = true;
            particleX = maxX - 0.1;
            particleY = entityCenterY;
            particleZ = entityCenterZ;
        } else if (entityBounds.minX < minX) {
            hitBoundary = true;
            particleX = minX + 0.1;
            particleY = entityCenterY;
            particleZ = entityCenterZ;
        }
        if (entityBounds.maxY > maxY) {
            hitBoundary = true;
            particleY = maxY - 0.1;
            if (entityBounds.minX >= minX && entityBounds.maxX <= maxX) {
                particleX = entityCenterX;
            }
            if (entityBounds.minZ >= minZ && entityBounds.maxZ <= maxZ) {
                particleZ = entityCenterZ;
            }
        } else if (entityBounds.minY < minY) {
            hitBoundary = true;
            particleY = minY + 0.1;
            if (entityBounds.minX >= minX && entityBounds.maxX <= maxX) {
                particleX = entityCenterX;
            }
            if (entityBounds.minZ >= minZ && entityBounds.maxZ <= maxZ) {
                particleZ = entityCenterZ;
            }
        }
        if (entityBounds.maxZ > maxZ) {
            hitBoundary = true;
            particleZ = maxZ - 0.1;
            if (entityBounds.minX >= minX && entityBounds.maxX <= maxX) {
                particleX = entityCenterX;
            }
            if (entityBounds.minY >= minY && entityBounds.maxY <= maxY) {
                particleY = entityCenterY;
            }
        } else if (entityBounds.minZ < minZ) {
            hitBoundary = true;
            particleZ = minZ + 0.1;
            if (entityBounds.minX >= minX && entityBounds.maxX <= maxX) {
                particleX = entityCenterX;
            }
            if (entityBounds.minY >= minY && entityBounds.maxY <= maxY) {
                particleY = entityCenterY;
            }
        }
        if (hitBoundary) {
            double moveX = 0.0;
            double moveY = 0.0;
            double moveZ = 0.0;
            if (entityBounds.maxX > maxX) {
                moveX = maxX - entityBounds.maxX;
            } else if (entityBounds.minX < minX) {
                moveX = minX - entityBounds.minX;
            }
            if (entityBounds.maxY > maxY) {
                moveY = maxY - entityBounds.maxY;
            } else if (entityBounds.minY < minY) {
                moveY = minY - entityBounds.minY;
            }
            if (entityBounds.maxZ > maxZ) {
                moveZ = maxZ - entityBounds.maxZ;
            } else if (entityBounds.minZ < minZ) {
                moveZ = minZ - entityBounds.minZ;
            }
            entity.setPos(entity.getX() + moveX, entity.getY() + moveY, entity.getZ() + moveZ);
            double dx = (centerX - entityCenterX) * 0.05;
            double dy = (centerY - entityCenterY) * 0.05;
            double dz = (centerZ - entityCenterZ) * 0.05;
            entity.setDeltaMovement(entity.getDeltaMovement().add(dx, dy, dz));
            entity.hurtMarked = true;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Intrinsics.checkNotNull((Object)entityBounds);
                this.createBarrierParticlesForBoundingBox(serverLevel, particleX, particleY, particleZ, centerX, centerY, centerZ, entityBounds);
            }
        }
    }

    private final void createBarrierParticlesForBoundingBox(ServerLevel level, double particleX, double particleY, double particleZ, double centerX, double centerY, double centerZ, AABB entityBounds) {
        double dirX = particleX - centerX;
        double dirY = particleY - centerY;
        double dirZ = particleZ - centerZ;
        double length = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        double normalizedX = length > 0.0 ? dirX / length : 0.0;
        double normalizedY = length > 0.0 ? dirY / length : 0.0;
        double normalizedZ = length > 0.0 ? dirZ / length : 0.0;
        double entityHeight = entityBounds.maxY - entityBounds.minY;
        int particleCount = RangesKt.coerceAtLeast((int)3, (int)((int)(entityHeight * (double)2)));
        for (int i = 0; i < particleCount; ++i) {
            double heightOffset = particleCount > 1 ? (double)i / (double)(particleCount - 1) * entityHeight - entityHeight / (double)2 : 0.0;
            double adjustedY = particleY + heightOffset;
            double offsetX = (level.random.nextDouble() - 0.5) * 0.2;
            double offsetZ = (level.random.nextDouble() - 0.5) * 0.2;
            level.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, particleX + offsetX, adjustedY, particleZ + offsetZ, 1, normalizedX * 0.05, normalizedY * 0.02, normalizedZ * 0.05, 0.01);
            if (i % 2 != 0) continue;
            level.sendParticles((ParticleOptions)ParticleTypes.END_ROD, particleX + offsetX, adjustedY, particleZ + offsetZ, 1, normalizedX * 0.02, normalizedY * 0.01, normalizedZ * 0.02, 0.0);
        }
        this.createRippleEffect(level, particleX, particleY, particleZ, normalizedX, normalizedY, normalizedZ);
    }

    private final void createRippleEffect(ServerLevel level, double particleX, double particleY, double particleZ, double normalizedX, double normalizedY, double normalizedZ) {
        double rippleRadius = 0.5;
        int angle = 0;
        int n = ProgressionUtilKt.getProgressionLastElement((int)0, (int)360, (int)60);
        if (angle <= n) {
            while (true) {
                double radians = Math.toRadians(angle);
                double perpX = 0.0;
                double perpY = 0.0;
                double perpZ = 0.0;
                if (Math.abs(normalizedY) > 0.7) {
                    perpX = Math.cos(radians) * rippleRadius;
                    perpY = 0.0;
                    perpZ = Math.sin(radians) * rippleRadius;
                } else if (Math.abs(normalizedX) > Math.abs(normalizedZ)) {
                    perpX = 0.0;
                    perpY = Math.cos(radians) * rippleRadius;
                    perpZ = Math.sin(radians) * rippleRadius;
                } else {
                    perpX = Math.cos(radians) * rippleRadius;
                    perpY = Math.sin(radians) * rippleRadius;
                    perpZ = 0.0;
                }
                level.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, particleX + perpX, particleY + perpY, particleZ + perpZ, 1, 0.0, 0.0, 0.0, 0.0);
                if (angle == n) break;
                angle += 60;
            }
        }
    }

    private final void containSpectralEntities(Level level, AABB box, BlockPos pos) {
        List allEntities = level.getEntitiesOfClass(Entity.class, box);
        for (Entity entity : allEntities) {
            if (!(entity instanceof AbstractSpectralEntity)) continue;
            this.containSpectralEntity((AbstractSpectralEntity)entity, pos, level);
        }
    }

    public final void loadSoulBarrier(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.saltCount = tag.getInt("SaltCount");
        this.fuelTime = tag.getInt("FuelTime");
        this.maxFuelTime = tag.getInt("MaxFuelTime");
        this.animationTime = tag.getInt("AnimationTime");
        this.wasProcessing = tag.getBoolean("WasProcessing");
    }

    public final void saveSoulBarrier(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.putInt("SaltCount", this.saltCount);
        tag.putInt("FuelTime", this.fuelTime);
        tag.putInt("MaxFuelTime", this.maxFuelTime);
        tag.putInt("AnimationTime", this.animationTime);
        tag.putBoolean("WasProcessing", this.wasProcessing);
    }

    private static final boolean findClosestPlayerInRange$lambda$0(BlockPos $pos, double $range, Player player) {
        return ((Entity)player).distanceToSqr((double)$pos.getX() + 0.5, (double)$pos.getY() + 0.5, (double)$pos.getZ() + 0.5) <= $range * $range;
    }

    private static final boolean findClosestPlayerInRange$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final double findClosestPlayerInRange$lambda$2(BlockPos $pos, Player player) {
        return player.distanceToSqr((double)$pos.getX() + 0.5, (double)$pos.getY() + 0.5, (double)$pos.getZ() + 0.5);
    }

    private static final double findClosestPlayerInRange$lambda$3(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).doubleValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/content/block/soul_cage/SoulCageBlockEntity$Companion;", "", "<init>", "()V", "TOTAL_DURATION", "", "SALT_TIME", "", "CONTAINMENT_RADIUS", "", "PARTICLE_OFFSET", "entityToSoulCageMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lnet/minecraft/core/BlockPos;", "handleChainDiscard", "", "entity", "Lnet/minecraft/world/entity/Entity;", "makeBindingParticles", "level", "Lnet/minecraft/world/level/Level;", "entityPos", "Lnet/minecraft/world/phys/Vec3;", "soulCagePos", "witchery"})
    @SourceDebugExtension(value={"SMAP\nSoulCageBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoulCageBlockEntity.kt\ndev/sterner/witchery/content/block/soul_cage/SoulCageBlockEntity$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,717:1\n1869#2,2:718\n*S KotlinDebug\n*F\n+ 1 SoulCageBlockEntity.kt\ndev/sterner/witchery/content/block/soul_cage/SoulCageBlockEntity$Companion\n*L\n388#1:718,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void handleChainDiscard(@Nullable Entity entity) {
            Object object = entity;
            if (object == null || (object = object.getUUID()) == null) {
                return;
            }
            Object entityId = object;
            BlockPos blockPos = (BlockPos)entityToSoulCageMap.get(entityId);
            if (blockPos == null) {
                return;
            }
            BlockPos soulCagePos = blockPos;
            Level level = entity.level();
            BlockEntity blockEntity = level.getBlockEntity(soulCagePos);
            if (blockEntity instanceof SoulCageBlockEntity && (entity instanceof Villager || entity instanceof ZombieVillager)) {
                ((SoulCageBlockEntity)blockEntity).setHasSoul(true);
                ((SoulCageBlockEntity)blockEntity).setChanged();
                level.playSound(null, soulCagePos, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                entityToSoulCageMap.remove(entityId);
                entity.discard();
                Intrinsics.checkNotNull((Object)level);
                Vec3 vec3 = entity.position();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                Vec3 vec32 = ((SoulCageBlockEntity)blockEntity).getBlockPos().getCenter();
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getCenter(...)");
                this.makeBindingParticles(level, vec3, vec32);
                level.setBlockAndUpdate(soulCagePos, (BlockState)level.getBlockState(soulCagePos).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
            }
        }

        private final void makeBindingParticles(Level level, Vec3 entityPos, Vec3 soulCagePos) {
            if (level instanceof ServerLevel) {
                int particleCount = 30;
                Vec3 direction = soulCagePos.subtract(entityPos).normalize();
                for (int i = 0; i < particleCount; ++i) {
                    Vec3 offset = new Vec3(level.random.nextDouble() - 0.5, level.random.nextDouble() - 0.5, level.random.nextDouble() - 0.5).scale(0.5);
                    Vec3 position = entityPos.add(direction.scale((double)i / (double)particleCount));
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SOUL, position.x + offset.x, position.y + offset.y, position.z + offset.z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)10);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, soulCagePos.x + (level.random.nextDouble() - 0.5) * 0.75, soulCagePos.y + 0.2 + level.random.nextDouble() * 0.5, soulCagePos.z + (level.random.nextDouble() - 0.5) * 0.75, 1, 0.0, 0.05, 0.0, 0.02);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

