/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.spirit_portal;

import dev.sterner.witchery.content.block.WitcheryBaseEntityBlock;
import dev.sterner.witchery.content.block.spirit_portal.SpiritPortalBlockComponent;
import dev.sterner.witchery.core.api.multiblock.MultiBlockHorizontalDirectionStructure;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.spirit_world.ManifestationHandler;
import dev.sterner.witchery.features.spirit_world.ManifestationPlayerAttachment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t0\u0010H\u0014J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J(\u0010\u001a\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0016\u0010!\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\"\u00a8\u0006$"}, d2={"Ldev/sterner/witchery/content/block/spirit_portal/SpiritPortalBlock;", "Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "blockPlaceContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getCollisionShape", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "entityInside", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "handleEntityInside", "Lnet/minecraft/world/entity/player/Player;", "Companion", "witchery"})
public final class SpiritPortalBlock
extends WitcheryBaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VoxelShape SOUTH;
    @NotNull
    private static final VoxelShape EAST;
    @NotNull
    private static final VoxelShape WEST;
    @NotNull
    private static final VoxelShape NORTH;
    @NotNull
    private static final Supplier<MultiBlockHorizontalDirectionStructure> STRUCTURE;

    public SpiritPortalBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        BlockBehaviour.Properties properties2 = properties.noCollission().lightLevel(Companion.litBlockEmission(8));
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"lightLevel(...)");
        super(properties2);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.INVISIBLE;
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        Intrinsics.checkNotNullParameter((Object)blockPlaceContext, (String)"blockPlaceContext");
        Object object = this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.OPEN};
        builder.add(propertyArray);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction dir;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> NORTH;
            case 2 -> EAST;
            case 3 -> WEST;
            default -> SOUTH;
        };
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction dir;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            VoxelShape voxelShape = Shapes.empty();
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"empty(...)");
            return voxelShape;
        }
        Direction direction = dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> NORTH;
            case 2 -> EAST;
            case 3 -> WEST;
            default -> SOUTH;
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getSPIRIT_PORTAL().get()).create(pos, state);
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof Player && ((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            VoxelShape voxelShape;
            Direction dir;
            Direction direction = dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    voxelShape = NORTH;
                    break;
                }
                case 2: {
                    voxelShape = EAST;
                    break;
                }
                case 3: {
                    voxelShape = WEST;
                    break;
                }
                case 4: {
                    voxelShape = SOUTH;
                    break;
                }
                default: {
                    return;
                }
            }
            VoxelShape portalShape = voxelShape;
            AABB portalBoundingBox = portalShape.bounds().move(pos);
            if (portalBoundingBox.move(pos).intersects(((Player)entity).getBoundingBox())) {
                this.handleEntityInside(level, (Player)entity);
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    public final void handleEntityInside(@NotNull Level level, @NotNull Player entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (ManifestationPlayerAttachment.getData(entity).getHasRiteOfManifestation()) {
            ServerLevel overworld;
            MinecraftServer minecraftServer = level.getServer();
            Object object = overworld = minecraftServer != null ? minecraftServer.overworld() : null;
            if (overworld != null) {
                List itemsToKeep = new ArrayList();
                int n = entity.getInventory().getContainerSize();
                for (int i = 0; i < n; ++i) {
                    ItemStack itemStack = entity.getInventory().getItem(i);
                    if (!Intrinsics.areEqual((Object)itemStack.getItem(), (Object)WitcheryItems.INSTANCE.getICY_NEEDLE().get())) continue;
                    ItemStack itemStack2 = entity.getInventory().removeItem(i, itemStack.getCount());
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"removeItem(...)");
                    itemsToKeep.add(itemStack2);
                }
                entity.getInventory().dropAll();
                for (ItemStack keep : itemsToKeep) {
                    entity.getInventory().add(keep.copy());
                }
                ManifestationHandler.INSTANCE.setManifestationTimer(entity);
                entity.teleportTo(overworld, entity.getX(), entity.getY(), entity.getZ(), SetsKt.emptySet(), entity.yHeadRot, entity.getXRot());
            }
        }
    }

    private static final MultiBlockHorizontalDirectionStructure STRUCTURE$lambda$0() {
        MultiBlockStructure.StructurePiece[] structurePieceArray = new MultiBlockStructure.StructurePiece[3];
        BlockState blockState = ((SpiritPortalBlockComponent)((Object)WitcheryBlocks.INSTANCE.getSPIRIT_PORTAL_COMPONENT().get())).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        structurePieceArray[0] = new MultiBlockStructure.StructurePiece(1, 0, 0, blockState);
        BlockState blockState2 = ((SpiritPortalBlockComponent)((Object)WitcheryBlocks.INSTANCE.getSPIRIT_PORTAL_COMPONENT().get())).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        structurePieceArray[1] = new MultiBlockStructure.StructurePiece(1, 1, 0, blockState2);
        BlockState blockState3 = ((SpiritPortalBlockComponent)((Object)WitcheryBlocks.INSTANCE.getSPIRIT_PORTAL_COMPONENT().get())).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"defaultBlockState(...)");
        structurePieceArray[2] = new MultiBlockStructure.StructurePiece(0, 1, 0, blockState3);
        return MultiBlockHorizontalDirectionStructure.Companion.of(structurePieceArray);
    }

    static {
        VoxelShape voxelShape = Shapes.create((double)0.0, (double)0.0, (double)0.8125, (double)1.0, (double)1.0, (double)1.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"create(...)");
        SOUTH = voxelShape;
        VoxelShape voxelShape2 = Shapes.create((double)0.8125, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"create(...)");
        EAST = voxelShape2;
        VoxelShape voxelShape3 = Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)0.1875, (double)1.0, (double)1.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"create(...)");
        WEST = voxelShape3;
        VoxelShape voxelShape4 = Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.1875);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"create(...)");
        NORTH = voxelShape4;
        STRUCTURE = SpiritPortalBlock::STRUCTURE$lambda$0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/content/block/spirit_portal/SpiritPortalBlock$Companion;", "", "<init>", "()V", "SOUTH", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSOUTH", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "EAST", "getEAST", "WEST", "getWEST", "NORTH", "getNORTH", "litBlockEmission", "Ljava/util/function/ToIntFunction;", "Lnet/minecraft/world/level/block/state/BlockState;", "lightValue", "", "STRUCTURE", "Ljava/util/function/Supplier;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockHorizontalDirectionStructure;", "getSTRUCTURE", "()Ljava/util/function/Supplier;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VoxelShape getSOUTH() {
            return SOUTH;
        }

        @NotNull
        public final VoxelShape getEAST() {
            return EAST;
        }

        @NotNull
        public final VoxelShape getWEST() {
            return WEST;
        }

        @NotNull
        public final VoxelShape getNORTH() {
            return NORTH;
        }

        @NotNull
        public final ToIntFunction<BlockState> litBlockEmission(int lightValue) {
            return arg_0 -> Companion.litBlockEmission$lambda$0(lightValue, arg_0);
        }

        @NotNull
        public final Supplier<MultiBlockHorizontalDirectionStructure> getSTRUCTURE() {
            return STRUCTURE;
        }

        private static final int litBlockEmission$lambda$0(int $lightValue, BlockState blockState) {
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Comparable comparable = blockState.getValue((Property)BlockStateProperties.OPEN);
            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Boolean");
            return (Boolean)comparable != false ? $lightValue : 4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

