/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.spirit_portal;

import dev.sterner.witchery.content.block.spirit_portal.SpiritPortalBlock;
import dev.sterner.witchery.core.api.multiblock.MultiBlockCoreEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockHorizontalDirectionStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020!H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldev/sterner/witchery/content/block/spirit_portal/SpiritPortalBlockEntity;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockCoreEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "isOpening", "", "lastProgress", "", "progress", "easeIn", "t", "easeOut", "getRenderProgress", "partialTick", "onUseWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "tickServer", "Lnet/minecraft/server/level/ServerLevel;", "loadAdditional", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "tag", "registries", "witchery"})
public final class SpiritPortalBlockEntity
extends MultiBlockCoreEntity {
    private boolean isOpening;
    private float lastProgress;
    private float progress;

    public SpiritPortalBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getSPIRIT_PORTAL().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        BlockEntityType blockEntityType = (BlockEntityType)object;
        MultiBlockHorizontalDirectionStructure multiBlockHorizontalDirectionStructure = SpiritPortalBlock.Companion.getSTRUCTURE().get();
        Intrinsics.checkNotNullExpressionValue((Object)multiBlockHorizontalDirectionStructure, (String)"get(...)");
        super(blockEntityType, multiBlockHorizontalDirectionStructure, blockPos, blockState);
    }

    private final float easeIn(float t) {
        return t * t;
    }

    private final float easeOut(float t) {
        return t * ((float)2 - t);
    }

    public final float getRenderProgress(float partialTick) {
        float interpolatedProgress = Mth.lerp((float)partialTick, (float)this.lastProgress, (float)this.progress);
        return this.isOpening ? this.easeOut(interpolatedProgress) : this.easeIn(interpolatedProgress);
    }

    @Override
    @NotNull
    public InteractionResult onUseWithoutItem(@NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        if (!(this.progress == 0.0f) && !(this.progress == 1.0f)) {
            return InteractionResult.FAIL;
        }
        this.isOpening = !this.isOpening;
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().cycle((Property)BlockStateProperties.OPEN));
        this.progress = this.isOpening ? 0.0f : 1.0f;
        this.setChanged();
        return InteractionResult.SUCCESS;
    }

    @Override
    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        if (!level.isClientSide) {
            float progressChangeSpeed = 0.05f;
            float previousProgress = this.progress;
            this.progress = this.isOpening ? RangesKt.coerceAtMost((float)(this.progress + progressChangeSpeed), (float)1.0f) : RangesKt.coerceAtLeast((float)(this.progress - progressChangeSpeed), (float)0.0f);
            if (!(previousProgress == this.progress)) {
                this.lastProgress = previousProgress;
                this.setChanged();
            }
        }
    }

    @Override
    public void tickServer(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        this.progress = pTag.getFloat("Progress");
        this.isOpening = pTag.getBoolean("IsOpening");
        this.lastProgress = this.progress;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putFloat("Progress", this.progress);
        tag.putBoolean("IsOpening", this.isOpening);
    }
}

