/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.entity.AbstractSpectralEntity;
import dev.sterner.witchery.content.entity.goal.RandomFloatAroundGoal;
import dev.sterner.witchery.content.entity.move_control.GhostMoveControl;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/content/entity/BansheeEntity;", "Ldev/sterner/witchery/content/entity/AbstractSpectralEntity;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "isInvulnerableTo", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "Companion", "witchery"})
public final class BansheeEntity
extends AbstractSpectralEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BansheeEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = WitcheryEntityTypes.INSTANCE.getBANSHEE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((EntityType<? extends FlyingMob>)((EntityType)object), level);
        this.moveControl = new GhostMoveControl(this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomFloatAroundGoal(this));
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.is(DamageTypeTags.IS_PROJECTILE) || super.isInvulnerableTo(source);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/sterner/witchery/content/entity/BansheeEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = FlyingMob.createMobAttributes().add(Attributes.FLYING_SPEED, 0.35).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

